/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AConsTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class ConsTerm
extends AConsTerm
implements Serializable {
    private final IAttachments attachments;
    private final ITerm head;
    private final IListTerm tail;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long MIN_SIZE_LAZY_INIT_BIT = 1L;
    private transient int minSize;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long serialVersionUID = 42L;

    private ConsTerm(ITerm head, IListTerm tail) {
        this.head = Objects.requireNonNull(head, "head");
        this.tail = Objects.requireNonNull(tail, "tail");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ConsTerm(Builder builder) {
        this.head = builder.head;
        this.tail = builder.tail;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ConsTerm(IAttachments attachments, ITerm head, IListTerm tail) {
        this.attachments = attachments;
        this.head = head;
        this.tail = tail;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public ITerm getHead() {
        return this.head;
    }

    @Override
    public IListTerm getTail() {
        return this.tail;
    }

    @Override
    public final ConsTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new ConsTerm(newValue, this.head, this.tail);
    }

    public final ConsTerm withHead(ITerm value) {
        if (this.head == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "head");
        return new ConsTerm(this.attachments, newValue, this.tail);
    }

    public final ConsTerm withTail(IListTerm value) {
        if (this.tail == value) {
            return this;
        }
        IListTerm newValue = Objects.requireNonNull(value, "tail");
        return new ConsTerm(this.attachments, this.head, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinSize() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ConsTerm consTerm = this;
            synchronized (consTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.minSize = super.getMinSize();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.minSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ConsTerm consTerm = this;
            synchronized (consTerm) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    public static ConsTerm of(ITerm head, IListTerm tail) {
        return new ConsTerm(head, tail);
    }

    public static ConsTerm copyOf(AConsTerm instance) {
        if (instance instanceof ConsTerm) {
            return (ConsTerm)instance;
        }
        return ConsTerm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ConsTerm(Builder builder, ConsTerm consTerm) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_HEAD = 1L;
        private static final long INIT_BIT_TAIL = 2L;
        private long initBits = 3L;
        private IAttachments attachments;
        private ITerm head;
        private IListTerm tail;

        private Builder() {
        }

        public final Builder from(AConsTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IConsTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof AConsTerm) {
                instance = (AConsTerm)object;
                if ((bits & 1L) == 0L) {
                    this.head(((AConsTerm)instance).getHead());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.tail(((AConsTerm)instance).getTail());
                    bits |= 4L;
                }
            }
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof IConsTerm) {
                instance = (IConsTerm)object;
                if ((bits & 1L) == 0L) {
                    this.head(instance.getHead());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.tail(instance.getTail());
                    bits |= 4L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder head(ITerm head) {
            this.head = Objects.requireNonNull(head, "head");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tail(IListTerm tail) {
            this.tail = Objects.requireNonNull(tail, "tail");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConsTerm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ConsTerm(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("head");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tail");
            }
            return "Cannot build ConsTerm, some of required attributes are not set " + attributes;
        }
    }
}

