/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableList;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AApplTerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class ApplTerm
extends AApplTerm
implements Serializable {
    private final IAttachments attachments;
    private final String op;
    private final ImmutableList<ITerm> args;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private ApplTerm(String op, Iterable<? extends ITerm> args) {
        this.op = Objects.requireNonNull(op, "op");
        this.args = ImmutableList.copyOf(args);
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ApplTerm(Builder builder) {
        this.op = builder.op;
        this.args = builder.args.build();
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ApplTerm(IAttachments attachments, String op, ImmutableList<ITerm> args) {
        this.attachments = attachments;
        this.op = op;
        this.args = args;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    public ImmutableList<ITerm> getArgs() {
        return this.args;
    }

    @Override
    public final ApplTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return ApplTerm.validate(new ApplTerm(newValue, this.op, this.args));
    }

    public final ApplTerm withOp(String value) {
        String newValue = Objects.requireNonNull(value, "op");
        if (this.op.equals(newValue)) {
            return this;
        }
        return ApplTerm.validate(new ApplTerm(this.attachments, newValue, this.args));
    }

    public final ApplTerm withArgs(ITerm ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ApplTerm.validate(new ApplTerm(this.attachments, this.op, (ImmutableList<ITerm>)newValue));
    }

    public final ApplTerm withArgs(Iterable<? extends ITerm> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ApplTerm.validate(new ApplTerm(this.attachments, this.op, (ImmutableList<ITerm>)newValue));
    }

    public static ApplTerm of(String op, List<ITerm> args) {
        return ApplTerm.of(op, args);
    }

    public static ApplTerm of(String op, Iterable<? extends ITerm> args) {
        return ApplTerm.validate(new ApplTerm(op, args));
    }

    private static ApplTerm validate(ApplTerm instance) {
        instance = (ApplTerm)instance.check();
        return instance;
    }

    public static ApplTerm copyOf(AApplTerm instance) {
        if (instance instanceof ApplTerm) {
            return (ApplTerm)instance;
        }
        return ApplTerm.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ApplTerm.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ApplTerm(Builder builder, ApplTerm applTerm) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_OP = 1L;
        private long initBits = 1L;
        private IAttachments attachments;
        private String op;
        private ImmutableList.Builder<ITerm> args = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 4L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 4L;
                }
            }
            if (object instanceof AbstractApplTerm) {
                instance = (AbstractApplTerm)object;
                if ((bits & 2L) == 0L) {
                    this.op(((AbstractApplTerm)instance).getOp());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 4L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 4L;
                }
            }
            if (object instanceof IApplTerm) {
                instance = (IApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.addAllArgs(instance.getArgs());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.op(instance.getOp());
                    bits |= 2L;
                }
            }
            if (object instanceof AApplTerm) {
                instance = (AApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.addAllArgs(((AApplTerm)instance).getArgs());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.op(((AApplTerm)instance).getOp());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder op(String op) {
            this.op = Objects.requireNonNull(op, "op");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addArgs(ITerm element) {
            this.args.add((Object)element);
            return this;
        }

        public final Builder addArgs(ITerm ... elements) {
            this.args.add((Object[])elements);
            return this;
        }

        public final Builder args(Iterable<? extends ITerm> elements) {
            this.args = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        public final Builder addAllArgs(Iterable<? extends ITerm> elements) {
            this.args.addAll(elements);
            return this;
        }

        public ApplTerm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ApplTerm.validate(new ApplTerm(this, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("op");
            }
            return "Cannot build ApplTerm, some of required attributes are not set " + attributes;
        }
    }
}

