/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AAppl3Term;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class Appl3Term
extends AAppl3Term
implements Serializable {
    private final IAttachments attachments;
    private final String op;
    private final ITerm arg0;
    private final ITerm arg1;
    private final ITerm arg2;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private Appl3Term(String op, ITerm arg0, ITerm arg1, ITerm arg2) {
        this.op = Objects.requireNonNull(op, "op");
        this.arg0 = Objects.requireNonNull(arg0, "arg0");
        this.arg1 = Objects.requireNonNull(arg1, "arg1");
        this.arg2 = Objects.requireNonNull(arg2, "arg2");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl3Term(Builder builder) {
        this.op = builder.op;
        this.arg0 = builder.arg0;
        this.arg1 = builder.arg1;
        this.arg2 = builder.arg2;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl3Term(IAttachments attachments, String op, ITerm arg0, ITerm arg1, ITerm arg2) {
        this.attachments = attachments;
        this.op = op;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public ITerm getArg0() {
        return this.arg0;
    }

    @Override
    public ITerm getArg1() {
        return this.arg1;
    }

    @Override
    public ITerm getArg2() {
        return this.arg2;
    }

    @Override
    public final Appl3Term withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return Appl3Term.validate(new Appl3Term(newValue, this.op, this.arg0, this.arg1, this.arg2));
    }

    public final Appl3Term withOp(String value) {
        String newValue = Objects.requireNonNull(value, "op");
        if (this.op.equals(newValue)) {
            return this;
        }
        return Appl3Term.validate(new Appl3Term(this.attachments, newValue, this.arg0, this.arg1, this.arg2));
    }

    public final Appl3Term withArg0(ITerm value) {
        if (this.arg0 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg0");
        return Appl3Term.validate(new Appl3Term(this.attachments, this.op, newValue, this.arg1, this.arg2));
    }

    public final Appl3Term withArg1(ITerm value) {
        if (this.arg1 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg1");
        return Appl3Term.validate(new Appl3Term(this.attachments, this.op, this.arg0, newValue, this.arg2));
    }

    public final Appl3Term withArg2(ITerm value) {
        if (this.arg2 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg2");
        return Appl3Term.validate(new Appl3Term(this.attachments, this.op, this.arg0, this.arg1, newValue));
    }

    public static Appl3Term of(String op, ITerm arg0, ITerm arg1, ITerm arg2) {
        return Appl3Term.validate(new Appl3Term(op, arg0, arg1, arg2));
    }

    private static Appl3Term validate(Appl3Term instance) {
        instance = (Appl3Term)instance.check();
        return instance;
    }

    public static Appl3Term copyOf(AAppl3Term instance) {
        if (instance instanceof Appl3Term) {
            return (Appl3Term)instance;
        }
        return Appl3Term.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Appl3Term.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Appl3Term(Builder builder, Appl3Term appl3Term) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_OP = 1L;
        private static final long INIT_BIT_ARG0 = 2L;
        private static final long INIT_BIT_ARG1 = 4L;
        private static final long INIT_BIT_ARG2 = 8L;
        private long initBits = 15L;
        private IAttachments attachments;
        private String op;
        private ITerm arg0;
        private ITerm arg1;
        private ITerm arg2;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AAppl3Term instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractApplTerm) {
                instance = (AbstractApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(((AbstractApplTerm)instance).getOp());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof IApplTerm) {
                instance = (IApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(instance.getOp());
                    bits |= 1L;
                }
            }
            if (object instanceof AAppl3Term) {
                instance = (AAppl3Term)object;
                if ((bits & 1L) == 0L) {
                    this.op(((AAppl3Term)instance).getOp());
                    bits |= 1L;
                }
                this.arg2(((AAppl3Term)instance).getArg2());
                this.arg1(((AAppl3Term)instance).getArg1());
                this.arg0(((AAppl3Term)instance).getArg0());
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder op(String op) {
            this.op = Objects.requireNonNull(op, "op");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder arg0(ITerm arg0) {
            this.arg0 = Objects.requireNonNull(arg0, "arg0");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arg1(ITerm arg1) {
            this.arg1 = Objects.requireNonNull(arg1, "arg1");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder arg2(ITerm arg2) {
            this.arg2 = Objects.requireNonNull(arg2, "arg2");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Appl3Term build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return Appl3Term.validate(new Appl3Term(this, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("op");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arg0");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arg1");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("arg2");
            }
            return "Cannot build Appl3Term, some of required attributes are not set " + attributes;
        }
    }
}

