/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AAppl2Term;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class Appl2Term
extends AAppl2Term
implements Serializable {
    private final IAttachments attachments;
    private final String op;
    private final ITerm arg0;
    private final ITerm arg1;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private Appl2Term(String op, ITerm arg0, ITerm arg1) {
        this.op = Objects.requireNonNull(op, "op");
        this.arg0 = Objects.requireNonNull(arg0, "arg0");
        this.arg1 = Objects.requireNonNull(arg1, "arg1");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl2Term(Builder builder) {
        this.op = builder.op;
        this.arg0 = builder.arg0;
        this.arg1 = builder.arg1;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl2Term(IAttachments attachments, String op, ITerm arg0, ITerm arg1) {
        this.attachments = attachments;
        this.op = op;
        this.arg0 = arg0;
        this.arg1 = arg1;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public ITerm getArg0() {
        return this.arg0;
    }

    @Override
    public ITerm getArg1() {
        return this.arg1;
    }

    @Override
    public final Appl2Term withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return Appl2Term.validate(new Appl2Term(newValue, this.op, this.arg0, this.arg1));
    }

    public final Appl2Term withOp(String value) {
        String newValue = Objects.requireNonNull(value, "op");
        if (this.op.equals(newValue)) {
            return this;
        }
        return Appl2Term.validate(new Appl2Term(this.attachments, newValue, this.arg0, this.arg1));
    }

    public final Appl2Term withArg0(ITerm value) {
        if (this.arg0 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg0");
        return Appl2Term.validate(new Appl2Term(this.attachments, this.op, newValue, this.arg1));
    }

    public final Appl2Term withArg1(ITerm value) {
        if (this.arg1 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg1");
        return Appl2Term.validate(new Appl2Term(this.attachments, this.op, this.arg0, newValue));
    }

    public static Appl2Term of(String op, ITerm arg0, ITerm arg1) {
        return Appl2Term.validate(new Appl2Term(op, arg0, arg1));
    }

    private static Appl2Term validate(Appl2Term instance) {
        instance = (Appl2Term)instance.check();
        return instance;
    }

    public static Appl2Term copyOf(AAppl2Term instance) {
        if (instance instanceof Appl2Term) {
            return (Appl2Term)instance;
        }
        return Appl2Term.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Appl2Term.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Appl2Term(Builder builder, Appl2Term appl2Term) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_OP = 1L;
        private static final long INIT_BIT_ARG0 = 2L;
        private static final long INIT_BIT_ARG1 = 4L;
        private long initBits = 7L;
        private IAttachments attachments;
        private String op;
        private ITerm arg0;
        private ITerm arg1;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AAppl2Term instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractApplTerm) {
                instance = (AbstractApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(((AbstractApplTerm)instance).getOp());
                    bits |= 1L;
                }
            }
            if (object instanceof AAppl2Term) {
                instance = (AAppl2Term)object;
                if ((bits & 1L) == 0L) {
                    this.op(((AAppl2Term)instance).getOp());
                    bits |= 1L;
                }
                this.arg1(((AAppl2Term)instance).getArg1());
                this.arg0(((AAppl2Term)instance).getArg0());
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof IApplTerm) {
                instance = (IApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(instance.getOp());
                    bits |= 1L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder op(String op) {
            this.op = Objects.requireNonNull(op, "op");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder arg0(ITerm arg0) {
            this.arg0 = Objects.requireNonNull(arg0, "arg0");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arg1(ITerm arg1) {
            this.arg1 = Objects.requireNonNull(arg1, "arg1");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Appl2Term build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return Appl2Term.validate(new Appl2Term(this, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("op");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arg0");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arg1");
            }
            return "Cannot build Appl2Term, some of required attributes are not set " + attributes;
        }
    }
}

