/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import io.usethesource.capsule.Set;
import java.util.Objects;
import java.util.stream.Collectors;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AbstractTerm;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public abstract class AbstractApplTerm
extends AbstractTerm
implements IApplTerm {
    private static final byte IS_GROUND_SET = 1;
    private static final byte IS_GROUND_FLAG = 2;
    private volatile byte isGround;

    @Value.Check
    protected abstract IApplTerm check();

    @Override
    public abstract String getOp();

    @Override
    public int getArity() {
        return this.getArgs().size();
    }

    @Override
    public boolean isGround() {
        byte result = this.isGround;
        if ((result & 1) == 0) {
            boolean ground = true;
            for (ITerm arg : this.getArgs()) {
                ground &= arg.isGround();
            }
            this.isGround = result = (byte)(1 | (ground ? 2 : 0));
        }
        return (result & 2) != 0;
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        if (this.isGround()) {
            return CapsuleUtil.immutableSet();
        }
        Set.Transient vars = CapsuleUtil.transientSet();
        this.visitVars(arg_0 -> vars.__insert(arg_0));
        return vars.freeze();
    }

    @Override
    public void visitVars(Action1<ITermVar> onVar) {
        if (this.isGround()) {
            return;
        }
        for (ITerm arg : this.getArgs()) {
            arg.visitVars(onVar);
        }
    }

    @Override
    public <T> T match(ITerm.Cases<T> cases) {
        return cases.caseAppl(this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(ITerm.CheckedCases<T, E> cases) throws E {
        return cases.caseAppl(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOp(), this.getArgs());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IApplTerm)) {
            return false;
        }
        IApplTerm that = (IApplTerm)other;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return Objects.equals(this.getOp(), that.getOp()) && Objects.equals(this.getArity(), that.getArity()) && Objects.equals(this.getArgs(), that.getArgs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOp());
        sb.append("(").append(this.getArgs().stream().map(Object::toString).collect(Collectors.joining(",", "", ""))).append(")");
        return sb.toString();
    }
}

