/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import com.google.common.collect.Lists;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.exceptions.CriticalEdgeDelayException;
import mb.nabl2.solver.exceptions.DelayException;
import mb.nabl2.solver.exceptions.InterruptedDelayException;
import mb.nabl2.solver.exceptions.RelationDelayException;
import mb.nabl2.solver.exceptions.UnconditionalDelayExpection;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.solver.messages.Messages;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IndexedBag;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import org.metaborg.util.Ref;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.RateLimitedCancel;

public class FixedPointSolver {
    private static final ILogger log = LoggerUtils.logger(FixedPointSolver.class);
    private final PublishSubject<Step> stepSubject;
    private final ICancel cancel;
    private final IProgress progress;
    private final ISolver component;

    public FixedPointSolver(ICancel cancel, IProgress progress, ISolver component) {
        this.cancel = new RateLimitedCancel(cancel, 42);
        this.progress = progress;
        this.component = component;
        this.stepSubject = PublishSubject.create();
    }

    public SolveResult solve(Iterable<? extends IConstraint> initialConstraints, Ref<IUnifier.Immutable> unifier) throws InterruptedException {
        boolean progress;
        Messages.Transient messages = Messages.Transient.of();
        LinkedList constraints = Lists.newLinkedList(initialConstraints);
        IndexedBag<IConstraint, CriticalEdge> criticalEdgeDelays = new IndexedBag<IConstraint, CriticalEdge>(IndexedBag.RemovalPolicy.ALL);
        IndexedBag<IConstraint, String> relationDelays = new IndexedBag<IConstraint, String>(IndexedBag.RemovalPolicy.ALL);
        IndexedBag<IConstraint, ITermVar> variableDelays = new IndexedBag<IConstraint, ITermVar>(IndexedBag.RemovalPolicy.ANY);
        ArrayList unsolved = Lists.newArrayList();
        Action1<Iterable> resolveCriticalEdges = es -> es.forEach(e -> {
            Collection newConstraints = criticalEdgeDelays.reindex((CriticalEdge)e, ce -> Iterables2.empty());
            newConstraints.forEach(constraints::addFirst);
        });
        Action1<Iterable> resolveRelation = names -> names.forEach(name2 -> {
            Collection newConstraints = relationDelays.reindex((String)name2, ce -> Iterables2.empty());
            newConstraints.forEach(constraints::addFirst);
        });
        int solvedCount = 0;
        int criticalEdgeDelayCount = 0;
        int relationDelayCount = 0;
        int unconditionalDelayCount = 0;
        int variableDelayCount = 0;
        do {
            progress = false;
            while (!constraints.isEmpty()) {
                SolveResult result;
                this.cancel.throwIfCancelled();
                IConstraint constraint = (IConstraint)constraints.removeFirst();
                try {
                    result = (SolveResult)this.component.apply(constraint);
                }
                catch (InterruptedDelayException e) {
                    throw e.getCause();
                }
                catch (UnconditionalDelayExpection e) {
                    unsolved.add(constraint);
                    ++unconditionalDelayCount;
                    continue;
                }
                catch (CriticalEdgeDelayException e) {
                    criticalEdgeDelays.add(constraint, e.getCause().criticalEdges());
                    ++criticalEdgeDelayCount;
                    continue;
                }
                catch (VariableDelayException e) {
                    variableDelays.add(constraint, e.variables());
                    ++variableDelayCount;
                    continue;
                }
                catch (RelationDelayException e) {
                    relationDelays.add(constraint, Iterables2.singleton(e.relation()));
                    ++relationDelayCount;
                    continue;
                }
                catch (DelayException e) {
                    throw new IllegalStateException(e);
                }
                result.unifierDiff().domainSet().forEach(v -> constraints.addAll(variableDelays.reindex((ITermVar)v, ((IUnifier.Immutable)unifier.get())::getVars)));
                messages.addAll(result.messages());
                result.constraints().forEach(constraints::addFirst);
                this.stepSubject.onNext(new Step(constraint, result, resolveCriticalEdges, resolveRelation));
                this.progress.work(1);
                progress |= true;
                ++solvedCount;
            }
        } while (progress);
        unsolved.addAll(constraints);
        unsolved.addAll(variableDelays.values());
        unsolved.addAll(criticalEdgeDelays.values());
        unsolved.addAll(relationDelays.values());
        return SolveResult.builder().messages(messages.freeze()).constraints(unsolved).build();
    }

    public Observable<Step> step() {
        return this.stepSubject;
    }

    public class Step {
        public final IConstraint constraint;
        public final SolveResult result;
        private final Action1<Iterable<CriticalEdge>> resolveCriticalEdges;
        private final Action1<Iterable<String>> resolveRelations;

        private Step(IConstraint constraint, SolveResult result, Action1<Iterable<CriticalEdge>> release, Action1<Iterable<String>> resolveRelations) {
            this.constraint = constraint;
            this.result = result;
            this.resolveCriticalEdges = release;
            this.resolveRelations = resolveRelations;
        }

        public void resolveCriticalEdges(Iterable<CriticalEdge> criticalEdges) {
            this.resolveCriticalEdges.apply(criticalEdges);
        }

        public void resolveRelations(Iterable<String> names) {
            this.resolveRelations.apply(names);
        }
    }
}

