/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.constraints.relations.CBuildRelation;
import mb.nabl2.constraints.relations.CCheckRelation;
import mb.nabl2.constraints.relations.CEvalFunction;
import mb.nabl2.constraints.relations.IRelationConstraint;
import mb.nabl2.relations.terms.FunctionName;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.VariantRelations;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.exceptions.DelayException;
import mb.nabl2.solver.exceptions.FunctionUndefinedException;
import mb.nabl2.solver.exceptions.RelationDelayException;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.TermMatch;
import mb.scopegraph.relations.IFunctionName;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.IRelationName;
import mb.scopegraph.relations.RelationException;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.PartialFunction1;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.tuple.Tuple2;

public class RelationComponent
extends ASolver {
    private final Predicate1<String> isComplete;
    private final Map<String, IVariantRelation.Transient<ITerm>> relations;
    private final Map<String, CheckedFunction1<ITerm, Optional<ITerm>, DelayException>> functions;

    public RelationComponent(SolverCore core, Predicate1<String> isComplete, Map<String, PartialFunction1<ITerm, ITerm>> functions, Map<String, IVariantRelation.Transient<ITerm>> relations) {
        super(core);
        this.isComplete = isComplete;
        this.relations = relations;
        this.functions = Maps.newHashMap();
        functions.forEach((name2, f) -> {
            CheckedFunction1 checkedFunction1 = this.functions.put((String)name2, f::apply);
        });
        this.addRelationFunctions();
    }

    private void addRelationFunctions() {
        for (String relationName : this.relations.keySet()) {
            String lubName = FunctionName.RelationFunctions.LUB.of(relationName);
            CheckedFunction1 lubFun = term -> {
                Optional<Tuple2> pair = TermMatch.M.tuple2(TermMatch.M.term(), TermMatch.M.term(), (t, l, r) -> Tuple2.of(l, r)).match((ITerm)term);
                if (pair.isPresent()) {
                    return this.lub(relationName, (ITerm)pair.get()._1(), (ITerm)pair.get()._2());
                }
                return Optional.empty();
            };
            this.functions.put(lubName, lubFun);
            String glbName = FunctionName.RelationFunctions.GLB.of(relationName);
            CheckedFunction1 glbFun = term -> {
                Optional<Tuple2> pair = TermMatch.M.tuple2(TermMatch.M.term(), TermMatch.M.term(), (t, l, r) -> Tuple2.of(l, r)).match((ITerm)term);
                if (pair.isPresent()) {
                    return this.glb(relationName, (ITerm)pair.get()._1(), (ITerm)pair.get()._2());
                }
                return Optional.empty();
            };
            this.functions.put(glbName, glbFun);
        }
    }

    public SeedResult seed(Map<String, IVariantRelation.Immutable<ITerm>> solution, IMessageInfo message) throws InterruptedException {
        for (Map.Entry<String, IVariantRelation.Immutable<ITerm>> entry : solution.entrySet()) {
            try {
                this.relation(entry.getKey()).addAll((IRelation<ITerm>)entry.getValue());
            }
            catch (RelationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return SeedResult.empty();
    }

    public SolveResult solve(IRelationConstraint constraint) throws DelayException {
        return constraint.matchOrThrow(IRelationConstraint.CheckedCases.of(this::solve, this::solve, this::solve));
    }

    public Map<String, IVariantRelation.Immutable<ITerm>> finish() {
        return VariantRelations.freeze(this.relations);
    }

    public SolveResult solve(CBuildRelation c) throws DelayException {
        if (!this.unifier().isGround(c.getLeft()) || !this.unifier().isGround(c.getRight())) {
            throw new VariableDelayException(Iterables.concat(this.unifier().getVars(c.getLeft()), this.unifier().getVars(c.getRight())));
        }
        ITerm left = this.unifier().findRecursive(c.getLeft());
        ITerm right = this.unifier().findRecursive(c.getRight());
        return c.getRelation().match(IRelationName.Cases.of(name2 -> {
            try {
                this.relation((String)name2).add(left, right);
            }
            catch (RelationException e) {
                IMessageInfo message = c.getMessageInfo().withDefaultContent(MessageContent.of(e.getMessage()));
                return SolveResult.messages(message);
            }
            return SolveResult.empty();
        }, extName -> {
            throw new IllegalArgumentException("Cannot add entries to external relations.");
        }));
    }

    public SolveResult solve(CCheckRelation c) throws DelayException {
        if (!this.unifier().isGround(c.getLeft()) || !this.unifier().isGround(c.getRight())) {
            throw new VariableDelayException(Iterables.concat(this.unifier().getVars(c.getLeft()), this.unifier().getVars(c.getRight())));
        }
        ITerm left = this.unifier().findRecursive(c.getLeft());
        ITerm right = this.unifier().findRecursive(c.getRight());
        return c.getRelation().matchOrThrow(IRelationName.CheckedCases.of(name2 -> {
            if (!this.isComplete.test((String)name2)) {
                throw new RelationDelayException((String)name2);
            }
            if (this.relation((String)name2).contains(left, right)) {
                return SolveResult.empty();
            }
            IMessageInfo message = c.getMessageInfo().withDefaultContent(MessageContent.builder().append(left).append(" and ").append(right).append(" not in ").append((String)name2).build());
            return SolveResult.messages(message);
        }, extName -> {
            ITerm msginfo = MessageInfo.build(c.getMessageInfo());
            return this.callExternal((String)extName, left, right, msginfo).map(csTerm -> Constraints.matchConstraintOrList().match((ITerm)csTerm, this.unifier()).map(iConstraint -> SolveResult.constraints(iConstraint)).orElseThrow(() -> new IllegalArgumentException("Expected list of constraints, got " + csTerm))).orElse(SolveResult.messages(c.getMessageInfo()));
        }));
    }

    public SolveResult solve(CEvalFunction c) throws DelayException {
        if (!this.unifier().isGround(c.getTerm())) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(c.getTerm()));
        }
        ITerm term = this.unifier().findRecursive(c.getTerm());
        return c.getFunction().matchOrThrow(IFunctionName.CheckedCases.of(name2 -> {
            CheckedFunction1<ITerm, Optional<ITerm>, DelayException> fun = this.functions.get(name2);
            if (fun == null) {
                throw new FunctionUndefinedException("Function " + name2 + " undefined.");
            }
            Optional<ITerm> result = fun.apply(term);
            IMessageInfo message = c.getMessageInfo().withDefaultContent(MessageContent.builder().append((String)name2).append(" failed on ").append(term).build());
            return result.map(ret -> SolveResult.constraints(CEqual.of(c.getResult(), ret, c.getMessageInfo()))).orElse(SolveResult.messages(message));
        }, extName -> this.callExternal((String)extName, term).map(ret -> SolveResult.constraints(CEqual.of(c.getResult(), ret, c.getMessageInfo()))).orElse(SolveResult.messages(c.getMessageInfo()))));
    }

    private IRelation.Transient<ITerm> relation(String name2) {
        return Optional.ofNullable(this.relations.get(name2)).orElseThrow(() -> new IllegalStateException("Relation <" + name2 + ": not defined."));
    }

    private Optional<ITerm> lub(String name2, ITerm left, ITerm right) throws RelationDelayException {
        if (!left.isGround() || !right.isGround()) {
            throw new IllegalArgumentException("lub arguments need to be ground.");
        }
        if (!this.isComplete.test(name2)) {
            throw new RelationDelayException(name2);
        }
        return this.relation(name2).leastUpperBound(left, right);
    }

    private Optional<ITerm> glb(String name2, ITerm left, ITerm right) throws RelationDelayException {
        if (!this.isComplete.test(name2)) {
            throw new RelationDelayException(name2);
        }
        if (!left.isGround() || !right.isGround()) {
            throw new IllegalArgumentException("lub arguments need to be ground.");
        }
        return this.relation(name2).greatestLowerBound(left, right);
    }
}

