/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.relations.terms.ExtRelation;
import mb.nabl2.relations.terms.NamedRelation;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.scopegraph.relations.IRelationName;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

public abstract class RelationName
extends AbstractApplTerm
implements IRelationName,
IApplTerm {
    public static TermMatch.IMatcher<? extends RelationName> matcher() {
        return TermMatch.M.preserveAttachments(TermMatch.M.cases(NamedRelation.matcher(), ExtRelation.matcher()));
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class AExtRelation
    extends RelationName {
        private static final String OP = "ExtRelation";

        AExtRelation() {
        }

        @Value.Parameter
        public abstract String getName();

        @Override
        public <T> T match(IRelationName.Cases<T> cases) {
            return cases.caseExt(this.getName());
        }

        @Override
        public <T, E extends Throwable> T matchOrThrow(IRelationName.CheckedCases<T, E> cases) throws E {
            return cases.caseExt(this.getName());
        }

        @Override
        protected AExtRelation check() {
            return this;
        }

        @Override
        @Value.Lazy
        public String getOp() {
            return OP;
        }

        @Override
        @Value.Lazy
        public List<ITerm> getArgs() {
            return ImmutableList.of((Object)TermBuild.B.newString(this.getName()));
        }

        public static TermMatch.IMatcher<ExtRelation> matcher() {
            return TermMatch.M.preserveAttachments(TermMatch.M.appl1(OP, TermMatch.M.stringValue(), (t, name2) -> ExtRelation.of(name2)));
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ExtRelation)) {
                return super.equals(other);
            }
            ExtRelation that = (ExtRelation)other;
            return this.getName().equals(that.getName());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return "`" + this.getName() + "`";
        }
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ANamedRelation
    extends RelationName {
        private static final String OP0 = "DefaultRelation";
        private static final String OP1 = "Relation";

        ANamedRelation() {
        }

        @Value.Parameter
        public abstract String getName();

        @Override
        public <T> T match(IRelationName.Cases<T> cases) {
            return cases.caseNamed(this.getName());
        }

        @Override
        public <T, E extends Throwable> T matchOrThrow(IRelationName.CheckedCases<T, E> cases) throws E {
            return cases.caseNamed(this.getName());
        }

        @Override
        protected ANamedRelation check() {
            return this;
        }

        @Override
        @Value.Lazy
        public String getOp() {
            return this.getName().isEmpty() ? OP0 : OP1;
        }

        @Override
        @Value.Lazy
        public List<ITerm> getArgs() {
            return this.getName().isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)TermBuild.B.newString(this.getName()));
        }

        public static TermMatch.IMatcher<NamedRelation> matcher() {
            return TermMatch.M.preserveAttachments(TermMatch.M.cases(TermMatch.M.appl0(OP0, t -> NamedRelation.of("")), TermMatch.M.appl1(OP1, TermMatch.M.stringValue(), (t, name2) -> NamedRelation.of(name2))));
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof NamedRelation)) {
                return super.equals(other);
            }
            NamedRelation that = (NamedRelation)other;
            return this.getName().equals(that.getName());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

