/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.relations.terms.RelationName;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;

final class NamedRelation
extends RelationName.ANamedRelation
implements Serializable {
    private final IAttachments attachments;
    private final String name;
    private volatile transient long lazyInitBitmap;
    private static final long OP_LAZY_INIT_BIT = 1L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 2L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private NamedRelation(String name2) {
        this.name = Objects.requireNonNull(name2, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private NamedRelation(IAttachments attachments, String name2) {
        this.attachments = attachments;
        this.name = name2;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final NamedRelation withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new NamedRelation(newValue, this.name);
    }

    public final NamedRelation withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new NamedRelation(this.attachments, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            NamedRelation namedRelation = this;
            synchronized (namedRelation) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            NamedRelation namedRelation = this;
            synchronized (namedRelation) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.args;
    }

    public static NamedRelation of(String name2) {
        return new NamedRelation(name2);
    }

    public static NamedRelation copyOf(RelationName.ANamedRelation instance) {
        if (instance instanceof NamedRelation) {
            return (NamedRelation)instance;
        }
        return NamedRelation.of(instance.getName()).withAttachments(instance.getAttachments());
    }
}

