/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.relations.terms.ExtFunction;
import mb.nabl2.relations.terms.NamedFunction;
import mb.nabl2.relations.terms.NamedRelation;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.scopegraph.relations.IFunctionName;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

public abstract class FunctionName
extends AbstractApplTerm
implements IFunctionName,
IApplTerm {
    public static TermMatch.IMatcher<? extends FunctionName> matcher() {
        return TermMatch.M.preserveAttachments(TermMatch.M.cases(NamedFunction.matcher(), ExtFunction.matcher(), TermMatch.M.appl1("Lub", NamedRelation.matcher(), (t, r) -> NamedFunction.of(RelationFunctions.LUB.of(r.getName()))), TermMatch.M.appl1("Glb", NamedRelation.matcher(), (t, r) -> NamedFunction.of(RelationFunctions.GLB.of(r.getName())))));
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class AExtFunction
    extends FunctionName {
        private static final String OP = "ExtFunction";

        AExtFunction() {
        }

        @Value.Parameter
        public abstract String getName();

        @Override
        public <T> T match(IFunctionName.Cases<T> cases) {
            return cases.caseExt(this.getName());
        }

        @Override
        public <T, E extends Throwable> T matchOrThrow(IFunctionName.CheckedCases<T, E> cases) throws E {
            return cases.caseExt(this.getName());
        }

        @Override
        protected AExtFunction check() {
            return this;
        }

        @Override
        @Value.Lazy
        public String getOp() {
            return OP;
        }

        @Override
        @Value.Lazy
        public List<ITerm> getArgs() {
            return ImmutableList.of((Object)TermBuild.B.newString(this.getName()));
        }

        public static TermMatch.IMatcher<ExtFunction> matcher() {
            return TermMatch.M.preserveAttachments(TermMatch.M.appl1(OP, TermMatch.M.stringValue(), (t, name2) -> ExtFunction.of(name2)));
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ExtFunction)) {
                return super.equals(other);
            }
            ExtFunction that = (ExtFunction)other;
            return this.getName().equals(that.getName());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return "`" + this.getName() + "`";
        }
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    static abstract class ANamedFunction
    extends FunctionName {
        private static final String OP = "Function";

        ANamedFunction() {
        }

        @Value.Parameter
        public abstract String getName();

        @Override
        public <T> T match(IFunctionName.Cases<T> cases) {
            return cases.caseNamed(this.getName());
        }

        @Override
        public <T, E extends Throwable> T matchOrThrow(IFunctionName.CheckedCases<T, E> cases) throws E {
            return cases.caseNamed(this.getName());
        }

        @Override
        protected ANamedFunction check() {
            return this;
        }

        @Override
        @Value.Lazy
        public String getOp() {
            return OP;
        }

        @Override
        @Value.Lazy
        public List<ITerm> getArgs() {
            return ImmutableList.of((Object)TermBuild.B.newString(this.getName()));
        }

        public static TermMatch.IMatcher<NamedFunction> matcher() {
            return TermMatch.M.preserveAttachments(TermMatch.M.appl1(OP, TermMatch.M.stringValue(), (t, name2) -> NamedFunction.of(name2)));
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof NamedFunction)) {
                return super.equals(other);
            }
            NamedFunction that = (NamedFunction)other;
            return this.getName().equals(that.getName());
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public static enum RelationFunctions {
        LUB,
        GLB;


        public String of(String relation) {
            return relation.isEmpty() ? this.name() : String.valueOf(relation) + "." + this.name();
        }
    }
}

