/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.solver;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mb.flowspec.controlflow.IBasicBlock;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IControlFlowGraph;
import mb.flowspec.controlflow.IFlowSpecSolution;
import mb.flowspec.controlflow.TransferFunctionAppl;
import mb.flowspec.graph.Algorithms;
import mb.flowspec.runtime.interpreter.InterpreterBuilder;
import mb.flowspec.runtime.interpreter.TransferFunction;
import mb.flowspec.runtime.interpreter.UnreachableException;
import mb.flowspec.runtime.lattice.CompleteLattice;
import mb.flowspec.runtime.lattice.FullSetLattice;
import mb.flowspec.runtime.solver.CyclicGraphException;
import mb.flowspec.runtime.solver.FixedPointLimitException;
import mb.flowspec.runtime.solver.Metadata;
import mb.flowspec.runtime.solver.ParseException;
import mb.flowspec.runtime.solver.StaticInfo;
import mb.flowspec.runtime.solver.UnimplementedException;
import org.metaborg.util.Ref;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class FixedPoint {
    private static final ILogger logger = LoggerUtils.logger(FixedPoint.class);
    private static final String ARTIFICIAL_PROPERTY = "__START__";
    private static final int FIXPOINT_LIMIT = 500;
    private static final Function<IBasicBlock, IBasicBlock> ID = b -> b;
    private IFlowSpecSolution solution;
    private final TimingInfo timingInfo;
    private Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> preProperties = new HashMap<String, Map<ICFGNode, Ref<IStrategoTerm>>>();
    private Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> postProperties = new HashMap<String, Map<ICFGNode, Ref<IStrategoTerm>>>();

    public FixedPoint() {
        this.timingInfo = new TimingInfo();
    }

    public IFlowSpecSolution entryPoint(ITermFactory termFactory, IFlowSpecSolution nabl2solution, InterpreterBuilder interpBuilder) {
        StaticInfo staticInfo = interpBuilder.build(termFactory, nabl2solution, this.preProperties);
        return this.entryPoint(nabl2solution, staticInfo, staticInfo.metadata.keySet());
    }

    public IFlowSpecSolution entryPoint(ITermFactory termFactory, IFlowSpecSolution oldSolution, InterpreterBuilder interpBuilder, Collection<String> propNames) {
        StaticInfo staticInfo = interpBuilder.build(termFactory, oldSolution, this.preProperties);
        return this.entryPoint(oldSolution, staticInfo, propNames);
    }

    public IFlowSpecSolution entryPoint(IFlowSpecSolution oldSolution, StaticInfo staticInfo, Collection<String> propNames) {
        this.solution = oldSolution;
        IControlFlowGraph cfg = this.solution.controlFlowGraph();
        this.preProperties.putAll(this.solution.preProperties());
        this.postProperties.putAll(this.solution.postProperties());
        this.timingInfo.recordStart();
        this.timingInfo.recordInterpInit();
        if (logger.debugEnabled()) {
            logger.debug("SCCs: {}", cfg.topoSCCs());
        }
        try {
            this.solve(cfg, staticInfo, propNames);
            this.timingInfo.recordEnd();
            this.timingInfo.logReport(logger);
            IFlowSpecSolution flowspecSolution = oldSolution.withProperties(Collections.unmodifiableMap(this.preProperties), Collections.unmodifiableMap(this.postProperties));
            return flowspecSolution;
        }
        catch (UnreachableException | CyclicGraphException | FixedPointLimitException | ParseException | UnimplementedException e) {
            logger.error("Exception during FlowSpec solving: ", e);
            return oldSolution;
        }
    }

    private void solve(IControlFlowGraph cfg, StaticInfo staticInfo, Collection<String> propNames) throws CyclicGraphException, FixedPointLimitException {
        HashSet<String> allProps = new HashSet<String>(staticInfo.metadata.keySet());
        Iterator<String> iterator = propNames.iterator();
        while (iterator.hasNext()) {
            String propName = iterator.next();
            if (!allProps.contains(propName)) {
                logger.error("Given property {} cannot be found and will be ignored. ", propName);
                iterator.remove();
                continue;
            }
            allProps.remove(propName);
        }
        Iterable<String> propTopoOrder = allProps.isEmpty() ? Algorithms.topoSort(propNames, staticInfo.dependsOn.inverse()) : Algorithms.topoDeps(propNames, staticInfo.dependsOn);
        this.timingInfo.recordReverseTopo();
        for (String prop : propTopoOrder) {
            if (prop == ARTIFICIAL_PROPERTY) continue;
            this.solveFlowSensitiveProperty(cfg, prop, staticInfo.metadata.get(prop));
            this.timingInfo.recordProperty(prop);
        }
    }

    private void swapPrePostProperties(String prop, Map<ICFGNode, Ref<IStrategoTerm>> preProps, Map<ICFGNode, Ref<IStrategoTerm>> postProps) {
        this.preProperties.put(prop, postProps);
        this.postProperties.put(prop, preProps);
    }

    private void solveFlowSensitiveProperty(IControlFlowGraph cfg, String prop, Metadata<IStrategoTerm> metadata) throws FixedPointLimitException {
        Function<IBasicBlock, Set> next;
        Function<IBasicBlock, Set> prev;
        Set<ICFGNode> initialNodes;
        Iterable<Set<IBasicBlock>> sccs;
        Function<IBasicBlock, IBasicBlock> blockDir;
        HashMap<ICFGNode, Ref<IStrategoTerm>> preProps = new HashMap<ICFGNode, Ref<IStrategoTerm>>();
        this.preProperties.put(prop, preProps);
        HashMap<ICFGNode, Ref<IStrategoTerm>> postProps = new HashMap<ICFGNode, Ref<IStrategoTerm>>();
        this.postProperties.put(prop, postProps);
        switch (metadata.dir) {
            case Forward: {
                blockDir = ID;
                sccs = cfg.topoSCCs();
                initialNodes = cfg.startNodes();
                prev = cfg::prevBlocks;
                next = cfg::nextBlocks;
                break;
            }
            case Backward: {
                blockDir = IBasicBlock::inverse;
                sccs = cfg.revTopoSCCs();
                initialNodes = cfg.endNodes();
                prev = b -> cfg.nextBlocks(b.inverse());
                next = b -> cfg.prevBlocks(b.inverse());
                break;
            }
            default: {
                throw new RuntimeException("Unreachable: Dataflow property direction enum has unexpected value");
            }
        }
        for (Set<IBasicBlock> set : sccs) {
            for (IBasicBlock b2 : set) {
                ICFGNode pred;
                b2.clearIgnored();
                IBasicBlock block = blockDir.apply(b2);
                Iterator iterator = block.iterator();
                ICFGNode n = (ICFGNode)iterator.next();
                Set prevBlocks = prev.apply(block);
                if (prevBlocks.size() == 1) {
                    pred = blockDir.apply((IBasicBlock)prevBlocks.iterator().next()).last();
                    this.perhapsIgnored(prop, metadata, block, n, pred, preProps, postProps);
                } else {
                    preProps.put(n, new Ref<IStrategoTerm>((IStrategoTerm)metadata.lattice.bottom()));
                    postProps.put(n, new Ref<IStrategoTerm>((IStrategoTerm)metadata.lattice.bottom()));
                }
                while (iterator.hasNext()) {
                    pred = n;
                    n = (ICFGNode)iterator.next();
                    this.perhapsIgnored(prop, metadata, block, n, pred, preProps, postProps);
                }
            }
        }
        for (ICFGNode iCFGNode : initialNodes) {
            ((Ref)preProps.get(iCFGNode)).set(this.callTFInitial(prop, metadata, iCFGNode, preProps));
        }
        for (Set set : sccs) {
            boolean done = false;
            int fixpointCount = 0;
            while (!done) {
                if (fixpointCount >= 500) {
                    throw new FixedPointLimitException(prop, 500);
                }
                done = true;
                ++fixpointCount;
                for (IBasicBlock b3 : set) {
                    IBasicBlock block = blockDir.apply(b3);
                    PeekingIterator iterator = Iterators.peekingIterator(block.iterator());
                    while (iterator.hasNext()) {
                        ICFGNode from = (ICFGNode)iterator.next();
                        if (iterator.hasNext()) {
                            if (!this.compute(from, (ICFGNode)iterator.peek(), prop, metadata, block, preProps)) continue;
                            done = false;
                            continue;
                        }
                        Set nextBlocks = next.apply(block);
                        for (IBasicBlock nextB : nextBlocks) {
                            IBasicBlock nextBlock = blockDir.apply(nextB);
                            if (!this.compute(from, nextBlock.first(), prop, metadata, nextBlock, preProps) || !set.contains(nextB)) continue;
                            done = false;
                        }
                    }
                }
            }
            if (fixpointCount <= true) continue;
            logger.debug("Property '{}' took {} runs through an SCC to solve it. ", prop, fixpointCount);
        }
        for (Set set : sccs) {
            for (IBasicBlock block : set) {
                for (ICFGNode n : blockDir.apply(block)) {
                    IStrategoTerm value = this.callTF(prop, metadata, n, preProps);
                    postProps.put(n, new Ref<IStrategoTerm>(value));
                }
            }
        }
        switch (metadata.dir) {
            case Forward: {
                break;
            }
            case Backward: {
                this.swapPrePostProperties(prop, preProps, postProps);
                break;
            }
            default: {
                throw new RuntimeException("Unreachable: Dataflow property direction enum has unexpected value");
            }
        }
    }

    public void perhapsIgnored(String prop, Metadata<IStrategoTerm> metadata, IBasicBlock block, ICFGNode n, ICFGNode pred, Map<ICFGNode, Ref<IStrategoTerm>> preProps, Map<ICFGNode, Ref<IStrategoTerm>> postProps) {
        if (this.solution.getTFAppl(pred, prop) == null) {
            block.ignore(n);
            preProps.put(n, preProps.get(pred));
            postProps.put(n, postProps.get(pred));
        } else {
            preProps.put(n, new Ref<IStrategoTerm>((IStrategoTerm)metadata.lattice.bottom()));
            postProps.put(n, new Ref<IStrategoTerm>((IStrategoTerm)metadata.lattice.bottom()));
        }
    }

    public boolean compute(ICFGNode from, ICFGNode to2, String prop, Metadata<IStrategoTerm> metadata, IBasicBlock block, Map<ICFGNode, Ref<IStrategoTerm>> preProps) {
        IStrategoTerm beforeToTF;
        IStrategoTerm afterFromTF;
        if (!block.ignored(to2) && metadata.lattice.nleq(afterFromTF = this.callTF(prop, metadata, from, preProps), beforeToTF = preProps.get(to2).get())) {
            preProps.get(to2).set(metadata.lattice.lub(beforeToTF, afterFromTF));
            return true;
        }
        return false;
    }

    private IStrategoTerm callTFInitial(String prop, Metadata<?> metadata, ICFGNode node, Map<ICFGNode, Ref<IStrategoTerm>> preProps) {
        TransferFunctionAppl tfAppl = this.solution.getTFAppl(node, prop);
        if (tfAppl == null) {
            CompleteLattice l = metadata.lattice;
            if (l instanceof CompleteLattice.Flipped) {
                l = ((CompleteLattice.Flipped)l).wrapped;
            }
            if (l instanceof FullSetLattice) {
                return new mb.flowspec.runtime.interpreter.values.Set();
            }
            throw new RuntimeException("Missing extremal (start/end) rule for node: " + node);
        }
        return this.callTF(prop, metadata, node, preProps);
    }

    private IStrategoTerm callTF(String prop, Metadata<?> metadata, ICFGNode node, Map<ICFGNode, Ref<IStrategoTerm>> preProps) {
        TransferFunctionAppl tfAppl = this.solution.getTFAppl(node, prop);
        if (tfAppl == null) {
            return preProps.get(node).get();
        }
        TransferFunction tf = TransferFunction.findFunction(metadata.transferFunctions, tfAppl);
        return tf.call(tfAppl, node);
    }

    protected static class TimingInfo {
        private LinkedHashMap<String, Long> property = new LinkedHashMap();
        private long start;
        private long interpInit;
        private long reverseTopo;
        private long end;

        public void recordStart() {
            this.start = System.nanoTime();
        }

        public void logReport(ILogger logger) {
            long total = TimingInfo.millisecondBetween(this.start, this.end);
            long interpInit = TimingInfo.millisecondBetween(this.start, this.interpInit);
            long reverseTopo = TimingInfo.millisecondBetween(this.interpInit, this.reverseTopo);
            long properties = TimingInfo.millisecondBetween(this.reverseTopo, this.end);
            String[] propertyNames = new String[this.property.size()];
            long[] propertyTimes = new long[this.property.size()];
            long current = this.reverseTopo;
            int i = 0;
            for (Map.Entry<String, Long> e : this.property.entrySet()) {
                propertyNames[i] = e.getKey();
                propertyTimes[i] = TimingInfo.millisecondBetween(current, e.getValue());
                current = e.getValue();
                ++i;
            }
            StringBuilder message = new StringBuilder();
            message.append("FlowSpec dataflow solver timing report, time in milliseconds.\n");
            message.append("Total time: " + total + "\n");
            message.append("|- Initialising the interpreter: " + interpInit + "\n");
            message.append("|- Reverse topo order of properties: " + reverseTopo + "\n");
            message.append("|- Total dataflow property computation: " + properties + "\n");
            int i2 = 0;
            while (i2 < propertyNames.length) {
                message.append("  |- Compute property '" + propertyNames[i2] + "': " + propertyTimes[i2] + "\n");
                ++i2;
            }
            logger.debug(message.toString());
        }

        public void recordInterpInit() {
            this.interpInit = System.nanoTime();
        }

        public void recordReverseTopo() {
            this.reverseTopo = System.nanoTime();
        }

        public void recordProperty(String name2) {
            this.property.put(name2, System.nanoTime());
        }

        public void recordEnd() {
            this.end = System.nanoTime();
        }

        private static long millisecondBetween(long start, long end) {
            return (end - start) / 1000000L;
        }
    }
}

