/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import io.usethesource.capsule.Map;
import java.util.Map;
import mb.flowspec.runtime.interpreter.UnreachableException;
import mb.flowspec.runtime.interpreter.expressions.CompPredicateNode;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.patterns.PatternNode;
import mb.flowspec.runtime.interpreter.values.Map;
import mb.flowspec.terms.B;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.util.M;

public class MapCompNode
extends ExpressionNode {
    public final ExpressionNode expression;
    public final PatternNode[] sourcePatterns;
    public final ExpressionNode[] sources;
    public final CompPredicateNode[] predicates;

    public MapCompNode(ExpressionNode expression, PatternNode[] sourcePatterns, ExpressionNode[] sources, CompPredicateNode[] predicates) {
        this.expression = expression;
        this.sourcePatterns = sourcePatterns;
        this.sources = sources;
        this.predicates = predicates;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            return this.executeIMap(frame);
        }
        catch (UnexpectedResultException e) {
            throw new UnreachableException((Exception)((Object)e));
        }
    }

    @Override
    public IStrategoTerm executeIStrategoTerm(VirtualFrame frame) {
        try {
            return this.executeIMap(frame);
        }
        catch (UnexpectedResultException e) {
            throw new UnreachableException((Exception)((Object)e));
        }
    }

    public Map<IStrategoTerm, IStrategoTerm> executeIMap(VirtualFrame frame) throws UnexpectedResultException {
        Map.Immutable<IStrategoTerm, IStrategoTerm> map = this.sources[0].executeIMap(frame).getMap();
        Map.Transient result = Map.Transient.of();
        for (Map.Entry value : map.entrySet()) {
            boolean keep = this.sourcePatterns[0].matchGeneric(frame, B.tuple((IStrategoTerm)value.getKey(), (IStrategoTerm)value.getValue()));
            CompPredicateNode[] compPredicateNodeArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                CompPredicateNode pred = compPredicateNodeArray[n2];
                keep &= pred.executeBoolean(frame);
                ++n2;
            }
            if (!keep) continue;
            IStrategoTerm expectedTuple = this.expression.executeIStrategoTerm(frame);
            IStrategoTuple tuple2 = M.tuple(expectedTuple, 2);
            result.__put((Object)M.at(tuple2, 0), (Object)M.at(tuple2, 1));
        }
        return new Map<IStrategoTerm, IStrategoTerm>(result.freeze());
    }
}

