/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import java.util.function.BiFunction;
import mb.flowspec.runtime.InitValues;
import mb.flowspec.runtime.Initializable;
import mb.flowspec.runtime.interpreter.expressions.FunRefNode;
import mb.flowspec.runtime.lattice.CompleteLattice;

public class LatticeOpRefNode
implements Initializable,
FunRefNode {
    public final LatticeOp op;
    public final String name;
    public BiFunction function;

    public LatticeOpRefNode(LatticeOp op, String name2) {
        this.op = op;
        this.name = name2;
    }

    @Override
    public void init(InitValues initValues) {
        CompleteLattice lattice = initValues.lattices.get(this.name);
        switch (this.op) {
            case Lub: {
                this.function = lattice::lub;
                break;
            }
            case Glb: {
                this.function = lattice::glb;
                break;
            }
            case Geq: {
                this.function = lattice::geq;
                break;
            }
            case Leq: {
                this.function = lattice::leq;
                break;
            }
            case NLeq: {
                this.function = lattice::nleq;
                break;
            }
        }
    }

    public static enum LatticeOp {
        Lub,
        Glb,
        Leq,
        Geq,
        NLeq;

    }
}

