/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.google.common.collect.ImmutableList;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.flowspec.runtime.InitValues;
import mb.flowspec.runtime.Initializable;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.TypeErrorException;
import mb.flowspec.runtime.interpreter.locals.ReadVarNode;
import mb.flowspec.runtime.interpreter.values.Name;
import mb.flowspec.terms.B;
import mb.flowspec.terms.TermIndex;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.scopegraph.pepm16.terms.Occurrence;

public class ExtPropNode
extends ExpressionNode
implements Initializable {
    private InitValues initValues;
    private final String propName;
    @Node.Child
    private ReadVarNode rhs;

    public ExtPropNode(String propName, ReadVarNode rhs) {
        this.propName = propName;
        this.rhs = rhs;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            mb.nabl2.terms.stratego.TermIndex rhsIndex = TermIndex.get(this.rhs.executeIStrategoTerm(frame)).get().toNaBL2TermIndex();
            Optional<ITerm> nabl2value = this.initValues.astProperties.getValue(rhsIndex, TermBuild.B.newAppl("Property", TermBuild.B.newString(this.propName))).map(this.initValues.unifier::findRecursive);
            List value = (List)nabl2value.flatMap(term -> TermMatch.M.listElems(Occurrence.matcher(), (t, list2) -> list2).match((ITerm)term, PersistentUnifier.Immutable.of())).orElseGet(() -> ImmutableList.builder().build());
            List<Name> names = value.stream().map(occ -> Name.fromOccurrence(this.initValues, occ)).collect(Collectors.toList());
            return B.list(names.toArray(new Name[0]));
        }
        catch (UnexpectedResultException e) {
            throw new TypeErrorException(e);
        }
    }

    @Override
    public void init(InitValues initValues) {
        this.initValues = initValues;
    }
}

