/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import io.usethesource.capsule.Set;
import java.util.Arrays;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.FunRefNode;
import mb.flowspec.runtime.interpreter.expressions.FunRefRefNode;
import mb.flowspec.runtime.interpreter.expressions.LatticeOpRefNode;
import mb.flowspec.runtime.interpreter.expressions.QualRefNode;
import mb.flowspec.runtime.interpreter.values.Set;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class ApplicationNode
extends ExpressionNode {
    private static ILogger logger = LoggerUtils.logger(ApplicationNode.class);
    private final FunRefNode reference;
    private final ExpressionNode[] arguments;

    public ApplicationNode(FunRefNode reference, ExpressionNode[] arguments) {
        this.reference = reference;
        this.arguments = arguments;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        block12: {
            QualRefNode qualRef;
            block13: {
                if (this.reference instanceof LatticeOpRefNode) {
                    LatticeOpRefNode opRefNode = (LatticeOpRefNode)this.reference;
                    assert (this.arguments.length == 2);
                    Object arg0 = this.arguments[0].executeGeneric(frame);
                    Object arg1 = this.arguments[1].executeGeneric(frame);
                    return opRefNode.function.apply(arg0, arg1);
                }
                if (this.reference instanceof FunRefRefNode) {
                    FunRefRefNode opRefNode = (FunRefRefNode)this.reference;
                    Object[] args = Arrays.stream(this.arguments).map(a -> a.executeGeneric(frame)).toArray();
                    return Truffle.getRuntime().createCallTarget((RootNode)opRefNode.function).call(args);
                }
                if (!(this.reference instanceof QualRefNode)) break block12;
                qualRef = (QualRefNode)this.reference;
                if (qualRef.modname.length != 1 || !qualRef.modname[0].equals("Set")) break block13;
                switch (qualRef.var) {
                    case "fromList": {
                        assert (this.arguments.length == 1);
                        Object arg0 = this.arguments[0].executeGeneric(frame);
                        assert (arg0 instanceof IStrategoTerm && TermUtils.isList((IStrategoTerm)arg0));
                        return new Set<IStrategoTerm>(ApplicationNode.listTermToSet((IStrategoList)arg0));
                    }
                }
                logger.warn("Don't know reference " + qualRef.var);
                break block12;
            }
            logger.warn("Don't know Qualifier " + Arrays.toString(qualRef.modname));
        }
        throw new RuntimeException("Application of unknown function: " + this.reference);
    }

    private static Set.Immutable<IStrategoTerm> listTermToSet(IStrategoList list2) {
        Set.Transient terms = Set.Transient.of();
        for (IStrategoTerm term : list2) {
            terms.__insert((Object)term);
        }
        return terms.freeze();
    }
}

