/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.primitives;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mb.flowspec.controlflow.IFlowSpecSolution;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.IResult;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.stratego.StrategoBlob;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class AnalysisPrimitive
extends AbstractPrimitive {
    protected final int tvars;
    private ITermFactory tf;

    public AnalysisPrimitive(String name2, int tvars) {
        super(name2, 0, tvars + 1);
        this.tvars = tvars;
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        this.tf = env.getFactory();
        List<IStrategoTerm> termArgs = Arrays.asList(Arrays.copyOfRange(tvars, 1, tvars.length));
        return this.call(env.current(), tvars[0], termArgs, this.tf).map(t -> {
            env.setCurrent((IStrategoTerm)t);
            return true;
        }).orElse(false);
    }

    private Optional<? extends IStrategoTerm> call(IStrategoTerm term, IStrategoTerm analysisTerm, List<IStrategoTerm> otherTerms, ITermFactory factory) throws InterpreterException {
        StrategoBlob blob;
        if (otherTerms.size() != this.tvars) {
            throw new InterpreterException("Expected " + this.tvars + " term arguments, but got " + otherTerms.size());
        }
        if (analysisTerm instanceof StrategoBlob && (blob = (StrategoBlob)analysisTerm).value() instanceof IResult) {
            IResult result = (IResult)blob.value();
            return this.call(result, term, otherTerms);
        }
        throw new IllegalArgumentException("Not a valid analysis term.");
    }

    protected Optional<? extends IStrategoTerm> call(IResult result, IStrategoTerm term, List<IStrategoTerm> terms) throws InterpreterException {
        Optional<IFlowSpecSolution> solution = AnalysisPrimitive.getFSSolution(result);
        if (solution.isPresent()) {
            return this.call(solution.get(), term, terms);
        }
        throw new IllegalArgumentException("Cannot find FlowSpec solution in analysis term.");
    }

    protected Optional<? extends IStrategoTerm> call(IFlowSpecSolution solution, IStrategoTerm term, List<IStrategoTerm> terms) throws InterpreterException {
        return Optional.empty();
    }

    public static Optional<IFlowSpecSolution> getFSSolution(IResult result) {
        ISolution solution = result.solution();
        if (solution instanceof IFlowSpecSolution) {
            return Optional.of((IFlowSpecSolution)solution);
        }
        return result.customAnalysis().flatMap(customAnalysis -> {
            if (customAnalysis instanceof IFlowSpecSolution) {
                return Optional.of((IFlowSpecSolution)customAnalysis);
            }
            return customAnalysis.match(Terms.cases().blob(blob -> {
                Object blobValue = blob.getValue();
                if (blobValue instanceof IFlowSpecSolution) {
                    return Optional.of((IFlowSpecSolution)blobValue);
                }
                if (blobValue instanceof IResult && blobValue != result) {
                    return AnalysisPrimitive.getFSSolution((IResult)blobValue);
                }
                return Optional.empty();
            }).otherwise(t -> Optional.empty()));
        });
    }

    public ITermFactory getFactory() {
        return this.tf;
    }
}

