/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import com.google.common.collect.Sets;
import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.flowspec.controlflow.ControlFlowGraph;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IFlowSpecSolution;
import org.metaborg.util.Ref;
import org.spoofax.interpreter.terms.IStrategoTerm;

public final class ControlFlowGraphTerms {
    private static final String ESCAPE_MATCH = "\\\\$0";
    private static final String RECORD_RESERVED = "[\"{}|]";
    private final ControlFlowGraph controlFlowGraph;
    private final Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> preProperties;
    private final Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> postProperties;

    private ControlFlowGraphTerms(IFlowSpecSolution solution) {
        this.controlFlowGraph = (ControlFlowGraph)solution.controlFlowGraph();
        this.preProperties = solution.preProperties();
        this.postProperties = solution.postProperties();
    }

    private String toDot() {
        Set<String> properties = this.preProperties.keySet();
        Sets.SetView entryExitNodes = Sets.union(this.controlFlowGraph.entryNodes(), this.controlFlowGraph.exitNodes());
        String starts = this.controlFlowGraph.startNodes().stream().map(node -> this.nodeToDot((ICFGNode)node, properties)).collect(Collectors.joining());
        String ends = this.controlFlowGraph.endNodes().stream().map(node -> this.nodeToDot((ICFGNode)node, properties)).collect(Collectors.joining());
        String otherNodes = this.controlFlowGraph.normalNodes().stream().map(node -> this.nodeToDot((ICFGNode)node, properties)).collect(Collectors.joining());
        String edges = this.removeNodes(this.controlFlowGraph.edges(), (Set<ICFGNode>)entryExitNodes).tupleStream(this::edgeToDot).collect(Collectors.joining());
        return "digraph FG {\nnode [ shape = record, style = \"rounded\" ];\n" + starts + ends + "node [ style = \"\" ];\n" + otherNodes + edges + "}";
    }

    private BinaryRelation.Immutable<ICFGNode, ICFGNode> removeNodes(BinaryRelation.Immutable<ICFGNode, ICFGNode> edges, Set<ICFGNode> toRemove) {
        BinaryRelation.Transient result = edges.asTransient();
        for (ICFGNode node : toRemove) {
            Set.Immutable tos = result.get((Object)node);
            Set.Immutable froms = result.inverse().get((Object)node);
            result.__remove((Object)node);
            for (ICFGNode from : froms) {
                result.__remove((Object)from, (Object)node);
                for (ICFGNode to2 : tos) {
                    result.__insert((Object)from, (Object)to2);
                }
            }
        }
        return result.freeze();
    }

    private String edgeToDot(ICFGNode from, ICFGNode to2) {
        return "\"" + from.toString() + "\" -> \"" + to2.toString() + "\";\n";
    }

    private String nodeToDot(ICFGNode node, Set<String> properties) {
        String propNames = "{" + properties.stream().map(n -> n.replaceAll(RECORD_RESERVED, ESCAPE_MATCH)).collect(Collectors.joining("|")) + "}";
        String prePropVals = "{" + properties.stream().map(n -> this.prePropValToDot(node, (String)n)).collect(Collectors.joining("|")) + "}";
        String postPropVals = "{" + properties.stream().map(n -> this.postPropValToDot(node, (String)n)).collect(Collectors.joining("|")) + "}";
        String props = "{" + propNames + "|" + prePropVals + "|" + postPropVals + "}";
        return "\"" + node.toString() + "\" [ label = \"{" + (String.valueOf(node.getCFGNodeName()) + node.getIndex().toString()).replaceAll(RECORD_RESERVED, ESCAPE_MATCH) + "|" + props + "}\" ];\n";
    }

    private String prePropValToDot(ICFGNode node, String prop) {
        IStrategoTerm prePropVal = this.preProperties.get(prop).get(node).get();
        return prePropVal.toString().replaceAll(RECORD_RESERVED, ESCAPE_MATCH);
    }

    private String postPropValToDot(ICFGNode node, String prop) {
        IStrategoTerm postPropVal = this.postProperties.get(prop).get(node).get();
        return postPropVal.toString().replaceAll(RECORD_RESERVED, ESCAPE_MATCH);
    }

    public static String toDot(IFlowSpecSolution solution) {
        return new ControlFlowGraphTerms(solution).toDot();
    }
}

