/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import java.io.Serializable;
import javax.annotation.Nullable;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.ImmutableCFGNode;
import mb.flowspec.terms.B;
import mb.flowspec.terms.TermIndex;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoConstructor;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class CFGNode
implements ICFGNode,
Serializable {
    private static IStrategoConstructor cons;

    public static void initializeConstructor(ITermFactory tf) {
        cons = tf.makeConstructor("CFGNode", 3);
    }

    @Override
    public IStrategoConstructor getConstructor() {
        return cons != null ? cons : new StrategoConstructor(this.getName(), this.getSubtermCount());
    }

    @Override
    @Value.Parameter
    public abstract TermIndex getIndex();

    @Override
    @Nullable
    @Value.Parameter
    @Value.Auxiliary
    public abstract String getCFGNodeName();

    @Override
    @Value.Parameter
    public abstract ICFGNode.Kind getKind();

    @Override
    @Value.Lazy
    public IStrategoList getAnnotations() {
        return B.list(this.getIndex());
    }

    public String toString() {
        return "##" + this.getCFGNodeName() + "." + this.getKind() + this.getIndex().toString();
    }

    public static CFGNode normal(TermIndex index) {
        return CFGNode.normal(index, null);
    }

    public static CFGNode normal(TermIndex index, @Nullable String name2) {
        return ImmutableCFGNode.of(index, name2, ICFGNode.Kind.Normal);
    }

    public static CFGNode start(TermIndex index) {
        return CFGNode.start(index, null);
    }

    public static CFGNode start(TermIndex index, @Nullable String name2) {
        return ImmutableCFGNode.of(index, name2, ICFGNode.Kind.Start);
    }

    public static CFGNode end(TermIndex index) {
        return CFGNode.end(index, null);
    }

    public static CFGNode end(TermIndex index, @Nullable String name2) {
        return ImmutableCFGNode.of(index, name2, ICFGNode.Kind.End);
    }

    public static CFGNode entry(TermIndex index) {
        return CFGNode.entry(index, null);
    }

    public static CFGNode entry(TermIndex index, @Nullable String name2) {
        return ImmutableCFGNode.of(index, name2, ICFGNode.Kind.Entry);
    }

    public static CFGNode exit(TermIndex index) {
        return CFGNode.exit(index, null);
    }

    public static CFGNode exit(TermIndex index, @Nullable String name2) {
        return ImmutableCFGNode.of(index, name2, ICFGNode.Kind.Exit);
    }
}

