/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.MutableAuthHeader;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.admin.Control;
import oracle.pgx.api.internal.ApiProvider;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.PgxRealmClient;
import oracle.pgx.api.internal.ProxyServer;
import oracle.pgx.client.PgxRemoteRequest;
import oracle.pgx.client.RemoteControlImpl;
import oracle.pgx.client.RemoteCoreImpl;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.util.CcTrace;
import oracle.pgx.common.util.DaemonThreadFactory;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.Versions;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.realm.client.RealmClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApiProvider
implements ApiProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClientApiProvider.class);

    public PgxFuture<Control> createControl(ClientConfig config, RealmClient realmClient) {
        if (System.getProperty("java.version").startsWith("1.7.") && System.getProperty("https.protocols") == null) {
            System.setProperty("https.protocols", config.getTlsVersion());
        }
        return ClientApiProvider.createClientContext(config, realmClient).thenApply(RemoteControlImpl::new).thenApply(CcTrace.enableControlTracingIfConfigured((ClientConfig)config));
    }

    public PgxFuture<Core> createCore(ClientConfig config, RealmClient realmClient) {
        return ClientApiProvider.createClientContext(config, realmClient).thenApply(RemoteCoreImpl::new).thenApply(CcTrace.enableCoreTracingIfConfigured((ClientConfig)config));
    }

    public ProxyServer createProxyServer() {
        throw new UnsupportedOperationException("ClientApiProvider does not support the creation of ProxyServer");
    }

    private static final PgxFuture<ClientContext> createClientContext(ClientConfig config, RealmClient realmClient) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager(ClientApiProvider.createConnectionManager()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(config.getRemoteFutureTimeout().intValue()).build());
        try {
            if (!ClientApiProvider.urlContainsUsernamePassword(config.getCleanedBaseUrl())) {
                MutableAuthHeader mutableAuthHeader = new MutableAuthHeader(() -> ((RealmClient)realmClient).getToken());
                httpClientBuilder.setDefaultHeaders(Collections.singleton(mutableAuthHeader));
            }
        }
        catch (MalformedURLException e) {
            return PgxFuture.exceptionallyCompletedFuture((Throwable)new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_URL_SYNTAX", (Object[])new Object[]{config.getCleanedBaseUrl()}), e));
        }
        httpClientBuilder.setMaxConnPerRoute(config.getMaxClientHttpConnections().intValue());
        httpClientBuilder.setMaxConnTotal(config.getMaxClientHttpConnections().intValue());
        ClientApiProvider.setProxy(config, httpClientBuilder);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        Cookie instanceStickyCookie = ClientApiProvider.getInstanceStickyCookie(realmClient, config, (HttpClient)httpClient);
        return ClientApiProvider.versionCheck(config, (HttpClient)httpClient, instanceStickyCookie).thenCompose(arg_0 -> ClientApiProvider.lambda$createClientContext$0(config, (HttpClient)httpClient, instanceStickyCookie, arg_0)).thenApply(arg_0 -> ClientApiProvider.lambda$createClientContext$1(config, (HttpClient)httpClient, instanceStickyCookie, arg_0));
    }

    private static Cookie getInstanceStickyCookie(RealmClient realmClient, ClientConfig config, HttpClient httpClient) {
        Cookie cookie = realmClient.getPgxInstanceStickyCookie();
        if (cookie != null) {
            return cookie;
        }
        if (!(realmClient instanceof PgxRealmClient)) {
            return null;
        }
        cookie = ClientApiProvider.getPgxInstanceStickyCookie(config, httpClient);
        ((PgxRealmClient)realmClient).setInstanceStickyCookie(cookie);
        return cookie;
    }

    private static Cookie getPgxInstanceStickyCookie(ClientConfig config, HttpClient httpClient) {
        String isRunningUrl = config.getCleanedBaseUrl() + "/isRunning";
        BasicCookieStore cookieStore = new BasicCookieStore();
        try {
            HttpResponse response = Executor.newInstance((HttpClient)httpClient).use((CookieStore)cookieStore).execute(Request.Get((String)isRunningUrl)).returnResponse();
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (Cookie cookie : cookieStore.getCookies()) {
            if (!cookie.getName().equals("PGX_INSTANCE_STICKY_COOKIE")) continue;
            LOG.debug("reading client sticky cookie {} from request", (Object)cookie.getValue());
            return cookie;
        }
        return null;
    }

    private static boolean urlContainsUsernamePassword(String baseUrl) throws MalformedURLException {
        return new URL(baseUrl).getUserInfo() != null;
    }

    private static void setProxy(ClientConfig config, HttpClientBuilder httpClientBuilder) {
        if (StaticConfig.get().isRelease().booleanValue()) {
            return;
        }
        if (System.getenv("ZAP_HTTP_PROXY") != null) {
            URI httpProxy = URI.create(System.getenv("ZAP_HTTP_PROXY"));
            HttpHost httpHost = new HttpHost(httpProxy.getHost(), httpProxy.getPort(), httpProxy.getScheme());
            LOG.info("setting up zap http proxy: {}", (Object)httpProxy);
            httpClientBuilder.setProxy(httpHost);
        }
    }

    private static final HttpClientConnectionManager createConnectionManager() {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException securityException) {
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory())).build();
        return new PoolingHttpClientConnectionManager(sfr);
    }

    private static PgxFuture<Void> versionCheck(ClientConfig config, HttpClient httpClient, Cookie clientStickyCookie) {
        return ClientApiProvider.asyncRequest(() -> {
            VersionInfo serverVersionInfo;
            String serverApiVersion;
            VersionInfo clientVersionInfo = VersionInfo.getInstance((String)"PGX_CLIENT");
            String clientApiVersion = clientVersionInfo.getApiVersion();
            if (!Versions.isCompatible((String)clientApiVersion, (String)(serverApiVersion = (serverVersionInfo = ClientApiProvider.getServerVersionInfo(config, httpClient, clientStickyCookie)).getApiVersion()), (boolean)StaticConfig.get().isEnablePluginVersionChecks())) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VERSION_MISMATCH_SERVER", (Object[])new Object[]{serverApiVersion, clientApiVersion}));
            }
            if (clientApiVersion != null && serverApiVersion != null && !clientApiVersion.equalsIgnoreCase(serverApiVersion)) {
                LOG.warn("detected version mismatch between client (" + clientApiVersion + ") and server (" + serverApiVersion + ") api versions");
            }
            return null;
        });
    }

    private static VersionInfo getServerVersionInfo(ClientConfig config, HttpClient httpClient, Cookie clientStickyCookie) throws RemoteUtils.RequestPendingException, IOException {
        String versionUrl = config.getCleanedBaseUrl() + "/version?extendedInfo=true";
        LOG.debug("checking server version from {}", (Object)versionUrl);
        Executor executor = Executor.newInstance((HttpClient)httpClient);
        if (clientStickyCookie != null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            cookieStore.addCookie(clientStickyCookie);
            executor.use((CookieStore)cookieStore);
        }
        Response response = executor.execute(Request.Get((String)versionUrl));
        HttpResponse httpResponse = response.returnResponse();
        HttpEntity entity = httpResponse.getEntity();
        String json = EntityUtils.toString((HttpEntity)entity);
        ContentType contentType = ContentType.get((HttpEntity)entity);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 202) {
            throw new RemoteUtils.RequestPendingException();
        }
        if (status != 200) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT_WRONG_STATUS", (Object[])new Object[]{config.getCleanedBaseUrl(), status, json}));
        }
        if (!contentType.getMimeType().equals(ContentType.APPLICATION_JSON.getMimeType())) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT_WRONG_CONTENT_TYPE", (Object[])new Object[]{config.getCleanedBaseUrl(), contentType, json}));
        }
        try {
            GenericMarshaler marshaler = new GenericMarshaler(VersionInfo.class);
            return (VersionInfo)marshaler.unmarshal(json);
        }
        catch (JsonParseException e) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"FAILED_TO_CONNECT", (Object[])new Object[]{config.getCleanedBaseUrl(), json}), e);
        }
    }

    private static PgxFuture<String> getCsrfToken(ClientConfig config, HttpClient httpClient, Cookie clientStickyCookie) {
        return ClientApiProvider.asyncRequest(() -> {
            String tokenUrl = config.getCleanedBaseUrl() + "/token";
            LOG.debug("requesting CSRF token from {}", (Object)tokenUrl);
            BasicCookieStore cookieStore = new BasicCookieStore();
            if (clientStickyCookie != null) {
                cookieStore.addCookie(clientStickyCookie);
            }
            Executor executor = Executor.newInstance((HttpClient)httpClient).use((CookieStore)cookieStore);
            RemoteUtils.parse(executor.execute(Request.Get((String)tokenUrl)), Marshalers.VOID_MARSHALER);
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!cookie.getName().equals("_csrf_token")) continue;
                return cookie.getValue();
            }
            throw new IllegalStateException("server did not set CSRF cookie");
        });
    }

    private static <T> PgxFuture<T> asyncRequest(PgxRemoteRequest<T> request) {
        return RemoteUtils.asyncRequest(ClientExecutorServiceHolder.EXECUTOR_SERVICE, request);
    }

    private static /* synthetic */ ClientContext lambda$createClientContext$1(ClientConfig config, HttpClient httpClient, Cookie instanceStickyCookie, String csrfToken) {
        return new ClientContext(config, httpClient, ClientExecutorServiceHolder.EXECUTOR_SERVICE, csrfToken, instanceStickyCookie);
    }

    private static /* synthetic */ CompletionStage lambda$createClientContext$0(ClientConfig config, HttpClient httpClient, Cookie instanceStickyCookie, Void arg) {
        return ClientApiProvider.getCsrfToken(config, httpClient, instanceStickyCookie);
    }

    private static class ClientExecutorServiceHolder {
        public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("pgx-client-thread"));

        private ClientExecutorServiceHolder() {
        }
    }
}

