/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.jshell;

import com.sun.security.auth.module.UnixSystem;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutionException;
import oracle.pg.jshell.TokenProvider;
import oracle.pg.rdbms.internal.onprem.TokenResponse;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.AuthConsole;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.StringUtils;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.ClientConfigBuilder;
import oracle.pgx.config.InteractionMode;
import oracle.pgx.jshell.Arguments;
import org.apache.http.cookie.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArgumentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ArgumentHandler.class);
    private final Arguments arguments;
    private final AuthConsole console;
    private final TokenProvider tokenProvider;
    private Cookie stickyCookie;

    public ArgumentHandler(Arguments arguments, AuthConsole console, TokenProvider tokenProvider) {
        this.arguments = arguments;
        this.console = console;
        this.tokenProvider = tokenProvider;
    }

    public ClientConfig buildClientConfig() throws IOException, ExecutionException {
        if (StringUtils.isNotEmpty((String)this.arguments.truststore)) {
            System.setProperty("javax.net.ssl.trustStore", this.arguments.truststore);
        }
        ClientConfigBuilder builder = ClientConfigBuilder.forBaseUrl((String)this.arguments.baseUrl).setPrefetchSize(this.arguments.prefetchSize).setUploadBatchSize(this.arguments.uploadBatchSize).setRemoteFutureTimeout(this.arguments.remoteFutureTimoutMillis).setRemoteFuturePendingRetryInterval(this.arguments.pendingRetryIntervalMillis).setEnableCctrace(this.arguments.cctrace).setMaxClientHttpConnections(this.arguments.maxConnections).setClientServerInteractionMode(InteractionMode.valueOf((String)this.arguments.interactionMode.toUpperCase())).setAccessToken(this.getToken());
        return builder.build();
    }

    public Cookie getStickyCookie() {
        return this.stickyCookie;
    }

    private String getToken() throws IOException, ExecutionException {
        if (StringUtils.isEmpty((String)this.arguments.baseUrl)) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)this.arguments.username)) {
            this.console.printf("\n", new Object[0]);
            TokenResponse response = this.tokenProvider.getToken(this.arguments.baseUrl, this.arguments.username, this.getPassword());
            this.stickyCookie = response.getCookie();
            return response.getToken();
        }
        if (StringUtils.isNotEmpty((String)this.arguments.kerberosTicket)) {
            TokenResponse response = this.generateTokenUsingKerberos();
            this.stickyCookie = response.getCookie();
            return response.getToken();
        }
        try {
            String kerberosDefaultTicket = this.getDefaultTicketPath();
            if (kerberosDefaultTicket != null) {
                this.console.printf("attempting authentication using default Kerberos ticket detected at " + kerberosDefaultTicket + "\n", new Object[0]);
                TokenResponse response = this.tokenProvider.getToken(this.arguments.baseUrl, kerberosDefaultTicket);
                this.stickyCookie = response.getCookie();
                return response.getToken();
            }
        }
        catch (Exception ex) {
            this.console.printf("could not authenticate using default Kerberos ticket", new Object[0]);
        }
        this.console.printf("\n", new Object[0]);
        TokenResponse response = this.tokenProvider.getToken(this.arguments.baseUrl, this.promptUsername(), this.getPassword());
        this.stickyCookie = response.getCookie();
        return response.getToken();
    }

    private char[] getPassword() throws ExecutionException, IOException {
        return StringUtils.isNotEmpty((String)this.arguments.keystore) ? this.getPasswordFromKeystore(this.arguments.keystore) : this.promptPassword();
    }

    private String getDefaultTicketPath() {
        String OS = System.getProperty("os.name");
        if ("Linux".equals(OS)) {
            String envPath = System.getenv("KRB5CCNAME");
            if (envPath != null) {
                return envPath;
            }
            String uid = Long.toString(new UnixSystem().getUid());
            return "/tmp/krb5cc_" + uid;
        }
        return null;
    }

    private char[] getPasswordFromKeystore(String keystore) throws ExecutionException, IOException {
        char[] keystorePassword = this.getKeyStorePassword(keystore);
        try {
            String password = AuthCertUtils.getPasswordFromKeystore((String)keystore, (char[])keystorePassword, (String)"DatabasePassword");
            return password == null ? null : password.toCharArray();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error(e.getMessage());
            String message = "error reading password from keystore " + this.arguments.keystore;
            this.console.printf("%s\n", new Object[]{message});
            throw new ExecutionException(message, e);
        }
    }

    private TokenResponse generateTokenUsingKerberos() throws IOException, ExecutionException {
        return this.tokenProvider.getToken(this.arguments.baseUrl, this.arguments.kerberosTicket);
    }

    private char[] getKeyStorePassword(String keystore) throws ExecutionException {
        try {
            return AuthCertUtils.checkJksKeystorePassword((String)keystore, (AuthConsole)this.console, (boolean)true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot open keystore " + keystore, e);
        }
    }

    private String promptUsername() throws ExecutionException {
        return new String(this.promptValue("username", false));
    }

    private char[] promptPassword() throws ExecutionException {
        return this.promptValue("password", true);
    }

    private char[] promptValue(String value, boolean readAsSecret) throws ExecutionException {
        try {
            if (this.console == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"NO_CONSOLE_AVAILABLE", (Object[])new Object[0]));
            }
            this.console.printf("%s: ", new Object[]{value});
            return readAsSecret ? this.console.readRedacted() : this.console.readText().toCharArray();
        }
        catch (UnsupportedOperationException e) {
            LOG.error(e.getMessage());
            String message = "error reading " + value;
            this.console.printf("%s\n", new Object[]{message});
            throw new ExecutionException(message, e);
        }
    }
}

