/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.text;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;

public abstract class OracleIndexUtils {
    private static SimpleLog ms_log = SimpleLog.getLog(OracleIndexUtils.class);
    private static boolean ms_bDebug = ms_log.isDebugEnabled();

    public static final Class getDatatypeClass(Object value) {
        if (value == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"getDatatypeClass: key or value are null, ", "do nothing");
            }
            return null;
        }
        if (value instanceof String) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is String");
            }
            return String.class;
        }
        if (value instanceof Float) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is float");
            }
            return Float.class;
        }
        if (value instanceof Integer) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Integer");
            }
            return Integer.class;
        }
        if (value instanceof Long) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Long");
            }
            return Long.class;
        }
        if (value instanceof Short) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Short");
            }
            return Short.class;
        }
        if (value instanceof Byte) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Byte");
            }
            return Byte.class;
        }
        if (value instanceof Character) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Character");
            }
            return Character.class;
        }
        if (value instanceof Double) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Double");
            }
            return Double.class;
        }
        if (value instanceof Boolean) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Boolean");
            }
            return Boolean.class;
        }
        if (value instanceof Date) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Double");
            }
            return Date.class;
        }
        if (value instanceof SimpleRdfDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is URI");
            }
            return SimpleRdfDataWrapper.class;
        }
        if (value instanceof SimpleSpatialDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is SPATIAL");
            }
            return SimpleSpatialDataWrapper.class;
        }
        if (value instanceof SimpleJsonDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is JSON");
            }
            return SimpleJsonDataWrapper.class;
        }
        if (value instanceof Serializable) {
            if (ms_bDebug) {
                ms_log.debug("getDatatypeClass: value is Serializable");
            }
            return Serializable.class;
        }
        throw new OraclePropertyGraphException("getDatatypeClass: TODO  unsupported type. " + value.getClass().getName());
    }

    public static String getValueAsString(Object value, SimpleDateFormat sdf) {
        if (value == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"getValueAsString: key or value are null, ", "do nothing");
            }
            return null;
        }
        if (value instanceof String) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is String");
            }
            return (String)value;
        }
        if (value instanceof Character) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Character");
            }
            return String.valueOf((Character)value);
        }
        if (value instanceof Float) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is float");
            }
            return ((Float)value).toString();
        }
        if (value instanceof Integer) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Integer");
            }
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Long");
            }
            return ((Long)value).toString();
        }
        if (value instanceof Short) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Short");
            }
            return ((Short)value).toString();
        }
        if (value instanceof Byte) {
            if (ms_bDebug) {
                ms_log.debug("addKeyValuePropertyToDoc: value is Byte");
            }
            return ((Byte)value).toString();
        }
        if (value instanceof Double) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Double");
            }
            return ((Double)value).toString();
        }
        if (value instanceof SimpleRdfDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is URI");
            }
            return ((SimpleRdfDataWrapper)value).serialize();
        }
        if (value instanceof SimpleSpatialDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Spatial");
            }
            return ((SimpleSpatialDataWrapper)value).serialize();
        }
        if (value instanceof SimpleJsonDataWrapper) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is JSON");
            }
            return ((SimpleJsonDataWrapper)value).serialize();
        }
        if (value instanceof Boolean) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Boolean");
            }
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Date) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Double");
            }
            return sdf.format((Date)value);
        }
        if (value instanceof Serializable) {
            if (ms_bDebug) {
                ms_log.debug("getValueAsString: value is Serializable");
            }
            try {
                return OraclePropertyGraphBase.serializableToStr((Serializable)value);
            }
            catch (IOException ioe) {
                throw new OraclePropertyGraphException(ioe);
            }
        }
        throw new OraclePropertyGraphException("getValueAsString: TODO  unsupported type. " + value.getClass().getName());
    }
}

