/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader.exceptions;

import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OracleVertexBase;

public class InvalidArgumentSizeException
extends RuntimeException {
    public InvalidArgumentSizeException(long currentLineNumber, String line, int length, Class type) {
        super("Invalid number of arguments for line #" + currentLineNumber + " with content '" + line + "', size is " + length + " expected size for line is " + InvalidArgumentSizeException.getSizeForLine(type));
    }

    public static <T extends OracleElementBase> String getSizeForLine(Class<T> type) {
        if (type == null) {
            return null;
        }
        if (OracleVertexBase.class.isAssignableFrom(type)) {
            return "6 (VID,K,T,V,VN,VT) or 7 (VID,K,T,V,VN,VT,VL)";
        }
        if (OracleEdgeBase.class.isAssignableFrom(type)) {
            return "9 (EID,SVID,DVID,EL,K,T,V,VN,VT)";
        }
        return null;
    }
}

