/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.loader.OracleDataLoaderConfigBase;
import oracle.pg.common.loader.PropertyGraphLoader;

public abstract class VertexLoader
extends PropertyGraphLoader<OracleVertexBase> {
    static final int VERTEX_ITEMS_PER_LINE = 7;
    static final int VERTEX_ITEMS_PER_LINE_NO_LABEL = 6;
    private static final int ID_ITEM_INDEX = 0;
    private static final int VERTEX_PROPERTY_KEY_ITEM_INDEX = 1;
    private static final int VERTEX_PROPERTY_TYPE_ITEM_INDEX = 2;
    private static final int VERTEX_LABEL_ITEM_INDEX = 6;

    public VertexLoader(int taskId, InputStream is, OracleDataLoaderConfigBase config, OraclePropertyGraphBase opg) throws Exception {
        super(taskId, is, config, opg);
        this.m_bVertex = true;
    }

    public VertexLoader(int taskId) {
        super(taskId);
        this.m_bVertex = true;
    }

    @Override
    protected String getName() {
        return "VertexLoader";
    }

    @Override
    protected void convertAndStoreLineAsGraphData(long currentLineNumber, String line, SimpleDateFormat sdf) throws Exception {
        this.reportProgress(currentLineNumber, line);
        String[] fields = line.split(",", -1);
        if (!this.isValidLineSize(currentLineNumber, fields, line)) {
            return;
        }
        Long vid = this.extractIdFromLine(currentLineNumber, fields, line);
        String label = null;
        if (fields.length == this.getItemsPerLine()) {
            label = this.extractLabelFromLine(currentLineNumber, fields, line);
        }
        String propertyKey = this.extractPropertyKeyFromLine(currentLineNumber, fields, line);
        Object propertyValue = null;
        if (propertyKey != null && !propertyKey.isEmpty()) {
            propertyValue = this.extractPropertyValueFromLine(currentLineNumber, fields, line, sdf);
        }
        if (this.isTaskFailed()) {
            throw new RuntimeException();
        }
        this.loadDataIntoDb(vid, label, propertyKey, propertyValue, sdf);
    }

    protected abstract void loadDataIntoDb(Long var1, String var2, String var3, Object var4, SimpleDateFormat var5) throws Exception;

    @Override
    protected int getItemsPerLine() {
        return 7;
    }

    protected int getItemsPerLineNoLabel() {
        return 6;
    }

    @Override
    protected boolean isValidElementLineSize(int size) {
        return size == this.getItemsPerLine() || size == this.getItemsPerLineNoLabel();
    }

    @Override
    protected int getIDItemIndex() {
        return 0;
    }

    @Override
    protected int getPropertyTypeItemIndex() {
        return 2;
    }

    @Override
    protected int getPropertyKeyItemIndex() {
        return 1;
    }

    @Override
    protected int getLabelItemIndex() {
        return 6;
    }
}

