/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.loader.OracleDataLoader;
import oracle.pg.common.loader.OracleDataLoaderConfigBase;
import oracle.pg.common.loader.OracleFlatFileSplitter;

public abstract class OracleFlatFileGraphLoader<T extends OracleElementBase> {
    protected OracleDataLoaderConfigBase config;
    protected OutputStream[] osa;
    protected InputStream[] isa;
    private Object[] sources;
    protected Class<T> elementType;
    protected OracleDataLoader<T> dataloader;
    protected OraclePropertyGraphBase opg;
    protected static int PIPE_SIZE = 0x200000;
    protected String filePrefix;

    public OracleFlatFileGraphLoader(Object[] sources, Class<T> elementType, OraclePropertyGraphBase opg, OracleDataLoaderConfigBase config) {
        this.config = config;
        this.sources = sources;
        this.elementType = elementType;
        this.opg = opg;
    }

    public OracleFlatFileGraphLoader(Object[] sources, Class<T> elementType, OraclePropertyGraphBase opg, OracleDataLoaderConfigBase config, String prefix) {
        this.config = config;
        this.sources = sources;
        this.elementType = elementType;
        this.opg = opg;
        this.filePrefix = prefix;
    }

    public OracleFlatFileSplitter getFileSplitter() {
        boolean isVertex = OracleVertexBase.class.isAssignableFrom(this.elementType);
        OracleFlatFileSplitter fileSplitter = new OracleFlatFileSplitter(isVertex, this.sources, this.osa, this.config);
        return fileSplitter;
    }

    protected abstract OracleDataLoader<T> getDataLoader() throws Exception;

    public void prepareStreams(Object[] sources) throws Exception {
        int dop = this.config.getDOP();
        this.osa = new OutputStream[dop];
        this.isa = new InputStream[dop];
        for (int i = 0; i < dop; ++i) {
            this.osa[i] = new PipedOutputStream();
            this.isa[i] = new PipedInputStream((PipedOutputStream)this.osa[i], PIPE_SIZE);
        }
    }

    public <T extends OracleElementBase> void executeFileSplitAndGraphLoadingTasks() throws Exception {
        this.prepareStreams(this.sources);
        OracleFlatFileSplitter fileSplitter = this.getFileSplitter();
        OracleDataLoader<T> dataLoader = this.getDataLoader();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Long> completionService = new ExecutorCompletionService<Long>(executor);
        ArrayList<Future<Long>> tasks = new ArrayList<Future<Long>>();
        Future<Long> futureFileSplitter = completionService.submit(fileSplitter);
        tasks.add(futureFileSplitter);
        Future<Long> futureDataLoader = completionService.submit(dataLoader);
        tasks.add(futureDataLoader);
        long loadedItems = 0L;
        for (Future future : tasks) {
            try {
                Long result = (Long)future.get();
                loadedItems += result.longValue();
            }
            catch (InterruptedException result) {
            }
            catch (ExecutionException e) {
                for (Future future2 : tasks) {
                    future2.cancel(true);
                }
                tasks.clear();
                executor.shutdownNow();
                HelperUtilities.waitForTermination(executor);
                throw e;
            }
        }
        executor.shutdown();
    }
}

