/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.loader.CompositeCallable;
import oracle.pg.common.loader.OracleDataLoaderConfigBase;
import oracle.pg.common.loader.PropertyGraphLoader;

public abstract class OracleDataLoader<T extends OracleElementBase>
extends CompositeCallable {
    protected InputStream[] m_isa;
    protected PropertyGraphLoader<T>[] loaders;
    protected Class<T> elementType;
    protected OraclePropertyGraphBase opg;
    protected OracleDataLoaderConfigBase config;

    public OracleDataLoader(InputStream[] isa, Class<T> elementType, OraclePropertyGraphBase opg, OracleDataLoaderConfigBase config) throws Exception {
        this.elementType = elementType;
        this.config = config;
        this.opg = opg;
        this.m_isa = new InputStream[isa.length];
        for (int i = 0; i < isa.length; ++i) {
            this.m_isa[i] = isa[i];
        }
    }

    @Override
    public final ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(this.m_isa.length);
    }

    @Override
    public List<Future<Long>> getTasksFutures(ExecutorCompletionService<Long> completionService) throws Exception {
        ArrayList<Future<Long>> tasks = new ArrayList<Future<Long>>();
        for (PropertyGraphLoader<T> loader : this.loaders) {
            Future<Long> futureLoaderSplitter = completionService.submit(loader);
            tasks.add(futureLoaderSplitter);
        }
        return tasks;
    }

    public abstract <T extends OracleElementBase> PropertyGraphLoader<T> getPropertyGraphLoader(InputStream var1, int var2) throws Exception;

    @Override
    public Long call() throws Exception {
        this.loaders = new PropertyGraphLoader[this.m_isa.length];
        for (int i = 0; i < this.m_isa.length; ++i) {
            this.loaders[i] = this.getPropertyGraphLoader(this.m_isa[i], i);
        }
        return this.executeTasks();
    }
}

