/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.util.Iterator;
import oracle.pg.common.OpCallback;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.ProgressListener;
import oracle.pg.common.SimpleLog;

public class OracleGraphUpdateWorker<T extends OracleElementBase>
implements Runnable {
    static SimpleLog ms_log = SimpleLog.getLog(OracleGraphUpdateWorker.class);
    private Iterator<T> m_iterator = null;
    private int m_workerThread;
    private long m_lPrevTime = System.currentTimeMillis();
    private OpCallback.UpdateType m_updateType;
    private OpCallback<T> m_oc;
    private ProgressListener m_pl;
    private boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();

    public void updateAttribute(T element) {
        if (OpCallback.UpdateType.ADD_PROPERTY.equals((Object)this.m_updateType)) {
            String szPropertyKey = this.m_oc.getAttributeKeyName(element);
            Object value = this.m_oc.getAttributeKeyValue(element);
            element.property(szPropertyKey, (Object)value);
        } else if (OpCallback.UpdateType.REMOVE_PROPERTY.equals((Object)this.m_updateType)) {
            String szPropertyKey = this.m_oc.getAttributeKeyName(element);
            ((OracleElementBase)element).property(szPropertyKey).remove();
        }
    }

    @Override
    public void run() {
        int lCount = 0;
        while (this.m_iterator.hasNext()) {
            OracleElementBase element = (OracleElementBase)this.m_iterator.next();
            if (this.m_oc.needOp(element)) {
                if (OpCallback.UpdateType.REMOVE_ENTITY.equals((Object)this.m_updateType)) {
                    element.remove();
                } else {
                    this.updateAttribute(element);
                }
                ++lCount;
            }
            if (lCount % 100000 == 0 && this.ms_bShowProgress) {
                ms_log.info("[" + Thread.currentThread() + "] run: progress to " + lCount + " in (ms) " + (System.currentTimeMillis() - this.m_lPrevTime));
                this.m_lPrevTime = System.currentTimeMillis();
            }
            if (this.m_pl == null || (long)lCount % this.m_pl.reportProgressFrequency() != 0L) continue;
            this.m_pl.progressTo(lCount, "[" + Thread.currentThread() + "]: run in (" + (System.currentTimeMillis() - this.m_lPrevTime) + " ms)");
            this.m_lPrevTime = System.currentTimeMillis();
        }
        if (this.ms_bShowProgress) {
            ms_log.info("run [" + this.m_workerThread + "] : total number of elements " + lCount);
        }
    }

    public OracleGraphUpdateWorker(Iterator<T> it, int idx, OpCallback<T> oc, OpCallback.UpdateType updateType, ProgressListener pl) {
        this.m_iterator = it;
        this.m_workerThread = idx;
        this.m_oc = oc;
        this.m_updateType = updateType;
        this.m_pl = pl;
    }

    public String getName() {
        return "OracleGraphUpdateWorker" + this.m_workerThread;
    }

    protected static enum Action {
        ADD,
        DELETE;

    }
}

