/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.util.Optional;
import oracle.pg.common.OracleElement;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.OracleVertexPropertyBase;

public final class OracleElementHelper {
    private OracleElementHelper() {
    }

    public static void validateLabel(String label) throws IllegalArgumentException {
        if (null == label) {
            throw new IllegalArgumentException("Label can not be null");
        }
        if (label.isEmpty()) {
            throw new IllegalArgumentException("Label can not be empty");
        }
    }

    public static void validateMixedElementIds(Class<? extends OracleElementBase> clazz, Object ... ids) throws IllegalArgumentException {
        if (ids.length > 1) {
            boolean element = clazz.isAssignableFrom(ids[0].getClass());
            for (int i = 1; i < ids.length; ++i) {
                if (clazz.isAssignableFrom(ids[i].getClass()) == element) continue;
                throw new IllegalArgumentException("id arguments must be either ids or Elements");
            }
        }
    }

    public static void validateProperty(String key, Object value) throws IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("Property value can not be null");
        }
        if (null == key) {
            throw new IllegalArgumentException("Property key can not be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Property key can not be the empty string");
        }
    }

    public static void legalPropertyKeyValueArray(Object ... propertyKeyValues) throws IllegalArgumentException {
        if (propertyKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("The provided key/value array length must be a multiple of two");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i] instanceof String) continue;
            throw new IllegalArgumentException("The provided key/value array must have a String on even array indices");
        }
    }

    public static Optional<Object> getIdValue(Object ... keyValues) {
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals("id")) continue;
            return Optional.of(keyValues[i + 1]);
        }
        return Optional.empty();
    }

    public static Optional<String> getLabelValue(Object ... keyValues) {
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals("label")) continue;
            OracleElementHelper.validateLabel((String)keyValues[i + 1]);
            return Optional.of((String)keyValues[i + 1]);
        }
        return Optional.empty();
    }

    public static void attachProperties(OracleElement element, Object ... propertyKeyValues) {
        if (null == element) {
            throw new IllegalArgumentException("The provided argument can not be null: element");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals("id") || propertyKeyValues[i].equals("label")) continue;
            element.property((String)propertyKeyValues[i], propertyKeyValues[i + 1]);
        }
    }

    public static void attachProperties(OracleVertexBase vertex, Object ... propertyKeyValues) {
        if (null == vertex) {
            throw new IllegalArgumentException("The provided argument can not be null: vertex");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals("id") || propertyKeyValues[i].equals("label")) continue;
            vertex.property((String)propertyKeyValues[i], propertyKeyValues[i + 1]);
        }
    }

    public static boolean areEqual(OracleElement a, Object b) {
        if (null == b || null == a) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (!(a instanceof OracleVertexBase && b instanceof OracleVertexBase || a instanceof OracleVertexPropertyBase && b instanceof OracleVertexPropertyBase)) {
            return false;
        }
        return OracleElementHelper.haveEqualIds(a, (OracleElement)b);
    }

    public static boolean areEqual(OraclePropertyBase a, Object b) {
        if (null == a) {
            throw new IllegalArgumentException("The provided argument can not be null: a");
        }
        if (null == b) {
            throw new IllegalArgumentException("The provided argument can not be null: b");
        }
        if (a == b) {
            return true;
        }
        if (!(b instanceof OraclePropertyBase)) {
            return false;
        }
        if (!a.isPresent() && !((OraclePropertyBase)b).isPresent()) {
            return true;
        }
        if (!a.isPresent() && ((OraclePropertyBase)b).isPresent() || a.isPresent() && !((OraclePropertyBase)b).isPresent()) {
            return false;
        }
        return a.key().equals(((OraclePropertyBase)b).key()) && a.value().equals(((OraclePropertyBase)b).value()) && OracleElementHelper.areEqual(a.element(), (Object)((OraclePropertyBase)b).element());
    }

    public static boolean haveEqualIds(OracleElement a, OracleElement b) {
        return a.id().equals(b.id());
    }

    public static int hashCode(OracleElement element) {
        return element.id().hashCode();
    }

    public static int hashCode(OraclePropertyBase property) {
        return property.key().hashCode() + property.value().hashCode();
    }
}

