/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph.internal;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PgGraphConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PgGraphConfigUtil.class);

    private PgGraphConfigUtil() {
    }

    public static SourceType getAndValidateSourceType(PartitionedGraphConfig graphConfig) {
        SourceType sourceType = graphConfig.getSourceType();
        String pgViewName = graphConfig.getPgViewName();
        if (sourceType != null) {
            PgGraphConfigUtil.throwOnConfigFieldClash(pgViewName, (ConfigField)PartitionedGraphConfig.Field.PG_VIEW_NAME, (ConfigField)PartitionedGraphConfig.Field.SOURCE_TYPE);
            return sourceType;
        }
        if (pgViewName != null) {
            LOG.warn("Deprecated config field {} is used instead of {} and {}", new Object[]{PartitionedGraphConfig.Field.PG_VIEW_NAME, PartitionedGraphConfig.Field.SOURCE_TYPE, PartitionedGraphConfig.Field.SOURCE_NAME});
            return SourceType.PG_VIEW;
        }
        return null;
    }

    public static String getAndValidateSourceName(PartitionedGraphConfig graphConfig) {
        String sourceName = graphConfig.getSourceName();
        String pgViewName = graphConfig.getPgViewName();
        if (sourceName != null) {
            PgGraphConfigUtil.throwOnConfigFieldClash(pgViewName, (ConfigField)PartitionedGraphConfig.Field.PG_VIEW_NAME, (ConfigField)PartitionedGraphConfig.Field.SOURCE_NAME);
            return sourceName;
        }
        if (pgViewName != null) {
            LOG.warn("Deprecated config field {} is used instead of {} and {}", new Object[]{PartitionedGraphConfig.Field.PG_VIEW_NAME, PartitionedGraphConfig.Field.SOURCE_TYPE, PartitionedGraphConfig.Field.SOURCE_NAME});
            return pgViewName;
        }
        return null;
    }

    private static void throwOnConfigFieldClash(String configValue, ConfigField deprecatedField, ConfigField newField) {
        if (configValue == null) {
            return;
        }
        LOG.error("Deprecated config field {} was used in combination with {}", (Object)deprecatedField, (Object)newField);
        throw new IllegalStateException(ErrorMessages.getMessage((String)"DEPRECATED_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{deprecatedField, newField}));
    }
}

