/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.characteristic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.api.internal.characteristic.AccessCharacteristic;
import oracle.pgx.api.internal.characteristic.DurationCharacteristic;
import oracle.pgx.api.internal.characteristic.ParallelismCharacteristic;
import oracle.pgx.api.internal.characteristic.TargetPoolCharacteristic;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristic;
import oracle.pgx.common.IllegalEnumConstantException;

public class WorkloadCharacteristicSet {
    private AccessCharacteristic accessCharacteristic;
    private DurationCharacteristic durationCharacteristic;
    private ParallelismCharacteristic parallelismCharacteristic;
    private TargetPoolCharacteristic targetPoolCharacteristic;

    public WorkloadCharacteristicSet(@Nullable AccessCharacteristic accessCharacteristic, @Nullable DurationCharacteristic durationCharacteristic, @Nullable ParallelismCharacteristic parallelismCharacteristic, @Nullable TargetPoolCharacteristic targetPoolCharacteristic) {
        this.accessCharacteristic = accessCharacteristic;
        this.durationCharacteristic = durationCharacteristic;
        this.parallelismCharacteristic = parallelismCharacteristic;
        this.targetPoolCharacteristic = targetPoolCharacteristic;
    }

    public WorkloadCharacteristicSet(@Nonnull WorkloadCharacteristicSet copy) {
        this.accessCharacteristic = copy.accessCharacteristic;
        this.durationCharacteristic = copy.durationCharacteristic;
        this.parallelismCharacteristic = copy.parallelismCharacteristic;
        this.targetPoolCharacteristic = copy.targetPoolCharacteristic;
    }

    public WorkloadCharacteristicSet() {
        this(null, null, null, null);
    }

    public static WorkloadCharacteristicSet of(WorkloadCharacteristic ... characteristics) {
        if (characteristics == null) {
            return new WorkloadCharacteristicSet();
        }
        return WorkloadCharacteristicSet.of(Arrays.asList(characteristics));
    }

    @JsonCreator
    public static WorkloadCharacteristicSet of(Collection<WorkloadCharacteristic> characteristics) {
        AccessCharacteristic accessCharacteristic = null;
        DurationCharacteristic durationCharacteristic = null;
        ParallelismCharacteristic parallelismCharacteristic = null;
        TargetPoolCharacteristic targetPoolCharacteristic = null;
        if (characteristics != null) {
            block6: for (WorkloadCharacteristic characteristic : characteristics) {
                switch (characteristic.getCategory()) {
                    case PARALLELISM: {
                        parallelismCharacteristic = WorkloadCharacteristicSet.update(parallelismCharacteristic, characteristic);
                        continue block6;
                    }
                    case TARGET_POOL: {
                        targetPoolCharacteristic = WorkloadCharacteristicSet.update(targetPoolCharacteristic, characteristic);
                        continue block6;
                    }
                    case DURATION: {
                        durationCharacteristic = WorkloadCharacteristicSet.update(durationCharacteristic, characteristic);
                        continue block6;
                    }
                    case ACCESS_TYPE: {
                        accessCharacteristic = WorkloadCharacteristicSet.update(accessCharacteristic, characteristic);
                        continue block6;
                    }
                }
                throw new IllegalEnumConstantException((Enum)characteristic.getCategory());
            }
        }
        return new WorkloadCharacteristicSet(accessCharacteristic, durationCharacteristic, parallelismCharacteristic, targetPoolCharacteristic);
    }

    private static <T extends WorkloadCharacteristic> T update(T oldValue, WorkloadCharacteristic newValue) {
        if (oldValue != null) {
            throw new IllegalArgumentException("Malformed characteristic. " + oldValue + " conflicts with " + newValue);
        }
        return (T)newValue;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.accessCharacteristic == null && this.durationCharacteristic == null && this.parallelismCharacteristic == null && this.targetPoolCharacteristic == null;
    }

    @JsonIgnore
    public AccessCharacteristic getAccessCharacteristic() {
        return this.accessCharacteristic;
    }

    @JsonIgnore
    public DurationCharacteristic getDurationCharacteristic() {
        return this.durationCharacteristic;
    }

    @JsonIgnore
    public ParallelismCharacteristic getParallelismCharacteristic() {
        return this.parallelismCharacteristic;
    }

    @JsonIgnore
    public TargetPoolCharacteristic getTargetPoolCharacteristic() {
        return this.targetPoolCharacteristic;
    }

    @JsonValue
    public Set<WorkloadCharacteristic> getWorkloadCharacteristics() {
        return this.stream().collect(Collectors.toSet());
    }

    public Stream<WorkloadCharacteristic> stream() {
        return Stream.of(this.accessCharacteristic, this.durationCharacteristic, this.parallelismCharacteristic, this.targetPoolCharacteristic).filter(Objects::nonNull);
    }

    public boolean contains(AccessCharacteristic accessCharacteristic) {
        return this.accessCharacteristic == accessCharacteristic;
    }

    public boolean contains(DurationCharacteristic durationCharacteristic) {
        return this.durationCharacteristic == durationCharacteristic;
    }

    public boolean contains(ParallelismCharacteristic parallelismCharacteristic) {
        return this.parallelismCharacteristic == parallelismCharacteristic;
    }

    public boolean contains(TargetPoolCharacteristic targetPoolCharacteristic) {
        return this.targetPoolCharacteristic == targetPoolCharacteristic;
    }

    public boolean contains(WorkloadCharacteristic workloadCharacteristic) {
        return this.getWorkloadCharacteristics().contains(workloadCharacteristic);
    }

    public void setAccessCharacteristic(AccessCharacteristic accessCharacteristic) {
        this.accessCharacteristic = accessCharacteristic;
    }

    public void setDurationCharacteristic(DurationCharacteristic durationCharacteristic) {
        this.durationCharacteristic = durationCharacteristic;
    }

    public void setParallelismCharacteristic(ParallelismCharacteristic parallelismCharacteristic) {
        this.parallelismCharacteristic = parallelismCharacteristic;
    }

    public void setTargetPoolCharacteristic(TargetPoolCharacteristic targetPoolCharacteristic) {
        this.targetPoolCharacteristic = targetPoolCharacteristic;
    }

    @JsonIgnore
    public boolean isCallerThreadCall() {
        return this.contains(TargetPoolCharacteristic.CALLER_THREAD);
    }

    @JsonIgnore
    public boolean isServerThreadCall() {
        return this.contains(TargetPoolCharacteristic.SYNCHRONIZED);
    }

    @JsonIgnore
    public boolean isAnalysis() {
        return !(this.isCallerThreadCall() || this.isServerThreadCall());
    }

    public boolean containsAll(Collection<WorkloadCharacteristic> workloadCharacteristics) {
        return workloadCharacteristics.stream().allMatch(this::contains);
    }

    public boolean containsAll(WorkloadCharacteristic ... workloadCharacteristics) {
        return this.containsAll(Arrays.asList(workloadCharacteristics));
    }

    public WorkloadCharacteristicSet combine(WorkloadCharacteristicSet overwrite) {
        if (overwrite == null) {
            return this;
        }
        AccessCharacteristic accessCharacteristic = this.accessCharacteristic;
        DurationCharacteristic durationCharacteristic = this.durationCharacteristic;
        ParallelismCharacteristic parallelismCharacteristic = this.parallelismCharacteristic;
        TargetPoolCharacteristic targetPoolCharacteristic = this.targetPoolCharacteristic;
        if (overwrite.accessCharacteristic != null) {
            accessCharacteristic = overwrite.accessCharacteristic;
        }
        if (overwrite.durationCharacteristic != null) {
            durationCharacteristic = overwrite.durationCharacteristic;
        }
        if (overwrite.parallelismCharacteristic != null) {
            parallelismCharacteristic = overwrite.parallelismCharacteristic;
        }
        if (overwrite.targetPoolCharacteristic != null) {
            targetPoolCharacteristic = overwrite.targetPoolCharacteristic;
        }
        return new WorkloadCharacteristicSet(accessCharacteristic, durationCharacteristic, parallelismCharacteristic, targetPoolCharacteristic);
    }

    public String toString() {
        return "WorkloadCharacteristicSet{" + this.getWorkloadCharacteristics() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadCharacteristicSet that = (WorkloadCharacteristicSet)o;
        return this.accessCharacteristic == that.accessCharacteristic && this.durationCharacteristic == that.durationCharacteristic && this.parallelismCharacteristic == that.parallelismCharacteristic && this.targetPoolCharacteristic == that.targetPoolCharacteristic;
    }

    public int hashCode() {
        return Objects.hash(this.accessCharacteristic, this.durationCharacteristic, this.parallelismCharacteristic, this.targetPoolCharacteristic);
    }

    public static WorkloadCharacteristic[] toArray(Collection<WorkloadCharacteristic> workloadCharacteristics) {
        return (WorkloadCharacteristic[])workloadCharacteristics.stream().toArray(WorkloadCharacteristic[]::new);
    }
}

