/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.frames.schema.ColumnDescriptor;
import oracle.pgx.api.frames.schema.internal.DataTypeInternalUtils;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.loaders.location.EntityProviderLocation;

public abstract class PgxFrameReader<PgxFrameReaderType extends PgxFrameReader<PgxFrameReaderType>> {
    protected PgxSession session;
    protected Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;
    protected boolean autodetectColumn = true;

    PgxFrameReader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
    }

    protected abstract PgxFrameReaderType getThis();

    public abstract PgxFrameReaderType name(String var1);

    public PgxFrameReaderType autodetectColumns(boolean autodetectColumn) {
        this.autodetectColumn = autodetectColumn;
        this.clearColumns();
        return this.getThis();
    }

    public PgxFrameReaderType columns(ColumnDescriptor ... columnDescriptors) {
        this.autodetectColumn = false;
        this.clearColumns();
        for (ColumnDescriptor columnDescriptor : columnDescriptors) {
            GraphPropertyConfig propertyConfig = DataTypeInternalUtils.toPropertyConfig(columnDescriptor.getColumnName(), columnDescriptor.getColumnType());
            this.withVectorColumn(propertyConfig.getName(), propertyConfig.getType(), propertyConfig.getDimension(), propertyConfig.getDefault());
        }
        return this.getThis();
    }

    protected abstract PgxFrameReaderType withVectorColumn(String var1, PropertyType var2, int var3, Object var4);

    protected abstract void clearColumns();

    public abstract PgxFuture<PgxFrame> loadAsync(String ... var1);

    public PgxFrame load(String ... uris) throws InterruptedException, ExecutionException {
        return this.loadAsync(uris).get();
    }

    protected final PgxFuture<PgxFrame> triggerLoadAsync(EntityProviderLocation location, AbstractEntityProviderConfigBuilder<?, ?> configBuilder) {
        CompletableFuture populatedConfigFuture = this.autodetectColumn ? this.core.describeFrame(this.session.getSessionContext(), location).thenApply(detectedConfig -> {
            configBuilder.clearProperties();
            detectedConfig.getProps().forEach(prop -> configBuilder.addVectorProperty(prop.getName(), prop.getType(), prop.getDimension().intValue(), prop.getDefault()));
            return configBuilder.build();
        }) : PgxFuture.completedFuture(configBuilder.build());
        return populatedConfigFuture.thenCompose(this::triggerLoadAsyncWithPopulatedConfig);
    }

    private PgxFuture<PgxFrame> triggerLoadAsyncWithPopulatedConfig(EntityProviderConfig config) {
        try {
            if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null) {
                config = ConfigUtils.createProviderConfigWithCredentials((String)this.keystorePathSupplier.get(), (char[])this.keystorePasswordSupplier.get(), (EntityProviderConfig)config);
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return this.core.loadRowFrame(this.session.getSessionContext(), config).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }
}

