/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.Arrays;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameReader;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.loaders.location.EntityProviderLocation;
import oracle.pgx.loaders.location.FileEntityProviderLocation;

public class PgxCsvFrameReader
extends PgxFrameReader<PgxCsvFrameReader> {
    protected final FileEntityProviderConfigBuilder configBuilder = new FileEntityProviderConfigBuilder(ProviderFormat.CSV);

    public PgxCsvFrameReader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        this.configBuilder.setHasKeys(false);
    }

    @Override
    protected PgxCsvFrameReader getThis() {
        return this;
    }

    @Override
    public PgxCsvFrameReader name(String frameName) {
        this.configBuilder.setName(frameName);
        return this;
    }

    @Override
    protected PgxCsvFrameReader withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        this.configBuilder.addVectorProperty(columnName, type, dimension, defaultValue);
        return this;
    }

    @Override
    protected void clearColumns() {
        this.configBuilder.clearProperties();
    }

    public PgxCsvFrameReader separator(char separator) {
        this.configBuilder.setSeparator(Character.toString(separator));
        return this;
    }

    @Override
    public PgxFuture<PgxFrame> loadAsync(String ... uris) {
        FileEntityProviderLocation location = new FileEntityProviderLocation(Arrays.asList(uris), EntityType.ROW, ProviderFormat.CSV);
        this.configBuilder.setUris(uris);
        return this.triggerLoadAsync((EntityProviderLocation)location, (AbstractEntityProviderConfigBuilder<?, ?>)this.configBuilder);
    }
}

