/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.expansion;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.expansion.AbstractGraphExpander;
import oracle.pgx.api.expansion.PreparedPgViewPgqlQuery;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.api.expansion.internal.PgqlGraphExpansionConfig;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.api.subgraph.internal.PgGraphConfigUtil;
import oracle.pgx.api.subgraph.internal.PreparedPgqlQueryBuilderImpl;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphConfigBuilder;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.SourceType;
import oracle.pgx.loaders.location.GraphLocation;
import oracle.pgx.loaders.location.PgSqlGraphLocation;
import oracle.pgx.loaders.location.PgViewGraphLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BetaApi
public class PgqlViewGraphExpander
extends AbstractGraphExpander<PgqlViewGraphExpander> {
    private static final Logger LOG = LoggerFactory.getLogger(PgqlViewGraphExpander.class);
    private SourceType sourceType;
    private String dbGraphName;
    private final List<String> queries = new ArrayList<String>();
    private final List<PreparedPgqlQueryBuilderImpl> preparedQueries = new ArrayList<PreparedPgqlQueryBuilderImpl>();
    private String jdbcUrl;
    private String dataSourceId;
    private String owner;
    private String username;
    private String password;
    private String keystoreAlias;
    private int numConnections;

    public PgqlViewGraphExpander(PartitionedGraphConfig graphConfig, PgxSession session, Function<GraphExpansionConfig, PgxFuture<PgxGraph>> expansionFunction, KeystoreLookup keystoreLookup) {
        super(graphConfig, session, expansionFunction, keystoreLookup);
    }

    @Override
    protected PgqlViewGraphExpander getThis() {
        return this;
    }

    @Override
    protected PgxFuture<GraphExpansionConfig> buildExpansionConfig(String newGraphName, boolean asSnapshot) {
        PgxFuture<PartitionedGraphConfig> expandCfg;
        LOG.debug("Building expansion config.");
        if (this.expansionConfig != null) {
            LOG.debug("Separate config was provided, using this config.");
            expandCfg = PgxFuture.completedFuture(this.expansionConfig);
        } else if (this.isExpandFromDifferentGraph()) {
            LOG.debug("Expanding from different graph, using describe graph");
            expandCfg = this.runDescribeGraph();
        } else {
            LOG.info("Using base config");
            expandCfg = PgxFuture.completedFuture(this.graphConfig);
        }
        return expandCfg.thenApply(cfg -> {
            ArrayList<PreparedQueryConfig> preparedQueries = new ArrayList<PreparedQueryConfig>();
            for (PreparedPgqlQueryBuilderImpl preparedPgqlQueryBuilder : this.preparedQueries) {
                preparedQueries.add(preparedPgqlQueryBuilder.buildQueryWithArguments());
            }
            assert (cfg instanceof PartitionedGraphConfig);
            PartitionedGraphConfigBuilder configBuilder = GraphConfigBuilder.forPartitioned().copyFrom((PartitionedGraphConfig)cfg);
            if (this.jdbcUrl != null) {
                configBuilder.setJdbcUrl(this.jdbcUrl);
            }
            if (this.dataSourceId != null) {
                configBuilder.setDataSourceId(this.dataSourceId);
            }
            if (this.owner != null) {
                configBuilder.setSchema(this.owner);
            }
            if (this.username != null) {
                configBuilder.setUsername(this.username);
            }
            if (this.password != null) {
                configBuilder.setPassword(this.password);
            }
            if (this.keystoreAlias != null) {
                configBuilder.setKeystoreAlias(this.keystoreAlias);
            }
            if (this.numConnections > 0) {
                configBuilder.setNumConnections(this.numConnections);
            }
            PartitionedGraphConfig newGraphConfig = (PartitionedGraphConfig)configBuilder.build();
            return new PgqlGraphExpansionConfig(newGraphName, this.graphConfig, newGraphConfig, this.queries, preparedQueries, asSnapshot, this.vertexPropertyMergeStrategy, this.edgePropertyMergeStrategy);
        });
    }

    private boolean isExpandFromDifferentGraph() {
        boolean isExpandFromDifferentGraphName;
        boolean isExpandFromDifferentSchemaName;
        boolean isExpandFromDifferentType;
        SourceType baseSourceType = PgGraphConfigUtil.getAndValidateSourceType(this.graphConfig);
        String baseSchemaName = this.graphConfig.getSchema();
        String baseSourceName = PgGraphConfigUtil.getAndValidateSourceName(this.graphConfig);
        boolean bl = isExpandFromDifferentType = this.sourceType != null && this.sourceType != baseSourceType;
        if (isExpandFromDifferentType) {
            LOG.debug("Expanding from different source type");
        }
        boolean bl2 = isExpandFromDifferentSchemaName = this.owner != null && !Objects.equals(this.owner, baseSchemaName);
        if (isExpandFromDifferentSchemaName) {
            LOG.debug("Expanding from different schema");
        }
        boolean bl3 = isExpandFromDifferentGraphName = this.dbGraphName != null && !Objects.equals(this.dbGraphName, baseSourceName);
        if (isExpandFromDifferentGraphName) {
            LOG.debug("Expanding from different graph name");
        }
        return isExpandFromDifferentType || isExpandFromDifferentSchemaName || isExpandFromDifferentGraphName;
    }

    private PgxFuture<GraphConfig> runDescribeGraph() {
        SourceType newSourceType = this.sourceType == null ? PgGraphConfigUtil.getAndValidateSourceType(this.graphConfig) : this.sourceType;
        String newSchemaName = this.owner == null ? this.graphConfig.getSchema() : this.owner;
        String newSourceName = this.dbGraphName == null ? PgGraphConfigUtil.getAndValidateSourceName(this.graphConfig) : this.dbGraphName;
        ErrorMessages.requireNonNull((Object)newSourceType, (String)"source type");
        ErrorMessages.requireNonNull((Object)newSourceName, (String)"source name");
        GraphLocation loc = this.createGraphLocationForType(newSourceType, newSchemaName, newSourceName);
        return this.session.describeGraphAsync(loc);
    }

    private GraphLocation createGraphLocationForType(SourceType type, String schemaName, String sourceName) {
        switch (type) {
            case PG_VIEW: {
                return PgViewGraphLocation.fromQualifiedName((String)schemaName, (String)sourceName, null, (String)this.jdbcUrl, (String)this.username, (String)this.password, (String)this.dataSourceId);
            }
            case PG_SQL: {
                return PgSqlGraphLocation.fromQualifiedName((String)schemaName, (String)sourceName, null, (String)this.jdbcUrl, (String)this.username, (String)this.password, (String)this.dataSourceId);
            }
        }
        throw IllegalEnumConstantException.create((Enum)type, (Enum[])new SourceType[]{SourceType.PG_VIEW, SourceType.PG_SQL});
    }

    public PgqlViewGraphExpander fromPgView(String pgViewName) {
        return this.fromPgView(null, pgViewName);
    }

    public PgqlViewGraphExpander fromPgView(String schemaName, String pgViewName) {
        this.owner = schemaName;
        this.dbGraphName = pgViewName;
        this.sourceType = SourceType.PG_VIEW;
        return this;
    }

    public PgqlViewGraphExpander fromPgSql(String sqlGraphName) {
        return this.fromPgView(null, sqlGraphName);
    }

    public PgqlViewGraphExpander fromPgSql(String schemaName, String sqlGraphName) {
        this.owner = schemaName;
        this.dbGraphName = sqlGraphName;
        this.sourceType = SourceType.PG_SQL;
        return this;
    }

    public PgqlViewGraphExpander queryPgql(String query) {
        this.queries.add(query);
        return this;
    }

    public PreparedPgViewPgqlQuery preparedPgqlQuery(String query) {
        PreparedPgqlQueryBuilderImpl preparedQuery = new PreparedPgqlQueryBuilderImpl(query);
        this.preparedQueries.add(preparedQuery);
        return new PreparedPgViewPgqlQuery(this, preparedQuery);
    }

    public PgqlViewGraphExpander dataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        return this;
    }

    public PgqlViewGraphExpander jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public PgqlViewGraphExpander username(String userName) {
        this.username = userName;
        return this;
    }

    public PgqlViewGraphExpander keystoreAlias(String keystoreAlias) {
        try {
            this.password(this.keystoreLookup.getPasswordForAlias(keystoreAlias));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        this.keystoreAlias = keystoreAlias;
        return this;
    }

    public PgqlViewGraphExpander password(String password) {
        this.password = password;
        return this;
    }

    @Deprecated
    public PgqlViewGraphExpander schema(String schema) {
        this.owner = schema;
        return this;
    }

    @Deprecated
    public PgqlViewGraphExpander owner(String owner) {
        return this.schema(owner);
    }

    public PgqlViewGraphExpander connections(int numConnections) {
        this.numConnections = numConnections;
        return this;
    }
}

