/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import oracle.pg.common.CloseableIterator;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleEdge;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.OracleVertex;
import oracle.pg.rdbms.Parameters;

public class OracleEdgeIteratorImpl
extends OracleElementIteratorImpl
implements CloseableIterator<OracleEdgeBase> {
    static SimpleLog ms_log = SimpleLog.getLog(OracleEdgeIteratorImpl.class);
    private OracleEdge EMPTY_EDGE = OracleEdge.getEmptyInstance();
    private long m_lStartTime;
    private long m_lWindowStartTime = this.m_lStartTime = System.currentTimeMillis();
    private long m_lWindowCount = 1L;
    static boolean ms_bShowProgress = Parameters.getInstance().showProgress();
    private AtomicLong[] atomicLongArray = null;
    private int atomicIdx = 0;

    public OracleEdge next() {
        boolean b;
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"next: start");
        }
        if (!this.bNextInovked && !(b = this.hasNext())) {
            throw new NoSuchElementException(MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
        }
        OracleEdge oe = null;
        try {
            long lPreviousID = 0L;
            OracleEdge ePrevious = null;
            while (!this.bNextExhausted) {
                Long lEID = this.rs.getLong(1);
                if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT)) {
                    this.moveCursor();
                    return this.EMPTY_EDGE;
                }
                if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.JUST_EDGE_ID)) {
                    oe = OracleEdge.getInstance(this.m_opg, lEID, true, this.getSkipStoreToCache());
                    oe.setCreatedWithOptFlag(true);
                    this.moveCursor();
                    return oe;
                }
                if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_EDGE_ID)) {
                    String szLabel = this.rs.getString(2);
                    if (szLabel != null && szLabel.equals(OracleEdge.EMPTY_LBL)) {
                        szLabel = "";
                    }
                    oe = OracleEdge.getInstance(this.m_opg, lEID, szLabel, true, this.getSkipStoreToCache());
                    oe.setCreatedWithOptFlag(true);
                    this.moveCursor();
                    return oe;
                }
                Long lSVID = this.rs.getLong(2);
                Long lDVID = this.rs.getLong(3);
                String szLabel = null;
                if ((this.m_optFlag == null || OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID.equals((Object)this.m_optFlag)) && (szLabel = this.rs.getString(4)) != null && szLabel.equals(OracleEdge.EMPTY_LBL)) {
                    szLabel = "";
                }
                if (ePrevious != null && lEID == lPreviousID) {
                    ms_log.debug((Object)"next: the same Edge. reuse");
                    oe = ePrevious;
                } else {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"next: a different Edge. ", (Object)lEID);
                    }
                    if (ePrevious != null) break;
                    OracleVertex outVertex = OracleVertex.getInstance(this.m_opg, lSVID, true, this.getSkipStoreToCache());
                    outVertex.setPartial(true);
                    OracleVertex inVertex = OracleVertex.getInstance(this.m_opg, lDVID, true, this.getSkipStoreToCache());
                    inVertex.setPartial(true);
                    if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_EDGE_ID)) {
                        this.moveCursor();
                        outVertex.setCreatedWithOptFlag(true);
                        inVertex.setCreatedWithOptFlag(true);
                        oe = OracleEdge.getInstance(this.m_opg, (OracleVertexBase)outVertex, (OracleVertexBase)inVertex, lEID, true, this.getSkipStoreToCache());
                        oe.setCreatedWithOptFlag(true);
                        return oe;
                    }
                    if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID)) {
                        this.moveCursor();
                        outVertex.setCreatedWithOptFlag(true);
                        inVertex.setCreatedWithOptFlag(true);
                        oe = OracleEdge.getInstance(this.m_opg, outVertex, inVertex, szLabel, lEID, true, this.getSkipStoreToCache());
                        oe.setCreatedWithOptFlag(true);
                        return oe;
                    }
                    oe = OracleEdge.getInstance(this.m_opg, outVertex, inVertex, szLabel, lEID, true, this.getSkipStoreToCache());
                    lPreviousID = lEID;
                }
                ePrevious = oe;
                String szKey = this.rs.getString(5);
                Object val = OraclePropertyGraph.readObjFromResultSet(this.rs, 6, this.m_opg.getTreatTimestampTzAsStr());
                if (val != null) {
                    oe.property(szKey, val, true, true);
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"next: oe ", oe.id());
                }
                this.moveCursor();
            }
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
        }
        catch (Exception sqle) {
            ms_log.debug((Object)"next: Exception ", (Throwable)sqle);
            this.safeCloseAndDeregisterIfNeeded(this.rs);
            this.rs = null;
            if (sqle instanceof SQLException) {
                if (((SQLException)sqle).getErrorCode() == 1013) {
                    this.m_bHitTimeoutAlready = true;
                    ms_log.debug((Object)"next: Query timeout exception(1013)");
                    if (this.m_gracefulTimeout) {
                        return oe;
                    }
                }
            } else {
                ms_log.debug((Object)"next: exception ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException(sqle);
        }
        ++this.m_lCount;
        ++this.m_lWindowCount;
        if (this.m_lCount % 100000L == 0L && ms_bShowProgress) {
            ms_log.info((Object)("next: progress to " + this.m_lCount + " in (ms) " + (System.currentTimeMillis() - this.m_lPrevTime)));
            this.m_lPrevTime = System.currentTimeMillis();
            long lDurationTime = System.currentTimeMillis() - this.m_lStartTime;
            long lWindowDurTime = System.currentTimeMillis() - this.m_lWindowStartTime;
            long edgesPerMinute = this.m_lCount * 60000L / lDurationTime;
            long edgesPerMinWindow = this.m_lWindowCount * 60000L / lWindowDurTime;
            this.reportProgress(edgesPerMinute, edgesPerMinWindow, this.m_lCount, lDurationTime);
            this.m_lWindowCount = 0L;
            this.m_lWindowStartTime = System.currentTimeMillis();
        }
        if (Parameters.getInstance().getUseIteratorBalancer() && this.m_lCount % 100000L == 0L && this.atomicLongArray != null && this.atomicLongArray.length > 1) {
            this.atomicLongArray[this.atomicIdx].set(this.m_lCount);
            double dAllProgress = 0.0;
            double dMin = Double.MAX_VALUE;
            double dMax = Double.MIN_VALUE;
            for (int iProgIdx = 0; iProgIdx < this.atomicLongArray.length; ++iProgIdx) {
                double d = this.atomicLongArray[iProgIdx].doubleValue();
                if (d > dMax) {
                    dMax = d;
                }
                if (d < dMin) {
                    dMin = d;
                }
                dAllProgress += d;
            }
            dAllProgress /= (double)this.atomicLongArray.length;
            double dCurProgress = this.m_lCount;
            if (ms_bShowProgress & ms_log.isInfoEnabled()) {
                ms_log.info((Object)("next: relative progress: current thread=> " + this.atomicLongArray[this.atomicIdx].longValue() + " , average " + (long)dAllProgress + " [ " + (long)dMin + " , " + (long)dMax));
            }
            if (dCurProgress > dMin * 1.2) {
                try {
                    long lWait = (long)(dCurProgress / (dMin + 1.0) * 1000.0);
                    if (lWait > 10000L) {
                        lWait = 10000L;
                    }
                    if (ms_bShowProgress & ms_log.isInfoEnabled()) {
                        ms_log.info((Object)("next: sleep ............................................... for a bit (in ms) " + lWait));
                    }
                    Thread.currentThread();
                    Thread.sleep(lWait);
                }
                catch (Throwable t) {
                    ms_log.debug((Object)"next: sleep adjustment exception ", t);
                }
            }
        }
        return oe;
    }

    private void reportProgress(long elementsPerMin, long elementsPerMinWindow, long lLine, long lDurationTime) {
        block2: {
            try {
                String szVal = "OracleElementIteratorImpl: load to " + lLine + " , elementsPerMin " + elementsPerMin + " , elementsPerMinWindow " + elementsPerMinWindow + " , lDurationTime_in_s " + lDurationTime / 1000L;
                System.out.println(szVal);
                System.out.flush();
                ms_log.info((Object)szVal);
            }
            catch (Throwable t) {
                if (!ms_log.isDebugEnabled()) break block2;
                ms_log.debug((Object)"reportProgress: ", t);
            }
        }
    }

    public OracleEdgeIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag) {
        super(opg, rs, flag);
        ms_log.debug((Object)"OracleEdgeIteratorImpl: constructor");
    }

    OracleEdgeIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag, int queryFetchSize) throws SQLException {
        this(opg, rs, flag);
        this.setQueryFetchSize(queryFetchSize);
    }

    OracleEdgeIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag, int queryFetchSize, boolean skipStoreToCache) throws SQLException {
        this(opg, rs, flag, queryFetchSize);
        this.setSkipStoreToCache(skipStoreToCache);
    }

    OracleEdgeIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag, int queryFetchSize, boolean skipStoreToCache, AtomicLong[] atomicLongArray, int atomicIdx) throws SQLException {
        this(opg, rs, flag, queryFetchSize, skipStoreToCache);
        this.atomicLongArray = atomicLongArray;
        this.atomicIdx = atomicIdx;
    }
}

