/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.DataChange;
import oracle.pg.rdbms.OraclePropertyGraph;

public final class EdgeChange
extends DataChange {
    protected static final SimpleLog LOG = SimpleLog.getLog(EdgeChange.class);
    private final String edgeLabel;
    private final Long svid;
    private final Long dvid;

    private EdgeChange(DataChange.ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId, String edgeLabel, Long svid, Long dvid) {
        super(changeAction, elementId, propertyKey, value, startScn, endScn, xId);
        this.edgeLabel = edgeLabel;
        this.svid = svid;
        this.dvid = dvid;
    }

    public static EdgeChange getInstance(DataChange.ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId, String edgeLabel, Long svid, Long dvid) {
        return new EdgeChange(changeAction, elementId, propertyKey, value, startScn, endScn, xId, edgeLabel, svid, dvid);
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public Long getSVID() {
        return this.svid;
    }

    public Long getDVID() {
        return this.dvid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.changeAction == DataChange.ChangeAction.ADD) {
            sb.append("[I]");
        } else if (this.changeAction == DataChange.ChangeAction.REMOVE) {
            sb.append("[D]");
        } else {
            sb.append("[U]");
        }
        sb.append(" SSCN=").append(EdgeChange.pad(this.startScn, 12, ' ')).append(" ESCN=").append(EdgeChange.pad(this.endScn, 12, ' ')).append(" XID=").append(EdgeChange.pad(this.xId, 24, ' ')).append(" EID=").append(EdgeChange.pad(this.elementId, 24, ' ')).append(" SVID=").append(this.svid).append(" DVID=").append(this.dvid).append(" Key=").append(this.propertyKey).append(" Value=").append(OraclePropertyGraph.getStringForObj((Object)this.value)).append(" LBL=").append(this.edgeLabel);
        return sb.toString();
    }
}

