/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports;

import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.pg.imports.GraphImportInputFormat;
import oracle.pg.imports.GraphImportOutputFormat;
import oracle.pg.imports.db.ConnectionManager;
import oracle.pg.imports.exceptions.GraphImportException;
import oracle.pg.imports.graph.PropertyGraphWriter;
import oracle.pg.imports.parser.ReaderFactory;
import oracle.pg.imports.parser.ReaderResult;
import oracle.pg.imports.parser.WriterFactory;
import oracle.pg.imports.parser.graphson.GraphsonParser;
import oracle.pgql.lang.PgqlException;

public class GraphImporter {
    public static final GraphImportInputFormat DEFAULT_INPUT_FORMAT = GraphImportInputFormat.GRAPHSON;
    public static final GraphImportOutputFormat DEFAULT_OUTPUT_FORMAT = GraphImportOutputFormat.PG_VIEW;
    public static final int DEFAULT_THREADS = 1;
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final int DEFAULT_STRING_SIZE = 100;
    public static final short DEFAULT_FRACTIONAL_SECONDS_PRECISION = 6;
    public static final int DEFAULT_PARALLEL = 0;
    public static final int DEFAULT_DYNAMIC_SAMPLING = 2;
    public static final String DEFAULT_MATCH_OPTIONS = null;
    public static final String DEFAULT_OPTIONS = null;
    private final ConnectionManager connectionManager;
    private final String filePath;
    private final String graphName;
    private final GraphImportInputFormat inFormat;
    private final GraphImportOutputFormat outFormat;
    private final int batchSize;
    private final int threads;
    private final int stringFieldsSize;
    private final short fractionalSecondsPrecision;
    private final int parallelism;
    private final int dynamicSampling;
    private final String matchOptions;
    private final String options;

    private GraphImporter(Builder builder) throws GraphImportException {
        if (builder.getDataSource() == null && (builder.getDbJdbcUrl().isEmpty() || builder.getDbUsername().isEmpty() || builder.getDbPassword().isEmpty())) {
            throw new IllegalArgumentException("The connection info was not provided or was provided incomplete, please submit either a Data Source or a JDBC URL string, username and password.");
        }
        if (builder.getFilePath().isEmpty()) {
            throw new IllegalArgumentException("The input file was not provided, please submit a file that matches your input format.");
        }
        if (builder.getGraphName().isEmpty()) {
            throw new IllegalArgumentException("The graph name was not provided, please submit a name for your graph.");
        }
        if (builder.getBatchSize() < 1) {
            throw new IllegalArgumentException("The batch size number must be positive, please submit a positive number.");
        }
        if (builder.getThreads() < 1) {
            throw new IllegalArgumentException("The number of threads must be positive, please submit a positive number.");
        }
        if (builder.getStringFieldsSize() < 1) {
            throw new IllegalArgumentException("The string fields size must be positive, please submit a positive number.");
        }
        if (builder.getFractionalSecondsPrecision() < 0) {
            throw new IllegalArgumentException("The fractional seconds precision number must be positive, please submit a positive number.");
        }
        this.filePath = builder.getFilePath();
        this.graphName = builder.getGraphName();
        this.inFormat = builder.getInputFormat();
        this.outFormat = builder.getOutputFormat();
        this.batchSize = builder.getBatchSize();
        this.threads = builder.getThreads();
        this.stringFieldsSize = builder.getStringFieldsSize();
        this.fractionalSecondsPrecision = builder.getFractionalSecondsPrecision();
        this.parallelism = builder.getParallelism();
        this.dynamicSampling = builder.getDynamicSampling();
        this.matchOptions = builder.getMatchOptions();
        this.options = builder.getOptions();
        this.connectionManager = builder.getDataSource() != null ? new ConnectionManager(builder.getDataSource()) : new ConnectionManager(builder.getDbJdbcUrl(), builder.getDbUsername(), builder.getDbPassword());
    }

    public Object importGraph() throws GraphImportException, PgqlException, SQLException {
        GraphsonParser reader = ReaderFactory.getReader(this.inFormat, this);
        ReaderResult readerResult = reader.read();
        PropertyGraphWriter writer = WriterFactory.getWriter(this.outFormat, this, readerResult);
        return writer.write();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public GraphImportInputFormat getInFormat() {
        return this.inFormat;
    }

    public GraphImportOutputFormat getOutFormat() {
        return this.outFormat;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getStringFieldsSize() {
        return this.stringFieldsSize;
    }

    public short getFractionalSecondsPrecision() {
        return this.fractionalSecondsPrecision;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getDynamicSampling() {
        return this.dynamicSampling;
    }

    public String getMatchOptions() {
        return this.matchOptions;
    }

    public String getOptions() {
        return this.options;
    }

    public static class Builder {
        private String dbJdbcUrl = "";
        private String dbUsername = "";
        private String dbPassword = "";
        private DataSource dataSource = null;
        private String filePath = "";
        private String graphName = "";
        private GraphImportInputFormat inFormat = DEFAULT_INPUT_FORMAT;
        private GraphImportOutputFormat outFormat = DEFAULT_OUTPUT_FORMAT;
        private int batchSize = 1000;
        private int threads = 1;
        private int stringFieldsSize = 100;
        private short fractionalSecondsPrecision = (short)6;
        private int parallelism = 0;
        private int dynamicSampling = 2;
        private String matchOptions = DEFAULT_MATCH_OPTIONS;
        private String options = DEFAULT_OPTIONS;

        public GraphImporter build() throws GraphImportException {
            return new GraphImporter(this);
        }

        public String getDbJdbcUrl() {
            return this.dbJdbcUrl;
        }

        public Builder setDbJdbcUrl(String dbJdbcUrl) {
            this.dbJdbcUrl = dbJdbcUrl;
            return this;
        }

        public String getDbUsername() {
            return this.dbUsername;
        }

        public Builder setDbUsername(String dbUsername) {
            this.dbUsername = dbUsername;
            return this;
        }

        public String getDbPassword() {
            return this.dbPassword;
        }

        public Builder setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Builder setFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public String getGraphName() {
            return this.graphName;
        }

        public Builder setGraphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public GraphImportInputFormat getInputFormat() {
            return this.inFormat;
        }

        public Builder setInputFormat(GraphImportInputFormat inFormat) {
            this.inFormat = inFormat;
            return this;
        }

        public GraphImportOutputFormat getOutputFormat() {
            return this.outFormat;
        }

        public Builder setOutputFormat(GraphImportOutputFormat outFormat) {
            this.outFormat = outFormat;
            return this;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public int getThreads() {
            return this.threads;
        }

        public Builder setThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public int getStringFieldsSize() {
            return this.stringFieldsSize;
        }

        public Builder setStringFieldsSize(int stringFieldsSize) {
            this.stringFieldsSize = stringFieldsSize;
            return this;
        }

        public short getFractionalSecondsPrecision() {
            return this.fractionalSecondsPrecision;
        }

        public Builder setFractionalSecondsPrecision(short fractionalSecondsPrecision) {
            this.fractionalSecondsPrecision = fractionalSecondsPrecision;
            return this;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public Builder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public int getDynamicSampling() {
            return this.dynamicSampling;
        }

        public Builder setDynamicSampling(int dynamicSampling) {
            this.dynamicSampling = dynamicSampling;
            return this;
        }

        public String getMatchOptions() {
            return this.matchOptions;
        }

        public Builder setMatchOptions(String matchOptions) {
            this.matchOptions = matchOptions;
            return this;
        }

        public String getOptions() {
            return this.options;
        }

        public Builder setOptions(String options) {
            this.options = options;
            return this;
        }
    }
}

