"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A Listener Action to authenticate with Cognito
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC)
     */
    constructor(options) {
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: options.sessionTimeout?.toSeconds().toString(),
            },
        }, options.next);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_elasticloadbalancingv2_actions_AuthenticateCognitoActionProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AuthenticateCognitoAction);
            }
            throw error;
        }
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
_a = JSII_RTTI_SYMBOL_1;
AuthenticateCognitoAction[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoAction", version: "1.198.0" };
//# sourceMappingURL=data:application/json;base64,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