#
# This code has been auto-generated by the MDE Workbench
# Version: 2.4.0.
#
# File: calculations.py
# Date: 2021-07-14 11:34
# Time: 11:34
#


import requests
import jsons
import urllib3
from requests import Response

from pypws.constants import *
from pypws.enums import *
from pypws.entities import *
from pypws.utilities import getAccessToken, getApiTarget, getClientAliasId

# Suppress https message
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


class Calculation(object):

	# Constructor.
	def __init__(self):

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# Post json to url and time the call
	def post_request(self, url, json, accessToken) -> Response:

		headers = {
			'Content-Type': 'application/json',
			'Authorization': 'Bearer {}'.format(accessToken)
		}

		response = requests.post(url, json=json, headers=headers, verify=False)

		return response

	# Print out the messages
	def print_messages(self):

		for message in self.messages:
			print('     {0}'.format(message))

# Request object for a calc thermo paths calculation.
class CalcThermoPathsCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Definition of pure component / mixture
		self.material = Material()

		# Initial pressure and temperature
		self.initialState = State()


# Calc thermo paths calculation class.
class CalcThermoPathsCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Definition of pure component / mixture
		self.material = Material()

		# Initial pressure and temperature
		self.initialState = State()

		# Calculation outputs.
		# Callback for individual points along the thermodynamic paths
		self.thermoPathRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# CalcThermoPaths calculation run method.
	def run(self) -> ResultCode:

		# Create the calc thermo paths request.
		calcThermoPathsCalculationRequest = CalcThermoPathsCalculationRequest()

		# Initialise the member properties.

		calcThermoPathsCalculationRequest.material = self.material
		calcThermoPathsCalculationRequest.initialState = self.initialState

		requestJson = jsons.dumps(calcThermoPathsCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatecalcthermopaths?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			calcThermoPathsCalculationResponse = CalcThermoPathsCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				calcThermoPathsCalculationResponse.initialiseFromDictionary(json)

				self.thermoPathRecords = calcThermoPathsCalculationResponse.thermoPathRecords
				self.resultCode = calcThermoPathsCalculationResponse.resultCode
				self.resultCode = calcThermoPathsCalculationResponse.resultCode
				self.messages = calcThermoPathsCalculationResponse.messages
				self.elapsedTime = calcThermoPathsCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the CalcThermoPaths calculation object to print itself.
	def print(self):

		# CalcThermoPaths
		print('** CalcThermoPaths')

		# material
		self.material.print()

		# initialState
		self.initialState.print()

		for thermoPathRecord in self.thermoPathRecords:
			thermoPathRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a calc thermo paths calculation.
class CalcThermoPathsCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Callback for individual points along the thermodynamic paths
		self.thermoPathRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Callback for individual points along the thermodynamic paths
		for dataItem in data['thermoPathRecords']:
			thermoPathRecord = ThermoPathRecord()
			thermoPathRecord.initialiseFromDictionary(dataItem)
			self.thermoPathRecords.append(thermoPathRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a concentration at point calculation.
class ConcentrationAtPointCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()


# Concentration at point calculation class.
class ConcentrationAtPointCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentration at a position of interest
		self.concentration = 0.0

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# ConcentrationAtPoint calculation run method.
	def run(self) -> ResultCode:

		# Create the concentration at point request.
		concentrationAtPointCalculationRequest = ConcentrationAtPointCalculationRequest()

		# Initialise the member properties.

		concentrationAtPointCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		concentrationAtPointCalculationRequest.weather = self.weather
		concentrationAtPointCalculationRequest.dispersionRecords = self.dispersionRecords
		concentrationAtPointCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		concentrationAtPointCalculationRequest.substrate = self.substrate
		concentrationAtPointCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		concentrationAtPointCalculationRequest.material = self.material

		requestJson = jsons.dumps(concentrationAtPointCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateconcentrationatpoint?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			concentrationAtPointCalculationResponse = ConcentrationAtPointCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				concentrationAtPointCalculationResponse.initialiseFromDictionary(json)

				self.concentration = concentrationAtPointCalculationResponse.concentration
				self.resultCode = concentrationAtPointCalculationResponse.resultCode
				self.resultCode = concentrationAtPointCalculationResponse.resultCode
				self.messages = concentrationAtPointCalculationResponse.messages
				self.elapsedTime = concentrationAtPointCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the ConcentrationAtPoint calculation object to print itself.
	def print(self):

		# ConcentrationAtPoint
		print('** ConcentrationAtPoint')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# material
		self.material.print()

		# concentration
		print('{0}\t{1}'.format('Concentration', self.concentration))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a concentration at point calculation.
class ConcentrationAtPointCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentration at a position of interest
		self.concentration = 0.0

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentration at a position of interest
		self.concentration = float(data['concentration'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a corqa flash calculation.
class CorqaFlashCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()


# Corqa flash calculation class.
class CorqaFlashCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()

		# Calculation outputs.
		# Constant properties of the fluid
		self.constMatResult = ConstantMaterialResult()

		# Fluid properties at given conditions
		self.flashResult = FlashResult()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# CorqaFlash calculation run method.
	def run(self) -> ResultCode:

		# Create the corqa flash request.
		corqaFlashCalculationRequest = CorqaFlashCalculationRequest()

		# Initialise the member properties.

		corqaFlashCalculationRequest.material = self.material
		corqaFlashCalculationRequest.materialState = self.materialState

		requestJson = jsons.dumps(corqaFlashCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatecorqaflash?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			corqaFlashCalculationResponse = CorqaFlashCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				corqaFlashCalculationResponse.initialiseFromDictionary(json)

				self.constMatResult = corqaFlashCalculationResponse.constMatResult
				self.flashResult = corqaFlashCalculationResponse.flashResult
				self.resultCode = corqaFlashCalculationResponse.resultCode
				self.resultCode = corqaFlashCalculationResponse.resultCode
				self.messages = corqaFlashCalculationResponse.messages
				self.elapsedTime = corqaFlashCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the CorqaFlash calculation object to print itself.
	def print(self):

		# CorqaFlash
		print('** CorqaFlash')

		# material
		self.material.print()

		# materialState
		self.materialState.print()

		# constMatResult
		self.constMatResult.print()

		# flashResult
		self.flashResult.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a corqa flash calculation.
class CorqaFlashCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Constant properties of the fluid
		self.constMatResult = ConstantMaterialResult()

		# Fluid properties at given conditions
		self.flashResult = FlashResult()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Constant properties of the fluid
		self.constMatResult.initialiseFromDictionary(data['constMatResult'])

		# Fluid properties at given conditions
		self.flashResult.initialiseFromDictionary(data['flashResult'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a dispersion calculation.
class DispersionCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# The dispersing surface
		self.substrate = Substrate()

		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Discharge / source term definition
		self.dischargeRecords = []

		# Number of discharge records
		self.dischargeRecordCount = 0

		# Weather
		self.weather = Weather()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Concentration at which the dispersion calculations will terminate (v/v fraction)
		self.endPointConcentration = 0.0


	# No description provided.
# Dispersion calculation class.
class DispersionCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# The dispersing surface
		self.substrate = Substrate()

		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Discharge / source term definition
		self.dischargeRecords = []


		# Weather
		self.weather = Weather()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Concentration at which the dispersion calculations will terminate (v/v fraction)
		self.endPointConcentration = 0.0

		# Calculation outputs.
		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Array of Dispersion records
		self.dispersionRecords = []

		# Array of Pool records
		self.poolRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# Dispersion calculation run method.
	def run(self) -> ResultCode:

		# Create the dispersion request.
		dispersionCalculationRequest = DispersionCalculationRequest()

		# Initialise the member properties.

		dispersionCalculationRequest.material = self.material
		dispersionCalculationRequest.substrate = self.substrate
		dispersionCalculationRequest.dischargeResult = self.dischargeResult
		dispersionCalculationRequest.dischargeRecords = self.dischargeRecords
		dispersionCalculationRequest.dischargeRecordCount = len(self.dischargeRecords)
		dispersionCalculationRequest.weather = self.weather
		dispersionCalculationRequest.dispersionParameters = self.dispersionParameters
		dispersionCalculationRequest.endPointConcentration = self.endPointConcentration

		requestJson = jsons.dumps(dispersionCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatedispersion?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			dispersionCalculationResponse = DispersionCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				dispersionCalculationResponse.initialiseFromDictionary(json)

				self.scalarUdmOutputs = dispersionCalculationResponse.scalarUdmOutputs
				self.dispersionRecords = dispersionCalculationResponse.dispersionRecords
				self.poolRecords = dispersionCalculationResponse.poolRecords
				self.resultCode = dispersionCalculationResponse.resultCode
				self.resultCode = dispersionCalculationResponse.resultCode
				self.messages = dispersionCalculationResponse.messages
				self.elapsedTime = dispersionCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the Dispersion calculation object to print itself.
	def print(self):

		# Dispersion
		print('** Dispersion')

		# material
		self.material.print()

		# substrate
		self.substrate.print()

		# dischargeResult
		self.dischargeResult.print()

		for item in self.dischargeRecords:
			item.print()


		# weather
		self.weather.print()

		# dispersionParameters
		self.dispersionParameters.print()

		print(self.endPointConcentration)
		print('{0}\t{1}'.format('End point concentration', self.endPointConcentration))

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		for dispersionRecord in self.dispersionRecords:
			dispersionRecord.print()

		for poolRecord in self.poolRecords:
			poolRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a dispersion calculation.
class DispersionCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Array of Dispersion records
		self.dispersionRecords = []

		# Array of Pool records
		self.poolRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# UDM scalar outputs
		self.scalarUdmOutputs.initialiseFromDictionary(data['scalarUdmOutputs'])

		# Array of Dispersion records
		for dataItem in data['dispersionRecords']:
			dispersionRecord = DispersionRecord()
			dispersionRecord.initialiseFromDictionary(dataItem)
			self.dispersionRecords.append(dispersionRecord)

		# Array of Pool records
		for dataItem in data['poolRecords']:
			poolRecord = PoolRecord()
			poolRecord.initialiseFromDictionary(dataItem)
			self.poolRecords.append(poolRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a distances and ellipses to radiation levels calculation.
class DistancesAndEllipsesToRadiationLevelsCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []

		# Number of flame records
		self.flameRecordCount = 0

		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Description for entry point parameter flammableOutputConfigs not found.
		self.flammableOutputConfigs = []

		# Number of radiation levels
		self.flammableOutputConfigCount = 0


# Distances and ellipses to radiation levels calculation class.
class DistancesAndEllipsesToRadiationLevelsCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []


		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Description for entry point parameter flammableOutputConfigs not found.
		self.flammableOutputConfigs = []


		# Calculation outputs.
		# Distances to radiation levels
		self.distances = []

		# Contour points of radiation ellipses to radiation levels
		self.contourPoints = []

		# Number of contour points per radiation level
		self.nCountourPoints = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# DistancesAndEllipsesToRadiationLevels calculation run method.
	def run(self) -> ResultCode:

		# Create the distances and ellipses to radiation levels request.
		distancesAndEllipsesToRadiationLevelsCalculationRequest = DistancesAndEllipsesToRadiationLevelsCalculationRequest()

		# Initialise the member properties.

		distancesAndEllipsesToRadiationLevelsCalculationRequest.flameResult = self.flameResult
		distancesAndEllipsesToRadiationLevelsCalculationRequest.flameRecords = self.flameRecords
		distancesAndEllipsesToRadiationLevelsCalculationRequest.flameRecordCount = len(self.flameRecords)
		distancesAndEllipsesToRadiationLevelsCalculationRequest.weather = self.weather
		distancesAndEllipsesToRadiationLevelsCalculationRequest.flammableParameters = self.flammableParameters
		distancesAndEllipsesToRadiationLevelsCalculationRequest.flammableOutputConfigs = self.flammableOutputConfigs
		distancesAndEllipsesToRadiationLevelsCalculationRequest.flammableOutputConfigCount = len(self.flammableOutputConfigs)

		requestJson = jsons.dumps(distancesAndEllipsesToRadiationLevelsCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatedistancesandellipsestoradiationlevels?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			distancesAndEllipsesToRadiationLevelsCalculationResponse = DistancesAndEllipsesToRadiationLevelsCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				distancesAndEllipsesToRadiationLevelsCalculationResponse.initialiseFromDictionary(json)

				self.distances = distancesAndEllipsesToRadiationLevelsCalculationResponse.distances
				self.contourPoints = distancesAndEllipsesToRadiationLevelsCalculationResponse.contourPoints
				self.nCountourPoints = distancesAndEllipsesToRadiationLevelsCalculationResponse.nCountourPoints
				self.resultCode = distancesAndEllipsesToRadiationLevelsCalculationResponse.resultCode
				self.resultCode = distancesAndEllipsesToRadiationLevelsCalculationResponse.resultCode
				self.messages = distancesAndEllipsesToRadiationLevelsCalculationResponse.messages
				self.elapsedTime = distancesAndEllipsesToRadiationLevelsCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the DistancesAndEllipsesToRadiationLevels calculation object to print itself.
	def print(self):

		# DistancesAndEllipsesToRadiationLevels
		print('** DistancesAndEllipsesToRadiationLevels')

		# flameResult
		self.flameResult.print()

		for item in self.flameRecords:
			item.print()


		# weather
		self.weather.print()

		# flammableParameters
		self.flammableParameters.print()

		for item in self.flammableOutputConfigs:
			item.print()


		# distances
		for item in self.distances:
			print('{0}'.format(item))

		for contourPoint in self.contourPoints:
			contourPoint.print()

		# nCountourPoints
		for item in self.nCountourPoints:
			print('{0}'.format(item))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a distances and ellipses to radiation levels calculation.
class DistancesAndEllipsesToRadiationLevelsCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Distances to radiation levels
		self.distances = []

		# Contour points of radiation ellipses to radiation levels
		self.contourPoints = []

		# Number of contour points per radiation level
		self.nCountourPoints = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Distances to radiation levels
		for dataItem in data['distances']:
			self.distances.append(float(dataItem))

		# Contour points of radiation ellipses to radiation levels
		for dataItem in data['contourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.contourPoints.append(localPosition)

		# Number of contour points per radiation level
		for dataItem in data['nCountourPoints']:
			self.nCountourPoints.append(int(dataItem))

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a distances to conc levels calculation.
class DistancesToConcLevelsCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Concentration levels
		self.dispersionOutputConfigs = []

		# Number of concentration levels
		self.dispersionOutputConfigCount = 0

		# Material with post-discharge composition
		self.material = Material()


# Distances to conc levels calculation class.
class DistancesToConcLevelsCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Concentration levels
		self.dispersionOutputConfigs = []


		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentrations of interest
		self.concUsed = []

		# Description for entry point parameter distances not found.
		self.distances = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# DistancesToConcLevels calculation run method.
	def run(self) -> ResultCode:

		# Create the distances to conc levels request.
		distancesToConcLevelsCalculationRequest = DistancesToConcLevelsCalculationRequest()

		# Initialise the member properties.

		distancesToConcLevelsCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		distancesToConcLevelsCalculationRequest.weather = self.weather
		distancesToConcLevelsCalculationRequest.dispersionRecords = self.dispersionRecords
		distancesToConcLevelsCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		distancesToConcLevelsCalculationRequest.substrate = self.substrate
		distancesToConcLevelsCalculationRequest.dispersionOutputConfigs = self.dispersionOutputConfigs
		distancesToConcLevelsCalculationRequest.dispersionOutputConfigCount = len(self.dispersionOutputConfigs)
		distancesToConcLevelsCalculationRequest.material = self.material

		requestJson = jsons.dumps(distancesToConcLevelsCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatedistancestoconclevels?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			distancesToConcLevelsCalculationResponse = DistancesToConcLevelsCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				distancesToConcLevelsCalculationResponse.initialiseFromDictionary(json)

				self.concUsed = distancesToConcLevelsCalculationResponse.concUsed
				self.distances = distancesToConcLevelsCalculationResponse.distances
				self.resultCode = distancesToConcLevelsCalculationResponse.resultCode
				self.resultCode = distancesToConcLevelsCalculationResponse.resultCode
				self.messages = distancesToConcLevelsCalculationResponse.messages
				self.elapsedTime = distancesToConcLevelsCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the DistancesToConcLevels calculation object to print itself.
	def print(self):

		# DistancesToConcLevels
		print('** DistancesToConcLevels')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		for item in self.dispersionOutputConfigs:
			item.print()


		# material
		self.material.print()

		# concUsed
		for item in self.concUsed:
			print('{0}'.format(item))

		# distances
		for item in self.distances:
			print('{0}'.format(item))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a distances to conc levels calculation.
class DistancesToConcLevelsCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentrations of interest
		self.concUsed = []

		# Description for entry point parameter distances not found.
		self.distances = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentrations of interest
		for dataItem in data['concUsed']:
			self.concUsed.append(float(dataItem))

		# Description for entry point parameter distances not found.
		for dataItem in data['distances']:
			self.distances.append(float(dataItem))

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a distances to radiation levels calculation.
class DistancesToRadiationLevelsCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []

		# Number of flame records
		self.flameRecordCount = 0

		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Flammable output configurations
		self.flammableOutputConfigs = []

		# Number of flammable output configurations
		self.flammableOutputConfigCount = 0


# Distances to radiation levels calculation class.
class DistancesToRadiationLevelsCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []


		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Flammable output configurations
		self.flammableOutputConfigs = []


		# Calculation outputs.
		# Distances to radiation level
		self.distances = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# DistancesToRadiationLevels calculation run method.
	def run(self) -> ResultCode:

		# Create the distances to radiation levels request.
		distancesToRadiationLevelsCalculationRequest = DistancesToRadiationLevelsCalculationRequest()

		# Initialise the member properties.

		distancesToRadiationLevelsCalculationRequest.flameResult = self.flameResult
		distancesToRadiationLevelsCalculationRequest.flameRecords = self.flameRecords
		distancesToRadiationLevelsCalculationRequest.flameRecordCount = len(self.flameRecords)
		distancesToRadiationLevelsCalculationRequest.weather = self.weather
		distancesToRadiationLevelsCalculationRequest.flammableParameters = self.flammableParameters
		distancesToRadiationLevelsCalculationRequest.flammableOutputConfigs = self.flammableOutputConfigs
		distancesToRadiationLevelsCalculationRequest.flammableOutputConfigCount = len(self.flammableOutputConfigs)

		requestJson = jsons.dumps(distancesToRadiationLevelsCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatedistancestoradiationlevels?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			distancesToRadiationLevelsCalculationResponse = DistancesToRadiationLevelsCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				distancesToRadiationLevelsCalculationResponse.initialiseFromDictionary(json)

				self.distances = distancesToRadiationLevelsCalculationResponse.distances
				self.resultCode = distancesToRadiationLevelsCalculationResponse.resultCode
				self.resultCode = distancesToRadiationLevelsCalculationResponse.resultCode
				self.messages = distancesToRadiationLevelsCalculationResponse.messages
				self.elapsedTime = distancesToRadiationLevelsCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the DistancesToRadiationLevels calculation object to print itself.
	def print(self):

		# DistancesToRadiationLevels
		print('** DistancesToRadiationLevels')

		# flameResult
		self.flameResult.print()

		for item in self.flameRecords:
			item.print()


		# weather
		self.weather.print()

		# flammableParameters
		self.flammableParameters.print()

		for item in self.flammableOutputConfigs:
			item.print()


		# distances
		for item in self.distances:
			print('{0}'.format(item))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a distances to radiation levels calculation.
class DistancesToRadiationLevelsCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Distances to radiation level
		self.distances = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Distances to radiation level
		for dataItem in data['distances']:
			self.distances.append(float(dataItem))

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a distance to radiation calculation.
class DistanceToRadiationCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []

		# Number of flame records
		self.flameRecordCount = 0

		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()


# Distance to radiation calculation class.
class DistanceToRadiationCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []


		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()

		# Calculation outputs.
		# Distance to radiation level
		self.distance = 0.0

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# DistanceToRadiation calculation run method.
	def run(self) -> ResultCode:

		# Create the distance to radiation request.
		distanceToRadiationCalculationRequest = DistanceToRadiationCalculationRequest()

		# Initialise the member properties.

		distanceToRadiationCalculationRequest.flameResult = self.flameResult
		distanceToRadiationCalculationRequest.flameRecords = self.flameRecords
		distanceToRadiationCalculationRequest.flameRecordCount = len(self.flameRecords)
		distanceToRadiationCalculationRequest.weather = self.weather
		distanceToRadiationCalculationRequest.flammableParameters = self.flammableParameters
		distanceToRadiationCalculationRequest.flammableOutputConfig = self.flammableOutputConfig

		requestJson = jsons.dumps(distanceToRadiationCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatedistancetoradiation?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			distanceToRadiationCalculationResponse = DistanceToRadiationCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				distanceToRadiationCalculationResponse.initialiseFromDictionary(json)

				self.distance = distanceToRadiationCalculationResponse.distance
				self.resultCode = distanceToRadiationCalculationResponse.resultCode
				self.resultCode = distanceToRadiationCalculationResponse.resultCode
				self.messages = distanceToRadiationCalculationResponse.messages
				self.elapsedTime = distanceToRadiationCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the DistanceToRadiation calculation object to print itself.
	def print(self):

		# DistanceToRadiation
		print('** DistanceToRadiation')

		# flameResult
		self.flameResult.print()

		for item in self.flameRecords:
			item.print()


		# weather
		self.weather.print()

		# flammableParameters
		self.flammableParameters.print()

		# flammableOutputConfig
		self.flammableOutputConfig.print()

		# distance
		print('{0}\t{1}'.format('Distance', self.distance))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a distance to radiation calculation.
class DistanceToRadiationCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Distance to radiation level
		self.distance = 0.0

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Distance to radiation level
		self.distance = float(data['distance'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a fireball calculation.
class FireballCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# The thermodynamic conditions
		self.state = State()

		# Discharge / source term definition
		self.dischargeRecords = []

		# Number of discharge records
		self.dischargeRecordCount = 0

		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Weather
		self.weather = Weather()


	# No description provided.
# Fireball calculation class.
class FireballCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# The thermodynamic conditions
		self.state = State()

		# Discharge / source term definition
		self.dischargeRecords = []


		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Weather
		self.weather = Weather()

		# Calculation outputs.
		# Flame scalar result
		self.flameResult = FlameResult()

		# Array of fireball flame records
		self.flameRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# Fireball calculation run method.
	def run(self) -> ResultCode:

		# Create the fireball request.
		fireballCalculationRequest = FireballCalculationRequest()

		# Initialise the member properties.

		fireballCalculationRequest.material = self.material
		fireballCalculationRequest.state = self.state
		fireballCalculationRequest.dischargeRecords = self.dischargeRecords
		fireballCalculationRequest.dischargeRecordCount = len(self.dischargeRecords)
		fireballCalculationRequest.dischargeResult = self.dischargeResult
		fireballCalculationRequest.weather = self.weather

		requestJson = jsons.dumps(fireballCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatefireball?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			fireballCalculationResponse = FireballCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				fireballCalculationResponse.initialiseFromDictionary(json)

				self.flameResult = fireballCalculationResponse.flameResult
				self.flameRecords = fireballCalculationResponse.flameRecords
				self.resultCode = fireballCalculationResponse.resultCode
				self.resultCode = fireballCalculationResponse.resultCode
				self.messages = fireballCalculationResponse.messages
				self.elapsedTime = fireballCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the Fireball calculation object to print itself.
	def print(self):

		# Fireball
		print('** Fireball')

		# material
		self.material.print()

		# state
		self.state.print()

		for item in self.dischargeRecords:
			item.print()


		# dischargeResult
		self.dischargeResult.print()

		# weather
		self.weather.print()

		# flameResult
		self.flameResult.print()

		for flameRecord in self.flameRecords:
			flameRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a fireball calculation.
class FireballCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Flame scalar result
		self.flameResult = FlameResult()

		# Array of fireball flame records
		self.flameRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Flame scalar result
		self.flameResult.initialiseFromDictionary(data['flameResult'])

		# Array of fireball flame records
		for dataItem in data['flameRecords']:
			flameRecord = FlameRecord()
			flameRecord.initialiseFromDictionary(dataItem)
			self.flameRecords.append(flameRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a flare stack designer calculation.
class FlareStackDesignerCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Flare stack asset
		self.flareStack = FlareStack()

		# Data that defines the design requirements
		self.flareStackConstraint = Constraint()

		# Weather
		self.weather = Weather()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Substrate data
		self.substrate = Substrate()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Defines the flammable results of interest
		self.flammableOutputConfig = FlammableOutputConfig()


	# No description provided.
# Flare stack designer calculation class.
class FlareStackDesignerCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Flare stack asset
		self.flareStack = FlareStack()

		# Data that defines the design requirements
		self.flareStackConstraint = Constraint()

		# Weather
		self.weather = Weather()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Substrate data
		self.substrate = Substrate()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Defines the flammable results of interest
		self.flammableOutputConfig = FlammableOutputConfig()

		# Calculation outputs.
		# Value of design variable that satisfies the design target
		self.designSolution = 0.0

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# FlareStackDesigner calculation run method.
	def run(self) -> ResultCode:

		# Create the flare stack designer request.
		flareStackDesignerCalculationRequest = FlareStackDesignerCalculationRequest()

		# Initialise the member properties.

		flareStackDesignerCalculationRequest.flareStack = self.flareStack
		flareStackDesignerCalculationRequest.flareStackConstraint = self.flareStackConstraint
		flareStackDesignerCalculationRequest.weather = self.weather
		flareStackDesignerCalculationRequest.dischargeParameters = self.dischargeParameters
		flareStackDesignerCalculationRequest.substrate = self.substrate
		flareStackDesignerCalculationRequest.flammableParameters = self.flammableParameters
		flareStackDesignerCalculationRequest.flammableOutputConfig = self.flammableOutputConfig

		requestJson = jsons.dumps(flareStackDesignerCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateflarestackdesigner?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			flareStackDesignerCalculationResponse = FlareStackDesignerCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				flareStackDesignerCalculationResponse.initialiseFromDictionary(json)

				self.designSolution = flareStackDesignerCalculationResponse.designSolution
				self.resultCode = flareStackDesignerCalculationResponse.resultCode
				self.resultCode = flareStackDesignerCalculationResponse.resultCode
				self.messages = flareStackDesignerCalculationResponse.messages
				self.elapsedTime = flareStackDesignerCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the FlareStackDesigner calculation object to print itself.
	def print(self):

		# FlareStackDesigner
		print('** FlareStackDesigner')

		# flareStack
		self.flareStack.print()

		# flareStackConstraint
		self.flareStackConstraint.print()

		# weather
		self.weather.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# substrate
		self.substrate.print()

		# flammableParameters
		self.flammableParameters.print()

		# flammableOutputConfig
		self.flammableOutputConfig.print()

		# designSolution
		print('{0}\t{1}'.format('Design solution', self.designSolution))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a flare stack designer calculation.
class FlareStackDesignerCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Value of design variable that satisfies the design target
		self.designSolution = 0.0

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Value of design variable that satisfies the design target
		self.designSolution = float(data['designSolution'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a flash calculation.
class FlashCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()


# Flash calculation class.
class FlashCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()

		# Calculation outputs.
		# Fluid properties at given conditions
		self.flashResult = FlashResult()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# Flash calculation run method.
	def run(self) -> ResultCode:

		# Create the flash request.
		flashCalculationRequest = FlashCalculationRequest()

		# Initialise the member properties.

		flashCalculationRequest.material = self.material
		flashCalculationRequest.materialState = self.materialState

		requestJson = jsons.dumps(flashCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateflash?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			flashCalculationResponse = FlashCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				flashCalculationResponse.initialiseFromDictionary(json)

				self.flashResult = flashCalculationResponse.flashResult
				self.resultCode = flashCalculationResponse.resultCode
				self.resultCode = flashCalculationResponse.resultCode
				self.messages = flashCalculationResponse.messages
				self.elapsedTime = flashCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the Flash calculation object to print itself.
	def print(self):

		# Flash
		print('** Flash')

		# material
		self.material.print()

		# materialState
		self.materialState.print()

		# flashResult
		self.flashResult.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a flash calculation.
class FlashCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Fluid properties at given conditions
		self.flashResult = FlashResult()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Fluid properties at given conditions
		self.flashResult.initialiseFromDictionary(data['flashResult'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a jet fire calculation.
class JetFireCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# Discharge / source term definition
		self.dischargeRecords = []

		# Number of discharge records
		self.dischargeRecordCount = 0

		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Weather
		self.weather = Weather()

		# Substrate
		self.substrate = Substrate()


	# No description provided.
# Jet fire calculation class.
class JetFireCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# Discharge / source term definition
		self.dischargeRecords = []


		# Discharge / source term definition
		self.dischargeResult = DischargeResult()

		# Weather
		self.weather = Weather()

		# Substrate
		self.substrate = Substrate()

		# Calculation outputs.
		# Flame scalar results
		self.flameResult = FlameResult()

		# Array of jet fire flame records
		self.flameRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# JetFire calculation run method.
	def run(self) -> ResultCode:

		# Create the jet fire request.
		jetFireCalculationRequest = JetFireCalculationRequest()

		# Initialise the member properties.

		jetFireCalculationRequest.material = self.material
		jetFireCalculationRequest.dischargeRecords = self.dischargeRecords
		jetFireCalculationRequest.dischargeRecordCount = len(self.dischargeRecords)
		jetFireCalculationRequest.dischargeResult = self.dischargeResult
		jetFireCalculationRequest.weather = self.weather
		jetFireCalculationRequest.substrate = self.substrate

		requestJson = jsons.dumps(jetFireCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatejetfire?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			jetFireCalculationResponse = JetFireCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				jetFireCalculationResponse.initialiseFromDictionary(json)

				self.flameResult = jetFireCalculationResponse.flameResult
				self.flameRecords = jetFireCalculationResponse.flameRecords
				self.resultCode = jetFireCalculationResponse.resultCode
				self.resultCode = jetFireCalculationResponse.resultCode
				self.messages = jetFireCalculationResponse.messages
				self.elapsedTime = jetFireCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the JetFire calculation object to print itself.
	def print(self):

		# JetFire
		print('** JetFire')

		# material
		self.material.print()

		for item in self.dischargeRecords:
			item.print()


		# dischargeResult
		self.dischargeResult.print()

		# weather
		self.weather.print()

		# substrate
		self.substrate.print()

		# flameResult
		self.flameResult.print()

		for flameRecord in self.flameRecords:
			flameRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a jet fire calculation.
class JetFireCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Flame scalar results
		self.flameResult = FlameResult()

		# Array of jet fire flame records
		self.flameRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Flame scalar results
		self.flameResult.initialiseFromDictionary(data['flameResult'])

		# Array of jet fire flame records
		for dataItem in data['flameRecords']:
			flameRecord = FlameRecord()
			flameRecord.initialiseFromDictionary(dataItem)
			self.flameRecords.append(flameRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a late explosion calculation.
class LateExplosionCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# Dispersion scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Cloud definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# Substrate
		self.substrate = Substrate()

		# Specification of cloud view
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Explosion output configuration
		self.explosionOutputConfig = ExplosionOutputConfig()

		# Explosion parameters
		self.explosionParameters = ExplosionParameters()

		# Explosion confined volumes
		self.explosionConfinedVolumes = []

		# Number of confined explosion sources
		self.explosionConfinedVolumeCount = 0


	# No description provided.
# Late explosion calculation class.
class LateExplosionCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# Dispersion scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Cloud definition
		self.dispersionRecords = []


		# Substrate
		self.substrate = Substrate()

		# Specification of cloud view
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Explosion output configuration
		self.explosionOutputConfig = ExplosionOutputConfig()

		# Explosion parameters
		self.explosionParameters = ExplosionParameters()

		# Explosion confined volumes
		self.explosionConfinedVolumes = []


		# Calculation outputs.
		# Uniform confined explosion overpressure result
		self.explosionUnifConfOverpressureResult = ExplosionOverpressureResult()

		# Unconfined explosion overpressure result
		self.explosionUnconfOverpressureResult = ExplosionOverpressureResult()

		# Eror code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# LateExplosion calculation run method.
	def run(self) -> ResultCode:

		# Create the late explosion request.
		lateExplosionCalculationRequest = LateExplosionCalculationRequest()

		# Initialise the member properties.

		lateExplosionCalculationRequest.material = self.material
		lateExplosionCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		lateExplosionCalculationRequest.weather = self.weather
		lateExplosionCalculationRequest.dispersionRecords = self.dispersionRecords
		lateExplosionCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		lateExplosionCalculationRequest.substrate = self.substrate
		lateExplosionCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		lateExplosionCalculationRequest.explosionOutputConfig = self.explosionOutputConfig
		lateExplosionCalculationRequest.explosionParameters = self.explosionParameters
		lateExplosionCalculationRequest.explosionConfinedVolumes = self.explosionConfinedVolumes
		lateExplosionCalculationRequest.explosionConfinedVolumeCount = len(self.explosionConfinedVolumes)

		requestJson = jsons.dumps(lateExplosionCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatelateexplosion?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			lateExplosionCalculationResponse = LateExplosionCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				lateExplosionCalculationResponse.initialiseFromDictionary(json)

				self.explosionUnifConfOverpressureResult = lateExplosionCalculationResponse.explosionUnifConfOverpressureResult
				self.explosionUnconfOverpressureResult = lateExplosionCalculationResponse.explosionUnconfOverpressureResult
				self.resultCode = lateExplosionCalculationResponse.resultCode
				self.resultCode = lateExplosionCalculationResponse.resultCode
				self.messages = lateExplosionCalculationResponse.messages
				self.elapsedTime = lateExplosionCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the LateExplosion calculation object to print itself.
	def print(self):

		# LateExplosion
		print('** LateExplosion')

		# material
		self.material.print()

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# explosionOutputConfig
		self.explosionOutputConfig.print()

		# explosionParameters
		self.explosionParameters.print()

		for item in self.explosionConfinedVolumes:
			item.print()


		# explosionUnifConfOverpressureResult
		self.explosionUnifConfOverpressureResult.print()

		# explosionUnconfOverpressureResult
		self.explosionUnconfOverpressureResult.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a late explosion calculation.
class LateExplosionCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Uniform confined explosion overpressure result
		self.explosionUnifConfOverpressureResult = ExplosionOverpressureResult()

		# Unconfined explosion overpressure result
		self.explosionUnconfOverpressureResult = ExplosionOverpressureResult()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Uniform confined explosion overpressure result
		self.explosionUnifConfOverpressureResult.initialiseFromDictionary(data['explosionUnifConfOverpressureResult'])

		# Unconfined explosion overpressure result
		self.explosionUnconfOverpressureResult.initialiseFromDictionary(data['explosionUnconfOverpressureResult'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a lethality distance calculation.
class LethalityDistanceCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()


	# No description provided.
# Lethality distance calculation class.
class LethalityDistanceCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Calculation outputs.
		# Toxic results
		self.toxicRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# LethalityDistance calculation run method.
	def run(self) -> ResultCode:

		# Create the lethality distance request.
		lethalityDistanceCalculationRequest = LethalityDistanceCalculationRequest()

		# Initialise the member properties.

		lethalityDistanceCalculationRequest.material = self.material
		lethalityDistanceCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		lethalityDistanceCalculationRequest.weather = self.weather
		lethalityDistanceCalculationRequest.dispersionRecords = self.dispersionRecords
		lethalityDistanceCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		lethalityDistanceCalculationRequest.substrate = self.substrate
		lethalityDistanceCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig

		requestJson = jsons.dumps(lethalityDistanceCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatelethalitydistance?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			lethalityDistanceCalculationResponse = LethalityDistanceCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				lethalityDistanceCalculationResponse.initialiseFromDictionary(json)

				self.toxicRecords = lethalityDistanceCalculationResponse.toxicRecords
				self.resultCode = lethalityDistanceCalculationResponse.resultCode
				self.resultCode = lethalityDistanceCalculationResponse.resultCode
				self.messages = lethalityDistanceCalculationResponse.messages
				self.elapsedTime = lethalityDistanceCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the LethalityDistance calculation object to print itself.
	def print(self):

		# LethalityDistance
		print('** LethalityDistance')

		# material
		self.material.print()

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		for toxicRecord in self.toxicRecords:
			toxicRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a lethality distance calculation.
class LethalityDistanceCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Toxic results
		self.toxicRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Toxic results
		for dataItem in data['toxicRecords']:
			toxicRecord = ToxicRecord()
			toxicRecord.initialiseFromDictionary(dataItem)
			self.toxicRecords.append(toxicRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a load mass inventory vessel for leak scenario calculation.
class LoadMassInventoryVesselForLeakScenarioCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Vessel material
		self.material = Material()

		# Total vessel mass inventory
		self.mass = 0.0

		# Vessel pressure in absolute scale
		self.pressure = 0.0

		# Vessel temperature
		self.temperature = 0.0

		# Leak hole size
		self.holeSize = 0.0

		# Release elevation
		self.releaseElevation = 0.0

		# Release direction (1 = vertical, 0 = horizontal)
		self.releaseDirection = ReleaseDirection.VERTICAL


# Load mass inventory vessel for leak scenario calculation class.
class LoadMassInventoryVesselForLeakScenarioCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Vessel material
		self.material = Material()

		# Total vessel mass inventory
		self.mass = 0.0

		# Vessel pressure in absolute scale
		self.pressure = 0.0

		# Vessel temperature
		self.temperature = 0.0

		# Leak hole size
		self.holeSize = 0.0

		# Release elevation
		self.releaseElevation = 0.0

		# Release direction (1 = vertical, 0 = horizontal)
		self.releaseDirection = ReleaseDirection.VERTICAL

		# Calculation outputs.
		# Vessel definition
		self.vessel = Vessel()

		# Leak scenario
		self.leak = Leak()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# LoadMassInventoryVesselForLeakScenario calculation run method.
	def run(self) -> ResultCode:

		# Create the load mass inventory vessel for leak scenario request.
		loadMassInventoryVesselForLeakScenarioCalculationRequest = LoadMassInventoryVesselForLeakScenarioCalculationRequest()

		# Initialise the member properties.

		loadMassInventoryVesselForLeakScenarioCalculationRequest.material = self.material
		loadMassInventoryVesselForLeakScenarioCalculationRequest.mass = self.mass
		loadMassInventoryVesselForLeakScenarioCalculationRequest.pressure = self.pressure
		loadMassInventoryVesselForLeakScenarioCalculationRequest.temperature = self.temperature
		loadMassInventoryVesselForLeakScenarioCalculationRequest.holeSize = self.holeSize
		loadMassInventoryVesselForLeakScenarioCalculationRequest.releaseElevation = self.releaseElevation
		loadMassInventoryVesselForLeakScenarioCalculationRequest.releaseDirection = self.releaseDirection

		requestJson = jsons.dumps(loadMassInventoryVesselForLeakScenarioCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'loadMassInventoryVesselForLeakScenario?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			loadMassInventoryVesselForLeakScenarioCalculationResponse = LoadMassInventoryVesselForLeakScenarioCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				loadMassInventoryVesselForLeakScenarioCalculationResponse.initialiseFromDictionary(json)

				self.vessel = loadMassInventoryVesselForLeakScenarioCalculationResponse.vessel
				self.leak = loadMassInventoryVesselForLeakScenarioCalculationResponse.leak
				self.resultCode = loadMassInventoryVesselForLeakScenarioCalculationResponse.resultCode
				self.resultCode = loadMassInventoryVesselForLeakScenarioCalculationResponse.resultCode
				self.messages = loadMassInventoryVesselForLeakScenarioCalculationResponse.messages
				self.elapsedTime = loadMassInventoryVesselForLeakScenarioCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the LoadMassInventoryVesselForLeakScenario calculation object to print itself.
	def print(self):

		# LoadMassInventoryVesselForLeakScenario
		print('** LoadMassInventoryVesselForLeakScenario')

		# material
		self.material.print()

		print(self.mass)
		print('{0}\t{1}'.format('Mass', self.mass))

		print(self.pressure)
		print('{0}\t{1}'.format('Pressure', self.pressure))

		print(self.temperature)
		print('{0}\t{1}'.format('Temperature', self.temperature))

		print(self.holeSize)
		print('{0}\t{1}'.format('Hole size', self.holeSize))

		print(self.releaseElevation)
		print('{0}\t{1}'.format('Release elevation', self.releaseElevation))

		print(self.releaseDirection)
		print('{0}\t{1}'.format('Release direction', self.releaseDirection))

		# vessel
		self.vessel.print()

		# leak
		self.leak.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a load mass inventory vessel for leak scenario calculation.
class LoadMassInventoryVesselForLeakScenarioCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Vessel definition
		self.vessel = Vessel()

		# Leak scenario
		self.leak = Leak()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Vessel definition
		self.vessel.initialiseFromDictionary(data['vessel'])

		# Leak scenario
		self.leak.initialiseFromDictionary(data['leak'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a long pipe breach calculation.
class LongPipeBreachCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Pipe equipment item
		self.pipe = Pipe()

		# Long pipeline scenario
		self.pipeBreach = PipeBreach()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()


	# No description provided.
# Long pipe breach calculation class.
class LongPipeBreachCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Pipe equipment item
		self.pipe = Pipe()

		# Long pipeline scenario
		self.pipeBreach = PipeBreach()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Calculation outputs.
		# Composition of the released material (indentical to storage composition - using PC mode)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge records
		self.dischargeRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# LongPipeBreach calculation run method.
	def run(self) -> ResultCode:

		# Create the long pipe breach request.
		longPipeBreachCalculationRequest = LongPipeBreachCalculationRequest()

		# Initialise the member properties.

		longPipeBreachCalculationRequest.pipe = self.pipe
		longPipeBreachCalculationRequest.pipeBreach = self.pipeBreach
		longPipeBreachCalculationRequest.dischargeParameters = self.dischargeParameters

		requestJson = jsons.dumps(longPipeBreachCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatelongpipebreach?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			longPipeBreachCalculationResponse = LongPipeBreachCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				longPipeBreachCalculationResponse.initialiseFromDictionary(json)

				self.exitMaterial = longPipeBreachCalculationResponse.exitMaterial
				self.dischargeResult = longPipeBreachCalculationResponse.dischargeResult
				self.dischargeRecords = longPipeBreachCalculationResponse.dischargeRecords
				self.resultCode = longPipeBreachCalculationResponse.resultCode
				self.resultCode = longPipeBreachCalculationResponse.resultCode
				self.messages = longPipeBreachCalculationResponse.messages
				self.elapsedTime = longPipeBreachCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the LongPipeBreach calculation object to print itself.
	def print(self):

		# LongPipeBreach
		print('** LongPipeBreach')

		# pipe
		self.pipe.print()

		# pipeBreach
		self.pipeBreach.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# exitMaterial
		self.exitMaterial.print()

		# dischargeResult
		self.dischargeResult.print()

		for dischargeRecord in self.dischargeRecords:
			dischargeRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a long pipe breach calculation.
class LongPipeBreachCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Composition of the released material (indentical to storage composition - using PC mode)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge records
		self.dischargeRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Composition of the released material (indentical to storage composition - using PC mode)
		self.exitMaterial.initialiseFromDictionary(data['exitMaterial'])

		# Scalar discharge results
		self.dischargeResult.initialiseFromDictionary(data['dischargeResult'])

		# Array of discharge records
		for dataItem in data['dischargeRecords']:
			dischargeRecord = DischargeRecord()
			dischargeRecord.initialiseFromDictionary(dataItem)
			self.dischargeRecords.append(dischargeRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a max conc distance calculation.
class MaxConcDistanceCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()


# Max conc distance calculation class.
class MaxConcDistanceCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentration of interest
		self.concUsed = 0.0

		# Array of maximum concentration at x, y, z coordinates
		self.concentrationRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# MaxConcDistance calculation run method.
	def run(self) -> ResultCode:

		# Create the max conc distance request.
		maxConcDistanceCalculationRequest = MaxConcDistanceCalculationRequest()

		# Initialise the member properties.

		maxConcDistanceCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		maxConcDistanceCalculationRequest.weather = self.weather
		maxConcDistanceCalculationRequest.dispersionRecords = self.dispersionRecords
		maxConcDistanceCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		maxConcDistanceCalculationRequest.substrate = self.substrate
		maxConcDistanceCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		maxConcDistanceCalculationRequest.material = self.material

		requestJson = jsons.dumps(maxConcDistanceCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatemaxconcdistance?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			maxConcDistanceCalculationResponse = MaxConcDistanceCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				maxConcDistanceCalculationResponse.initialiseFromDictionary(json)

				self.concUsed = maxConcDistanceCalculationResponse.concUsed
				self.concentrationRecords = maxConcDistanceCalculationResponse.concentrationRecords
				self.resultCode = maxConcDistanceCalculationResponse.resultCode
				self.resultCode = maxConcDistanceCalculationResponse.resultCode
				self.messages = maxConcDistanceCalculationResponse.messages
				self.elapsedTime = maxConcDistanceCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the MaxConcDistance calculation object to print itself.
	def print(self):

		# MaxConcDistance
		print('** MaxConcDistance')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# material
		self.material.print()

		# concUsed
		print('{0}\t{1}'.format('Conc used', self.concUsed))

		for concentrationRecord in self.concentrationRecords:
			concentrationRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a max conc distance calculation.
class MaxConcDistanceCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentration of interest
		self.concUsed = 0.0

		# Array of maximum concentration at x, y, z coordinates
		self.concentrationRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentration of interest
		self.concUsed = float(data['concUsed'])

		# Array of maximum concentration at x, y, z coordinates
		for dataItem in data['concentrationRecords']:
			concentrationRecord = ConcentrationRecord()
			concentrationRecord.initialiseFromDictionary(dataItem)
			self.concentrationRecords.append(concentrationRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a max conc footprint calculation.
class MaxConcFootprintCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()


	# No description provided.
# Max conc footprint calculation class.
class MaxConcFootprintCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentration of interest
		self.concUsed = 0.0

		# Array of footprint results
		self.contourPoints = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# MaxConcFootprint calculation run method.
	def run(self) -> ResultCode:

		# Create the max conc footprint request.
		maxConcFootprintCalculationRequest = MaxConcFootprintCalculationRequest()

		# Initialise the member properties.

		maxConcFootprintCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		maxConcFootprintCalculationRequest.weather = self.weather
		maxConcFootprintCalculationRequest.dispersionRecords = self.dispersionRecords
		maxConcFootprintCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		maxConcFootprintCalculationRequest.substrate = self.substrate
		maxConcFootprintCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		maxConcFootprintCalculationRequest.material = self.material

		requestJson = jsons.dumps(maxConcFootprintCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatemaxconcfootprint?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			maxConcFootprintCalculationResponse = MaxConcFootprintCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				maxConcFootprintCalculationResponse.initialiseFromDictionary(json)

				self.concUsed = maxConcFootprintCalculationResponse.concUsed
				self.contourPoints = maxConcFootprintCalculationResponse.contourPoints
				self.resultCode = maxConcFootprintCalculationResponse.resultCode
				self.resultCode = maxConcFootprintCalculationResponse.resultCode
				self.messages = maxConcFootprintCalculationResponse.messages
				self.elapsedTime = maxConcFootprintCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the MaxConcFootprint calculation object to print itself.
	def print(self):

		# MaxConcFootprint
		print('** MaxConcFootprint')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# material
		self.material.print()

		# concUsed
		print('{0}\t{1}'.format('Conc used', self.concUsed))

		for contourPoint in self.contourPoints:
			contourPoint.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a max conc footprint calculation.
class MaxConcFootprintCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentration of interest
		self.concUsed = 0.0

		# Array of footprint results
		self.contourPoints = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentration of interest
		self.concUsed = float(data['concUsed'])

		# Array of footprint results
		for dataItem in data['contourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.contourPoints.append(localPosition)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a max distance to conc calculation.
class MaxDistanceToConcCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()


	# No description provided.
# Max distance to conc calculation class.
class MaxDistanceToConcCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentration of interest
		self.concUsed = 0.0

		# Maximum distance to concentration of interest
		self.distance = 0.0

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# MaxDistanceToConc calculation run method.
	def run(self) -> ResultCode:

		# Create the max distance to conc request.
		maxDistanceToConcCalculationRequest = MaxDistanceToConcCalculationRequest()

		# Initialise the member properties.

		maxDistanceToConcCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		maxDistanceToConcCalculationRequest.weather = self.weather
		maxDistanceToConcCalculationRequest.dispersionRecords = self.dispersionRecords
		maxDistanceToConcCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		maxDistanceToConcCalculationRequest.substrate = self.substrate
		maxDistanceToConcCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		maxDistanceToConcCalculationRequest.material = self.material

		requestJson = jsons.dumps(maxDistanceToConcCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatemaxdistancetoconc?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			maxDistanceToConcCalculationResponse = MaxDistanceToConcCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				maxDistanceToConcCalculationResponse.initialiseFromDictionary(json)

				self.concUsed = maxDistanceToConcCalculationResponse.concUsed
				self.distance = maxDistanceToConcCalculationResponse.distance
				self.resultCode = maxDistanceToConcCalculationResponse.resultCode
				self.resultCode = maxDistanceToConcCalculationResponse.resultCode
				self.messages = maxDistanceToConcCalculationResponse.messages
				self.elapsedTime = maxDistanceToConcCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the MaxDistanceToConc calculation object to print itself.
	def print(self):

		# MaxDistanceToConc
		print('** MaxDistanceToConc')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# material
		self.material.print()

		# concUsed
		print('{0}\t{1}'.format('Conc used', self.concUsed))

		# distance
		print('{0}\t{1}'.format('Distance', self.distance))

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a max distance to conc calculation.
class MaxDistanceToConcCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentration of interest
		self.concUsed = 0.0

		# Maximum distance to concentration of interest
		self.distance = 0.0

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentration of interest
		self.concUsed = float(data['concUsed'])

		# Maximum distance to concentration of interest
		self.distance = float(data['distance'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a pool fire calculation.
class PoolFireCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Material with post-discharge composition
		self.material = Material()

		# Pool / source term definition
		self.poolRecords = []

		# Number of pool records
		self.poolRecordCount = 0

		# Weather
		self.weather = Weather()

		# Substrate
		self.substrate = Substrate()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()


	# No description provided.
# Pool fire calculation class.
class PoolFireCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Material with post-discharge composition
		self.material = Material()

		# Pool / source term definition
		self.poolRecords = []


		# Weather
		self.weather = Weather()

		# Substrate
		self.substrate = Substrate()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Calculation outputs.
		# Flame scalar result
		self.flameResult = FlameResult()

		# Array of pool fire flame records
		self.flameRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# PoolFire calculation run method.
	def run(self) -> ResultCode:

		# Create the pool fire request.
		poolFireCalculationRequest = PoolFireCalculationRequest()

		# Initialise the member properties.

		poolFireCalculationRequest.material = self.material
		poolFireCalculationRequest.poolRecords = self.poolRecords
		poolFireCalculationRequest.poolRecordCount = len(self.poolRecords)
		poolFireCalculationRequest.weather = self.weather
		poolFireCalculationRequest.substrate = self.substrate
		poolFireCalculationRequest.flammableParameters = self.flammableParameters

		requestJson = jsons.dumps(poolFireCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatepoolfire?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			poolFireCalculationResponse = PoolFireCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				poolFireCalculationResponse.initialiseFromDictionary(json)

				self.flameResult = poolFireCalculationResponse.flameResult
				self.flameRecords = poolFireCalculationResponse.flameRecords
				self.resultCode = poolFireCalculationResponse.resultCode
				self.resultCode = poolFireCalculationResponse.resultCode
				self.messages = poolFireCalculationResponse.messages
				self.elapsedTime = poolFireCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the PoolFire calculation object to print itself.
	def print(self):

		# PoolFire
		print('** PoolFire')

		# material
		self.material.print()

		for item in self.poolRecords:
			item.print()


		# weather
		self.weather.print()

		# substrate
		self.substrate.print()

		# flammableParameters
		self.flammableParameters.print()

		# flameResult
		self.flameResult.print()

		for flameRecord in self.flameRecords:
			flameRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a pool fire calculation.
class PoolFireCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Flame scalar result
		self.flameResult = FlameResult()

		# Array of pool fire flame records
		self.flameRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Flame scalar result
		self.flameResult.initialiseFromDictionary(data['flameResult'])

		# Array of pool fire flame records
		for dataItem in data['flameRecords']:
			flameRecord = FlameRecord()
			flameRecord.initialiseFromDictionary(dataItem)
			self.flameRecords.append(flameRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a radiation contour calculation.
class RadiationContourCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []

		# Number of flame records
		self.flameRecordCount = 0

		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()


	# No description provided.
# Radiation contour calculation class.
class RadiationContourCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []


		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()

		# Calculation outputs.
		# Array of contour points
		self.contourPoints = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# RadiationContour calculation run method.
	def run(self) -> ResultCode:

		# Create the radiation contour request.
		radiationContourCalculationRequest = RadiationContourCalculationRequest()

		# Initialise the member properties.

		radiationContourCalculationRequest.flameResult = self.flameResult
		radiationContourCalculationRequest.flameRecords = self.flameRecords
		radiationContourCalculationRequest.flameRecordCount = len(self.flameRecords)
		radiationContourCalculationRequest.weather = self.weather
		radiationContourCalculationRequest.flammableParameters = self.flammableParameters
		radiationContourCalculationRequest.flammableOutputConfig = self.flammableOutputConfig

		requestJson = jsons.dumps(radiationContourCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateradiationcontour?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			radiationContourCalculationResponse = RadiationContourCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				radiationContourCalculationResponse.initialiseFromDictionary(json)

				self.contourPoints = radiationContourCalculationResponse.contourPoints
				self.resultCode = radiationContourCalculationResponse.resultCode
				self.resultCode = radiationContourCalculationResponse.resultCode
				self.messages = radiationContourCalculationResponse.messages
				self.elapsedTime = radiationContourCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the RadiationContour calculation object to print itself.
	def print(self):

		# RadiationContour
		print('** RadiationContour')

		# flameResult
		self.flameResult.print()

		for item in self.flameRecords:
			item.print()


		# weather
		self.weather.print()

		# flammableParameters
		self.flammableParameters.print()

		# flammableOutputConfig
		self.flammableOutputConfig.print()

		for contourPoint in self.contourPoints:
			contourPoint.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a radiation contour calculation.
class RadiationContourCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Array of contour points
		self.contourPoints = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Array of contour points
		for dataItem in data['contourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.contourPoints.append(localPosition)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a radiation transect calculation.
class RadiationTransectCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []

		# Number of flame records
		self.flameRecordCount = 0

		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()


	# No description provided.
# Radiation transect calculation class.
class RadiationTransectCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Scalar flame results
		self.flameResult = FlameResult()

		# Flame definition
		self.flameRecords = []


		# Weather
		self.weather = Weather()

		# Flammable parameters
		self.flammableParameters = FlammableParameters()

		# Settings of flammable contours view
		self.flammableOutputConfig = FlammableOutputConfig()

		# Calculation outputs.
		# Array of radiation results along transect
		self.radiationRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# RadiationTransect calculation run method.
	def run(self) -> ResultCode:

		# Create the radiation transect request.
		radiationTransectCalculationRequest = RadiationTransectCalculationRequest()

		# Initialise the member properties.

		radiationTransectCalculationRequest.flameResult = self.flameResult
		radiationTransectCalculationRequest.flameRecords = self.flameRecords
		radiationTransectCalculationRequest.flameRecordCount = len(self.flameRecords)
		radiationTransectCalculationRequest.weather = self.weather
		radiationTransectCalculationRequest.flammableParameters = self.flammableParameters
		radiationTransectCalculationRequest.flammableOutputConfig = self.flammableOutputConfig

		requestJson = jsons.dumps(radiationTransectCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateradiationtransect?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			radiationTransectCalculationResponse = RadiationTransectCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				radiationTransectCalculationResponse.initialiseFromDictionary(json)

				self.radiationRecords = radiationTransectCalculationResponse.radiationRecords
				self.resultCode = radiationTransectCalculationResponse.resultCode
				self.resultCode = radiationTransectCalculationResponse.resultCode
				self.messages = radiationTransectCalculationResponse.messages
				self.elapsedTime = radiationTransectCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the RadiationTransect calculation object to print itself.
	def print(self):

		# RadiationTransect
		print('** RadiationTransect')

		# flameResult
		self.flameResult.print()

		for item in self.flameRecords:
			item.print()


		# weather
		self.weather.print()

		# flammableParameters
		self.flammableParameters.print()

		# flammableOutputConfig
		self.flammableOutputConfig.print()

		for radiationRecord in self.radiationRecords:
			radiationRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a radiation transect calculation.
class RadiationTransectCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Array of radiation results along transect
		self.radiationRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Array of radiation results along transect
		for dataItem in data['radiationRecords']:
			radiationRecord = RadiationRecord()
			radiationRecord.initialiseFromDictionary(dataItem)
			self.radiationRecords.append(radiationRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a sideview at time calculation.
class SideviewAtTimeCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []

		# Number of dispersion records
		self.dispersionRecordCount = 0

		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()


# Sideview at time calculation class.
class SideviewAtTimeCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# UDM scalar outputs
		self.scalarUdmOutputs = ScalarUdmOutputs()

		# Weather
		self.weather = Weather()

		# Dispersion definition
		self.dispersionRecords = []


		# The dispersing surface
		self.substrate = Substrate()

		# Dispersion view configuration
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Material with post-discharge composition
		self.material = Material()

		# Calculation outputs.
		# Concentration of interest
		self.concUsed = 0.0

		# Array of sideview results
		self.contourPoints = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# SideviewAtTime calculation run method.
	def run(self) -> ResultCode:

		# Create the sideview at time request.
		sideviewAtTimeCalculationRequest = SideviewAtTimeCalculationRequest()

		# Initialise the member properties.

		sideviewAtTimeCalculationRequest.scalarUdmOutputs = self.scalarUdmOutputs
		sideviewAtTimeCalculationRequest.weather = self.weather
		sideviewAtTimeCalculationRequest.dispersionRecords = self.dispersionRecords
		sideviewAtTimeCalculationRequest.dispersionRecordCount = len(self.dispersionRecords)
		sideviewAtTimeCalculationRequest.substrate = self.substrate
		sideviewAtTimeCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig
		sideviewAtTimeCalculationRequest.material = self.material

		requestJson = jsons.dumps(sideviewAtTimeCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatesideviewattime?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			sideviewAtTimeCalculationResponse = SideviewAtTimeCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				sideviewAtTimeCalculationResponse.initialiseFromDictionary(json)

				self.concUsed = sideviewAtTimeCalculationResponse.concUsed
				self.contourPoints = sideviewAtTimeCalculationResponse.contourPoints
				self.resultCode = sideviewAtTimeCalculationResponse.resultCode
				self.resultCode = sideviewAtTimeCalculationResponse.resultCode
				self.messages = sideviewAtTimeCalculationResponse.messages
				self.elapsedTime = sideviewAtTimeCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the SideviewAtTime calculation object to print itself.
	def print(self):

		# SideviewAtTime
		print('** SideviewAtTime')

		# scalarUdmOutputs
		self.scalarUdmOutputs.print()

		# weather
		self.weather.print()

		for item in self.dispersionRecords:
			item.print()


		# substrate
		self.substrate.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# material
		self.material.print()

		# concUsed
		print('{0}\t{1}'.format('Conc used', self.concUsed))

		for contourPoint in self.contourPoints:
			contourPoint.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a sideview at time calculation.
class SideviewAtTimeCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Concentration of interest
		self.concUsed = 0.0

		# Array of sideview results
		self.contourPoints = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Concentration of interest
		self.concUsed = float(data['concUsed'])

		# Array of sideview results
		for dataItem in data['contourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.contourPoints.append(localPosition)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a vessel catastrophic rupture calculation.
class VesselCatastrophicRuptureCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Catastrophic rupture failure case
		self.catastrophicRupture = CatastrophicRupture()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()


	# No description provided.
# Vessel catastrophic rupture calculation class.
class VesselCatastrophicRuptureCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Catastrophic rupture failure case
		self.catastrophicRupture = CatastrophicRupture()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Calculation outputs.
		# Composition of the released material (indentical to storage composition)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge record
		self.dischargeRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# VesselCatastrophicRupture calculation run method.
	def run(self) -> ResultCode:

		# Create the vessel catastrophic rupture request.
		vesselCatastrophicRuptureCalculationRequest = VesselCatastrophicRuptureCalculationRequest()

		# Initialise the member properties.

		vesselCatastrophicRuptureCalculationRequest.vessel = self.vessel
		vesselCatastrophicRuptureCalculationRequest.catastrophicRupture = self.catastrophicRupture
		vesselCatastrophicRuptureCalculationRequest.dischargeParameters = self.dischargeParameters

		requestJson = jsons.dumps(vesselCatastrophicRuptureCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatevesselcatastrophicrupture?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			vesselCatastrophicRuptureCalculationResponse = VesselCatastrophicRuptureCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				vesselCatastrophicRuptureCalculationResponse.initialiseFromDictionary(json)

				self.exitMaterial = vesselCatastrophicRuptureCalculationResponse.exitMaterial
				self.dischargeResult = vesselCatastrophicRuptureCalculationResponse.dischargeResult
				self.dischargeRecords = vesselCatastrophicRuptureCalculationResponse.dischargeRecords
				self.resultCode = vesselCatastrophicRuptureCalculationResponse.resultCode
				self.resultCode = vesselCatastrophicRuptureCalculationResponse.resultCode
				self.messages = vesselCatastrophicRuptureCalculationResponse.messages
				self.elapsedTime = vesselCatastrophicRuptureCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the VesselCatastrophicRupture calculation object to print itself.
	def print(self):

		# VesselCatastrophicRupture
		print('** VesselCatastrophicRupture')

		# vessel
		self.vessel.print()

		# catastrophicRupture
		self.catastrophicRupture.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# exitMaterial
		self.exitMaterial.print()

		# dischargeResult
		self.dischargeResult.print()

		for dischargeRecord in self.dischargeRecords:
			dischargeRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a vessel catastrophic rupture calculation.
class VesselCatastrophicRuptureCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Composition of the released material (indentical to storage composition)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge record
		self.dischargeRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Composition of the released material (indentical to storage composition)
		self.exitMaterial.initialiseFromDictionary(data['exitMaterial'])

		# Scalar discharge results
		self.dischargeResult.initialiseFromDictionary(data['dischargeResult'])

		# Array of discharge record
		for dataItem in data['dischargeRecords']:
			dischargeRecord = DischargeRecord()
			dischargeRecord.initialiseFromDictionary(dataItem)
			self.dischargeRecords.append(dischargeRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a vessel leak calculation.
class VesselLeakCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Leak failure case
		self.leak = Leak()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()


# Vessel leak calculation class.
class VesselLeakCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Leak failure case
		self.leak = Leak()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Calculation outputs.
		# Composition of the released material (may differ from storage composition)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge records
		self.dischargeRecords = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# VesselLeak calculation run method.
	def run(self) -> ResultCode:

		# Create the vessel leak request.
		vesselLeakCalculationRequest = VesselLeakCalculationRequest()

		# Initialise the member properties.

		vesselLeakCalculationRequest.vessel = self.vessel
		vesselLeakCalculationRequest.leak = self.leak
		vesselLeakCalculationRequest.dischargeParameters = self.dischargeParameters

		requestJson = jsons.dumps(vesselLeakCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatevesselleak?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			vesselLeakCalculationResponse = VesselLeakCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				vesselLeakCalculationResponse.initialiseFromDictionary(json)

				self.exitMaterial = vesselLeakCalculationResponse.exitMaterial
				self.dischargeResult = vesselLeakCalculationResponse.dischargeResult
				self.dischargeRecords = vesselLeakCalculationResponse.dischargeRecords
				self.resultCode = vesselLeakCalculationResponse.resultCode
				self.resultCode = vesselLeakCalculationResponse.resultCode
				self.messages = vesselLeakCalculationResponse.messages
				self.elapsedTime = vesselLeakCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the VesselLeak calculation object to print itself.
	def print(self):

		# VesselLeak
		print('** VesselLeak')

		# vessel
		self.vessel.print()

		# leak
		self.leak.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# exitMaterial
		self.exitMaterial.print()

		# dischargeResult
		self.dischargeResult.print()

		for dischargeRecord in self.dischargeRecords:
			dischargeRecord.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a vessel leak calculation.
class VesselLeakCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Composition of the released material (may differ from storage composition)
		self.exitMaterial = Material()

		# Scalar discharge results
		self.dischargeResult = DischargeResult()

		# Array of discharge records
		self.dischargeRecords = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Composition of the released material (may differ from storage composition)
		self.exitMaterial.initialiseFromDictionary(data['exitMaterial'])

		# Scalar discharge results
		self.dischargeResult.initialiseFromDictionary(data['dischargeResult'])

		# Array of discharge records
		for dataItem in data['dischargeRecords']:
			dischargeRecord = DischargeRecord()
			dischargeRecord.initialiseFromDictionary(dataItem)
			self.dischargeRecords.append(dischargeRecord)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a vessel leak flammable linked run calculation.
class VesselLeakFlammableLinkedRunCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Vessel definition
		self.vessel = Vessel()

		# Leak scenario
		self.leak = Leak()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# The dispersing surface
		self.substrate = Substrate()

		# Weather definition
		self.weather = Weather()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Concentration at which the dispersion calculations will terminate (v/v fraction)
		self.endPointConcentration = 0.0

		# Fire model parameters
		self.flammableParameters = FlammableParameters()

		# Explosion parameters
		self.explosionParameters = ExplosionParameters()

		# Concentration levels
		self.dispersionOutputConfigs = []

		# Number of concentration levels
		self.dispersionOutputConfigCount = 0

		# Radiation levels
		self.flammableOutputConfigs = []

		# Number of radiation levels
		self.flammableOutputConfigCount = 0

		# Overpressure levels
		self.explosionOutputConfigs = []

		# Number of overpressure levels
		self.explosionOutputConfigCount = 0

		# Explosion confined volumes
		self.explosionConfinedVolumes = []

		# Number of confined explosion sources
		self.explosionConfinedVolumeCount = 0


# Vessel leak flammable linked run calculation class.
class VesselLeakFlammableLinkedRunCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Vessel definition
		self.vessel = Vessel()

		# Leak scenario
		self.leak = Leak()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# The dispersing surface
		self.substrate = Substrate()

		# Weather definition
		self.weather = Weather()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Concentration at which the dispersion calculations will terminate (v/v fraction)
		self.endPointConcentration = 0.0

		# Fire model parameters
		self.flammableParameters = FlammableParameters()

		# Explosion parameters
		self.explosionParameters = ExplosionParameters()

		# Concentration levels
		self.dispersionOutputConfigs = []


		# Radiation levels
		self.flammableOutputConfigs = []


		# Overpressure levels
		self.explosionOutputConfigs = []


		# Explosion confined volumes
		self.explosionConfinedVolumes = []


		# Calculation outputs.
		# Discharge data for table
		self.dischargeRecord = DischargeRecord()

		# Distances to jet fire radiation levels
		self.distancesToJetFireRadiation = []

		# Ellipses to jet fire radiation levels
		self.jetContourPoints = []

		# Number of contour points for jet fire ellipses per radiation level
		self.nJetCountourPoints = []

		# Areas of jet fire ellipses
		self.areaEllipseJet = []

		# Distances to concentration levels
		self.distancesToConcentration = []

		# Concentration levels
		self.concentrationsUsed = []

		# Maximum concentration footprints at given concentration levels
		self.concContourPoints = []

		# Number of contour points per concentration level
		self.nConcCountourPoints = []

		# Areas of maximum concentration footprints
		self.areaFootprintConc = []

		# Distances to pool fire radiation levels
		self.distancesToPoolFireRadiation = []

		# Ellipses to pool fire radiation levels
		self.poolContourPoints = []

		# Number of contour points for pool fire ellipses per radiation level
		self.nPoolCountourPoints = []

		# Areas of pool fire ellipses
		self.areaEllipsePool = []

		# Worst case scenario ME explosion results
		self.explosionOverpressureResults = []

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# VesselLeakFlammableLinkedRun calculation run method.
	def run(self) -> ResultCode:

		# Create the vessel leak flammable linked run request.
		vesselLeakFlammableLinkedRunCalculationRequest = VesselLeakFlammableLinkedRunCalculationRequest()

		# Initialise the member properties.

		vesselLeakFlammableLinkedRunCalculationRequest.vessel = self.vessel
		vesselLeakFlammableLinkedRunCalculationRequest.leak = self.leak
		vesselLeakFlammableLinkedRunCalculationRequest.dischargeParameters = self.dischargeParameters
		vesselLeakFlammableLinkedRunCalculationRequest.substrate = self.substrate
		vesselLeakFlammableLinkedRunCalculationRequest.weather = self.weather
		vesselLeakFlammableLinkedRunCalculationRequest.dispersionParameters = self.dispersionParameters
		vesselLeakFlammableLinkedRunCalculationRequest.endPointConcentration = self.endPointConcentration
		vesselLeakFlammableLinkedRunCalculationRequest.flammableParameters = self.flammableParameters
		vesselLeakFlammableLinkedRunCalculationRequest.explosionParameters = self.explosionParameters
		vesselLeakFlammableLinkedRunCalculationRequest.dispersionOutputConfigs = self.dispersionOutputConfigs
		vesselLeakFlammableLinkedRunCalculationRequest.dispersionOutputConfigCount = len(self.dispersionOutputConfigs)
		vesselLeakFlammableLinkedRunCalculationRequest.flammableOutputConfigs = self.flammableOutputConfigs
		vesselLeakFlammableLinkedRunCalculationRequest.flammableOutputConfigCount = len(self.flammableOutputConfigs)
		vesselLeakFlammableLinkedRunCalculationRequest.explosionOutputConfigs = self.explosionOutputConfigs
		vesselLeakFlammableLinkedRunCalculationRequest.explosionOutputConfigCount = len(self.explosionOutputConfigs)
		vesselLeakFlammableLinkedRunCalculationRequest.explosionConfinedVolumes = self.explosionConfinedVolumes
		vesselLeakFlammableLinkedRunCalculationRequest.explosionConfinedVolumeCount = len(self.explosionConfinedVolumes)

		requestJson = jsons.dumps(vesselLeakFlammableLinkedRunCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'vesselleakflammablelinkedrun?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			vesselLeakFlammableLinkedRunCalculationResponse = VesselLeakFlammableLinkedRunCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				vesselLeakFlammableLinkedRunCalculationResponse.initialiseFromDictionary(json)

				self.dischargeRecord = vesselLeakFlammableLinkedRunCalculationResponse.dischargeRecord
				self.distancesToJetFireRadiation = vesselLeakFlammableLinkedRunCalculationResponse.distancesToJetFireRadiation
				self.jetContourPoints = vesselLeakFlammableLinkedRunCalculationResponse.jetContourPoints
				self.nJetCountourPoints = vesselLeakFlammableLinkedRunCalculationResponse.nJetCountourPoints
				self.areaEllipseJet = vesselLeakFlammableLinkedRunCalculationResponse.areaEllipseJet
				self.distancesToConcentration = vesselLeakFlammableLinkedRunCalculationResponse.distancesToConcentration
				self.concentrationsUsed = vesselLeakFlammableLinkedRunCalculationResponse.concentrationsUsed
				self.concContourPoints = vesselLeakFlammableLinkedRunCalculationResponse.concContourPoints
				self.nConcCountourPoints = vesselLeakFlammableLinkedRunCalculationResponse.nConcCountourPoints
				self.areaFootprintConc = vesselLeakFlammableLinkedRunCalculationResponse.areaFootprintConc
				self.distancesToPoolFireRadiation = vesselLeakFlammableLinkedRunCalculationResponse.distancesToPoolFireRadiation
				self.poolContourPoints = vesselLeakFlammableLinkedRunCalculationResponse.poolContourPoints
				self.nPoolCountourPoints = vesselLeakFlammableLinkedRunCalculationResponse.nPoolCountourPoints
				self.areaEllipsePool = vesselLeakFlammableLinkedRunCalculationResponse.areaEllipsePool
				self.explosionOverpressureResults = vesselLeakFlammableLinkedRunCalculationResponse.explosionOverpressureResults
				self.resultCode = vesselLeakFlammableLinkedRunCalculationResponse.resultCode
				self.resultCode = vesselLeakFlammableLinkedRunCalculationResponse.resultCode
				self.messages = vesselLeakFlammableLinkedRunCalculationResponse.messages
				self.elapsedTime = vesselLeakFlammableLinkedRunCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the VesselLeakFlammableLinkedRun calculation object to print itself.
	def print(self):

		# VesselLeakFlammableLinkedRun
		print('** VesselLeakFlammableLinkedRun')

		# vessel
		self.vessel.print()

		# leak
		self.leak.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# substrate
		self.substrate.print()

		# weather
		self.weather.print()

		# dispersionParameters
		self.dispersionParameters.print()

		print(self.endPointConcentration)
		print('{0}\t{1}'.format('End point concentration', self.endPointConcentration))

		# flammableParameters
		self.flammableParameters.print()

		# explosionParameters
		self.explosionParameters.print()

		for item in self.dispersionOutputConfigs:
			item.print()


		for item in self.flammableOutputConfigs:
			item.print()


		for item in self.explosionOutputConfigs:
			item.print()


		for item in self.explosionConfinedVolumes:
			item.print()


		# dischargeRecord
		self.dischargeRecord.print()

		# distancesToJetFireRadiation
		for item in self.distancesToJetFireRadiation:
			print('{0}'.format(item))

		for jetContourPoint in self.jetContourPoints:
			jetContourPoint.print()

		# nJetCountourPoints
		for item in self.nJetCountourPoints:
			print('{0}'.format(item))

		# areaEllipseJet
		for item in self.areaEllipseJet:
			print('{0}'.format(item))

		# distancesToConcentration
		for item in self.distancesToConcentration:
			print('{0}'.format(item))

		# concentrationsUsed
		for item in self.concentrationsUsed:
			print('{0}'.format(item))

		for concContourPoint in self.concContourPoints:
			concContourPoint.print()

		# nConcCountourPoints
		for item in self.nConcCountourPoints:
			print('{0}'.format(item))

		# areaFootprintConc
		for item in self.areaFootprintConc:
			print('{0}'.format(item))

		# distancesToPoolFireRadiation
		for item in self.distancesToPoolFireRadiation:
			print('{0}'.format(item))

		for poolContourPoint in self.poolContourPoints:
			poolContourPoint.print()

		# nPoolCountourPoints
		for item in self.nPoolCountourPoints:
			print('{0}'.format(item))

		# areaEllipsePool
		for item in self.areaEllipsePool:
			print('{0}'.format(item))

		# explosionOverpressureResults
		for item in self.explosionOverpressureResults:
			item.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a vessel leak flammable linked run calculation.
class VesselLeakFlammableLinkedRunCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Discharge data for table
		self.dischargeRecord = DischargeRecord()

		# Distances to jet fire radiation levels
		self.distancesToJetFireRadiation = []

		# Ellipses to jet fire radiation levels
		self.jetContourPoints = []

		# Number of contour points for jet fire ellipses per radiation level
		self.nJetCountourPoints = []

		# Areas of jet fire ellipses
		self.areaEllipseJet = []

		# Distances to concentration levels
		self.distancesToConcentration = []

		# Concentration levels
		self.concentrationsUsed = []

		# Maximum concentration footprints at given concentration levels
		self.concContourPoints = []

		# Number of contour points per concentration level
		self.nConcCountourPoints = []

		# Areas of maximum concentration footprints
		self.areaFootprintConc = []

		# Distances to pool fire radiation levels
		self.distancesToPoolFireRadiation = []

		# Ellipses to pool fire radiation levels
		self.poolContourPoints = []

		# Number of contour points for pool fire ellipses per radiation level
		self.nPoolCountourPoints = []

		# Areas of pool fire ellipses
		self.areaEllipsePool = []

		# Worst case scenario ME explosion results
		self.explosionOverpressureResults = []

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Discharge data for table
		self.dischargeRecord.initialiseFromDictionary(data['dischargeRecord'])

		# Distances to jet fire radiation levels
		for dataItem in data['distancesToJetFireRadiation']:
			self.distancesToJetFireRadiation.append(float(dataItem))

		# Ellipses to jet fire radiation levels
		for dataItem in data['jetContourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.jetContourPoints.append(localPosition)

		# Number of contour points for jet fire ellipses per radiation level
		for dataItem in data['nJetCountourPoints']:
			self.nJetCountourPoints.append(int(dataItem))

		# Areas of jet fire ellipses
		for dataItem in data['areaEllipseJet']:
			self.areaEllipseJet.append(float(dataItem))

		# Distances to concentration levels
		for dataItem in data['distancesToConcentration']:
			self.distancesToConcentration.append(float(dataItem))

		# Concentration levels
		for dataItem in data['concentrationsUsed']:
			self.concentrationsUsed.append(float(dataItem))

		# Maximum concentration footprints at given concentration levels
		for dataItem in data['concContourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.concContourPoints.append(localPosition)

		# Number of contour points per concentration level
		for dataItem in data['nConcCountourPoints']:
			self.nConcCountourPoints.append(int(dataItem))

		# Areas of maximum concentration footprints
		for dataItem in data['areaFootprintConc']:
			self.areaFootprintConc.append(float(dataItem))

		# Distances to pool fire radiation levels
		for dataItem in data['distancesToPoolFireRadiation']:
			self.distancesToPoolFireRadiation.append(float(dataItem))

		# Ellipses to pool fire radiation levels
		for dataItem in data['poolContourPoints']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.poolContourPoints.append(localPosition)

		# Number of contour points for pool fire ellipses per radiation level
		for dataItem in data['nPoolCountourPoints']:
			self.nPoolCountourPoints.append(int(dataItem))

		# Areas of pool fire ellipses
		for dataItem in data['areaEllipsePool']:
			self.areaEllipsePool.append(float(dataItem))

		# Worst case scenario ME explosion results
		for dataItem in data['explosionOverpressureResults']:
			explosionOverpressureResult = ExplosionOverpressureResult()
			explosionOverpressureResult.initialiseFromDictionary(dataItem)
			self.explosionOverpressureResults.append(explosionOverpressureResult)

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a vessel leak max flammable cloud calculation.
class VesselLeakMaxFlammableCloudCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Leak failure case
		self.leak = Leak()

		# Weather
		self.weather = Weather()

		# The dispersing surface
		self.substrate = Substrate()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Options for controlling dispersion results (here used to set height of interest only)
		self.dispersionOutputConfig = DispersionOutputConfig()


# Vessel leak max flammable cloud calculation class.
class VesselLeakMaxFlammableCloudCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Vessel (pressurised or atmospheric)
		self.vessel = Vessel()

		# Leak failure case
		self.leak = Leak()

		# Weather
		self.weather = Weather()

		# The dispersing surface
		self.substrate = Substrate()

		# Discharge parameters
		self.dischargeParameters = DischargeParameters()

		# Dispersion parameters
		self.dispersionParameters = DispersionParameters()

		# Options for controlling dispersion results (here used to set height of interest only)
		self.dispersionOutputConfig = DispersionOutputConfig()

		# Calculation outputs.
		# Collated discharge and flammable cloud characterisation results
		self.vesselLeakMaxFlammableCloudResults = VesselLeakMaxFlammableCloudResults()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# VesselLeakMaxFlammableCloud calculation run method.
	def run(self) -> ResultCode:

		# Create the vessel leak max flammable cloud request.
		vesselLeakMaxFlammableCloudCalculationRequest = VesselLeakMaxFlammableCloudCalculationRequest()

		# Initialise the member properties.

		vesselLeakMaxFlammableCloudCalculationRequest.vessel = self.vessel
		vesselLeakMaxFlammableCloudCalculationRequest.leak = self.leak
		vesselLeakMaxFlammableCloudCalculationRequest.weather = self.weather
		vesselLeakMaxFlammableCloudCalculationRequest.substrate = self.substrate
		vesselLeakMaxFlammableCloudCalculationRequest.dischargeParameters = self.dischargeParameters
		vesselLeakMaxFlammableCloudCalculationRequest.dispersionParameters = self.dispersionParameters
		vesselLeakMaxFlammableCloudCalculationRequest.dispersionOutputConfig = self.dispersionOutputConfig

		requestJson = jsons.dumps(vesselLeakMaxFlammableCloudCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatevesselleakmaxflammablecloud?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			vesselLeakMaxFlammableCloudCalculationResponse = VesselLeakMaxFlammableCloudCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				vesselLeakMaxFlammableCloudCalculationResponse.initialiseFromDictionary(json)

				self.vesselLeakMaxFlammableCloudResults = vesselLeakMaxFlammableCloudCalculationResponse.vesselLeakMaxFlammableCloudResults
				self.resultCode = vesselLeakMaxFlammableCloudCalculationResponse.resultCode
				self.resultCode = vesselLeakMaxFlammableCloudCalculationResponse.resultCode
				self.messages = vesselLeakMaxFlammableCloudCalculationResponse.messages
				self.elapsedTime = vesselLeakMaxFlammableCloudCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the VesselLeakMaxFlammableCloud calculation object to print itself.
	def print(self):

		# VesselLeakMaxFlammableCloud
		print('** VesselLeakMaxFlammableCloud')

		# vessel
		self.vessel.print()

		# leak
		self.leak.print()

		# weather
		self.weather.print()

		# substrate
		self.substrate.print()

		# dischargeParameters
		self.dischargeParameters.print()

		# dispersionParameters
		self.dispersionParameters.print()

		# dispersionOutputConfig
		self.dispersionOutputConfig.print()

		# vesselLeakMaxFlammableCloudResults
		self.vesselLeakMaxFlammableCloudResults.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a vessel leak max flammable cloud calculation.
class VesselLeakMaxFlammableCloudCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Collated discharge and flammable cloud characterisation results
		self.vesselLeakMaxFlammableCloudResults = VesselLeakMaxFlammableCloudResults()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Collated discharge and flammable cloud characterisation results
		self.vesselLeakMaxFlammableCloudResults.initialiseFromDictionary(data['vesselLeakMaxFlammableCloudResults'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a vessel state calculation.
class VesselStateCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()


# Vessel state calculation class.
class VesselStateCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# User-defined input material, pure component or mixture (max 20 components)
		self.material = Material()

		# Describes the fluid pressure, temperature, liquid fraction
		self.materialState = State()

		# Calculation outputs.
		# Describes the vessel storage conditions (Pure gas, Stratified Two-Phase or Pressurised liquid)
		self.vesselConditions = VesselConditions.PURE_GAS

		# Describes the fluid pressure, temperature and liquid fraction after the flash calculation
		self.outputState = State()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# VesselState calculation run method.
	def run(self) -> ResultCode:

		# Create the vessel state request.
		vesselStateCalculationRequest = VesselStateCalculationRequest()

		# Initialise the member properties.

		vesselStateCalculationRequest.material = self.material
		vesselStateCalculationRequest.materialState = self.materialState

		requestJson = jsons.dumps(vesselStateCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculatevesselstate?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			vesselStateCalculationResponse = VesselStateCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				vesselStateCalculationResponse.initialiseFromDictionary(json)

				self.vesselConditions = vesselStateCalculationResponse.vesselConditions
				self.outputState = vesselStateCalculationResponse.outputState
				self.resultCode = vesselStateCalculationResponse.resultCode
				self.resultCode = vesselStateCalculationResponse.resultCode
				self.messages = vesselStateCalculationResponse.messages
				self.elapsedTime = vesselStateCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the VesselState calculation object to print itself.
	def print(self):

		# VesselState
		print('** VesselState')

		# material
		self.material.print()

		# materialState
		self.materialState.print()

		# vesselConditions
		print('{0}\t{1}'.format('Vessel conditions', self.vesselConditions))

		# outputState
		self.outputState.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a vessel state calculation.
class VesselStateCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Describes the vessel storage conditions (Pure gas, Stratified Two-Phase or Pressurised liquid)
		self.vesselConditions = VesselConditions.PURE_GAS

		# Describes the fluid pressure, temperature and liquid fraction after the flash calculation
		self.outputState = State()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Describes the vessel storage conditions (Pure gas, Stratified Two-Phase or Pressurised liquid)
		self.vesselConditions = VesselConditions(data['vesselConditions'])

		# Describes the fluid pressure, temperature and liquid fraction after the flash calculation
		self.outputState.initialiseFromDictionary(data['outputState'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


# Request object for a weather conversion calculation.
class WeatherConversionCalculationRequest(object):

	# Constructor.
	def __init__(self):

		# Input live weather station data
		self.weatherStationData = WeatherStationData()


# Weather conversion calculation class.
class WeatherConversionCalculation(Calculation):

	# Constructor.
	def __init__(self):

		Calculation.__init__(self)

		# Calculation inputs.

		# Input live weather station data
		self.weatherStationData = WeatherStationData()

		# Calculation outputs.
		# Weather data used in our APIs
		self.weather = Weather()

		# Error code (0 = OK, < 0 data input error, > 0 execution error)
		self.resultCode = ResultCode.SUCCESS

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0

	# WeatherConversion calculation run method.
	def run(self) -> ResultCode:

		# Create the weather conversion request.
		weatherConversionCalculationRequest = WeatherConversionCalculationRequest()

		# Initialise the member properties.

		weatherConversionCalculationRequest.weatherStationData = self.weatherStationData

		requestJson = jsons.dumps(weatherConversionCalculationRequest, use_enum_name=False)

		url = getApiTarget() + 'calculateweatherconversion?clientId=' + getClientAliasId()

		self.resultCode = ResultCode.UNEXPECTED_APPLICATION_ERROR

		response = Calculation.post_request(self, url, requestJson, getAccessToken())

		if response.ok:

			json = jsons.loads(response.text)
			self.resultCode = ResultCode(json['resultCode'])

			weatherConversionCalculationResponse = WeatherConversionCalculationResponse()

			if (self.resultCode == ResultCode.SUCCESS):

				weatherConversionCalculationResponse.initialiseFromDictionary(json)

				self.weather = weatherConversionCalculationResponse.weather
				self.resultCode = weatherConversionCalculationResponse.resultCode
				self.resultCode = weatherConversionCalculationResponse.resultCode
				self.messages = weatherConversionCalculationResponse.messages
				self.elapsedTime = weatherConversionCalculationResponse.elapsedTime

			else:

				for message in json['messages']:
					self.messages.append(message)

		else:

			try:

				json = jsons.loads(response.text)
				self.resultCode = ResultCode(json['resultCode'])

				for message in json['messages']:
					self.messages.append(message)

			except:
				self.messages.append("No additional error information available")

			self.messages.append("%s (Status code: %3d)" % (response.reason, response.status_code))

		return self.resultCode


	# Utility method to get the WeatherConversion calculation object to print itself.
	def print(self):

		# WeatherConversion
		print('** WeatherConversion')

		# weatherStationData
		self.weatherStationData.print()

		# weather
		self.weather.print()

		# resultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# ResultCode
		print('{0}\t{1}'.format('Result code', self.resultCode))

		# Messages
		for item in self.messages:
			print('{0}'.format(item))

		# ElapsedTime
		print('{0}\t{1}'.format('Elapsed time', self.elapsedTime))

# Response object for a weather conversion calculation.
class WeatherConversionCalculationResponse(object):

	# Constructor.
	def __init__(self):

		# Weather data used in our APIs
		self.weather = Weather()

		# Calculation result code.
		self.resultCode = ResultCode.SUCCESS

		# Messages generated by the calculation.
		self.messages = []

		# Time taken to run the calculation.
		self.elapsedTime = 0.0


	# Initialise response with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Weather data used in our APIs
		self.weather.initialiseFromDictionary(data['weather'])

		# Calculation result code.
		self.resultCode = ResultCode(data['resultCode'])

		# Messages generated by the calculation.
		for dataItem in data['messages']:
			self.messages.append(dataItem)

		# Time taken to run the calculation.
		self.elapsedTime = float(data['elapsedTime'])


