#!/usr/bin/env node
"use strict";
// cdk8s-server: http server which synthesizes cdk operators
// ------------------------------------------------------------------------------------
// request body should include an input manifest for a single resource
// response will include the synthesized output manifest
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const yaml = require("yaml");
const server_1 = require("../server");
async function main() {
    const command = resolveAppFromCommandLine() ?? resolveAppFromConfig();
    if (!command) {
        throw new Error('unable to determine how to execute your CDK8s app. You can either pass a command line as arguments (cdk8s-server COMMAND) or specify the "app" attribute in cdk8s.yaml');
    }
    // needed in docker
    process.on('SIGINT', () => process.exit());
    ;
    const server = new server_1.Server({ appCommand: command });
    const port = await server.listen();
    console.error(`Listening on ${port}`);
    console.error(`- App command: ${command}`);
    console.error('- Request body should include a single k8s resource in JSON format');
    console.error(`- Request will be piped through STDIN to "${command}"`);
    console.error('- Response is the STDOUT and expected to be a multi-resource yaml manifest');
}
main().catch((e) => {
    console.error(e.stack);
    process.exit(1);
});
function resolveAppFromConfig() {
    if (!fs.existsSync('cdk8s.yaml')) {
        return undefined;
    }
    const config = yaml.parse(fs.readFileSync('cdk8s.yaml', 'utf-8'));
    return config.app;
}
function resolveAppFromCommandLine() {
    if (process.argv.length < 3) {
        return undefined;
    }
    return process.argv.slice(2).join(' ');
}
//# sourceMappingURL=data:application/json;base64,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