DROP TABLE IF EXISTS hebrew_lemma;
CREATE TABLE hebrew_lemma (id varchar(10) NOT NULL, pos CHECK(pos IN ('n','v','a','s','r')) DEFAULT 'n', lemma varchar(200) NOT NULL, is_phrase CHECK(is_phrase IN ('Y','N')) DEFAULT 'N', PRIMARY KEY (id,lemma,is_phrase));

INSERT INTO hebrew_lemma VALUES ("n#09425087","n","אֱגוֹז","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003985","n","אֱלִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003986","n","אֱלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06888992","n","אֱלֹהִים","N");
INSERT INTO hebrew_lemma VALUES ("n#07293144","n","אֱלֹהִים","N");
INSERT INTO hebrew_lemma VALUES ("n#06889275","n","אֱלֹהֵי-הַנּוֹצְרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10929604","n","אֱלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10077974","n","אֲבֵלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05792731","n","אֲבַטִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#10757941","n","אֲגַם","N");
INSERT INTO hebrew_lemma VALUES ("n#10758043","n","אֲגַם","N");
INSERT INTO hebrew_lemma VALUES ("n#06787575","n","אֲגַם","N");
INSERT INTO hebrew_lemma VALUES ("n#06302563","n","אֲגַף","N");
INSERT INTO hebrew_lemma VALUES ("n#02190772","n","אֲגַף","N");
INSERT INTO hebrew_lemma VALUES ("n#06049069","n","אֲגַף","N");
INSERT INTO hebrew_lemma VALUES ("n#06261108","n","אֲגַף","N");
INSERT INTO hebrew_lemma VALUES ("n#03567934","n","אֲגַרְטָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02353159","n","אֲגֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05997364","n","אֲגֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05999585","n","אֲגֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04313119","n","אֲגוּדָל","N");
INSERT INTO hebrew_lemma VALUES ("n#03783654","n","אֲדִיקוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05563705","n","אֲדִישׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10928324","n","אֲדָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00330518","n","אֲהַבְהָבִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003966","n","אֲהוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01327490","a","אֲוִירִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02174460","n","אֲוִירוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#01372857","n","אֲוָז","N");
INSERT INTO hebrew_lemma VALUES ("n#02791525","n","אֲזִקִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#04474097","n","אֲחִיזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00518769","n","אֲחִיזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07574321","n","אֲחָאִים","N");
INSERT INTO hebrew_lemma VALUES ("a#02158584","a","אֲחָדִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02234103","n","אֲחוֹרֵי-הַקְּלָעִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","אֲחוֹרַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#00537892","n","אֲכִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00729616","n","אֲכִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07777807","n","אֲלֻמַּת-אוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03680488","n","אֲמִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05320427","n","אֲמִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05349662","n","אֲמִירָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01066794","a","אֲמִתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02095155","a","אֲמִתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02341880","a","אֲמִתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02342342","a","אֲמִתִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05073898","n","אֲמָנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01182362","a","אֲנָכִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05789084","n","אֲנָנָס","N");
INSERT INTO hebrew_lemma VALUES ("n#08907523","n","אֲנָנָס","N");
INSERT INTO hebrew_lemma VALUES ("n#01519964","n","אֲנָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003974","n","אֲסִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00583730","n","אֲפִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04733874","n","אֲפִיק-תִּמְסֹרֶת","N");
INSERT INTO hebrew_lemma VALUES ("r#00016468","r","אֲפִלּוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#00583897","n","אֲרִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02430052","n","אֲרֻבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02467466","n","אֲרוֹן-מֵתִים","N");
INSERT INTO hebrew_lemma VALUES ("n#05627549","n","אֲרוּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05630599","n","אֲרוּחָה-קַלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06353805","n","אֲתָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06371658","n","אֲתָר","N");
INSERT INTO hebrew_lemma VALUES ("n#03318070","n","אֳנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00436039","v","אִבְחֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#00435856","v","אִבְחֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#00099234","n","אִבְחוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02360473","n","אִבְקָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00032369","v","אִבֵּד-מִשְׁקָל","N");
INSERT INTO hebrew_lemma VALUES ("n#06112041","n","אִגּוּד","N");
INSERT INTO hebrew_lemma VALUES ("v#00340255","v","אִוְרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#05068012","n","אִזְכּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02433142","n","אִזְמֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#03279791","n","אִזְמֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01025171","v","אִחְסֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#01559786","v","אִחְסֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#00166362","v","אִחֵד","N");
INSERT INTO hebrew_lemma VALUES ("v#01682716","v","אִחֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#06598174","n","אִחוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00245212","n","אִחוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#04974383","n","אִחוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06741251","n","אִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09904832","n","אִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04015096","n","אִי-כְּשִׁירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10117000","n","אִי-פּוֹרִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00479886","n","אִי-צֶדֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#05212011","n","אִידִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01692973","a","אִימְפְּרוֹבִיזוֹרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01705076","a","אִימְפֶּרְסוֹנָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00733062","n","אִימְפֶּרָטִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#09940115","n","אִימְפֶּרָטִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004231","n","אִימִיגְרַנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004232","n","אִימִיגְרַנְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004192","n","אִינְטֶלֶקְטוּאָל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004193","n","אִינְטֶלֶקְטוּאָלִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00240731","n","אִינְטֶנְסִיפִיקַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02864326","n","אִינְטֶרְנֶט","N");
INSERT INTO hebrew_lemma VALUES ("a#02621476","a","אִינְסְטְרוּמֶנְטָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04354143","n","אִינְסְטִינְקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#00401944","n","אִינְסְטֶלַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03147209","n","אִינְסְטֶלַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07482774","n","אִינְסְטֶלָטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04977171","n","אִינְפוֹרְמַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00004123","n","אִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07331418","n","אִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","אִישׁ-אֲדָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003987","n","אִישׁ-מִלְחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003657","n","אִישׁ-מִקְצוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07551670","n","אִישׁ-מַדָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#03643456","n","אִישִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07469416","n","אִישִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("r#00128086","r","אִישִׁית","N");
INSERT INTO hebrew_lemma VALUES ("r#00128250","r","אִישִׁית","N");
INSERT INTO hebrew_lemma VALUES ("v#01227336","v","אִכְזֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01809924","v","אִכְסֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","אִכָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003980","n","אִכָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00014590","v","אִלְחֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01183358","v","אִלְתֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00062947","n","אִלְתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00116556","n","אִלְתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00138377","v","אִלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00138537","v","אִלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#01707058","v","אִלֵּץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00565367","v","אִמֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07385387","n","אִמָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#00273030","n","אִמָּא_וְאַבָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01672406","a","אִמָּהִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09949956","n","אִמָּהוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00574902","n","אִמּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00654309","n","אִסּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#04911144","n","אִסּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05414897","n","אִסּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00545801","v","אִפְשֵׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#00357077","v","אִפְשֵׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#00545347","v","אִפְשֵׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#01649126","v","אִפְשֵׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#02961095","n","אִפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05997592","n","אִרְגּוּן","N");
INSERT INTO hebrew_lemma VALUES ("a#02678888","a","אִרְגּוּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04860581","n","אִשּׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04987262","n","אִשּׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05367196","n","אִשּׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00787796","n","אִשּׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01603822","v","אִשְׁפֵּז","N");
INSERT INTO hebrew_lemma VALUES ("n#00430554","n","אִשְׁפּוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#00323207","n","אִשְׁקוּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05367196","n","אִשְׁרוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06665028","n","אִתּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10077974","n","אֵבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#09146840","n","אֵזוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#06268839","n","אֵזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06395720","n","אֵזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06276601","n","אֵזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06369402","n","אֵזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04271545","n","אֵיבְרֵי-הַמִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#05609785","n","אֵיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04111451","n","אֵיבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04279799","n","אֵיבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#05591377","n","אֵימָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00297667","a","אֵין-סְפֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#00297667","a","אֵינְסוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003739","n","אֵירוֹפִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02734993","a","אֵירוֹפִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003740","n","אֵירוֹפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003739","n","אֵירוֹפֶּאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02734993","a","אֵירוֹפֶּאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003740","n","אֵירוֹפֶּאִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06888992","n","אֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#06888584","n","אֵלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09060979","n","אֵלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07419862","n","אֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#07624693","n","אֵם-פּוּנְדְקָאִית","N");
INSERT INTO hebrew_lemma VALUES ("v#00812388","v","אֵרֵח","N");
INSERT INTO hebrew_lemma VALUES ("n#00017297","n","אֵרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07796465","n","אֵרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05538537","n","אֵרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00635718","n","אֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05561864","n","אֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09686541","n","אֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#08689752","n","אֵשֶׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003659","n","אֵשֶׁת-מִקְצוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07463556","n","אֶבְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06669293","n","אֶבֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#10534851","n","אֶבֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#02875598","n","אֶבֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#02887975","n","אֶבֶן-הָרֹאשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#02875598","n","אֶבֶן-חֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#02875598","n","אֶבֶן-טוֹבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02875598","n","אֶבֶן-יְקָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04311659","n","אֶגְרוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#00087361","n","אֶגְרוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#03503032","n","אֶדֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#03622225","n","אֶדֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003969","n","אֶזְרָח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003971","n","אֶזְרָח","N");
INSERT INTO hebrew_lemma VALUES ("n#02445507","n","אֶזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01454970","a","אֶזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02546488","a","אֶזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02546684","a","אֶזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003970","n","אֶזְרָחִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003972","n","אֶזְרָחִית","N");
INSERT INTO hebrew_lemma VALUES ("a#00715355","a","אֶלֶמֶנְטָרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09902316","n","אֶלֶף","N");
INSERT INTO hebrew_lemma VALUES ("a#00803427","a","אֶלַסְטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04994165","n","אֶמְבַּרְגּוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#02185415","n","אֶמְפְּלִיפָיֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004229","n","אֶמִיגְרַנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004230","n","אֶמִיגְרַנְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07239856","n","אֶמִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#04394091","n","אֶנִיגְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09893278","n","אֶפֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#09894639","n","אֶפֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#04312269","n","אֶצְבַּע","N");
INSERT INTO hebrew_lemma VALUES ("n#09817148","n","אֶצְבַּע","N");
INSERT INTO hebrew_lemma VALUES ("n#03131514","n","אֶקְדָּח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003895","n","אֶקְסְהִיבִּיצְיוֹנִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003896","n","אֶקְסְהִיבִּיצְיוֹנִיסְטִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01791543","a","אֶקְסְקְלוּסִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04674380","n","אֶקוֹנוֹמְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07947238","n","אֶרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#07940601","n","אֶרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#07940800","n","אֶרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#06073126","n","אֶרֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06299747","n","אֶרֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06753779","n","אֶרֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06277165","n","אֶרֶץ-אָבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06455500","n","אֶרֶץ-יִשְׂרָאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#06277165","n","אֶרֶץ-מוֹלֶדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06277165","n","אֶרֶץ-מוֹצָא","N");
INSERT INTO hebrew_lemma VALUES ("n#10413485","n","אֶרוֹזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04590750","n","אֶרוּדִיצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06794207","n","אֶשֶׁד","N");
INSERT INTO hebrew_lemma VALUES ("n#10877300","n","אֶתְמוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#10963940","n","אֶתְמוֹל","N");
INSERT INTO hebrew_lemma VALUES ("r#00504351","r","אֶתְמוֹל","N");
INSERT INTO hebrew_lemma VALUES ("r#00504454","r","אֶתְמוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#00687814","n","אֶתְנַחְתָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01961794","a","אֶתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09949831","n","אַבְהוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00099234","n","אַבְחָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00099504","n","אַבְחָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10063667","n","אַבְטָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05651204","n","אַבְקַת-חָרוּבִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04858569","n","אַבְּסְטְרַקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#07358345","n","אַבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#03846796","n","אַבִּירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04571025","n","אַבִּירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06207397","n","אַבִּירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07199293","n","אַבָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07258194","n","אַבָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#09949831","n","אַבָּהוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03050496","n","אַבּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03662132","n","אַגְרֶסִיבִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09592197","n","אַגְרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01867171","a","אַגָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04803389","n","אַגָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05393724","n","אַגָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01321645","a","אַגָּדָתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01867171","a","אַגָּדָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05803355","n","אַגָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#08951407","n","אַגָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#06786830","n","אַדְמַת-בִּצָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004207","n","אַדְרִיכָל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004208","n","אַדְרִיכָלִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01755567","a","אַדִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#10160247","n","אַדֶּמֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01136895","a","אַוְרִירִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01137316","a","אַוְרִירִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05003120","n","אַזְהָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05395080","n","אַזְהָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07430196","n","אַחְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07432658","n","אַחְיָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03679828","n","אַחְרָיוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05012271","n","אַחְרָיוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06019148","n","אַחֲוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03679828","n","אַחֲרָיוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05012271","n","אַחֲרָיוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00961089","a","אַחֲרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01472797","a","אַחֲרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01986829","a","אַחֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01991315","a","אַחֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01992026","a","אַחֵר","N");
INSERT INTO hebrew_lemma VALUES ("r#00044456","r","אַחֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("r#00110511","r","אַחֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09893278","n","אַיִן","N");
INSERT INTO hebrew_lemma VALUES ("r#00023400","r","אַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#01927508","n","אַיָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05605549","n","אַכְזָבָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01211817","a","אַכְזָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01211817","a","אַכְזָרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02835429","n","אַכְסַנְיַת-נֹעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02835429","n","אַכְסַנְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003953","n","אַלְבִּינוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#04463475","n","אַלְטֶרְנָטִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07681060","n","אַלְמָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07680892","n","אַלְמָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00619852","n","אַלִּימוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02531456","n","אַלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08572627","n","אַלּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07388553","n","אַלּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003967","n","אַלּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07166351","n","אַלּוּף_מִשְׁנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003968","n","אַלּוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03790984","n","אַמְבִּיצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00165598","n","אַמְבַּטְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02263808","n","אַמְבַּטְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02264436","n","אַמְבַּטְיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00258473","a","אַמִּיץ","N");
INSERT INTO hebrew_lemma VALUES ("a#00246712","a","אַמִּיץ-לֵב","N");
INSERT INTO hebrew_lemma VALUES ("a#00791837","a","אַנְאַלְפָבֵּיתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02984139","n","אַנְדַּרְטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06086825","n","אַנְסַמְבְּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04448080","n","אַנְתְּרוֹפּוֹמוֹרְפִיזְם","N");
INSERT INTO hebrew_lemma VALUES ("n#07519749","n","אַנָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05564290","n","אַסְפִּירַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00684444","n","אַסְפָּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09626009","n","אַסְפָּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10174999","n","אַסְתְּמָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00016468","r","אַף","N");
INSERT INTO hebrew_lemma VALUES ("r#00026464","r","אַף-עַל-פִּי-כֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#00747433","n","אַפְלָיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02382678","a","אַפְסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00017487","n","אַקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003957","n","אַקְרוֹבָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003958","n","אַקְרוֹבָּטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#08796174","n","אַרְבֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#01730494","n","אַרְבֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02517015","n","אַרְגָּז","N");
INSERT INTO hebrew_lemma VALUES ("n#10479212","n","אַרְגּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00011937","n","אַרְטִיפָקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#01637880","n","אַרְיֵה","N");
INSERT INTO hebrew_lemma VALUES ("n#01634046","n","אַרְיֵה-הָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02206789","n","אַרְכִיּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02206789","n","אַרְכִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004207","n","אַרְכִיטֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004208","n","אַרְכִיטֶקְטִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01580126","a","אַרְכָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01828427","n","אַרְנֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#01826220","n","אַרְנָבוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03587013","n","אַרְנָק","N");
INSERT INTO hebrew_lemma VALUES ("n#09583701","n","אַרְנוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00222282","a","אַרְסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07938180","n","אַשּׁוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07938419","n","אַשּׁוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("r#00037263","r","אַשְׁכָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10497589","n","אַשְׁלְגָן","N");
INSERT INTO hebrew_lemma VALUES ("n#10763066","n","אַשְׁלָג","N");
INSERT INTO hebrew_lemma VALUES ("n#05404012","n","אַשְׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05602697","n","אַשְׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10078983","n","אַשְׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10656895","n","אַשְׁפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05013928","n","אַשְׁרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07258194","n","אָב","N");
INSERT INTO hebrew_lemma VALUES ("n#07272604","n","אָב","N");
INSERT INTO hebrew_lemma VALUES ("n#07276210","n","אָב","N");
INSERT INTO hebrew_lemma VALUES ("n#10929407","n","אָב","N");
INSERT INTO hebrew_lemma VALUES ("n#07075378","n","אָב_קַדְמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00430514","a","אָבִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07421559","n","אָבֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#00297331","v","אָבַד","N");
INSERT INTO hebrew_lemma VALUES ("n#10507783","n","אָבָץ","N");
INSERT INTO hebrew_lemma VALUES ("v#01559048","v","אָגַר","N");
INSERT INTO hebrew_lemma VALUES ("a#01289497","a","אָדִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09743067","n","אָדַפְּטַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00004123","n","אָדָם","N");
INSERT INTO hebrew_lemma VALUES ("n#03879230","n","אָדֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#00362449","a","אָדֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#07414666","n","אָדוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07451003","n","אָדוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02902895","n","אָהִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003965","n","אָהוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01402474","a","אָהוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00480312","n","אָוֶן","N");
INSERT INTO hebrew_lemma VALUES ("r#00114832","r","אָז","N");
INSERT INTO hebrew_lemma VALUES ("r#00115115","r","אָז","N");
INSERT INTO hebrew_lemma VALUES ("r#00115244","r","אָז","N");
INSERT INTO hebrew_lemma VALUES ("n#02685797","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("n#07127521","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("n#07127750","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("n#07128451","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("n#07188374","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("n#07436855","n","אָח","N");
INSERT INTO hebrew_lemma VALUES ("a#01150299","a","אָחִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#01898654","a","אָחִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#07579639","n","אָחוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06317924","n","אָחוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#06348384","n","אָחוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#09952143","n","אָחוּז","N");
INSERT INTO hebrew_lemma VALUES ("a#00402602","a","אָטוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00735347","a","אָטוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#01342680","a","אָטוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00193648","a","אָיֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#01079225","a","אָיֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#01079947","a","אָיֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00036883","r","אָכֵן","N");
INSERT INTO hebrew_lemma VALUES ("r#00037028","r","אָכֵן","N");
INSERT INTO hebrew_lemma VALUES ("r#00037028","r","אָכֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#07700121","n","אָלֶכְּסָנְדֶר-בֶּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05120286","n","אָלֶף","N");
INSERT INTO hebrew_lemma VALUES ("a#00688247","a","אָמִין","N");
INSERT INTO hebrew_lemma VALUES ("a#02346141","a","אָמִין","N");
INSERT INTO hebrew_lemma VALUES ("n#09417961","n","אָמִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01731610","v","אָמַן","N");
INSERT INTO hebrew_lemma VALUES ("v#00506398","v","אָמַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00682542","v","אָמַר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003955","n","אָמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003959","n","אָמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003956","n","אָמָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003960","n","אָמָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06815749","n","אָמוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003973","n","אָסִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00540739","v","אָסַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00879090","v","אָסַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01699803","v","אָסַר","N");
INSERT INTO hebrew_lemma VALUES ("n#05452645","n","אָסוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01346629","a","אָסוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01012191","a","אָסוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01697122","a","אָסוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00346121","a","אָפְיָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04733874","n","אָפִיק","N");
INSERT INTO hebrew_lemma VALUES ("a#00268709","a","אָפֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#01084447","a","אָפֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#00366117","a","אָפֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#00430862","a","אָפֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#00963416","a","אָפֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03656931","n","אָפַּתְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08067245","n","אָקַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02656657","n","אָרִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#03504435","n","אָרִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04598167","n","אָרִיתְמֶטִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10552050","n","אָרָד","N");
INSERT INTO hebrew_lemma VALUES ("n#02467466","n","אָרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02534044","n","אָרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00631927","a","אָרוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00632302","a","אָרוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07805661","n","אֹבֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02931334","n","אֹדֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#03486655","n","אֹהֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00011575","n","אֹכֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#05595229","n","אֹמֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03805961","n","אֹמֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#05320427","n","אֹמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05349662","n","אֹמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04945821","n","אֹסֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#03858557","n","אֹפֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#05837941","n","אֹרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#08432637","n","אֹרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#03659752","n","אֹרֶך-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07925865","n","אֹרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07926500","n","אֹרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#06095787","n","אֻגְדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03433996","n","אֻלְפָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#03434290","n","אֻלְפָּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00138537","v","אֻלַּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01102092","a","אֻמְלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#07191544","n","אֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07191713","n","אֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07581578","n","אֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003975","n","אֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003976","n","אֻמָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04258369","n","אֻנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03395783","n","אֻרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00009457","n","אוֹבְּיֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#04861501","n","אוֹגֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#01844208","n","אוֹגֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01403478","a","אוֹהֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#02383458","n","אוֹטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#03149960","n","אוֹלָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07427165","n","אוֹמֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03017826","n","אוֹפַנּוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004968","n","אוֹפּוֹרְטוּנִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004969","n","אוֹפּוֹרְטוּנִיסְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003977","n","אוֹצֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003978","n","אוֹצֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09628243","n","אוֹצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#09628428","n","אוֹצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10001673","n","אוֹקְטָגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02923368","n","אוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#07811448","n","אוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03062454","n","אוֹרְגָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#04602657","n","אוֹרְדִּינָטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00786532","a","אוֹרְיֶנְטָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#08348831","n","אוֹרְכִידֵאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02550579","n","אוֹרְנָמֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#05435037","n","אוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05090749","n","אוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05115901","n","אוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06665028","n","אוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05085885","n","אוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#03784611","n","אוֹת-קַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#05088890","n","אוֹת-קָלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10835446","n","אוּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00294418","r","אוּלַי","N");
INSERT INTO hebrew_lemma VALUES ("n#02244446","n","אוּלַם-רִקּוּדִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02786743","n","אוּלָם","N");
INSERT INTO hebrew_lemma VALUES ("n#02511574","n","אוּלָם-בֵּית-הַמִּשְׁפָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00383340","n","אוּרְבָּנִיזַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00156699","r","בְּאֹפֶן-יַחֲסִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00039873","r","בְּאֹפֶן-כְּלָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00482966","n","בְּגִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00500041","n","בְּגִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10873520","n","בְּגִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("r#00052077","r","בְּגָּלוּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00154389","r","בְּדִיּוּק","N");
INSERT INTO hebrew_lemma VALUES ("r#00363408","r","בְּדִיּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#10343521","n","בְּדִידוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05077026","n","בְּדִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10504929","n","בְּדִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#00419850","n","בְּדִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03779450","n","בְּהִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01212141","a","בְּהֵמִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00140819","r","בְּוַדַּאי","N");
INSERT INTO hebrew_lemma VALUES ("r#00223640","r","בְּזַעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#05578076","n","בְּחִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10302574","n","בְּחִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00419850","n","בְּחִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04707108","n","בְּחִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05378329","n","בְּחִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04462889","n","בְּחִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00104850","n","בְּחִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00118873","n","בְּחִירוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00131987","n","בְּחִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("r#00207028","r","בְּחָפְשִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("r#00499119","r","בְּיִחוּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00086681","r","בְּיוֹתֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#05387878","n","בְּכִי-תַּמְרוּרִים","N");
INSERT INTO hebrew_lemma VALUES ("r#00059927","r","בְּכַוָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00223640","r","בְּכַעַס","N");
INSERT INTO hebrew_lemma VALUES ("r#00026464","r","בְּכָל-זֹאת","N");
INSERT INTO hebrew_lemma VALUES ("r#00336979","r","בְּכֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004007","n","בְּכוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004008","n","בְּכוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02678745","n","בְּלִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09596000","n","בְּלַאי","N");
INSERT INTO hebrew_lemma VALUES ("r#00026338","r","בְּלָאו_הָכִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00025661","r","בְּלָאו_הָכֵי","N");
INSERT INTO hebrew_lemma VALUES ("n#02299245","n","בְּלוֹק","N");
INSERT INTO hebrew_lemma VALUES ("r#00160847","r","בְּמִקְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("r#00059927","r","בְּמִתְכַּוֵּן","N");
INSERT INTO hebrew_lemma VALUES ("r#00059927","r","בְּמַחְשָׁבָה-תְּחִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00117044","r","בְּמַקְבִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#00585093","n","בְּנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00715519","n","בְּנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00204090","r","בְּנִפְרָד","N");
INSERT INTO hebrew_lemma VALUES ("r#00044621","r","בְּנוֹסָף","N");
INSERT INTO hebrew_lemma VALUES ("a#00026848","a","בְּסִיסִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00071501","r","בְּעִקָּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00145000","r","בְּעֶצֶם","N");
INSERT INTO hebrew_lemma VALUES ("r#00006065","r","בְּעֶרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00151980","r","בְּעַל-פֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05080756","n","בְּעָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10340761","n","בְּעָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07451379","n","בְּעָלִים","N");
INSERT INTO hebrew_lemma VALUES ("r#00117172","r","בְּעוֹד","N");
INSERT INTO hebrew_lemma VALUES ("r#00145000","r","בְּפֹעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#10037091","n","בְּצַוְתָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#00413658","a","בְּקִרְבַת-מָקוֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00032928","r","בְּקָרוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#00154105","n","בְּרִיאַת_הָעוֹלָם","N");
INSERT INTO hebrew_lemma VALUES ("n#10366424","n","בְּרִיאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07780411","n","בְּרִיזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00032997","n","בְּרִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04898850","n","בְּרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05074858","n","בְּרִית","N");
INSERT INTO hebrew_lemma VALUES ("r#00285860","r","בְּרִפְרוּף","N");
INSERT INTO hebrew_lemma VALUES ("r#00177383","r","בְּרֶגַע-שֶׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10382904","n","בְּרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08418023","n","בְּרוֹמִית-הַשִּׁיפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07947710","n","בְּרוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09539173","n","בְּרוּטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("a#01768682","a","בְּרוּךְ-כִּשָּׁרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06909450","n","בְּתוּלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04277222","n","בְּתוּלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10063030","n","בְּתוּלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04277222","n","בְּתוּלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#07667236","n","בְּתוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00189588","r","בִּגְנֵבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02456798","n","בִּגּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#10343743","n","בִּדּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00529661","n","בִּדּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00332306","n","בִּדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10360525","n","בִּזָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00803947","n","בִּזּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01689077","v","בִּטֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01652576","v","בִּטֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10426769","n","בִּטּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#09608739","n","בִּטּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05384738","n","בִּטּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00148356","n","בִּטּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00150989","n","בִּטּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00151154","n","בִּטּוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00138537","v","בִּיֵּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00208649","v","בִּיֵּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00208796","v","בִּיֵּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03306252","n","בִּיּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10656399","n","בִּיּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#09698142","n","בִּיּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03306252","n","בִּיב","N");
INSERT INTO hebrew_lemma VALUES ("n#01907269","n","בִּיזוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05631794","n","בִּיס","N");
INSERT INTO hebrew_lemma VALUES ("n#05681148","n","בִּיסְקְוִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#05913023","n","בִּירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06283013","n","בִּירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03097378","n","בִּיתָן","N");
INSERT INTO hebrew_lemma VALUES ("r#00039873","r","בִּכְלָל","N");
INSERT INTO hebrew_lemma VALUES ("r#00054968","r","בִּכְלָל","N");
INSERT INTO hebrew_lemma VALUES ("r#00007655","r","בִּלְבַד","N");
INSERT INTO hebrew_lemma VALUES ("n#00043311","n","בִּלְבּוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00427123","a","בִּלְבוּשׁ-חַוָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00188908","v","בִּלְגֵּן","N");
INSERT INTO hebrew_lemma VALUES ("a#02070047","a","בִּלְעָדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03829588","n","בִּלְעָדִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01708553","a","בִּלְתִּי-חָדִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01202822","a","בִּלְתִּי-מְחֻמָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00272358","n","בִּלּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00484777","n","בִּלּוּף","N");
INSERT INTO hebrew_lemma VALUES ("r#00363032","r","בִּמְדֻיָּק","N");
INSERT INTO hebrew_lemma VALUES ("r#00032928","r","בִּמְהֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00081536","r","בִּמְיֻחָד","N");
INSERT INTO hebrew_lemma VALUES ("r#00245145","r","בִּמְיֻחָד","N");
INSERT INTO hebrew_lemma VALUES ("r#00153689","r","בִּמְלוֹאוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#00585093","n","בִּנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02347413","n","בִּנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#05996567","n","בִּנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#10963303","n","בִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00430666","v","בִּסֵּס","N");
INSERT INTO hebrew_lemma VALUES ("r#00245145","r","בִּפְרָט","N");
INSERT INTO hebrew_lemma VALUES ("n#06786994","n","בִּצָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00061811","n","בִּצּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00729882","n","בִּצּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06730976","n","בִּקְעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02839632","n","בִּקְתָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00560756","v","בִּקֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00726812","v","בִּקֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00510998","v","בִּקֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00683875","n","בִּקּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#09725817","n","בִּקּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00188908","v","בִּרְדֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00157100","n","בִּשּׁוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05626343","n","בִּשּׁוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05120394","n","בֵּי&quotת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003883","n","בֵּיְבִּי-סִיטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003883","n","בֵּיְבִּיסִיטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10888065","n","בֵּין-הַשְּׁמָשׁוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#10888065","n","בֵּין-הָעַרְבַּיִם","N");
INSERT INTO hebrew_lemma VALUES ("a#01512129","a","בֵּין-לְאֻמִּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00025661","r","בֵּין_כֹּה_וָכֹה","N");
INSERT INTO hebrew_lemma VALUES ("a#01512129","a","בֵּינְלְאֻמִּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00052557","r","בֵּינְתַיִם","N");
INSERT INTO hebrew_lemma VALUES ("r#00062583","r","בֵּינְתַיִם","N");
INSERT INTO hebrew_lemma VALUES ("a#00963005","a","בֵּינַיִם","N");
INSERT INTO hebrew_lemma VALUES ("a#01693227","a","בֵּינַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#04777587","n","בֵּינוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02668605","n","בֵּית","N");
INSERT INTO hebrew_lemma VALUES ("n#05120394","n","בֵּית","N");
INSERT INTO hebrew_lemma VALUES ("n#06021037","n","בֵּית-אָב","N");
INSERT INTO hebrew_lemma VALUES ("n#02199760","n","בֵּית-דִּירוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#04301367","n","בֵּית-הֶחָזֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03524562","n","בֵּית-הָעִירִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06009454","n","בֵּית-הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02618194","n","בֵּית-מְגוּרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02835992","n","בֵּית-מָלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02825467","n","בֵּית_אָבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06949518","n","בֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07592357","n","בֵּן","N");
INSERT INTO hebrew_lemma VALUES ("r#00036639","r","בֶּאֱמֶת","N");
INSERT INTO hebrew_lemma VALUES ("r#00037263","r","בֶּאֱמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02740446","n","בֶּגֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#04304826","n","בֶּטֶן","N");
INSERT INTO hebrew_lemma VALUES ("r#00140819","r","בֶּטַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10632664","n","בֶּטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00557729","n","בֶּכִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003885","n","בֶּן-זוּג","N");
INSERT INTO hebrew_lemma VALUES ("a#01692272","a","בֶּן-חֲלוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#07058255","n","בֶּן-לְוָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07498573","n","בֶּן-מֶלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10263905","n","בֶּקַע","N");
INSERT INTO hebrew_lemma VALUES ("n#03595967","n","בֶּרֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#02282730","n","בֶּרֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#01959421","n","בֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02892631","n","בֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#04319321","n","בֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00367067","r","בַּאֲדִישׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10874257","n","בַּגְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02656657","n","בַּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00117044","r","בַּד-בְּבַד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003995","n","בַּדְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003999","n","בַּדְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003996","n","בַּדְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004000","n","בַּדְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01212141","a","בַּהֲמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01133146","n","בַּז","N");
INSERT INTO hebrew_lemma VALUES ("n#01134625","n","בַּז-עֵצִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004015","n","בַּזְבְּזָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004016","n","בַּזְבְּזָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10592567","n","בַּזֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("r#00162722","r","בַּחֲשַׁאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07290496","n","בַּחוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004009","n","בַּטְלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004010","n","בַּטְלָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04973475","n","בַּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04973475","n","בַּי_בַּי","N");
INSERT INTO hebrew_lemma VALUES ("n#09796150","n","בַּיְט","N");
INSERT INTO hebrew_lemma VALUES ("n#02837386","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#02838086","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#04813281","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#05976484","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#06021037","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#06070449","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#06116890","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#06393436","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#09796150","n","בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004013","n","בַּלְשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004014","n","בַּלְשָׁנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04686584","n","בַּלְשָׁנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07095815","n","בַּלָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004001","n","בַּלָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004003","n","בַּלָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004002","n","בַּלָּשִׁית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004004","n","בַּלָּשִׁית","N");
INSERT INTO hebrew_lemma VALUES ("n#04132803","n","בַּלּוּטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05770815","n","בַּנְדּוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07128703","n","בַּנַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07489798","n","בַּעֲלַת_בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#10386828","n","בַּעֲלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09525525","n","בַּעֲלוּת","N");
INSERT INTO hebrew_lemma VALUES ("r#00056554","r","בַּעֲקִיפִין","N");
INSERT INTO hebrew_lemma VALUES ("n#04591530","n","בַּעֲרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06871364","n","בַּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07331418","n","בַּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07070950","n","בַּעַל-בְּרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00008019","n","בַּעַל-חַיִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#07192423","n","בַּעַל-חוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#01768682","a","בַּעַל-כִּשָּׁרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10318432","n","בַּעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#10425626","n","בַּצֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05370393","n","בַּקָּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01692272","a","בַּר-חֲלוֹף","N");
INSERT INTO hebrew_lemma VALUES ("a#00334532","a","בַּר-מְנִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01375081","n","בַּרְבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00932728","a","בַּרְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03834766","n","בַּרְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06949518","n","בַּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07202206","n","בַּת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003886","n","בַּת-זוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#07499227","n","בַּת-מֶלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00099935","r","בַּתְּחִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01263165","v","בָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#00414175","a","בָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#00130334","a","בָּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01867344","a","בָּדוּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00117044","r","בָּהּ-בָּעֵת","N");
INSERT INTO hebrew_lemma VALUES ("a#00678779","a","בָּהוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01211520","v","בָּז","N");
INSERT INTO hebrew_lemma VALUES ("v#00455018","v","בָּחַר","N");
INSERT INTO hebrew_lemma VALUES ("a#01848451","a","בָּטוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02163862","a","בָּטוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02025056","a","בָּכִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01853436","v","בָּלַט","N");
INSERT INTO hebrew_lemma VALUES ("v#01745445","v","בָּלַם","N");
INSERT INTO hebrew_lemma VALUES ("n#02256491","n","בָּסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#04465690","n","בָּסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#09930598","n","בָּסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#02211356","n","בָּסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#02211356","n","בָּסִיס-צְבָאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00441120","a","בָּעִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#08734429","n","בָּצָל","N");
INSERT INTO hebrew_lemma VALUES ("n#08734702","n","בָּצָל","N");
INSERT INTO hebrew_lemma VALUES ("a#02389630","a","בָּקִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02389630","a","בָּקִיא","N");
INSERT INTO hebrew_lemma VALUES ("n#01899570","n","בָּקָר","N");
INSERT INTO hebrew_lemma VALUES ("n#02255304","n","בָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02254799","n","בָּרִיקָדָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00455018","v","בָּרַר","N");
INSERT INTO hebrew_lemma VALUES ("n#07805321","n","בָּרָד","N");
INSERT INTO hebrew_lemma VALUES ("n#03874574","n","בָּרָק","N");
INSERT INTO hebrew_lemma VALUES ("n#07812527","n","בָּרָק","N");
INSERT INTO hebrew_lemma VALUES ("n#04088435","n","בָּשָׂר","N");
INSERT INTO hebrew_lemma VALUES ("n#05694720","n","בָּשָׂר","N");
INSERT INTO hebrew_lemma VALUES ("n#09388596","n","בָּשָׂר","N");
INSERT INTO hebrew_lemma VALUES ("n#04321796","n","בֹּהֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#05379363","n","בֹּחַן","N");
INSERT INTO hebrew_lemma VALUES ("n#10731519","n","בֹּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03107757","n","בֹּשֶׂם","N");
INSERT INTO hebrew_lemma VALUES ("n#02586827","n","בֻּבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03189020","n","בֻּבָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00138537","v","בֻּיַּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00208649","v","בֻּיַּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00208796","v","בֻּיַּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03131951","n","בֻּכְנָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00117044","r","בּוֹ-זְמַנִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003991","n","בּוֹגֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003993","n","בּוֹגֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003992","n","בּוֹגֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003994","n","בּוֹגֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("r#00117044","r","בּוֹזְמַנִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004005","n","בּוֹחֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004017","n","בּוֹחֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004006","n","בּוֹחֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004018","n","בּוֹחֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01299804","a","בּוֹלֵט","N");
INSERT INTO hebrew_lemma VALUES ("a#01747562","a","בּוֹנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#09551149","n","בּוֹנוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00087361","n","בּוֹקְס","N");
INSERT INTO hebrew_lemma VALUES ("n#07189764","n","בּוֹקֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#05639196","n","בּוֹרְשְׁט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003997","n","בּוֹרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003998","n","בּוֹרֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05037154","n","בּוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#05577544","n","בּוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#10395158","n","בּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05493195","n","בּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#02354112","n","בּוּנְקֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#06802591","n","בּוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004011","n","בּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00791837","a","בּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00792028","a","בּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03417221","n","בּוּרְסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004012","n","בּוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04591530","n","בּוּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10360525","n","בּוּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#02966407","n","ג\'וּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01736855","n","ג\'וּק","N");
INSERT INTO hebrew_lemma VALUES ("a#00371098","a","גִ\'ינְגִ\'י","N");
INSERT INTO hebrew_lemma VALUES ("n#01934997","n","גִ\'ירָף","N");
INSERT INTO hebrew_lemma VALUES ("n#01934997","n","גִ\'ירָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03910916","n","גֶ\'נְדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#01739872","n","גּ\'וּק","N");
INSERT INTO hebrew_lemma VALUES ("n#04889243","n","גְּבִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05881045","n","גְּבִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05456179","n","גְּבֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07200414","n","גְּבֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07681693","n","גְּבֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04595466","n","גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06273824","n","גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03992325","n","גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10019175","n","גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10019535","n","גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01434711","a","גְּבוּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03806460","n","גְּבוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01913446","n","גְּדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03473484","n","גְּדִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#06096346","n","גְּדוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00772379","n","גְּזַר_דִין","N");
INSERT INTO hebrew_lemma VALUES ("n#02764776","n","גְּלִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10654891","n","גְּלָלִים","N");
INSERT INTO hebrew_lemma VALUES ("a#01512420","a","גְּלוֹבָּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04972377","n","גְּלוּיָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00052077","r","גְּלוּיוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#03123283","n","גְּלוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03123093","n","גְּלוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03123382","n","גְּלוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03123382","n","גְּלוּלָה-לִמְנִיעַת-הֵרָיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04856408","n","גְּמָרָא","N");
INSERT INTO hebrew_lemma VALUES ("n#05332420","n","גְּנִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00499179","n","גְּנֵבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05033972","n","גְּעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03804255","n","גְּרִימַת-עָוֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00101562","n","גְּרִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05836741","n","גְּרִיסִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10159752","n","גְּרִיפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00073753","n","גְּרִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00075113","n","גְּרֶפְּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07804383","n","גְּרָבִיטַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09879963","n","גְּרָם","N");
INSERT INTO hebrew_lemma VALUES ("a#00218557","a","גְּרוֹטֶסְקִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07219938","n","גְּרוּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#03019094","n","גִּבְעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06723275","n","גִּבְעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06723626","n","גִּבְעֹנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004021","n","גִּבֵּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00150780","v","גִּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004022","n","גִּבֶּנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00786967","n","גִּבּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00803600","n","גִּבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00158819","v","גִּדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01731610","v","גִּדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10226609","n","גִּדּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05331503","n","גִּדּוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00953839","v","גִּהֵץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00002561","v","גִּהֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#00380753","n","גִּהוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02867844","n","גִּהוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00075113","n","גִּהוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004028","n","גִּזְבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004029","n","גִּזְבָּרִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01859739","a","גִּזְעִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01833935","a","גִּזְעִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01860484","a","גִּזְעָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00748682","n","גִּזְעָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04702580","n","גִּזְעָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04436807","n","גִּזְרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00743026","v","גִּיֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00749110","n","גִּיּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00798373","n","גִּיּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00820277","n","גִּיּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#04110255","n","גִּיד","N");
INSERT INTO hebrew_lemma VALUES ("n#04279799","n","גִּיד","N");
INSERT INTO hebrew_lemma VALUES ("n#02777744","n","גִּיטָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03878188","n","גִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#02419477","n","גִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#10621972","n","גִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06266273","n","גִּישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("v#00632077","v","גִּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01467069","v","גִּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01467644","v","גִּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00163357","n","גִּלּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04475351","n","גִּלּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05389592","n","גִּלּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05388870","n","גִּלּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00664326","v","גִּמְגֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10334727","n","גִּמְגּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00687997","n","גִּמְגּוּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00245987","v","גִּמֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00752542","v","גִּמֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00863766","v","גִּמֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02739225","n","גִּנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06242655","n","גִּנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02738912","n","גִּנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05032286","n","גִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00026214","v","גִּרְגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00718213","v","גִּרְגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01817423","a","גֵּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01231908","a","גֵּאֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01817423","a","גֵּאֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04598408","n","גֵּאוֹמֶטְרְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05509141","n","גֵּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10395158","n","גֵּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00074431","n","גֵּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00230520","n","גֵּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00135765","n","גֵּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00136174","n","גֵּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00778442","n","גֵּרוּשִׁין","N");
INSERT INTO hebrew_lemma VALUES ("n#10520893","n","גֶּבֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#10759377","n","גֶּבֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#01310064","n","גֶּבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#07391044","n","גֶּבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#07392266","n","גֶּבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#09450405","n","גֶּזַע","N");
INSERT INTO hebrew_lemma VALUES ("n#04220839","n","גֶּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09432522","n","גֶּפֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#03364657","n","גֶּרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#04089833","n","גֶּרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#03938934","n","גֶּשֶׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#07830260","n","גֶּשֶׁם","N");
INSERT INTO hebrew_lemma VALUES ("a#01819704","a","גַּאַוְתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04306040","n","גַּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00786967","n","גַּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10405722","n","גַּבְנוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#03678106","n","גַּבְרִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03678106","n","גַּבְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04279799","n","גַּבְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04123270","n","גַּבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03250547","n","גַּג","N");
INSERT INTO hebrew_lemma VALUES ("n#03250224","n","גַּג","N");
INSERT INTO hebrew_lemma VALUES ("n#02228878","n","גַּגּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06688669","n","גַּחֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06688669","n","גַּחַל","N");
INSERT INTO hebrew_lemma VALUES ("n#06095338","n","גַּיִס","N");
INSERT INTO hebrew_lemma VALUES ("n#06189502","n","גַּיִס-חֲמִישִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#03255317","n","גַּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05477241","n","גַּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05969773","n","גַּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05601181","n","גַּלְמוּדִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02984139","n","גַּלְעֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#03448363","n","גַּלְשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("r#00046022","r","גַּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06893154","n","גַּמָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004019","n","גַּמָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#01337558","a","גַּמָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004020","n","גַּמָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02739225","n","גַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06220586","n","גַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06220715","n","גַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06242655","n","גַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02738912","n","גַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10274392","n","גַּנְגְּרֶנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07200787","n","גַּנְדְּרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02206789","n","גַּנְזַךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004027","n","גַּנֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10174999","n","גַּנַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004026","n","גַּנָּב","N");
INSERT INTO hebrew_lemma VALUES ("a#02124533","a","גַּס","N");
INSERT INTO hebrew_lemma VALUES ("a#00649057","a","גַּס","N");
INSERT INTO hebrew_lemma VALUES ("a#00606314","a","גַּס","N");
INSERT INTO hebrew_lemma VALUES ("a#00606314","a","גַּס-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05565891","n","גַּעְגּוּעִים","N");
INSERT INTO hebrew_lemma VALUES ("n#01960106","n","גַּפָּה-קִדְמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02452062","n","גַּרְדֶּרוֹבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02229021","n","גַּרְזֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#06689681","n","גַּרְעִין","N");
INSERT INTO hebrew_lemma VALUES ("n#08462710","n","גַּרְעִינִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003757","n","גַּשָּׁשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003758","n","גַּשָּׁשִׁית","N");
INSERT INTO hebrew_lemma VALUES ("a#02727539","a","גָּאלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00333978","n","גָּאלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00745640","v","גָּבַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00750517","v","גָּבַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00155084","v","גָּבַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02670460","n","גָּדֵר","N");
INSERT INTO hebrew_lemma VALUES ("v#00107371","v","גָּדַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01732007","v","גָּדַל","N");
INSERT INTO hebrew_lemma VALUES ("a#00546266","a","גָּדוֹל","N");
INSERT INTO hebrew_lemma VALUES ("a#01328712","a","גָּדוֹל","N");
INSERT INTO hebrew_lemma VALUES ("a#01617066","a","גָּדוֹל","N");
INSERT INTO hebrew_lemma VALUES ("a#02078228","a","גָּדוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#03876333","n","גָּוֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#04955518","n","גָּוֶן","N");
INSERT INTO hebrew_lemma VALUES ("v#01075277","v","גָּזַז","N");
INSERT INTO hebrew_lemma VALUES ("n#01665080","n","גָּחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00388398","a","גָּלְמִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01885093","a","גָּלְמִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00261817","v","גָּלַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01321425","v","גָּלַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00979375","a","גָּלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07252140","n","גָּלוּת-מֵרָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00803427","a","גָּמִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00975648","a","גָּמִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00337013","v","גָּמַר","N");
INSERT INTO hebrew_lemma VALUES ("n#01933103","n","גָּמָל","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","גָּמוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00559552","v","גָּעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#10502703","n","גָּפְרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10808144","n","גָּפְרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01809405","v","גָּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00523422","v","גָּרַם","N");
INSERT INTO hebrew_lemma VALUES ("v#01130277","v","גָּרַם","N");
INSERT INTO hebrew_lemma VALUES ("n#02738353","n","גָּרָז\'","N");
INSERT INTO hebrew_lemma VALUES ("a#00938029","a","גָּרוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07219938","n","גָּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01421281","a","גָּרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03990044","n","גֹּדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01815040","n","גֹּלֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#01814863","n","גֹּלֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#07383205","n","גֹּלֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#02895368","n","גֻּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02895469","n","גֻּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02966407","n","גֻּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10012749","n","גֻּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07547514","n","גּוֹאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#01135737","n","גּוֹזָל","N");
INSERT INTO hebrew_lemma VALUES ("n#00123083","n","גּוֹל","N");
INSERT INTO hebrew_lemma VALUES ("v#01046121","v","גּוֹלֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#07252035","n","גּוֹלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#09888197","n","גּוֹרֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#09767402","n","גּוֹרֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#10381983","n","גּוֹרָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02485388","n","גּוּמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10769087","n","גּוּמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04774665","n","גּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#04055158","n","גּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#04055717","n","גּוּף-הָאָדָם","N");
INSERT INTO hebrew_lemma VALUES ("n#04056524","n","גּוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00935806","a","גּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07195668","n","גּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00866210","n","גּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00866478","n","גּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05593817","n","דְּאָגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03783864","n","דְּבֵקוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05887861","n","דְּבַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00187201","n","דְּהִירָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00184935","r","דְּהַיְנוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#00229544","n","דְּחִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03863303","n","דְּחִיסוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04028238","n","דְּחִיפוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10368281","n","דְּחִיפוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02344831","n","דְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09913096","n","דְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05532335","n","דְּלִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00206677","n","דְּלִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05772123","n","דְּלַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#08464304","n","דְּלַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#05137171","n","דְּמִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09714984","n","דְּמִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09572926","n","דְּמֵי-שְׁתִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05317127","n","דְּמוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00761046","n","דְּקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04528749","n","דְּרִישַׁת-קְדָם","N");
INSERT INTO hebrew_lemma VALUES ("n#04974383","n","דְּרִישַׁת-שָׁלוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#10367157","n","דְּרִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#04528955","n","דְּרִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#00577992","n","דְּרָמָטִיזַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00651246","v","דִּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00638109","v","דִּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00651246","v","דִּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00522215","v","דִּבֵּר-עַל-לִבּוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#00093873","n","דִּגְדּוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#05340429","n","דִּיּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05342032","n","דִּיּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#03768956","n","דִּיּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#02839091","n","דִּיּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00099504","n","דִּיאַגְנוֹזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10157458","n","דִּיאָבֶּטִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#05352409","n","דִּיאָלֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#05073174","n","דִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#02571784","n","דִּימֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04537256","n","דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#06060223","n","דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#07766144","n","דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#05368498","n","דִּין-וּדְבָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04594727","n","דִּיסְצִיפְּלִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02551422","n","דִּיפּ-פְרִיז","N");
INSERT INTO hebrew_lemma VALUES ("n#04864239","n","דִּיפְּלוֹמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06200783","n","דִּירֶקְטוֹרְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03434438","n","דִּירַת-סְטוּדְיוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#02199402","n","דִּירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01916377","n","דִּישׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10888065","n","דִּמְדּוּמִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03730047","n","דִּמְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05317845","n","דִּמּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05319077","n","דִּמּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05407138","n","דִּקְלוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00455463","n","דִּקּוּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00035125","r","דֵּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00103672","r","דֵּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00141645","r","דֵּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00141865","r","דֵּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00280549","r","דֵּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01077153","a","דֵּי-טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#04564824","n","דֵּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05079660","n","דֵּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07214409","n","דֶּאוּס-אֶקְס-מָכִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10169961","n","דֶּבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10831619","n","דֶּטֶרְגֶּנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#03218660","n","דֶּלְפֵּק-קַבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10528091","n","דֶּלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#10669661","n","דֶּלֶק","N");
INSERT INTO hebrew_lemma VALUES ("a#00697814","a","דֶּסְקְרִיפְּטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004031","n","דֶּפֶטִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004032","n","דֶּפֶטִיסְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00803947","n","דֶּצֶנְטְרָלִיזַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10001823","n","דֶּקָגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02550579","n","דֶּקוֹרַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04627248","n","דֶּרְמָטוֹלוֹגְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00112808","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00266805","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02653712","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03243979","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03858557","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#09939326","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03856995","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02159544","n","דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03851783","n","דֶּרֶךְ-אֶרֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#10657851","n","דֶּשֶׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#10012108","n","דַּבֶּשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#01717162","n","דַּבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04302960","n","דַּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00145000","r","דַּוְקָא","N");
INSERT INTO hebrew_lemma VALUES ("n#03099621","n","דַּוְשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#05131232","n","דַּוְשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#03280310","n","דַּחְלִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#02350401","n","דַּחְפּוֹר","N");
INSERT INTO hebrew_lemma VALUES ("r#00017767","r","דַּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05902479","n","דַּיְסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00288131","n","דַּיִג","N");
INSERT INTO hebrew_lemma VALUES ("n#00288265","n","דַּיִג","N");
INSERT INTO hebrew_lemma VALUES ("n#00252246","n","דַּיִשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07266374","n","דַּיָּג","N");
INSERT INTO hebrew_lemma VALUES ("n#07611457","n","דַּיֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07635964","n","דַּיָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07636191","n","דַּיָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07636278","n","דַּיָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10397144","n","דַּלּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#08015110","n","דַּפְנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08015534","n","דַּפְנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04955518","n","דַּקּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07389783","n","דַּרְדַּק","N");
INSERT INTO hebrew_lemma VALUES ("n#08251864","n","דַּרְדַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06819534","n","דַּרְלִינג","N");
INSERT INTO hebrew_lemma VALUES ("n#02907151","n","דַּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01288660","v","דָּאָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01288913","v","דָּאָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01323578","v","דָּאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02757129","n","דָּאוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03495843","n","דָּבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06847052","n","דָּבָר-לֹא-הֶכְרֵחִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00775186","v","דָּג","N");
INSERT INTO hebrew_lemma VALUES ("v#00900840","v","דָּג","N");
INSERT INTO hebrew_lemma VALUES ("n#00969494","n","דָּגִיג","N");
INSERT INTO hebrew_lemma VALUES ("v#01334516","v","דָּהַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01334879","v","דָּהַר","N");
INSERT INTO hebrew_lemma VALUES ("a#00678779","a","דָּחוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#00507880","a","דָּלִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00441120","a","דָּלִיק","N");
INSERT INTO hebrew_lemma VALUES ("v#00176221","v","דָּלַף","N");
INSERT INTO hebrew_lemma VALUES ("v#00633898","v","דָּלַף","N");
INSERT INTO hebrew_lemma VALUES ("v#00634658","v","דָּלַף","N");
INSERT INTO hebrew_lemma VALUES ("v#00295171","v","דָּלַק","N");
INSERT INTO hebrew_lemma VALUES ("n#01945877","n","דָּלָק","N");
INSERT INTO hebrew_lemma VALUES ("v#00613914","v","דָּן","N");
INSERT INTO hebrew_lemma VALUES ("v#01433087","v","דָּרַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01432910","v","דָּרַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00562059","v","דָּרַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00808096","v","דָּרַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01792695","v","דָּרַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09965063","n","דָּרוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#04565571","n","דָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06023733","n","דָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04736420","n","דֹּאַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06064102","n","דֹּאַר-שָׁמוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#01640332","n","דֹּב","N");
INSERT INTO hebrew_lemma VALUES ("n#07105643","n","דֹּב","N");
INSERT INTO hebrew_lemma VALUES ("r#00109581","r","דֹּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04483764","n","דֻּגְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04549495","n","דֻּגְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04559362","n","דֻּגְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02251357","n","דּוֹבְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07601647","n","דּוֹבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07091771","n","דּוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02592220","n","דּוֹזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003701","n","דּוֹקְטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003702","n","דּוֹקְטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04923025","n","דּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#01346765","n","דּוּכִיפַת","N");
INSERT INTO hebrew_lemma VALUES ("n#06265145","n","דּוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00109581","r","דּוּמָם","N");
INSERT INTO hebrew_lemma VALUES ("n#10031143","n","דּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04923025","n","דו&quotח-תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04755856","n","הֲבָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05333921","n","הֲגִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00031327","n","הֲגִירָה-יוֹצֵאת","N");
INSERT INTO hebrew_lemma VALUES ("n#00031422","n","הֲגִירָה-נִכְנֶסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00528304","n","הֲגָנָה-עַצְמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05385339","n","הֲדִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00616711","n","הֲדִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01877861","a","הֲדָדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10315277","n","הֲזָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00684853","n","הֲזָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09698815","n","הֲטָלַת-בֵּיצִים","N");
INSERT INTO hebrew_lemma VALUES ("n#09698815","n","הֲטָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00660588","n","הֲלִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00766856","n","הֲלִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00766856","n","הֲלִיכִים-מִשְׁפָּטִיִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#05077026","n","הֲלָצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01052403","a","הֲמוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00471513","n","הֲסָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00742390","n","הֲפִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00037744","n","הֲפֵכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00742390","n","הֲפֵכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00746155","n","הֲפָסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00687814","n","הֲפוּגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00450672","n","הֲצָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00564046","n","הֲצָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00075786","n","הֲקָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00811339","n","הֲרִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00074216","n","הֲרָמָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00438616","v","הִבְדִּיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00439665","v","הִבְדִּיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00420545","v","הִבְהִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01478422","v","הִבְהֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01888444","v","הִבְהֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01501559","v","הִבְחִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00438616","v","הִבְחִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00603511","v","הִבְטִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00358494","v","הִבְלִיט","N");
INSERT INTO hebrew_lemma VALUES ("v#01154777","v","הִבְרִיק","N");
INSERT INTO hebrew_lemma VALUES ("v#00631861","v","הִבִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00157585","v","הִגְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00104604","v","הִגְדִּיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00569024","v","הִגְזִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01751567","v","הִגְזִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01703298","v","הִגְלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00134840","v","הִגְעִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00506398","v","הִגִּיד","N");
INSERT INTO hebrew_lemma VALUES ("v#00682542","v","הִגִּיד","N");
INSERT INTO hebrew_lemma VALUES ("v#01568149","v","הִגִּישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01737017","v","הִגִּישׁ-עֶזְרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00289068","v","הִגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05333921","n","הִגּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00358208","v","הִדְגִּישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00685448","v","הִדְגִּישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00679313","v","הִדְפִּיס","N");
INSERT INTO hebrew_lemma VALUES ("v#01338825","v","הִדַּרְדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01638892","v","הִדִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01581572","v","הִדִּיר-אוֹתוֹ-מִנְּכָסָיו","N");
INSERT INTO hebrew_lemma VALUES ("n#00096215","n","הִדּוּק","N");
INSERT INTO hebrew_lemma VALUES ("v#00979971","v","הִזְדַּוֵּג","N");
INSERT INTO hebrew_lemma VALUES ("n#00212689","n","הִזְדַּחֲלוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00977560","v","הִזְדַּיֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10390345","n","הִזְדַּמְּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00695868","v","הִטְבִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#05317607","n","הִיפֶּרְבּוֹלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02097138","a","הִיפּוֹקְרִיטִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00691426","v","הִכְלִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00574815","v","הִכְפִּישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00654101","v","הִכְרִיז","N");
INSERT INTO hebrew_lemma VALUES ("v#00424940","v","הִכְתִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00506658","v","הִכְתִּיב","N");
INSERT INTO hebrew_lemma VALUES ("n#10041978","n","הִכָּלְלוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00285796","v","הִלְאִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00191916","v","הִלְבִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#01098741","v","הִלְחִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01169420","v","הִלְחִין","N");
INSERT INTO hebrew_lemma VALUES ("v#01303950","v","הִלֵּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07821579","n","הִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02688619","n","הִלּוּךְ-רִאשׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00815376","n","הִמְהוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05275813","n","הִמְנוֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00371203","v","הִמְתִּיק","N");
INSERT INTO hebrew_lemma VALUES ("n#00133654","n","הִמָּנְעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10859737","n","הִמָּשְׁכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09607798","n","הִמּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00513119","n","הִמּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01807979","v","הִנְצִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00428091","v","הִנִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00427776","v","הִנִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00635987","v","הִסְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00636437","v","הִסְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00722994","v","הִסְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00420545","v","הִסְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00188350","v","הִסְדִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00518436","v","הִסְדִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01542655","v","הִסְדִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00546534","v","הִסְכִּים","N");
INSERT INTO hebrew_lemma VALUES ("v#01841740","v","הִסְכִּים","N");
INSERT INTO hebrew_lemma VALUES ("v#00541962","v","הִסְכִּים","N");
INSERT INTO hebrew_lemma VALUES ("v#00596971","v","הִסְפִּיד","N");
INSERT INTO hebrew_lemma VALUES ("v#01821274","v","הִסְפִּיק","N");
INSERT INTO hebrew_lemma VALUES ("v#01824318","v","הִסְרִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01453522","v","הִסְרִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03603464","n","הִסְתַּבְּכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09743067","n","הִסְתַּגְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06112041","n","הִסְתַּדְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01780558","v","הִסְתַּדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01675140","v","הִסְתַּדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01785226","v","הִסְתַּדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00028653","v","הִסְתַּדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05067166","n","הִסְתַּיְּגוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01779664","v","הִסְתַּיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00605096","n","הִסְתַּכְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","הִסְתַּלְבֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00029100","n","הִסְתַּלְּקוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00628795","n","הִסְתַּנְּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00627161","n","הִסְתַּעֲרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00219234","n","הִסְתּוֹבְבוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01283094","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01436577","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01301287","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01396866","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01628048","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01284430","v","הִסְתּוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01802820","v","הִסֵּס","N");
INSERT INTO hebrew_lemma VALUES ("v#01803236","v","הִסֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#03663200","n","הִסּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#04403483","n","הִסּוּס","N");
INSERT INTO hebrew_lemma VALUES ("v#01464775","v","הִפְגִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#01467644","v","הִפְגִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#01728504","v","הִפְגִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#01241470","v","הִפְחִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#00613501","v","הִפְחִית_","N");
INSERT INTO hebrew_lemma VALUES ("v#00783825","v","הִפְנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00782270","v","הִפְנָה-שְׁאֵלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00253202","v","הִפְסִיק","N");
INSERT INTO hebrew_lemma VALUES ("v#01829006","v","הִפְסִיק","N");
INSERT INTO hebrew_lemma VALUES ("v#00516262","v","הִפְצִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00438616","v","הִפְרִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#00569024","v","הִפְרִיז","N");
INSERT INTO hebrew_lemma VALUES ("v#00553491","v","הִפְרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00490924","v","הִפְרִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00035494","v","הִפְשִׁיט","N");
INSERT INTO hebrew_lemma VALUES ("n#00277973","n","הִפּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05515974","n","הִפּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#09984290","n","הִפּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00199381","v","הִצְהִיב","N");
INSERT INTO hebrew_lemma VALUES ("v#01453522","v","הִצְחִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00103366","v","הִצְטַמְצֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#00165232","v","הִצְטַמֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#01658042","v","הִצְטָרֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#01773236","v","הִצְטָרֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#00885494","v","הִצְמִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#01792695","v","הִצְרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01464775","v","הִצִּיג","N");
INSERT INTO hebrew_lemma VALUES ("v#01467644","v","הִצִּיג","N");
INSERT INTO hebrew_lemma VALUES ("v#01470807","v","הִצִּיג","N");
INSERT INTO hebrew_lemma VALUES ("v#01728504","v","הִצִּיג","N");
INSERT INTO hebrew_lemma VALUES ("v#00592804","v","הִצִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01571054","v","הִצִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00610465","v","הִקְבִּיל-אֶת-פָּנָיו","N");
INSERT INTO hebrew_lemma VALUES ("v#01364150","v","הִקְדִּים","N");
INSERT INTO hebrew_lemma VALUES ("v#00308251","v","הִקְטִין","N");
INSERT INTO hebrew_lemma VALUES ("v#01528254","v","הִקְצָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01441871","v","הִרְגִּישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00014590","v","הִרְדִּים","N");
INSERT INTO hebrew_lemma VALUES ("v#00819436","v","הִרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00032369","v","הִרְזָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01670331","v","הִרְחִיק","N");
INSERT INTO hebrew_lemma VALUES ("v#01052778","v","הִרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#01137704","v","הִרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#01080919","v","הִרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00058927","v","הִרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#01788354","v","הִרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00613686","v","הִרְשִׁיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01722366","v","הִשִּׂיג","N");
INSERT INTO hebrew_lemma VALUES ("v#00560756","v","הִשִּׂיג","N");
INSERT INTO hebrew_lemma VALUES ("v#00598488","v","הִשְׁוִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00338284","v","הִשְׁלִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00644607","v","הִשְׁמִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00574026","v","הִשְׁמִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00330961","v","הִשְׁקִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00330720","v","הִשְׁקִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01052666","v","הִשְׁתִּיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00050470","v","הִשְׁתִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#00356023","v","הִשְׁתַּזֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00598488","v","הִשְׁתַּחְצֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#01234562","v","הִשְׁתַּלֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#05066308","n","הִשְׁתַּמְּטוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00476851","n","הִשְׁתַּמְּטוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00074063","v","הִשְׁתַּנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05441797","n","הִשְׁתַּנּוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00004183","v","הִשְׁתַּעֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#03224208","n","הִשְׁתַּקְּפוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00804778","n","הִשְׁתַּתְּפוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05582358","n","הִשְׁתָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05582358","n","הִשְׁתּוֹמְמוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05564936","n","הִשְׁתּוֹקְקוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05565891","n","הִשְׁתּוֹקְקוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01565625","v","הִשְׂתַּכֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00155072","n","הִתְאַגְּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00256707","v","הִתְאַדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09738922","n","הִתְאַדּוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00257011","v","הִתְאַחֵד","N");
INSERT INTO hebrew_lemma VALUES ("v#01789163","v","הִתְאַחֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#00574902","n","הִתְאַמְּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00409147","v","הִתְאַמֵּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00067976","v","הִתְאַמֵּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00219507","v","הִתְאָרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05521978","n","הִתְאוֹשְׁשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00331800","n","הִתְבַּדְּחוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00071715","v","הִתְבַּדֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00578703","v","הִתְבַּדֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00783936","v","הִתְבַּיֵּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00261111","n","הִתְבַּלְּטוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03647110","n","הִתְבּוֹדְדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00565102","n","הִתְבּוֹנְנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05455668","n","הִתְגַּבְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07765923","n","הִתְגַּבְּשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00750517","v","הִתְגַּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00155084","v","הִתְגַּבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00742311","v","הִתְגַּיֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#07470212","n","הִתְגַּלְּמוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00792860","n","הִתְגָּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00528304","n","הִתְגּוֹנְנוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01809405","v","הִתְגּוֹרֵר","N");
INSERT INTO hebrew_lemma VALUES ("v#00182381","v","הִתְדַּלְדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00252195","v","הִתְהַוָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00277973","n","הִתְהַפְּכוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01302894","v","הִתְהַפֵּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01275270","v","הִתְהַפֵּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00610889","v","הִתְוַדֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00592223","v","הִתְוַדֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00242403","v","הִתְחִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#01133757","v","הִתְחִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00239960","v","הִתְחִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#01778989","v","הִתְחִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00881541","v","הִתְחַבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01789163","v","הִתְחַבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01539216","v","הִתְחַבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05455668","n","הִתְחַזְּקוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00155084","v","הִתְחַזֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05074715","n","הִתְחַיְּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10395519","n","הִתְחַיְּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05441797","n","הִתְחַלְּפוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01544679","v","הִתְחַלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00074063","v","הִתְחַלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00163821","v","הִתְחַמְצֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#00476851","n","הִתְחַמְּקוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02642566","n","הִתְחַפְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00206842","n","הִתְחַקּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03794865","n","הִתְחַשְּׁבוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00643556","v","הִתְחַשֵּׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#00727087","v","הִתְחָרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00149731","v","הִתְיַבֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00820543","n","הִתְיַעֲצוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05343797","n","הִתְיַעֲצוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00047059","v","הִתְיַפֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00750993","n","הִתְיַצְּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01235891","v","הִתְיָאֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04968827","n","הִתְכַּתְּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00680786","v","הִתְכַּתֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03655378","n","הִתְלַהֲבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04383528","n","הִתְלַהֲבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05616611","n","הִתְלַהֲבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00244814","n","הִתְמַזְּגוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01825948","v","הִתְמַקֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#10859737","n","הִתְמַשְּׁכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00617685","n","הִתְמָרְדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00762791","n","הִתְמָרְדוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00589434","v","הִתְמוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("v#00727087","v","הִתְמוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("v#01763911","v","הִתְמוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#00132311","n","הִתְנַגְּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05385605","n","הִתְנַגְּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05409439","n","הִתְנַגְּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00548744","v","הִתְנַגֵּד","N");
INSERT INTO hebrew_lemma VALUES ("v#00845185","v","הִתְנַגֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02398582","a","הִתְנַדְּבוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09738922","n","הִתְנַדְּפוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00256707","v","הִתְנַדֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#01717501","v","הִתְנַהֵג","N");
INSERT INTO hebrew_lemma VALUES ("v#00813536","v","הִתְנַזֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00010240","v","הִתְנַמְנֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#04406104","n","הִתְנַפְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00924489","v","הִתְעַוֵּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10274793","n","הִתְעַטְּשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00003595","v","הִתְעַטֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00268796","n","הִתְעַלְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01715663","v","הִתְעַלֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00016435","v","הִתְעַלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00134937","n","הִתְעַלּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10075760","n","הִתְעַלּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10075760","n","הִתְעַלּוּת-הַנֶּפֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00275488","n","הִתְעַמְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00411620","n","הִתְעַמְּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05455668","n","הִתְעַצְּמוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00155084","v","הִתְעַצֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04995117","n","הִתְעָרְבוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01670845","v","הִתְעָרֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01730921","v","הִתְעָרֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#00818293","n","הִתְעוֹרְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00371203","v","הִתְפִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#05414101","n","הִתְפַּטְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00427080","v","הִתְפַּלְסֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#00525851","v","הִתְפַּלְפֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00626227","v","הִתְפַּלֵּא","N");
INSERT INTO hebrew_lemma VALUES ("v#00516449","v","הִתְפַּלֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00694512","n","הִתְפַּנְּקוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00701844","v","הִתְפַּשֵּׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#00700989","v","הִתְפַּשֵּׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#00701304","v","הִתְפַּשֵּׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#06302980","n","הִתְפַּתְּחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09724860","n","הִתְפַּתְּחוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01285061","v","הִתְפַּתֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10069174","n","הִתְפָּרְעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00362034","n","הִתְפָּרְצוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05261864","n","הִתְפָּרְצוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05531291","n","הִתְפָּרְצוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00502562","n","הִתְפָּרְצוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01080919","v","הִתְקִין","N");
INSERT INTO hebrew_lemma VALUES ("n#00159609","n","הִתְקַדְּמוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05489950","n","הִתְקַדְּמוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00169694","v","הִתְקַדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#01358414","v","הִתְקַדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00235191","v","הִתְקַיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#01784619","v","הִתְקַיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00143719","v","הִתְקַלְקֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01404337","v","הִתְקָרֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#00617685","n","הִתְקוֹמְמוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00598488","v","הִתְרַבְרֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#09730422","n","הִתְרַחֲבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05432762","n","הִתְרַחֲשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01670331","v","הִתְרַחֵק","N");
INSERT INTO hebrew_lemma VALUES ("v#00235191","v","הִתְרַחֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09671783","n","הִתְרַכְּכוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01825948","v","הִתְרַכֵּז","N");
INSERT INTO hebrew_lemma VALUES ("v#00590442","v","הִתְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05487790","n","הִתְרוֹמְמוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10075760","n","הִתְרוֹמְמוּת-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00745902","n","הִתְרוֹשְׁשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01154430","v","הִתִּיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00877495","v","הִתִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","הִתֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00305843","v","הֵאִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00306811","v","הֵאִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00015408","v","הֵבִיא","N");
INSERT INTO hebrew_lemma VALUES ("v#01722366","v","הֵבִיא","N");
INSERT INTO hebrew_lemma VALUES ("v#01782390","v","הֵבִיא","N");
INSERT INTO hebrew_lemma VALUES ("v#00397666","v","הֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00399152","v","הֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00400923","v","הֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00401225","v","הֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00401413","v","הֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00311901","v","הֵגִיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00485595","v","הֵגִיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00554194","v","הֵגִיב","N");
INSERT INTO hebrew_lemma VALUES ("v#01263706","v","הֵזִיז","N");
INSERT INTO hebrew_lemma VALUES ("v#00047342","v","הֵזִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00239960","v","הֵחֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#05455349","n","הֵחָלְשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00050470","v","הֵטִיל-מַיִם","N");
INSERT INTO hebrew_lemma VALUES ("r#00010099","r","הֵיטֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01796995","v","הֵכִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#06955549","n","הֵלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07433746","n","הֵלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07672456","n","הֵלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00111031","v","הֵמִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01617829","v","הֵעֵז","N");
INSERT INTO hebrew_lemma VALUES ("v#01735366","v","הֵעֵז","N");
INSERT INTO hebrew_lemma VALUES ("n#00741201","n","הֵעָרְכוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01750236","v","הֵפֵר","N");
INSERT INTO hebrew_lemma VALUES ("v#01234562","v","הֵצִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01482148","v","הֵצִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00210095","v","הֵצֵר","N");
INSERT INTO hebrew_lemma VALUES ("v#00053004","v","הֵקִיא","N");
INSERT INTO hebrew_lemma VALUES ("v#01064709","v","הֵקִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01131591","v","הֵקִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01140839","v","הֵקִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00613501","v","הֵקֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01343923","v","הֵרִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00617516","v","הֵרִים-אֶת-קוֹלוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#10117409","n","הֵרָיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00554194","v","הֵשִׁיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00541962","v","הֵשִׁיב-בְּחִיּוּב","N");
INSERT INTO hebrew_lemma VALUES ("v#00460650","v","הֶאֱמִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00461366","v","הֶאֱמִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00461554","v","הֶאֱמִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00497762","v","הֶאֱמִין_בְּ","N");
INSERT INTO hebrew_lemma VALUES ("v#00220504","v","הֶאֱרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03950799","n","הֶאָטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00235112","n","הֶגְבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06191189","n","הֶגְמוֹנְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05321825","n","הֶגֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04046959","n","הֶגֶה-הַשִּׁלְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00974953","v","הֶחְדִּיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01652221","v","הֶחְזִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01545633","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01544679","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01430837","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#00115962","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#00385513","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01639012","v","הֶחְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#00145474","v","הֶחְמִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00320369","v","הֶחְמִיץ","N");
INSERT INTO hebrew_lemma VALUES ("v#01319179","v","הֶחְנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01554470","v","הֶחְרִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00490373","v","הֶחְשִׁיב","N");
INSERT INTO hebrew_lemma VALUES ("v#H0003469","v","הֶחְשִׁיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00066451","v","הֶחֱיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10488178","n","הֶלְיוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#02814163","n","הֶלִיקוֹפְּטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04465274","n","הֶסְבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05050688","n","הֶסְבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05365792","n","הֶסְדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04466733","n","הֶסְכֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10065762","n","הֶסְכֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06735707","n","הֶעְתֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#01429473","v","הֶעֱבִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01526289","v","הֶעֱבִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01582621","v","הֶעֱבִיר-אוֹתוֹ-מִיְּרֻשָּׁתוֹ","N");
INSERT INTO hebrew_lemma VALUES ("v#00575170","v","הֶעֱלִיב","N");
INSERT INTO hebrew_lemma VALUES ("v#00108988","v","הֶעֱלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00693379","v","הֶעֱלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01343923","v","הֶעֱלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01200852","v","הֶעֱלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01064709","v","הֶעֱמִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#00445269","v","הֶעֱרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01544040","v","הֶעֱרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00469237","v","הֶעֱרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00459984","v","הֶעֱרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05068616","n","הֶעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05558471","n","הֶפְסֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#00246501","n","הֶפְסֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#05137171","n","הֶפְסֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#09984290","n","הֶפֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10001597","n","הֶפְּטָגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00723443","n","הֶצֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10001524","n","הֶקְסָגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03991813","n","הֶקֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#06667120","n","הֶקֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03979387","n","הֶקֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#09993826","n","הֶקֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10045533","n","הֶקֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#04455499","n","הֶקֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06086825","n","הֶרְכֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03860186","n","הֶרְכֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10263905","n","הֶרְנְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00141128","n","הֶרֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#05465405","n","הֶרֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#03806460","n","הֶרוֹאִיזְם","N");
INSERT INTO hebrew_lemma VALUES ("n#02816318","n","הֶרוֹאִין","N");
INSERT INTO hebrew_lemma VALUES ("n#00020977","n","הֶשֵּׂג","N");
INSERT INTO hebrew_lemma VALUES ("n#03790984","n","הֶשֵּׂגִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00738404","n","הֶתֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00739664","n","הַאֲצָלַת-סַמְכֻיּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00657628","n","הַאֲרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00096864","n","הַאֲרָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05035457","n","הַאֲשָׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04434578","n","הַבְחָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04568216","n","הַבְטָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05396507","n","הַבְטָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00721552","n","הַבְרָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04467595","n","הַבְרָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00379645","n","הַבְרָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07739854","n","הַבְּתוּלָה-הַקְּדוֹשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#06889957","n","הַבֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00516738","n","הַגְבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04502083","n","הַגְבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00240731","n","הַגְבָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00235112","n","הַגְבָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03701336","n","הַגְדָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05054071","n","הַגְדָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00236516","n","הַגְזָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05064555","n","הַגְזָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00136174","n","הַגְלָיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02321283","a","הַגָּבוֹהַּ-בְּיוֹתֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#06861200","n","הַגּוֹרָל","N");
INSERT INTO hebrew_lemma VALUES ("n#05149300","n","הַדְגָּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04825639","n","הַדְפָּסָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01093726","a","הַדְרָגָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00521002","n","הַדְרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00742277","n","הַדְרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00062816","n","הַדְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00103904","n","הַזְמָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05371036","n","הַזְמָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00542336","n","הַזְרָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10749997","n","הַזָּהָב-הַשָּׁחֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#00517535","n","הַחְזָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00678772","n","הַחְיָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00058314","n","הַחְלָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09718984","n","הַחְלָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00719451","n","הַחְלָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00129213","n","הַחְלָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00232935","n","הַחְלָשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#09735288","n","הַחְמָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00141128","n","הַחְרָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00052209","n","הַחְרָמָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02108714","a","הַחֲמִשִּׁים","N");
INSERT INTO hebrew_lemma VALUES ("n#05960426","n","הַחֵרְשִׁים","N");
INSERT INTO hebrew_lemma VALUES ("n#06206464","n","הַחֶבְרָה-הַגְּבוֹהָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00670476","n","הַטְבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04439113","n","הַטְבָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00270946","n","הַטְרָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05034327","n","הַטָּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05407766","n","הַטָּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06206464","n","הַי-סוֹסָיֶטִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00184935","r","הַיְנוּ","N");
INSERT INTO hebrew_lemma VALUES ("r#00046870","r","הַיּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00203867","r","הַיּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00047077","r","הַיּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#00239677","n","הַכְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04453175","n","הַכְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04543301","n","הַכְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09542885","n","הַכְנָסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00207301","n","הַכְנָסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09538207","n","הַכְנָסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09540718","n","הַכְנָסָה-נְקִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09540718","n","הַכְנָסָה-נֶטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#05043361","n","הַכְרָזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00574678","n","הַכְשָׁרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05354380","n","הַכְתָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05359574","n","הַכְתָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00177796","n","הַכְתָּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05541618","n","הַכְתָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00746627","n","הַלְאָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03560325","n","הַלְבָּשָׁה-תַּחְתּוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00708190","n","הַלְוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09651550","n","הַלְוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05540129","n","הַלְוָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00096699","n","הַלְחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00752563","n","הַלְקָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00577992","n","הַמְחָזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05541618","n","הַמְלָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05002823","n","הַמְלָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05018986","n","הַמְלָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00601160","n","הַמְצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00657384","n","הַמְשָׁכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00227941","n","הַמְתָּקַת-דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#05977849","n","הַמִּשְׁפָּחָה_הַמֻּרְחֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03482557","n","הַמָּסָךְ-הַקָּטָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04598408","n","הַנְדָּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04660658","n","הַנְדָּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00734610","n","הַנְהָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06201180","n","הַנְהָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00521002","n","הַנְחָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00742277","n","הַנְחָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00211411","n","הַנְמָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06860410","n","הַנִּסְתָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07731120","n","הַנּוֹצְרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00139574","n","הַסְגָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05483217","n","הַסְדָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00514820","n","הַסְדָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02372458","n","הַסְוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00235973","n","הַסְלָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00107544","n","הַסְמָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00582602","n","הַסְרָטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06860910","n","הַסִּבָּה-הָעִלָּה-הָרִאשׁוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06860910","n","הַסִּבָּה-הָרִאשׁוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06062754","n","הַסָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00658241","n","הַעְתָּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00717034","n","הַעְתָּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10910256","n","הַעֲלָאַת-מִרְיָם","N");
INSERT INTO hebrew_lemma VALUES ("n#03984405","n","הַעֲלָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00074216","n","הַעֲלָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00130078","n","הַעֲלָאָה-בְּדַרְגָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09725201","n","הַעֲמָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00751324","n","הַעֲנָשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#00240731","n","הַעֲצָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00561814","n","הַעֲרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00793474","n","הַפְחָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00225760","n","הַפְחָתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00203158","n","הַפְלָגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05002955","n","הַפְנָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05068012","n","הַפְנָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03646609","n","הַפְנָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10969750","n","הַפְסָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00687814","n","הַפְסָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00688153","n","הַפְסָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00629628","n","הַפְצָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00052487","n","הַפְקָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06200584","n","הַפְרָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05064555","n","הַפְרָזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00013018","n","הַפְשָׁטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07818171","n","הַפְשָׁרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00361333","n","הַפְתָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05442564","n","הַפְתָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05582875","n","הַפְתָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05456093","n","הַפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00149581","n","הַפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00149696","n","הַפָּלָה-טִבְעִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05049744","n","הַצְהָרָה-בִּשְׁבוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00087268","n","הַצְלָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05464222","n","הַצְּלִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05998735","n","הַצְּלָב-הָאָדֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#00077753","n","הַצָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05157784","n","הַצָּגַת-בְּכוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05391158","n","הַצָּגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07731120","n","הַצָּלוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05355200","n","הַצָּעַת-נִשּׂוּאִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05357635","n","הַצָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05370271","n","הַצָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05355066","n","הַצָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05355488","n","הַצָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00243460","n","הַצָּתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02849030","n","הַצָּתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09753841","n","הַצָּתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04821883","n","הַקְדָּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00816996","n","הַקְדָּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04772608","n","הַקְטָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04729099","n","הַקְנָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03681984","n","הַקְפָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06711088","n","הַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06748290","n","הַר-קֶרַח","N");
INSERT INTO hebrew_lemma VALUES ("n#09922518","n","הַרְבֵּה","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","הַרְבֵּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01488913","a","הַרְבֵּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00014045","n","הַרְגָּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#08084960","n","הַרְדּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00261237","n","הַרְחָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00178358","n","הַרְטָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00527847","n","הַרְכָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00244304","n","הַרְכָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00585619","n","הַרְכָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02799373","n","הַרְמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04023878","n","הַרְסָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00509169","n","הַרְפַּתְקָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00068206","a","הַרְפַּתְקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03674564","n","הַרְפַּתְקָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00573978","n","הַרְצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05035599","n","הַרְצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05406019","n","הַרְצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00646207","n","הַרְשָׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00027235","n","הַרְשָׁמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00046246","n","הַשָּׂגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00708190","n","הַשְׁאָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05317845","n","הַשְׁאָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00735967","n","הַשְׁגָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09980356","n","הַשְׁוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00093090","n","הַשְׁוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00121287","n","הַשְׁוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00258970","n","הַשְׁחָתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00035222","n","הַשְׁלָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09720867","n","הַשְׁמָטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03792664","n","הַשְׁעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00175673","n","הַשְׁפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05580938","n","הַשְׁפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10360768","n","הַשְׁפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00984974","n","הַשְׁקָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00712429","n","הַשְׁקָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05484185","n","הַשְׁקָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09599330","n","הַשְׁקָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09717059","n","הַשְׁתָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00372370","n","הַשְׂכָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09927753","n","הַתְאָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00153241","n","הַתְחָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04515071","n","הַתְחָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10965545","n","הַתְחָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00659771","n","הַתְמָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09688586","n","הַתְפָּלַת-מַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#09688586","n","הַתְפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05395080","n","הַתְרָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01967203","n","הָאָדָם","N");
INSERT INTO hebrew_lemma VALUES ("a#02427824","a","הָבִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00589915","a","הָגוּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00297331","v","הָלַךְ-לְאִבּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#10315277","n","הָלוּצִינַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09922518","n","הָמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09920124","n","הָמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03524562","n","הָעִירִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02321283","a","הָעֶלְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06024128","n","הָעוֹלָם-הַנּוֹצְרִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01791776","v","הָפַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01303191","v","הָפַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00390255","v","הָפַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00188908","v","הָפַךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00216022","r","הָפוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07430101","n","הָרַךְ-הַנּוֹלָד","N");
INSERT INTO hebrew_lemma VALUES ("n#07142917","n","הָרוּג","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","הָרוּג","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","הָרוּג","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","הָרוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#06509050","n","הֹדּוּ","N");
INSERT INTO hebrew_lemma VALUES ("v#00015408","v","הוֹבִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#00273902","n","הוֹבִּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00564266","v","הוֹדִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00768438","n","הוֹדָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04949838","n","הוֹדָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04729537","n","הוֹדָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05388391","n","הוֹדָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05370646","n","הוֹדָעָת_תַּשְׁלוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004009","n","הוֹלֵךְ-בָּטֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#01077975","a","הוֹלֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#00036903","a","הוֹמֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01150078","a","הוֹמוֹגֶנִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01753780","v","הוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00579423","v","הוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01368651","v","הוֹפִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00487065","n","הוֹפָעָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01007120","v","הוֹצִיא","N");
INSERT INTO hebrew_lemma VALUES ("n#06009454","n","הוֹצָאַת-סְפָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00229211","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09553033","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09554991","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00726534","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06009454","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09552872","n","הוֹצָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00715056","n","הוֹצָאָה-לָאוֹר","N");
INSERT INTO hebrew_lemma VALUES ("v#00032369","v","הוֹרִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#01527871","v","הוֹרִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#07456981","n","הוֹרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07288412","n","הוֹרֶה-בִּיוֹלוֹגִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00567704","n","הוֹרָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00570118","n","הוֹרָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04941372","n","הוֹרָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00211411","n","הוֹרָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00227277","n","הוֹרָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07456981","n","הוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00506398","v","הוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05343252","n","וְעִידָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02503673","a","וְרִידִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05013928","n","וִיזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02536246","n","וִילוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03330562","n","וִילוֹן-מִקְלַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#00871107","n","וִירוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05342315","n","וִכּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05368498","n","וִכּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00514820","n","וִסּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05364726","n","וִתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05390774","n","וִתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04286557","n","וֵשֶׁט","N");
INSERT INTO hebrew_lemma VALUES ("n#06240750","n","וֶגֶטַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03571404","n","וֶנְטִילָטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06753533","n","וֶנוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#09715092","n","וֶסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#08920236","n","וֶרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#04848367","n","וַיִּקְרָא","N");
INSERT INTO hebrew_lemma VALUES ("n#02571784","n","וַסַּת-אוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06173732","n","וַעֲדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06172564","n","וַעֲדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06734778","n","וָאדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04892722","n","וָאוּצֶ\'ר","N");
INSERT INTO hebrew_lemma VALUES ("a#01585161","a","וָתִיק","N");
INSERT INTO hebrew_lemma VALUES ("a#02398582","a","ווֹלוּנְטָרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00649057","a","ווּלְגָּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07684525","n","זְאֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#01623366","n","זְאֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#03676134","n","זְהִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04349454","n","זְהִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00212689","n","זְחִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04033272","n","זְכוּת-יֶתֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04776611","n","זְמַן","N");
INSERT INTO hebrew_lemma VALUES ("n#04777321","n","זְמַן-עָבָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01691661","a","זְמַנִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00482009","n","זְנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09742299","n","זְרִימָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01426574","v","זִבֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10401117","n","זִהוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00177916","n","זִהוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10412503","n","זִהוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#02663528","n","זִיּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00491849","n","זִיּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02850375","n","זִיּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00764310","n","זִילוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04443434","n","זִכָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04557437","n","זִכָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00573480","v","זִלְזֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01211520","v","זִלְזֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#00818472","n","זִמְזוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05493549","n","זִמְזוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00354500","n","זִמְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05096111","n","זִמְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03839481","n","זִמָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10111869","n","זִקְפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04557437","n","זֵכֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04984599","n","זֵכֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04200725","n","זֵעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03634464","n","זֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#00787314","n","זֵרוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#10656895","n","זֶבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#06392752","n","זֶנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#01486270","n","זֶפֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#07396425","n","זֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10700359","n","זֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05513139","n","זֶרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#06250108","n","זֶרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#07788451","n","זֶרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#04233304","n","זֶרַע","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","זַאֲטוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#07543728","n","זַבָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004043","n","זַגָּג","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004044","n","זַגָּגִית","N");
INSERT INTO hebrew_lemma VALUES ("n#01813568","n","זַחַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07274848","n","זַיְפָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004041","n","זַיְפָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004042","n","זַיְפָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05802870","n","זַיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#08604499","n","זַיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#08604641","n","זַיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#08604906","n","זַיִת","N");
INSERT INTO hebrew_lemma VALUES ("a#01267634","a","זַכַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#09449141","n","זַלְזַל","N");
INSERT INTO hebrew_lemma VALUES ("n#03438292","n","זַמְשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10584467","n","זַמְשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004046","n","זַמֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004045","n","זַמָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#01099177","n","זַרְזִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#10496075","n","זַרְחָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02841579","a","זַרְחָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03293342","n","זַרְקוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#02870166","n","זָ\'קֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#07014629","n","זָוִית","N");
INSERT INTO hebrew_lemma VALUES ("v#01411779","v","זָחַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01287363","v","זָחַל","N");
INSERT INTO hebrew_lemma VALUES ("n#04776306","n","זָכָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01337063","a","זָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01186048","a","זָקוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07273655","n","זָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07614356","n","זָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00033527","a","זָרִיז","N");
INSERT INTO hebrew_lemma VALUES ("n#07143593","n","זָרָז","N");
INSERT INTO hebrew_lemma VALUES ("a#00061781","a","זָרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01760779","a","זָרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03691006","n","זֹהַר","N");
INSERT INTO hebrew_lemma VALUES ("n#03874115","n","זֹהַר","N");
INSERT INTO hebrew_lemma VALUES ("n#10399165","n","זֻהֲמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07615942","n","זוֹנַת-רְחוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#07507944","n","זוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00117872","a","זוֹעֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#05982753","n","זוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#09895669","n","זוּג","N");
INSERT INTO hebrew_lemma VALUES ("a#01589250","a","זוּטָר","N");
INSERT INTO hebrew_lemma VALUES ("a#02025910","a","זוּטָר","N");
INSERT INTO hebrew_lemma VALUES ("n#03074890","n","חֲבִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05997364","n","חֲבִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004070","n","חֲבֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06212281","n","חֲבֵרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10038317","n","חֲבֵרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10038677","n","חֲבֵרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#08727889","n","חֲבַצֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05505766","n","חֲבָטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02504878","n","חֲגוֹרַת-בֶּטֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#09737023","n","חֲדִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03864989","n","חֲדִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02263808","n","חֲדַר-אַמְבַּטְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02289338","n","חֲדַר-בִּילְיַארְד","N");
INSERT INTO hebrew_lemma VALUES ("n#02493727","n","חֲדַר-בַּקָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02486912","n","חֲדַר-יְשִׁיבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#02640186","n","חֲדַר-מְנוֹעִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02388057","n","חֲדַר-קְלָפִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02263808","n","חֲדַר-רַחְצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02275625","n","חֲדַר-שֵׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04589992","n","חֲוָיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02331715","n","חֲזִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02684570","n","חֲזִיז","N");
INSERT INTO hebrew_lemma VALUES ("n#01893422","n","חֲזִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10169601","n","חֲזֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00576606","n","חֲזָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06096453","n","חֲטִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02848703","a","חֲטִיבָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00091213","n","חֲטִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00495415","n","חֲטִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00500941","n","חֲטִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03438739","n","חֲלִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04401363","n","חֲלִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00133501","r","חֲלִיפוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#03374325","n","חֲלָלִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00701398","n","חֲלֻקָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03970012","n","חֲלֻקָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05564290","n","חֲלוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#04449561","n","חֲלוֹם-רָטוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#04463475","n","חֲלוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004060","n","חֲלוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004062","n","חֲלוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05639196","n","חֲמִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02105452","a","חֲמִישִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#02258037","a","חֲמַצְמַץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02770699","n","חֲמָמָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02044251","a","חֲמוּר-סֵבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003748","n","חֲנִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04919295","n","חֲנִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00146798","n","חֲנִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03378225","n","חֲנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03378030","n","חֲנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03325022","n","חֲנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01514085","n","חֲסִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004058","n","חֲסִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00139905","n","חֲסִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03930302","n","חֲסִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10418829","n","חֲסִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01748937","a","חֲסַר-דֵּעָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02382678","a","חֲסַר-עֵרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01080360","a","חֲסַר-תַּקָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01255019","a","חֲסר-יֶדַע","N");
INSERT INTO hebrew_lemma VALUES ("n#06489489","n","חֲצִי-הָאִי-עֲרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05751363","n","חֲצִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#09193516","n","חֲצִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#02502829","n","חֲצוֹצְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10887026","n","חֲצוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00600227","n","חֲקִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04467719","n","חֲקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05376578","n","חֲקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00416938","n","חֲקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00418126","n","חֲקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04470360","n","חֲקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05495980","n","חֲרִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00589929","n","חֲרִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#04450733","n","חֲשִׁיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04025511","n","חֲשִׁיבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05591792","n","חֲשָׁשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05594044","n","חֲשָׁשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004068","n","חֲשׁוּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00137299","n","חֲתִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10966797","n","חֲתִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00373866","n","חֲתִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01631790","n","חֲתַלְתּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06130826","n","חֲתֻנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05540443","n","חֲתֻנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10163886","n","חֳלִירַע","N");
INSERT INTO hebrew_lemma VALUES ("v#01734511","v","חִבֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00642843","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00881672","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00885494","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01164896","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00432790","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00974283","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00884615","v","חִבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05608483","n","חִבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00268334","n","חִבּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00268460","n","חִבּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00560621","n","חִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00094409","n","חִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04831003","n","חִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00596202","n","חִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00157011","n","חִדּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02865563","n","חִדּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00695551","v","חִוָּה-דֵּעָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00150780","v","חִזֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05057929","n","חִזּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00096215","n","חִזּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#08448511","n","חִטָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05837413","n","חִטָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01549907","v","חִיֵּב","N");
INSERT INTO hebrew_lemma VALUES ("v#01707058","v","חִיֵּב","N");
INSERT INTO hebrew_lemma VALUES ("v#00536527","v","חִיֵּג","N");
INSERT INTO hebrew_lemma VALUES ("a#01747057","a","חִיּוּבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05147735","n","חִיּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01524177","a","חִיּוּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04394091","n","חִידָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00905055","a","חִיצוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00456982","n","חִכּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07800619","n","חִכּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#09737023","n","חִלְחוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01554470","v","חִלֵּט","N");
INSERT INTO hebrew_lemma VALUES ("v#01568792","v","חִלֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#04579197","n","חִלּוֹנִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00052209","n","חִלּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00719451","n","חִלּוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00163821","v","חִמְצֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#09684568","n","חִמְצוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00742153","n","חִמּוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#01647723","a","חִנָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06059102","n","חִנּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00058927","v","חִסֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09619452","n","חִסָּכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00531161","n","חִסּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#03564977","n","חִסּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00560394","n","חִסּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00898737","v","חִפֵּשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#01669942","n","חִפּוּשִׁית","N");
INSERT INTO hebrew_lemma VALUES ("n#00604336","n","חִפּוּשׂ","N");
INSERT INTO hebrew_lemma VALUES ("v#00430966","v","חִשֵּׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#00209319","v","חִשֵּׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#04467150","n","חִשּׁוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00558391","n","חִשּׁוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03387543","n","חִשּׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02564894","n","חִתּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06876198","n","חֵטְא","N");
INSERT INTO hebrew_lemma VALUES ("n#06097782","n","חֵיל-חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04121211","n","חֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#09945970","n","חֵלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#00504440","n","חֵלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#03090721","n","חֵלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#09561632","n","חֵלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#06684175","n","חֵלֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#10626993","n","חֵמָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00009457","n","חֵפֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00011937","n","חֵפֶץ_מְלָאכוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02545258","n","חֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02545362","n","חֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#10434472","n","חֵרְשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004049","n","חֵרֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00647484","a","חֵרֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00135310","n","חֵרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004050","n","חֵרֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#05973283","n","חֶבְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06107600","n","חֶבְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10037091","n","חֶבְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06015810","n","חֶבְרָה-לְהַשְׁקָעוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003044","n","חֶבְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03252883","n","חֶבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#04263179","n","חֶדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04190682","n","חֶדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#03250788","n","חֶדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#02188705","n","חֶדֶר-אָקוּסְטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05872814","n","חֶלְבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10560829","n","חֶלְבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#08476962","n","חֶלְמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00989609","n","חֶלְמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05879421","n","חֶמְאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03785836","n","חֶמְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07572257","n","חֶנְוָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00146677","n","חֶנֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#03794441","n","חֶסֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#03986577","n","חֶסֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#03291320","n","חֶרְמֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10360525","n","חֶרְפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03457380","n","חֶרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#03165060","n","חֶרֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#04598167","n","חֶשְׁבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09619552","n","חֶשְׁבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09619552","n","חֶשְׁבּוֹן-בַּנְק","N");
INSERT INTO hebrew_lemma VALUES ("a#02796906","a","חֶשְׁבּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00407290","n","חֶשְׁבּוֹנָאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07542125","n","חַבְּלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#10259769","n","חַבּוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05805084","n","חַבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#08928849","n","חַבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10911850","n","חַג-הַחֵרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03724711","n","חַד-ְגּוֹנִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03724711","n","חַדְגּוֹנִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07147268","n","חַדְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02666240","n","חַוָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06928357","n","חַוָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07676367","n","חַזַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004051","n","חַזָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004052","n","חַזָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00990356","n","חַט","N");
INSERT INTO hebrew_lemma VALUES ("n#00002086","n","חַי","N");
INSERT INTO hebrew_lemma VALUES ("v#01809405","v","חַי","N");
INSERT INTO hebrew_lemma VALUES ("a#00098090","a","חַי","N");
INSERT INTO hebrew_lemma VALUES ("a#02170020","a","חַי","N");
INSERT INTO hebrew_lemma VALUES ("n#06095338","n","חַיִל","N");
INSERT INTO hebrew_lemma VALUES ("n#00002880","n","חַיִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#10396797","n","חַיֵּי-מוֹתָרוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004066","n","חַיֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07205503","n","חַיָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00008019","n","חַיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07629479","n","חַיָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004065","n","חַיָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01212141","a","חַיָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004055","n","חַלְפָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004056","n","חַלְפָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10666463","n","חַלָּמִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01195771","a","חַם","N");
INSERT INTO hebrew_lemma VALUES ("n#10495237","n","חַמְצָן","N");
INSERT INTO hebrew_lemma VALUES ("n#08285778","n","חַמָּנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08285778","n","חַמָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06282697","n","חַנְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10775251","n","חַנְקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10494444","n","חַנְקָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02835011","a","חַנְקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05761291","n","חַסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08293804","n","חַסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10078249","n","חַפּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10160032","n","חַצֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07411603","n","חַקְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","חַקְלַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003980","n","חַקְלָאִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06058165","n","חַקְלָאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01729962","n","חַרְגּוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#05852339","n","חַרְדָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#08186398","n","חַרְדָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10515601","n","חַרְסִית","N");
INSERT INTO hebrew_lemma VALUES ("n#08258003","n","חַרְצִית","N");
INSERT INTO hebrew_lemma VALUES ("n#08258932","n","חַרְצִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07058678","n","חַשָּׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#03834482","n","חַשְׁדָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07793035","n","חַשְׁמַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07793357","n","חַשְׁמַל","N");
INSERT INTO hebrew_lemma VALUES ("n#05586574","n","חַשְׁמַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07788451","n","חַשְׁמַל","N");
INSERT INTO hebrew_lemma VALUES ("a#02622421","a","חַשְׁמַלִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#03426879","n","חַשְׁמַלִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#07616697","n","חַשְׂפָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00915013","a","חַתְרָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07344725","n","חַתָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#01402474","a","חָבִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#07626109","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07087841","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07128110","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07172243","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07623193","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07626109","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004069","n","חָבֵר","N");
INSERT INTO hebrew_lemma VALUES ("v#01658042","v","חָבַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01773236","v","חָבַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01645167","v","חָבַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01699803","v","חָבַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01887084","a","חָבוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01729962","n","חָגָב","N");
INSERT INTO hebrew_lemma VALUES ("a#01707060","a","חָדִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01829006","v","חָדַל","N");
INSERT INTO hebrew_lemma VALUES ("n#05693686","n","חָזֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04302029","n","חָזֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#01180029","v","חָזַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00062790","v","חָזַר-לְסוּרוֹ","N");
INSERT INTO hebrew_lemma VALUES ("r#00336979","r","חָזָק","N");
INSERT INTO hebrew_lemma VALUES ("a#02062857","a","חָטוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#00306683","a","חָטוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#01402214","v","חָלַף","N");
INSERT INTO hebrew_lemma VALUES ("v#01418612","v","חָלַף","N");
INSERT INTO hebrew_lemma VALUES ("n#04196379","n","חָלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05875585","n","חָלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05876056","n","חָלָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00646675","a","חָלָק","N");
INSERT INTO hebrew_lemma VALUES ("a#00765440","a","חָלָק","N");
INSERT INTO hebrew_lemma VALUES ("n#00466114","n","חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07275269","n","חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07616532","n","חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004059","n","חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004061","n","חָלוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#10112814","n","חָמְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01246798","v","חָמַד","N");
INSERT INTO hebrew_lemma VALUES ("n#07420248","n","חָמוֹת","N");
INSERT INTO hebrew_lemma VALUES ("a#00614072","a","חָמוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003747","n","חָנִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01523551","v","חָנַט","N");
INSERT INTO hebrew_lemma VALUES ("v#01651229","v","חָנַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01081810","v","חָנַק","N");
INSERT INTO hebrew_lemma VALUES ("v#01025543","v","חָנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01319179","v","חָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04056757","n","חָנוּט","N");
INSERT INTO hebrew_lemma VALUES ("a#01563078","a","חָנוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004057","n","חָסִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#01709139","a","חָסִין","N");
INSERT INTO hebrew_lemma VALUES ("a#00053941","a","חָסֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01775769","a","חָסֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01359458","a","חָפְשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#01010992","a","חָפְשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#01647723","a","חָפְשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("r#00207028","r","חָפְשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("v#00029432","v","חָפַף","N");
INSERT INTO hebrew_lemma VALUES ("a#01217941","a","חָפוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#05835955","n","חָצִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00433781","v","חָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10536256","n","חָצָץ","N");
INSERT INTO hebrew_lemma VALUES ("a#00204987","a","חָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#00205511","a","חָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01906636","a","חָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01923659","a","חָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02169249","a","חָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02888127","n","חָקִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00311342","a","חָקוּק","N");
INSERT INTO hebrew_lemma VALUES ("a#01541117","a","חָרִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#00589929","n","חָרִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01750236","v","חָרַג","N");
INSERT INTO hebrew_lemma VALUES ("v#01486965","v","חָרַק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004053","n","חָרַשׁ-עֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07653999","n","חָרָט","N");
INSERT INTO hebrew_lemma VALUES ("n#08794248","n","חָרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#08795921","n","חָרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05309419","n","חָרוּז","N");
INSERT INTO hebrew_lemma VALUES ("a#00719289","a","חָרוּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01761533","a","חָרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00311342","a","חָרוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01441871","v","חָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00428091","v","חָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#01123253","v","חָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#00426277","v","חָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#00465761","v","חָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("v#00427776","v","חָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("a#00546266","a","חָשׁוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01758782","a","חָשׁוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004067","n","חָשׁוּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00268709","a","חָשׁוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00632077","v","חָשַׂף","N");
INSERT INTO hebrew_lemma VALUES ("a#00428328","a","חָשׂוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01814114","a","חָשׂוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00337013","v","חָתַם","N");
INSERT INTO hebrew_lemma VALUES ("v#01513073","v","חָתַם","N");
INSERT INTO hebrew_lemma VALUES ("v#01326509","v","חָתַר","N");
INSERT INTO hebrew_lemma VALUES ("n#07302517","n","חָתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07302617","n","חָתָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00623957","a","חָתוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#01630731","n","חָתוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07575902","n","חָתוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#02008395","a","חָתוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10018378","n","חֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#10919146","n","חֹדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10922179","n","חֹדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04422689","n","חֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#10824042","n","חֹמֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#05861621","n","חֹמֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04799150","n","חֹמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10457644","n","חֹמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10626993","n","חֹמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10457644","n","חֹמֶר-גֶּלֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#04797504","n","חֹמֶר-כָּתוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#04927294","n","חֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#06243906","n","חֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#04646668","n","חֹק-שִׁמּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00446454","n","חֹקֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#10946591","n","חֹרֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#04101439","n","חֻלְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06100095","n","חֻלְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03320567","n","חֻלְצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03664048","n","חֻמְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05040252","n","חֻצְפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03772982","n","חֻקִּיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09655306","n","חוֹבָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00857047","a","חוֹבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07578399","n","חוֹטֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#07353959","n","חוֹטֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003903","n","חוֹכֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003904","n","חוֹכֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01692272","a","חוֹלֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004063","n","חוֹלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004064","n","חוֹלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07340274","n","חוֹקֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07530046","n","חוֹקֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004003","n","חוֹקֵר-פְּרָטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004004","n","חוֹקֶרֶת-פְּרָטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03497295","n","חוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03625583","n","חוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03625791","n","חוּט-חַשְׁמַל","N");
INSERT INTO hebrew_lemma VALUES ("n#00083719","n","חוּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#00986718","a","חוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04371175","n","חוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05567730","n","חוּשָׁנִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00670476","n","טְבִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00583827","n","טְוִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03000008","n","טְחִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07857465","n","טְחָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00200531","n","טְרֶמְפּ","N");
INSERT INTO hebrew_lemma VALUES ("n#03530611","n","טְרַנְסְפוֹרְמָטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#00717352","n","טְרַנְסַקְצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00636353","a","טְרוֹמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00161640","n","טִאטוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07661990","n","טִבְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00157874","n","טִגּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00162101","n","טִהוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00461068","n","טִיּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00201294","n","טִיּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00202291","n","טִיּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10759087","n","טִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#10722217","n","טִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#03004991","n","טִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#03176413","n","טִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#10792718","n","טִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05612377","n","טִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09572926","n","טִיפּ","N");
INSERT INTO hebrew_lemma VALUES ("v#00942761","v","טִפְטֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#01110335","v","טִפְטֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#01417339","v","טִפְטֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#01884408","v","טִפְטֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#07831030","n","טִפְטוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#00408403","a","טִפְּשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#02446777","a","טִפְּשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#07271334","n","טִפֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00408403","a","טִפֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01283121","a","טִפֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00735486","n","טִפּוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01538517","a","טִפּוּסִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02349429","a","טִפּוּסִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00346749","a","טִפּוּסִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00991360","a","טִקְסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03845335","n","טִקְסִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05489772","n","טִרְחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00161640","n","טֵאוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03471806","n","טֵיְפּ","N");
INSERT INTO hebrew_lemma VALUES ("n#00607693","n","טֶכְנוֹלוֹגְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03481385","n","טֶלֶבִיזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03482557","n","טֶלֶבִיזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04745188","n","טֶלֶוִיזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03481385","n","טֶלֶוִיזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03482557","n","טֶלֶוִיזְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03478277","n","טֶלֶפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04742189","n","טֶלֶפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04742034","n","טֶלֶפוֹנְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03914851","n","טֶמְפֶּרָטוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03651222","n","טֶמְפֶּרָמֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#03648054","n","טֶמְפֶּרָמֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#10964831","n","טֶמְפּוֹ","N");
INSERT INTO hebrew_lemma VALUES ("a#00523173","a","טֶנְטָטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09535912","n","טֶרִיטוֹרְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01661246","n","טֶרֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004633","n","טֶרוֹרִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004634","n","טֶרוֹרִיסְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03123093","n","טַבְלִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004217","n","טַבָּח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004218","n","טַבָּחִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06530219","n","טַבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#01323698","n","טַוָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#01782015","n","טַוָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#03939250","n","טַיְמִינְג","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004242","n","טַיֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004241","n","טַיָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02352536","n","טַמְבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03467835","n","טַמְבּוּרִין","N");
INSERT INTO hebrew_lemma VALUES ("n#03534522","n","טַס","N");
INSERT INTO hebrew_lemma VALUES ("n#00776560","n","טַעֲנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04452090","n","טַעֲנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04925009","n","טַעֲנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02608653","n","טַפְטֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00912376","n","טַפִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#07367906","n","טַפִּיל","N");
INSERT INTO hebrew_lemma VALUES ("a#02720715","a","טַקְטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00967729","a","טָבוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00080547","a","טָבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02426601","a","טָחוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#00284623","a","טָחוּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00397605","a","טָמֵא","N");
INSERT INTO hebrew_lemma VALUES ("a#02282742","a","טָעִים","N");
INSERT INTO hebrew_lemma VALUES ("a#00136205","a","טָעִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01528065","v","טָעַן","N");
INSERT INTO hebrew_lemma VALUES ("a#02290994","a","טָעוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#04531479","n","טָעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05071571","n","טָעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00042411","n","טָעוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01014707","a","טָרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01018698","a","טָרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10152408","n","טָרֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#10400755","n","טֻמְאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04005893","n","טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#01078193","a","טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#02220016","a","טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#01076114","a","טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("r#00010099","r","טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#04017901","n","טוֹבַת-הֲנָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05129356","n","טוֹטֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09587591","n","טוֹנָז\'","N");
INSERT INTO hebrew_lemma VALUES ("a#00092842","a","טוֹרְדָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04019795","n","טוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03800378","n","טוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","טוּסִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#07501217","n","טוּרַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00721243","n","יְבוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02852104","n","יְבוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#09380644","n","יְבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10038317","n","יְדִידוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04867981","n","יְדִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00183402","a","יְדָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03828648","n","יְהִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06998898","n","יְהוּדִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02697443","a","יְהוּדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06999516","n","יְהוּדִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003741","n","יְוָנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02773962","a","יְוָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003742","n","יְוָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02111616","a","יְחִידִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06683928","n","יְחִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09924828","n","יְחָסִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10036039","n","יְחָסִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10036283","n","יְחָסִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04047716","n","יְכֹלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04369800","n","יְכֹלֶת-קוֹגְנִיטִיבִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05498432","n","יְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05498595","n","יְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05387614","n","יְלָלוֹת","N");
INSERT INTO hebrew_lemma VALUES ("a#01784854","a","יְסוֹדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03682129","n","יְסוֹדִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04355888","n","יְצִירָתִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00721409","n","יְצוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02653164","n","יְצוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07253113","n","יְצוּאָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07192170","n","יְצוּר-אֱנוֹשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#05479408","n","יְרִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06725397","n","יְרִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03313932","n","יְרִיעַת-פַּח","N");
INSERT INTO hebrew_lemma VALUES ("a#02583497","a","יְרֵחִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07526600","n","יְשִׁיבָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00028436","r","יְתֵרָה-מִזּוֹ","N");
INSERT INTO hebrew_lemma VALUES ("v#01601935","v","יִבֵּא","N");
INSERT INTO hebrew_lemma VALUES ("v#00046267","v","יִבֵּב","N");
INSERT INTO hebrew_lemma VALUES ("v#00047059","v","יִבֵּב","N");
INSERT INTO hebrew_lemma VALUES ("v#00149082","v","יִבֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00721243","n","יִבּוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02852104","n","יִבּוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#09739112","n","יִבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00564266","v","יִדֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05388175","n","יִדּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00492345","v","יִחֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#03740993","n","יִחוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#03740993","n","יִחוּדִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04427252","n","יִחוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05212011","n","יִידִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00718430","v","יִלֵּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00709311","v","יִלֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07430101","n","יִלּוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#00122025","n","יִלּוּד","N");
INSERT INTO hebrew_lemma VALUES ("v#01652417","v","יִסֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#05602697","n","יִסּוּרֵי_מַצְפּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00382624","n","יִעוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00256511","n","יִעוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00167925","n","יִפּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#01602063","v","יִצֵּא","N");
INSERT INTO hebrew_lemma VALUES ("n#00721409","n","יִצּוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02653164","n","יִצּוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#00750993","n","יִצּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00586701","n","יִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00592801","n","יִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00593550","n","יִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00518436","v","יִשֵּׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#07025077","n","יִשְׂרְאֵלִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02738489","a","יִשְׂרְאֵלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06455500","n","יִשְׂרָאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#04016440","n","יִתְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04017901","n","יִתְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("r#00294418","r","יִתָּכֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#05606636","n","יֵאוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10054265","n","יֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07731120","n","יֵשׁוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#07731120","n","יֵשׁוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00001740","n","יֵשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00003731","n","יֵשׁוּת-גּוֹרֶמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06860613","n","יֵשׁוּת-עַל-טִבְעִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04596388","n","יֶדַע","N");
INSERT INTO hebrew_lemma VALUES ("n#07153837","n","יֶלֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#07154377","n","יֶלֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#07389783","n","יֶלֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#07154665","n","יֶלֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#05566100","n","יֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#09867130","n","יֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#00078903","n","יֶרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09440702","n","יֶרֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#06835944","n","יַבֶּשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#04311787","n","יַד-יָמִין","N");
INSERT INTO hebrew_lemma VALUES ("a#00790754","a","יַדְעָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04590750","n","יַדְעָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06032096","n","יַהֲדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04722359","n","יַהֲדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07245531","n","יַזָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00007066","a","יַחֲסִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00156699","r","יַחֲסִית","N");
INSERT INTO hebrew_lemma VALUES ("n#09953487","n","יַחַס","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","יַלְדּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10351040","n","יַלְדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10870647","n","יַלְדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03275700","n","יַלְקוּט","N");
INSERT INTO hebrew_lemma VALUES ("a#00431947","a","יַמִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02671223","a","יַמִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#07543103","n","יַמַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#04362028","n","יַמָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01143120","n","יַנְשׁוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07389783","n","יַנּוּקָא","N");
INSERT INTO hebrew_lemma VALUES ("n#08610160","n","יַסְמִין","N");
INSERT INTO hebrew_lemma VALUES ("n#07274398","n","יַעֲרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04634522","n","יַעֲרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04587791","n","יַעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#06302863","n","יַעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#04587307","n","יַעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#07507944","n","יַצְאָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06007767","n","יַצְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07394756","n","יַצְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03750498","n","יַצִּיבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07201633","n","יַקִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#01853157","n","יַרְבּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04947242","n","יַרְחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07301688","n","יַרְקָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","יַשְׁבָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00189092","a","יַשְׁנוּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01704520","n","יַתּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01807135","a","יָאֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#02314002","a","יָגֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01647223","v","יָגַע","N");
INSERT INTO hebrew_lemma VALUES ("n#02231667","n","יָד","N");
INSERT INTO hebrew_lemma VALUES ("v#00401762","v","יָדַע","N");
INSERT INTO hebrew_lemma VALUES ("v#00402497","v","יָדַע","N");
INSERT INTO hebrew_lemma VALUES ("v#00402992","v","יָדַע","N");
INSERT INTO hebrew_lemma VALUES ("v#00977560","v","יָדַע","N");
INSERT INTO hebrew_lemma VALUES ("a#01321211","a","יָדוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01321996","a","יָדוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01913005","a","יָדוּעַ-לְשִׁמְצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03828648","n","יָהֳרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01819144","a","יָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06449758","n","יָוָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03790844","n","יָזְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04753575","n","יָחִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#01791800","a","יָחִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#02111616","a","יָחִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#02073987","a","יָחֵף","N");
INSERT INTO hebrew_lemma VALUES ("r#00273450","r","יָחֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#06949518","n","יָלִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#06781925","n","יָם","N");
INSERT INTO hebrew_lemma VALUES ("n#09922052","n","יָם","N");
INSERT INTO hebrew_lemma VALUES ("n#09966059","n","יָם","N");
INSERT INTO hebrew_lemma VALUES ("n#03757761","n","יָמְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04311787","n","יָמִין","N");
INSERT INTO hebrew_lemma VALUES ("n#10922756","n","יָנוּאָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00476442","a","יָעִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00800025","a","יָעִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#01041904","n","יָעֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#02617730","n","יָעֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00072478","a","יָפֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00215099","a","יָפֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#02240068","n","יָצִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01419172","v","יָצָא","N");
INSERT INTO hebrew_lemma VALUES ("a#02067743","a","יָצוּק","N");
INSERT INTO hebrew_lemma VALUES ("a#01401996","a","יָקָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07064973","n","יָרִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#07445577","n","יָרִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#04309035","n","יָרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05693545","n","יָרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01347582","v","יָרַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01347698","v","יָרַד","N");
INSERT INTO hebrew_lemma VALUES ("v#00103366","v","יָרַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01341375","v","יָרַד","N");
INSERT INTO hebrew_lemma VALUES ("v#00032369","v","יָרַד-בַּמִּשְׁקָל","N");
INSERT INTO hebrew_lemma VALUES ("v#01809405","v","יָשַׁב","N");
INSERT INTO hebrew_lemma VALUES ("r#00028436","r","יָתֵר-עַל-כֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07448764","n","יָתוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#10425272","n","יֹבֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10952442","n","יֹבֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04549741","n","יֹפִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03689966","n","יֹפִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01080123","a","יֹפִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01080123","a","יֹפִי-שֶׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#08199367","n","יֹשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#03816422","n","יֹשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#03817073","n","יֹשֶׁר-לֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#10357033","n","יֻקְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","יוֹגֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#07340845","n","יוֹזֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#10955913","n","יוֹם-הַשָּׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10862782","n","יוֹם-מְנוּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10883469","n","יוֹם-שַׁבָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01329440","n","יוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07065373","n","יוֹעֵץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01242820","a","יוֹצֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#06944789","n","יוֹצֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07543103","n","יוֹרֵד-יָם","N");
INSERT INTO hebrew_lemma VALUES ("n#07315588","n","יוֹרֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("r#00257938","r","יוֹתֵר","N");
INSERT INTO hebrew_lemma VALUES ("r#00096714","r","יוֹתֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#10710391","n","יוּטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10924973","n","יוּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10924593","n","יוּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05119959","n","כִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003703","n","כִירוּרְג","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003704","n","כִירוּרְגִית","N");
INSERT INTO hebrew_lemma VALUES ("r#00006065","r","כְּ","N");
INSERT INTO hebrew_lemma VALUES ("n#10279666","n","כְּאֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#04490800","n","כְּאֵב-רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07804383","n","כְּבִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02911520","n","כְּבִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02911520","n","כְּבָסִים","N");
INSERT INTO hebrew_lemma VALUES ("r#00030867","r","כְּבָר","N");
INSERT INTO hebrew_lemma VALUES ("r#00032928","r","כְּבָר","N");
INSERT INTO hebrew_lemma VALUES ("a#02463868","a","כְּדָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04004113","n","כְּדָאִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10260405","n","כְּוִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02851548","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03563924","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00112599","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02740446","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03601056","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04111451","n","כְּלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03601056","n","כְּלִי-זַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#03601056","n","כְּלִי-נֶשֶׁק","N");
INSERT INTO hebrew_lemma VALUES ("n#00239677","n","כְּלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04476229","n","כְּלַל-הַיֶּדַע","N");
INSERT INTO hebrew_lemma VALUES ("a#01512420","a","כְּלַל-עוֹלָמִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00054968","r","כְּלָל","N");
INSERT INTO hebrew_lemma VALUES ("r#00184935","r","כְּלוֹמַר","N");
INSERT INTO hebrew_lemma VALUES ("n#10483675","n","כְּלוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#05565891","n","כְּמִיהָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06066212","n","כְּמוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02591205","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02748084","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05458618","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00026402","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05527437","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02641840","n","כְּנִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05359296","n","כְּנִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02438778","n","כְּנֵסִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00798100","n","כְּנֶסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06169890","n","כְּנֶסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04586741","n","כְּפִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04708659","n","כְּפִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02325897","n","כְּפָפַת-אִגְרוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02757746","n","כְּפָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06107243","n","כְּפָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06383813","n","כְּפָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07717771","n","כְּפוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#08258003","n","כְּרִיזַנְטֶמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08258932","n","כְּרִיזַנְטֶמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00778442","n","כְּרִיתוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00934815","a","כְּרַסְתָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05087726","n","כְּרָזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05752184","n","כְּרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#08183904","n","כְּרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05753383","n","כְּרוּבִית","N");
INSERT INTO hebrew_lemma VALUES ("n#08184847","n","כְּרוּבִית","N");
INSERT INTO hebrew_lemma VALUES ("n#01524724","n","כְּרוּכְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04014903","n","כְּשִׁירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#08700478","n","כְּשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04790339","n","כְּתִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#00596202","n","כְּתִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00404574","n","כְּתִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00697514","n","כְּתִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#04826409","n","כְּתַב-יָד","N");
INSERT INTO hebrew_lemma VALUES ("n#04788218","n","כְּתָב","N");
INSERT INTO hebrew_lemma VALUES ("n#04826409","n","כְּתָב","N");
INSERT INTO hebrew_lemma VALUES ("n#04919548","n","כְּתָב","N");
INSERT INTO hebrew_lemma VALUES ("n#04828090","n","כְּתֹבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05083171","n","כְּתֹבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04852916","n","כְּתוּבִים","N");
INSERT INTO hebrew_lemma VALUES ("n#05250807","n","כִּבְשָׂה","N");
INSERT INTO hebrew_lemma VALUES ("n#01908755","n","כִּבְשָׂה","N");
INSERT INTO hebrew_lemma VALUES ("n#00037624","n","כִּבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00054499","n","כִּבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00104245","n","כִּבּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00646064","n","כִּוְנוּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00782363","v","כִּוֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00645793","n","כִּיּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10212984","n","כִּיב","N");
INSERT INTO hebrew_lemma VALUES ("n#02268139","n","כִּידוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07413689","n","כִּילַי","N");
INSERT INTO hebrew_lemma VALUES ("n#04640400","n","כִּימְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09971597","n","כִּימְיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02543445","a","כִּימִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02543733","a","כִּימִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02495933","n","כִּירַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#05725764","n","כִּכַּר-לֶחֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#05725764","n","כִּכָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04136473","n","כִּלְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00788511","n","כִּלְכּוּל","N");
INSERT INTO hebrew_lemma VALUES ("r#00156524","r","כִּמְעַט","N");
INSERT INTO hebrew_lemma VALUES ("r#00070549","r","כִּמְעַט","N");
INSERT INTO hebrew_lemma VALUES ("n#03579422","n","כִּנּוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04780372","n","כִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#02418562","n","כִּסֵּא","N");
INSERT INTO hebrew_lemma VALUES ("n#04427092","n","כִּסּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02806551","n","כִּסּוּי-רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05565891","n","כִּסּוּפִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03693789","n","כִּעוּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00316569","r","כִּפְלַיִם","N");
INSERT INTO hebrew_lemma VALUES ("r#00316651","r","כִּפְלַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#06285184","n","כִּפַּת-הַשָּׁמַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#06285184","n","כִּפַּת-הָרָקִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02588147","n","כִּפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02587986","n","כִּפָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01295618","v","כִּשְׁכֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01768682","a","כִּשְׁרוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02447403","n","כִּתָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06115327","n","כִּתָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04785610","n","כִּתּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00610851","n","כִּתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02621476","a","כֵּלִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02043991","a","כֵּן","N");
INSERT INTO hebrew_lemma VALUES ("a#02094165","a","כֵּן","N");
INSERT INTO hebrew_lemma VALUES ("r#00118084","r","כֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02737525","n","כֶּבֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02737262","n","כֶּבֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07569298","n","כֶּבֶשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#07569478","n","כֶּבֶשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#01908461","n","כֶּבֶשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#02872007","n","כֶּלֶא","N");
INSERT INTO hebrew_lemma VALUES ("n#05343252","n","כֶּנֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#06166581","n","כֶּנֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#09534064","n","כֶּסֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#09639711","n","כֶּסֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#09639977","n","כֶּסֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#10501473","n","כֶּסֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#03196324","n","כֶּסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02623403","n","כֶּסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03578669","n","כֶּרֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#04304039","n","כֶּרֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#05088890","n","כֶּתֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#02880403","n","כַּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09915071","n","כַּד","N");
INSERT INTO hebrew_lemma VALUES ("n#03123093","n","כַּדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00306597","n","כַּדּוּרְסַל","N");
INSERT INTO hebrew_lemma VALUES ("n#02260281","n","כַּדּוּרְסַל","N");
INSERT INTO hebrew_lemma VALUES ("n#00305986","n","כַּדּוּרְעָף","N");
INSERT INTO hebrew_lemma VALUES ("n#03581346","n","כַּדּוּרְעָף","N");
INSERT INTO hebrew_lemma VALUES ("n#02709998","n","כַּדּוּרֶגֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00304700","n","כַּדּוּרֶגֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#N0000331","n","כַּדּוּרַגְלָן","N");
INSERT INTO hebrew_lemma VALUES ("r#00501853","r","כַּהֲלָכָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00192828","r","כַּהֲלָכָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00192828","r","כַּהֹגֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07106714","n","כַּוְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00588610","n","כַּוְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02276576","n","כַּוֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06082383","n","כַּוֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06845741","n","כַּוֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04588033","n","כַּוָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04951584","n","כַּוָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00192828","r","כַּיָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07475990","n","כַּיָּס","N");
INSERT INTO hebrew_lemma VALUES ("r#00046870","r","כַּיּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00047077","r","כַּיּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#01594789","n","כַּלְבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07234388","n","כַּלְכְּלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04674380","n","כַּלְכָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07673310","n","כַּלַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07126220","n","כַּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07126327","n","כַּלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08036172","n","כַּלָּנִית","N");
INSERT INTO hebrew_lemma VALUES ("a#00462055","a","כַּמָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01990138","a","כַּמָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02158584","a","כַּמָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00037564","r","כַּמּוּבָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00020056","n","כַּמּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03983740","n","כַּמּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04507519","n","כַּמּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02255918","n","כַּן","N");
INSERT INTO hebrew_lemma VALUES ("r#00134549","r","כַּנִּרְאֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00278090","a","כַּסְפִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02639054","a","כַּסְפִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#10492641","n","כַּסְפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#03266470","n","כַּסֶּפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03266553","n","כַּסֶּפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03388234","n","כַּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03387931","n","כַּף","N");
INSERT INTO hebrew_lemma VALUES ("n#09917014","n","כַּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03476379","n","כַּפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#09917537","n","כַּפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#05017234","n","כַּפַּיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#00059803","n","כַּפָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03124442","n","כַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06317924","n","כַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04892853","n","כַּרְטִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#04893172","n","כַּרְטִיסִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08718296","n","כַּרְכֹּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07654592","n","כַּתְבָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07185179","n","כַּתָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#07185317","n","כַּתָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#07528776","n","כַּתָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#06904522","n","כָּאוֹס","N");
INSERT INTO hebrew_lemma VALUES ("n#04186068","n","כָּבֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#05696495","n","כָּבֵד","N");
INSERT INTO hebrew_lemma VALUES ("a#01134980","a","כָּבֵד","N");
INSERT INTO hebrew_lemma VALUES ("v#00145474","v","כָּבַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03827814","n","כָּבוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#03827814","n","כָּבוֹד-עַצְמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10529587","n","כָּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00249471","a","כָּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01020775","a","כָּבוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00938029","a","כָּחוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("r#00118084","r","כָּךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00118084","r","כָּכָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00143534","r","כָּל_כָּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01699803","v","כָּלָא","N");
INSERT INTO hebrew_lemma VALUES ("a#01012191","a","כָּלוּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01599117","a","כָּלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07498013","n","כָּמְרִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01310388","a","כָּמֵהַּ","N");
INSERT INTO hebrew_lemma VALUES ("v#01231785","v","כָּמַהּ","N");
INSERT INTO hebrew_lemma VALUES ("v#01247460","v","כָּמַהּ","N");
INSERT INTO hebrew_lemma VALUES ("n#06101255","n","כָּנָף","N");
INSERT INTO hebrew_lemma VALUES ("a#00365148","a","כָּסוּף","N");
INSERT INTO hebrew_lemma VALUES ("r#00046870","r","כָּעֵת","N");
INSERT INTO hebrew_lemma VALUES ("v#01707058","v","כָּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10112984","n","כָּפָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02114682","a","כָּפוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#02114353","a","כָּפוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05737298","n","כָּרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07568727","n","כָּרִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01006126","n","כָּרִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00855839","v","כָּרַת","N");
INSERT INTO hebrew_lemma VALUES ("r#00192828","r","כָּרָאוּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00104058","r","כָּרָגִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#00791535","v","כָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06940836","n","כָּרוֹז","N");
INSERT INTO hebrew_lemma VALUES ("a#01442124","a","כָּרוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00624789","a","כָּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01168840","v","כָּתַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01164896","v","כָּתַב","N");
INSERT INTO hebrew_lemma VALUES ("v#00671763","v","כָּתַב","N");
INSERT INTO hebrew_lemma VALUES ("v#00698485","v","כָּתַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01160885","v","כָּתַב","N");
INSERT INTO hebrew_lemma VALUES ("a#00361864","a","כָּתֹם","N");
INSERT INTO hebrew_lemma VALUES ("r#00118084","r","כֹּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00726999","n","כֹּפֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#09560583","n","כֹּפֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04349777","n","כֹּשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#04369800","n","כֹּשֶׁר-מֶנְטָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02282730","n","כֻּמְתָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02209460","n","כֻּרְסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07177921","n","כּוֹבֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02304880","n","כּוֹבַע-קַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02485388","n","כּוֹבָעוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06059369","n","כּוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04349777","n","כּוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07804383","n","כּוֹחַ-הַכְּבִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07804383","n","כּוֹחַ-הַמְּשִׁיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06098727","n","כּוֹחַ-מְאַסֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#06092042","n","כּוֹחוֹת-מִּלּוּאִים","N");
INSERT INTO hebrew_lemma VALUES ("n#06753533","n","כּוֹכַב-הַשַּׁחַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06753533","n","כּוֹכַב-הָעֶרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#06758353","n","כּוֹכַב-שָׁבִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#05115508","n","כּוֹכָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05115508","n","כּוֹכָבִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003462","n","כּוֹלֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#00492805","a","כּוֹלֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#10163886","n","כּוֹלֶרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07119896","n","כּוֹרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07412036","n","כּוֹרֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#02193366","a","כּוֹשֵׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#04783598","n","כּוֹתֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06960662","n","כּוּשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#10163886","n","כוֹלֶרָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00157495","r","לְאַט","N");
INSERT INTO hebrew_lemma VALUES ("n#03821817","n","לְאֻמִּיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04727595","n","לְאֻמָּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01638160","n","לְבִיאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05687344","n","לְבִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07126030","n","לְבֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02335723","n","לְבֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00063279","r","לְבַסּוֹף","N");
INSERT INTO hebrew_lemma VALUES ("a#02409421","a","לְבָבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03813760","n","לְבָבִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03560325","n","לְבָנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00541182","n","לְגִימָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00007075","r","לְגַמְרֵי","N");
INSERT INTO hebrew_lemma VALUES ("n#05616745","n","לְהִיטוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04973475","n","לְהִתְרָאוֹת","N");
INSERT INTO hebrew_lemma VALUES ("r#00204090","r","לְחוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00094066","n","לְטִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01195408","n","לְטָאָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00047341","r","לְלֹא-דִּחוּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00164034","r","לְלֹא-הוֹעִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00246712","a","לְלֹא-חַת","N");
INSERT INTO hebrew_lemma VALUES ("r#00035125","r","לְמַדַּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00017767","r","לְמַדַּי","N");
INSERT INTO hebrew_lemma VALUES ("r#00077413","r","לְמַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00091761","r","לְמַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00091891","r","לְמַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00093654","r","לְמַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00057975","r","לְמַעֲשֶׂה","N");
INSERT INTO hebrew_lemma VALUES ("r#00145000","r","לְמַעֲשֶׂה","N");
INSERT INTO hebrew_lemma VALUES ("r#00145641","r","לְמַעֲשֶׂה","N");
INSERT INTO hebrew_lemma VALUES ("r#00162626","r","לְמַעֲשֶׂה","N");
INSERT INTO hebrew_lemma VALUES ("r#00133501","r","לְסֵרוּגִין","N");
INSERT INTO hebrew_lemma VALUES ("r#00033931","r","לְעִתִּים-קְרוֹבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("r#00034258","r","לְעִתִּים-רְחוֹקוֹת","N");
INSERT INTO hebrew_lemma VALUES ("r#00006065","r","לְעֵרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("r#00052557","r","לְעֵת-עַתָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00059620","r","לְפֶתַע","N");
INSERT INTO hebrew_lemma VALUES ("r#00167185","r","לְפֶתַע","N");
INSERT INTO hebrew_lemma VALUES ("r#00116080","r","לְפָנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00458729","n","לְקִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00106274","r","לְשָׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#05241839","n","לְשׁוֹן-הַקֹּדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00202730","v","לִבְלֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#08585601","n","לִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","לִגְלֵג","N");
INSERT INTO hebrew_lemma VALUES ("n#07289899","n","לִוְיָתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#01574318","n","לִוְיָתָן","N");
INSERT INTO hebrew_lemma VALUES ("v#01154777","v","לִטֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00094066","n","לִטּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#09815737","n","לִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06110607","n","לִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06164721","n","לִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05287483","n","לִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#09794447","n","לִיטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#08613795","n","לִילָךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#02258037","a","לִימוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02931334","n","לִיפְּסְטִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#02949126","n","לִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05491124","n","לִכּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#04949512","n","לִמּוּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00020741","r","לִפְעָמִים","N");
INSERT INTO hebrew_lemma VALUES ("r#00020741","r","לִפְרָקִים","N");
INSERT INTO hebrew_lemma VALUES ("v#01046121","v","לִפֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02420363","n","לִשְׁכַּת-הַשּׁוֹפֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#10096231","n","לֵאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06286659","n","לֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#07200414","n","לֵיְדִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00642547","a","לֵילִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07347950","n","לֵיצַן-הֶחָצֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004211","n","לֵיצָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004212","n","לֵיצָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07350149","n","לֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#09848270","n","לֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#02670260","n","לֶבֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#05721638","n","לֶחֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#05725136","n","לֶחֶם-הַקֹּדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("r#00383394","r","לֶנְטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#05772416","n","לֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04945821","n","לֶקֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#04955371","n","לֶקַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10528921","n","לֶשֶׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#05687344","n","לַאטְקֶעס","N");
INSERT INTO hebrew_lemma VALUES ("n#04186985","n","לַבְלַב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003953","n","לַבְקָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003954","n","לַבְקָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004116","n","לַהֲטוּטָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004117","n","לַהֲטוּטָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05985893","n","לַהֲקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05352409","n","לַהַג","N");
INSERT INTO hebrew_lemma VALUES ("n#05561864","n","לַהַט","N");
INSERT INTO hebrew_lemma VALUES ("n#03275905","n","לַוְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#06765049","n","לַוְיָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02426601","a","לַח","N");
INSERT INTO hebrew_lemma VALUES ("a#02427598","a","לַח","N");
INSERT INTO hebrew_lemma VALUES ("a#02426601","a","לַחְלוּחִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05723113","n","לַחְמָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00007075","r","לַחֲלוּטִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05270417","n","לַחַן","N");
INSERT INTO hebrew_lemma VALUES ("n#05334824","n","לַחַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10424817","n","לַחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05687344","n","לַטְקֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#06906151","n","לַיְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06906151","n","לַיִל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004221","n","לַכְלְכָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004222","n","לַכְלְכָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04590750","n","לַמְדָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("r#00026464","r","לַמְרוֹת-זֹאת","N");
INSERT INTO hebrew_lemma VALUES ("n#08236241","n","לַעֲנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05037006","n","לַעַג","N");
INSERT INTO hebrew_lemma VALUES ("r#00164034","r","לַשָּׁוְא","N");
INSERT INTO hebrew_lemma VALUES ("r#00063169","r","לָאַחֲרוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00620008","v","לָאַט","N");
INSERT INTO hebrew_lemma VALUES ("v#00037297","v","לָבַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02816318","n","לָבָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03613524","n","לָבָן","N");
INSERT INTO hebrew_lemma VALUES ("n#05872814","n","לָבָן","N");
INSERT INTO hebrew_lemma VALUES ("v#00796117","v","לָגַם","N");
INSERT INTO hebrew_lemma VALUES ("n#00037139","n","לָהִיט","N");
INSERT INTO hebrew_lemma VALUES ("v#01759411","v","לָחַץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00620008","v","לָחַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05221640","n","לָטִינִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10295713","n","לָמִינִיטִיס","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","לָעַג","N");
INSERT INTO hebrew_lemma VALUES ("v#00490373","v","לָקַח-בְּחֶשְׁבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03042473","n","לָקוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07197309","n","לָקוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01539893","a","לָקוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01748351","a","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00022819","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00023305","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00049246","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00115773","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00022819","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00023074","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00023305","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("r#00049246","r","לֹא","N");
INSERT INTO hebrew_lemma VALUES ("a#02389816","a","לֹא-בָּקִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01038036","a","לֹא-קָבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03877535","n","לֹבֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#05678434","n","לֻבְנָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07205503","n","לוֹוֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003987","n","לוֹחֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003988","n","לוֹחֶמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07382352","n","לוֹט","N");
INSERT INTO hebrew_lemma VALUES ("a#00550293","a","לוֹיָאלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03348184","n","לוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05621336","n","לוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02294665","n","לוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02493245","n","לוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#10836071","n","לוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02429288","n","לוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003957","n","לוּלְיָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02205944","a","לוּלְיָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003958","n","לוּלְיָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02520649","n","לוּלָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02360473","n","לוּלָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02421451","n","לוּסְטְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03989310","n","לוּקְסוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#09175035","n","לע-הָאֲרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06772258","n","לעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06738768","n","לעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05331503","n","מְאֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06950629","n","מְאַהֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#07414751","n","מְאַהֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07550942","n","מְאַהֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07414869","n","מְאַהֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03571404","n","מְאַוְרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#02386680","n","מְאַיֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#07630332","n","מְאַלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07648253","n","מְאַמֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06098727","n","מְאַסֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07326875","n","מְאָרַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#07327154","n","מְאָרַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#07221327","n","מְאֻבָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06670747","n","מְאֻבָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00583688","a","מְאֻדֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02388281","a","מְאֻוְרָר","N");
INSERT INTO hebrew_lemma VALUES ("a#02402895","a","מְאֻיָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#02222607","a","מְאֻכְזָב","N");
INSERT INTO hebrew_lemma VALUES ("a#01257959","a","מְאֻכְלָס","N");
INSERT INTO hebrew_lemma VALUES ("a#01692973","a","מְאֻלְתָּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00054768","r","מְאוֹד","N");
INSERT INTO hebrew_lemma VALUES ("r#00031106","r","מְאוֹד","N");
INSERT INTO hebrew_lemma VALUES ("r#00057204","r","מְאוֹד-מְאוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004475","n","מְאוֹתֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004479","n","מְאוֹתֶתֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06335368","n","מְאוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003956","n","מְבִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07469314","n","מְבַצֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004313","n","מְבַצֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004314","n","מְבַצַּעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004218","n","מְבַשֶּׁלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06847525","n","מְבַשֵּׂר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003992","n","מְבֻגֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003991","n","מְבֻגָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01733541","a","מְבֻדָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02022284","a","מְבֻטָּח","N");
INSERT INTO hebrew_lemma VALUES ("a#01592068","a","מְבֻטָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01875788","a","מְבֻסָּס","N");
INSERT INTO hebrew_lemma VALUES ("a#01812743","a","מְבֻצָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00582011","a","מְבֻשָּׁל","N");
INSERT INTO hebrew_lemma VALUES ("a#00581303","a","מְבֻשָּׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#02191831","n","מְבוֹאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10706467","n","מְבוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#04393348","n","מְבוּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004202","n","מְגִנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07068497","n","מְגַדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07125591","n","מְגַדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06390652","n","מְגַמָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00695450","a","מְגַמָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04701641","n","מְגַמָּתִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01305893","a","מְגֹהָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07252035","n","מְגֹרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00979375","a","מְגֻלְגָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#02070545","a","מְגֻלָּח","N");
INSERT INTO hebrew_lemma VALUES ("a#01268661","a","מְגֻנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00979375","a","מְגוֹלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02353326","n","מְגוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00643864","n","מְדִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04991678","n","מְדִינִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04536028","n","מְדִינִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06455500","n","מְדִינַת-יִשְׂרָאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#06074189","n","מְדִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06079469","n","מְדִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06299747","n","מְדִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06374245","n","מְדִינָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00652168","v","מְדַבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00243891","a","מְדַמֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004239","n","מְדַקְדֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004240","n","מְדַקְדֶּקֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01094898","a","מְדֹרָג","N");
INSERT INTO hebrew_lemma VALUES ("a#00953586","a","מְדֻשָּׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#05444860","n","מְדוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10393286","n","מְהִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03948579","n","מְהִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00688247","a","מְהֵימָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03679549","n","מְהֵימָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03680488","n","מְהֵימָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00276475","a","מְהַבְהֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004229","n","מְהַגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004231","n","מְהַגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004230","n","מְהַגֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004232","n","מְהַגֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07332142","n","מְהַפְנֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#07332142","n","מְהַפְּנֵט","N");
INSERT INTO hebrew_lemma VALUES ("a#01321211","a","מְהֻלָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00824313","a","מְהֻפְּנָט","N");
INSERT INTO hebrew_lemma VALUES ("n#00361442","n","מְהוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00361901","n","מְהוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09641408","n","מְזֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09641259","n","מְזֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09641408","n","מְזֻמָּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#09641259","n","מְזֻמָּנִים","N");
INSERT INTO hebrew_lemma VALUES ("a#00081633","a","מְזֻעְזָע","N");
INSERT INTO hebrew_lemma VALUES ("a#00081633","a","מְזֻעֲזָע","N");
INSERT INTO hebrew_lemma VALUES ("n#05017234","n","מְחִיאוֹת-כַּפַּיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#04008333","n","מְחִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#05522555","n","מְחִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#09576753","n","מְחִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#04022516","n","מְחִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#03091619","n","מְחִצָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09797175","n","מְחִצָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004633","n","מְחַבֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07689380","n","מְחַבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004634","n","מְחַבֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07092196","n","מְחַבֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004319","n","מְחַדֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004320","n","מְחַדֶּשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#07621123","n","מְחַזֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003660","n","מְחַנֵּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003661","n","מְחַנֶּכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07128625","n","מְחַצְצֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#00874188","a","מְחַשְׁמֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#05387111","n","מְחָאָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01942145","a","מְחֻדָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02212204","a","מְחֻזָּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00731811","n","מְחֻיָּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#02882176","a","מְחֻמְצָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01197989","a","מְחֻמָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#01205339","a","מְחֻמָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10001449","n","מְחֻמָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02252217","a","מְחֻסָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01080665","a","מְחֻרְבָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01107477","a","מְחֻשָּׁב","N");
INSERT INTO hebrew_lemma VALUES ("a#02553561","a","מְחוֹזִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01057111","a","מְחוֹזִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07368908","n","מְחוֹקֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004241","n","מְטַיֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004242","n","מְטַיֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#01111718","n","מְטַפֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#09394860","n","מְטַפֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#09393003","n","מְטַפֵּס","N");
INSERT INTO hebrew_lemma VALUES ("n#07427165","n","מְטַפֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01997327","a","מְטֹרָף","N");
INSERT INTO hebrew_lemma VALUES ("a#00582538","a","מְטֻגָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#02446777","a","מְטֻפָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00744544","a","מְטֻשְׁטָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00405649","a","מְטֻשְׁטָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#02875044","n","מְטוֹס-סִילוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03103907","n","מְטוּטֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#00798083","a","מְיַגֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04629219","n","מְיַלְּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07408554","n","מְיַלֶּדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07276457","n","מְיַסֵּד","N");
INSERT INTO hebrew_lemma VALUES ("a#01148040","a","מְיַצֵּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01241891","a","מְיֹעָד","N");
INSERT INTO hebrew_lemma VALUES ("a#02449626","a","מְיֹעָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04771907","n","מְיֻדָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#07060310","n","מְיֻדָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#02427972","a","מְיֻזָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#03740993","n","מְיֻחָדוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#02120292","a","מְיֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#04359865","n","מְיֻמָּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04360292","n","מְיֻמָּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01524704","a","מְיֻתָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05265364","n","מְיוּזִיקְל","N");
INSERT INTO hebrew_lemma VALUES ("n#01831351","n","מְכַרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#03055722","n","מְכָלִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07630406","n","מְכָלִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01175167","a","מְכֻבָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#02462881","a","מְכֻבָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00520179","a","מְכֻוָּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#02311557","a","מְכֻנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07343477","n","מְכֻנָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#07062359","n","מְכֻתָּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01597378","a","מְכֻתָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01599514","a","מְכֻתָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02383458","n","מְכוֹנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06277165","n","מְכוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03145459","n","מְלִיאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04417426","n","מְלִיחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09625793","n","מְלַאי","N");
INSERT INTO hebrew_lemma VALUES ("a#00825323","a","מְלַבֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004205","n","מְלַוֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004206","n","מְלַוָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02345767","n","מְלַטֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03757381","n","מְלָאכוּתִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01530237","a","מְלֻכְלָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07550283","n","מְלֻמָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#07549738","n","מְלֻמָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#02884926","n","מְלוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00489225","a","מְמַצֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02408307","a","מְמֻזָּג","N");
INSERT INTO hebrew_lemma VALUES ("a#01497126","a","מְמֻנָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#01461075","a","מְמֻנָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#00450971","a","מְמֻסְחָר","N");
INSERT INTO hebrew_lemma VALUES ("a#02052210","a","מְמֻקָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00827226","a","מְמֻשְׁכָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00697202","n","מְנִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09959513","n","מְנִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07424573","n","מְנַגֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07063762","n","מְנַהֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#07392929","n","מְנַהֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004237","n","מְנַצֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004238","n","מְנַצֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003703","n","מְנַתֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003704","n","מְנַתַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("a#01603792","a","מְנֻגָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#01746928","a","מְנֻגָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00604960","a","מְנֻמָּס","N");
INSERT INTO hebrew_lemma VALUES ("a#00389154","a","מְנֻקֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00624610","a","מְנֻקָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004564","n","מְנוּיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00032687","n","מְנוּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00205135","n","מְסִירָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02244840","a","מְסַיֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03424410","n","מְסַנֶּנֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01077729","a","מְסַפֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004311","n","מְסַפֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004311","n","מְסַפֵּר-סִפּוּרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004312","n","מְסַפֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004312","n","מְסַפֶּרֶת-סִפּוּרִים","N");
INSERT INTO hebrew_lemma VALUES ("a#02310342","a","מְסֹרָק","N");
INSERT INTO hebrew_lemma VALUES ("a#02093020","a","מְסֻבָּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01517206","a","מְסֻגְנָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00466878","a","מְסֻגָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00525982","a","מְסֻגָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02304688","a","מְסֻדָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02423250","a","מְסֻחְרָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01651175","a","מְסֻיָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#01982885","a","מְסֻכָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01983358","a","מְסֻכָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01981873","a","מְסֻכָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00977176","a","מְסֻלְסָל","N");
INSERT INTO hebrew_lemma VALUES ("a#02202211","a","מְסֻקָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#04286746","n","מְעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00496188","n","מְעִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09911106","n","מְעַט","N");
INSERT INTO hebrew_lemma VALUES ("r#00032688","r","מְעַט","N");
INSERT INTO hebrew_lemma VALUES ("a#00798083","a","מְעַיֵּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01290353","a","מְעַנְיֵן","N");
INSERT INTO hebrew_lemma VALUES ("a#00092842","a","מְעַצְבֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004262","n","מְעַצֵּב-פְּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004263","n","מְעַצֶּבֶת-פְּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#06737795","n","מְעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01272749","a","מְעֹרָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00504043","a","מְעֹרָם","N");
INSERT INTO hebrew_lemma VALUES ("a#02065259","a","מְעֻוָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10002071","n","מְעֻיָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#02232109","a","מְעֻלֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01078106","a","מְעֻלֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00279019","a","מְעֻמְעָם","N");
INSERT INTO hebrew_lemma VALUES ("a#00744748","a","מְעֻנָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00430275","a","מְעֻנָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01016940","a","מְעֻפָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00620033","a","מְעֻקָּב","N");
INSERT INTO hebrew_lemma VALUES ("a#00427123","a","מְעֻרְטָל","N");
INSERT INTO hebrew_lemma VALUES ("a#00430514","a","מְעֻרְפָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00663009","a","מְעֻרְפָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01021112","a","מְעֻשָּׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#10001823","n","מְעֻשָּׂר","N");
INSERT INTO hebrew_lemma VALUES ("a#01733675","a","מְעוֹדָד","N");
INSERT INTO hebrew_lemma VALUES ("n#02835270","n","מְעוֹנוֹת","N");
INSERT INTO hebrew_lemma VALUES ("a#01768786","a","מְפַגֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07168653","n","מְפַקֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004213","n","מְפַקֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004260","n","מְפַקֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004214","n","מְפַקֶּדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004261","n","מְפַקַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004209","n","מְפַרְנֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004210","n","מְפַרְנֶסֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01232112","a","מְפֹאָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00304990","a","מְפֹרָט","N");
INSERT INTO hebrew_lemma VALUES ("a#01324211","a","מְפֹרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00893241","a","מְפֹרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00953586","a","מְפֻטָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00823368","a","מְפֻטָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01216154","a","מְפֻלְפָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004235","n","מְפֻנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00878583","a","מְפֻנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","מְפֻנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004236","n","מְפֻנָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02882459","a","מְפֻסְטָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01719818","a","מְפֻסְפָּס","N");
INSERT INTO hebrew_lemma VALUES ("a#01321211","a","מְפֻרְסָם","N");
INSERT INTO hebrew_lemma VALUES ("n#00540731","n","מְצִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01001630","a","מְצַעֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#03431121","n","מְצָד","N");
INSERT INTO hebrew_lemma VALUES ("n#02354112","n","מְצָד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004289","n","מְצֹרַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004295","n","מְצֹרַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004288","n","מְצֹרָע","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004294","n","מְצֹרָע","N");
INSERT INTO hebrew_lemma VALUES ("a#01558954","a","מְצֻוֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02232109","a","מְצֻיָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09989692","n","מְצֻלָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#09990561","n","מְצֻלָּע-מְשֻׁכְלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#09990063","n","מְצֻלָּע-קָמוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#09990255","n","מְצֻלָּע-קָעוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02262475","n","מְצוּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09762118","n","מְקַדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04617294","n","מְקַדֵּם-מִתְאָם","N");
INSERT INTO hebrew_lemma VALUES ("n#02629139","n","מְקָרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#03225469","n","מְקָרֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#01639661","a","מְקֹרֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01976717","a","מְקֻדָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00631927","a","מְקֻלָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00632302","a","מְקֻלָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01970144","a","מְקֻמָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00502070","a","מְקֻמָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01793416","a","מְקֻפָּח","N");
INSERT INTO hebrew_lemma VALUES ("a#00623957","a","מְקֻצָּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#00977176","a","מְקֻרְזָל","N");
INSERT INTO hebrew_lemma VALUES ("a#01724371","a","מְקֻשָּׁט","N");
INSERT INTO hebrew_lemma VALUES ("a#00056778","a","מְקֻשָּׁט","N");
INSERT INTO hebrew_lemma VALUES ("n#03631348","n","מְקוֹם-עֲבוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05369518","n","מְרִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00617685","n","מְרִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00762791","n","מְרִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02255539","n","מְרִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01433642","a","מְרַבִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#07603319","n","מְרַגֵּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00873571","a","מְרַגֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02195972","a","מְרַגֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004219","n","מְרַכֵּז","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004220","n","מְרַכֶּזֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01045200","a","מְרֹהָט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004281","n","מְרֻאְיֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004280","n","מְרֻאְיָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01489680","a","מְרֻבֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09999084","n","מְרֻבָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#00235547","a","מְרֻבָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#00284623","a","מְרֻסָּק","N");
INSERT INTO hebrew_lemma VALUES ("a#01733361","a","מְרֻצֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01820636","a","מְרֻצֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00556147","a","מְרֻצֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01637984","a","מְרֻצָּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02654562","a","מְשִׁיחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00601880","a","מְשַׁלְשֵׁל","N");
INSERT INTO hebrew_lemma VALUES ("a#01291600","a","מְשַׁעֲמֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#01737913","a","מְשַׁעֲשֵׁעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01733541","a","מְשָׁעֳשָׁע","N");
INSERT INTO hebrew_lemma VALUES ("n#10052725","n","מְשָׁרֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#07566572","n","מְשָׁרֵת","N");
INSERT INTO hebrew_lemma VALUES ("a#00297396","a","מְשֹׁעָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10001597","n","מְשֻׁבָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#02068202","a","מְשֻׁכְלָל","N");
INSERT INTO hebrew_lemma VALUES ("a#01793416","a","מְשֻׁלָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#09999242","n","מְשֻׁלָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03538338","n","מְשֻׁלָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03538480","n","מְשֻׁלָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02141036","a","מְשֻׁנָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01013304","a","מְשֻׁעְבָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#01733541","a","מְשֻׁעְשָׁע","N");
INSERT INTO hebrew_lemma VALUES ("a#02458672","a","מְשֻׁפְשָׁף","N");
INSERT INTO hebrew_lemma VALUES ("a#01928002","a","מְשֻׁקָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10001524","n","מְשֻׁשֶּׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#02037068","a","מְשֻׁתָּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02069778","a","מְשֻׁתָּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02069607","a","מְשֻׁתָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07483717","n","מְשׁוֹרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#00461778","n","מְשִׂימָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01308059","a","מְשַׂמֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05552482","n","מְשׂוּכוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05636553","n","מְתַאֲבֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004315","n","מְתַכְנֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004317","n","מְתַכְנֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004316","n","מְתַכְנֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004318","n","מְתַכְנֶתֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01700267","a","מְתַסְכֵּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00826169","a","מְתַסְכֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07528266","n","מְתַקֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004557","n","מְתַקֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004558","n","מְתַקֶּנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04937943","n","מְתַרְגֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07342915","n","מְתַרְגֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004219","n","מְתָאֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004220","n","מְתָאֶמֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01652789","a","מְתֹאָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00977176","a","מְתֻלְתָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00512104","a","מְתֻמְצָת","N");
INSERT INTO hebrew_lemma VALUES ("n#10001673","n","מְתֻמָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00659470","a","מְתֻסְכָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#02222607","a","מְתֻסְכָּל","N");
INSERT INTO hebrew_lemma VALUES ("a#01927798","a","מְתֻקָּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01879678","a","מְתֻרְבָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07342915","n","מְתֻרְגְּמָן","N");
INSERT INTO hebrew_lemma VALUES ("n#10001749","n","מְתֻשָׁע","N");
INSERT INTO hebrew_lemma VALUES ("n#07229788","n","מְתוֹפֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#02585224","n","מִבְדּוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#03608465","n","מִבְדּוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#03431817","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03858780","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03860008","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04062157","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04423204","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#06199619","n","מִבְנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03904884","n","מִבְנֶה-גּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02716224","n","מִבְצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#02669463","n","מִגְבַּעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#04021804","n","מִגְבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02277408","n","מִגְדַּל-פַּעֲמוֹנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03593869","n","מִגְדַּל-תַּצְפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#03523510","n","מִגְדָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02269979","n","מִגְדָּלוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03910916","n","מִגְדָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02511316","n","מִגְרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05992155","n","מִגְרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06318048","n","מִגְרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06273995","n","מִדְבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06335561","n","מִדְשָׁאָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00020741","r","מִדֵּי-פַּעַם","N");
INSERT INTO hebrew_lemma VALUES ("r#00045916","r","מִדַּי","N");
INSERT INTO hebrew_lemma VALUES ("n#03991813","n","מִדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06667120","n","מִדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10045533","n","מִדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03972490","n","מִדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02237739","n","מִזְוָד","N");
INSERT INTO hebrew_lemma VALUES ("n#04882660","n","מִזְכָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04857466","n","מִזְמוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04857558","n","מִזְמוֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#01434385","a","מִזְעָרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09964070","n","מִזְרָח","N");
INSERT INTO hebrew_lemma VALUES ("a#00784074","a","מִזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00786532","a","מִזְרָחִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00318951","r","מִזְרָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02974054","n","מִזְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02974054","n","מִזְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00607051","n","מִחְזוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05626343","n","מִטְבָּח","N");
INSERT INTO hebrew_lemma VALUES ("n#02890846","n","מִטְבָּח","N");
INSERT INTO hebrew_lemma VALUES ("n#02388459","n","מִטְעָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02237739","n","מִטְעָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02792499","n","מִטְפַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#02885175","n","מִטְפַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#02809295","n","מִטְפַּחַת-רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00245729","n","מִטְרִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03558885","n","מִטְרִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00532025","n","מִטְרִיָּה-אֲוִירִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04490800","n","מִטְרָד","N");
INSERT INTO hebrew_lemma VALUES ("n#02792499","n","מִטפַּחַת-אַף","N");
INSERT INTO hebrew_lemma VALUES ("n#05118893","n","מִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05139537","n","מִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00102070","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00102202","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00102338","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00500318","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00500428","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00047341","r","מִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00678141","a","מִיָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00927884","a","מִיָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01668370","a","מִיָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00927659","a","מִיָּדִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00047341","r","מִיָּדִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04425786","n","מִיּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09902865","n","מִילְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06208663","n","מִילִיצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00541686","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05566729","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("n#04775802","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05991993","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("n#04496504","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("n#03910916","n","מִין","N");
INSERT INTO hebrew_lemma VALUES ("a#01434385","a","מִינִימָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10508351","n","מִינֶרָל","N");
INSERT INTO hebrew_lemma VALUES ("a#01749437","a","מִינוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#04586741","n","מִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04196137","n","מִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#05943522","n","מִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00004123","n","מִישֶׁהוּ","N");
INSERT INTO hebrew_lemma VALUES ("a#01321645","a","מִיתוֹלוֹגִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02911395","n","מִכְבָּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03078949","n","מִכְחוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#06146495","n","מִכְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03614902","n","מִכְלוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#02920866","n","מִכְסֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03001546","n","מִכְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#02859872","n","מִכְשׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04968965","n","מִכְתָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#04887366","n","מִכְתָּב-הִתְפַּטְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03296615","n","מִכְתָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00064182","n","מִכּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09546354","n","מִלְגָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00614914","n","מִלְחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00044621","r","מִלְּבַד-זֹאת","N");
INSERT INTO hebrew_lemma VALUES ("a#01580126","a","מִלִּפְנֵי-הַמַּבּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04754686","n","מִלָּה-שְׁאוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02792499","n","מִמְחָטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03227070","n","מִמְסָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06000383","n","מִמְשָׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#00712138","n","מִמּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00061322","n","מִמּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("r#00134549","r","מִן-הַסְּתָם","N");
INSERT INTO hebrew_lemma VALUES ("n#06729187","n","מִנְהָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03550931","n","מִנְהָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02494445","n","מִנְזָר","N");
INSERT INTO hebrew_lemma VALUES ("n#03010416","n","מִנְזָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06105666","n","מִנְזָר","N");
INSERT INTO hebrew_lemma VALUES ("n#05043559","n","מִנְשָׁר","N");
INSERT INTO hebrew_lemma VALUES ("v#01686884","v","מִנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00706704","n","מִנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05367055","n","מִנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#09557875","n","מִנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#09918604","n","מִנּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02720094","n","מִסְגֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04527384","n","מִסְגֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03015760","n","מִסְגָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00601893","n","מִסְגּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02504113","n","מִסְדְּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00335874","n","מִסְדָּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00328216","v","מִסְחֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#00706993","n","מִסְחָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06058462","n","מִסְחָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00609454","n","מִסְחוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03246805","n","מִסְלָעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03424410","n","מִסְנֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03233732","n","מִסְעָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03320411","n","מִסְפָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06363422","n","מִסְפָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05097671","n","מִסְפָּר","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","מִסְפָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00462055","a","מִסְפָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01990138","a","מִסְפָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02158584","a","מִסְפָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05834839","n","מִסְפּוֹא","N");
INSERT INTO hebrew_lemma VALUES ("n#04394091","n","מִסְתּוֹרִין","N");
INSERT INTO hebrew_lemma VALUES ("n#03991493","n","מִעוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#05973473","n","מִעוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#02716453","n","מִפְגָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00799023","n","מִפְגָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00695227","a","מִפְלַגְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01335151","a","מִפְלַצְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00218557","a","מִפְלַצְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01084054","a","מִפְלַצְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#06131180","n","מִפְלָגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00508925","n","מִפְעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02662271","n","מִפְעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#06004580","n","מִפְעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#10964831","n","מִפְעָם","N");
INSERT INTO hebrew_lemma VALUES ("n#00427077","n","מִפְקַד-אֻכְלוּסִין","N");
INSERT INTO hebrew_lemma VALUES ("n#00427077","n","מִפְקָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06735286","n","מִפְרָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06789684","n","מִפְרָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04335626","n","מִפְרָק","N");
INSERT INTO hebrew_lemma VALUES ("n#05360712","n","מִצְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00075441","n","מִצְמוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00335874","n","מִצְעָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06248227","n","מִצְעָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06234223","n","מִצְעָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06340480","n","מִצְפֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10048803","n","מִצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#09633002","n","מִקְדָּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10707339","n","מִקְטָע","N");
INSERT INTO hebrew_lemma VALUES ("n#02870166","n","מִקְטֹרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#03330936","n","מִקְלְחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02263808","n","מִקְלַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#03330277","n","מִקְלַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#02403444","n","מִקְלַעַת","N");
INSERT INTO hebrew_lemma VALUES ("a#02633578","a","מִקְצוֹעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10047274","n","מִקְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#05448971","n","מִקְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#05432762","n","מִקְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#00489333","v","מִקֵּד","N");
INSERT INTO hebrew_lemma VALUES ("v#01354457","v","מִקֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00764108","v","מִקֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04791907","n","מִקּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#05348764","n","מִקּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00014887","n","מִקּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00206677","n","מִרְדָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10024194","n","מִרְוָח","N");
INSERT INTO hebrew_lemma VALUES ("v#01265527","v","מִרְכֵּז","N");
INSERT INTO hebrew_lemma VALUES ("v#00281483","v","מִרְכֵּז","N");
INSERT INTO hebrew_lemma VALUES ("n#02450085","n","מִרְפְּאַת-חוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02239875","n","מִרְפֶּסֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05346176","n","מִרְפָּאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06002732","n","מִרְפָּאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02864326","n","מִרְשֶׁתֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04964806","n","מִשְׁדָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00121609","n","מִשְׁוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05001502","n","מִשְׁוָאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04540856","n","מִשְׁטָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06093563","n","מִשְׁטָרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01606101","v","מִשְׁכֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06213619","n","מִשְׁלַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#03905655","n","מִשְׁמַנִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#02231667","n","מִשְׁעֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07352677","n","מִשְׁפְּטָן","N");
INSERT INTO hebrew_lemma VALUES ("n#06021037","n","מִשְׁפָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05977978","n","מִשְׁפָּחָה-אוֹמֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05977683","n","מִשְׁפָּחָה_גַּרְעִינִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02290626","n","מִשְׁקֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01137740","a","מִשְׁקַל-זְבוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01137610","a","מִשְׁקַל-נוֹצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01137036","a","מִשְׁקַל-תַּרְנְגוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#05996300","n","מִשְׁקָל","N");
INSERT INTO hebrew_lemma VALUES ("n#03925610","n","מִשְׁקָל","N");
INSERT INTO hebrew_lemma VALUES ("a#01136044","a","מִשְׁקָל-בֵּינוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01136363","a","מִשְׁקָל-חֲצִי-בֵּינוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01135612","a","מִשְׁקָל-כָּבֵד","N");
INSERT INTO hebrew_lemma VALUES ("a#01137977","a","מִשְׁקָל-קַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07583177","n","מִשְׁתַּמֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#06847350","n","מִשְׁתַּנֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03048175","n","מִשְׁתָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00323207","n","מִשְׂחַק-הַמְּלָכִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00358063","n","מִשְׂחָק","N");
INSERT INTO hebrew_lemma VALUES ("n#06061034","n","מִשְׂרַד-הַפְּנִים-הָאָמֶרִיקָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06182017","n","מִשְׂרָד","N");
INSERT INTO hebrew_lemma VALUES ("n#07688631","n","מִתְאַבֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#04616407","n","מִתְאָם","N");
INSERT INTO hebrew_lemma VALUES ("n#07336148","n","מִתְחַזֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07390670","n","מִתְחַלֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00478654","a","מִתְחָרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004455","n","מִתְיַשֵּׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004456","n","מִתְיַשֶּׁבֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01689692","a","מִתְכַּלֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02797103","n","מִתְלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004642","n","מִתְלַמֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004643","n","מִתְלַמֶּדֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#00441120","a","מִתְלַקֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004644","n","מִתְנַדֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004646","n","מִתְנַדֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004645","n","מִתְנַדֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004647","n","מִתְנַדֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004455","n","מִתְנַחֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004456","n","מִתְנַחֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07306217","n","מִתְעַמֵּל","N");
INSERT INTO hebrew_lemma VALUES ("a#00434628","a","מִתְקַפֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03635572","n","מִתְקָן-סְחִיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02254799","n","מִתְרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#07254887","n","מִתְרוֹמֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#09892584","n","מֵאִית","N");
INSERT INTO hebrew_lemma VALUES ("v#00541774","v","מֵאֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#09901877","n","מֵאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09978384","n","מֵאָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00014301","r","מֵאָה-אָחוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#04977056","n","מֵאוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003955","n","מֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("a#01683181","a","מֵבִין","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004201","n","מֵגֵן","N");
INSERT INTO hebrew_lemma VALUES ("a#00049270","a","מֵהַצַּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00110345","r","מֵחָדָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10279666","n","מֵחוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10655576","n","מֵי-רַגְלַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#10656399","n","מֵי-שׁוֹפְכִין","N");
INSERT INTO hebrew_lemma VALUES ("n#04977171","n","מֵידָע","N");
INSERT INTO hebrew_lemma VALUES ("n#06941293","n","מֵיטִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#05351147","n","מֵימְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10488691","n","מֵימָן","N");
INSERT INTO hebrew_lemma VALUES ("n#10796986","n","מֵמֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#00013700","n","מֵנִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#00092842","a","מֵצִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#04341992","n","מֵצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#06745243","n","מֵצַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06745243","n","מֵצַר-יַבָּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("r#00064503","r","מֵרֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00379645","n","מֵרוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05960134","n","מֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#02983580","n","מֶגָפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04734700","n","מֶדְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05029668","n","מֶדַלְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03648054","n","מֶזֶג","N");
INSERT INTO hebrew_lemma VALUES ("n#02862021","n","מֶחְלָף","N");
INSERT INTO hebrew_lemma VALUES ("n#04467719","n","מֶחְקָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00417296","n","מֶחְקָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00215081","n","מֶחֱוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00796865","n","מֶחֱוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02993501","n","מֶטְרוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#09822324","n","מֶטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#03470891","n","מֶטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#09587324","n","מֶכֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#02987655","n","מֶכֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#07671545","n","מֶלְצַר","N");
INSERT INTO hebrew_lemma VALUES ("n#07671746","n","מֶלְצָרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02452062","n","מֶלְתָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10619948","n","מֶלֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#10731399","n","מֶלֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#07735082","n","מֶלֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#01637880","n","מֶלֶךְ-הַחַיּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#10772760","n","מֶלַח","N");
INSERT INTO hebrew_lemma VALUES ("n#05846273","n","מֶלַח","N");
INSERT INTO hebrew_lemma VALUES ("n#08469714","n","מֶלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#08469955","n","מֶלוֹן_אַפְרִיקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06000383","n","מֶמְשָׁלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04949838","n","מֶסֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04729537","n","מֶסֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#02424284","n","מֶרְכָּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06530219","n","מֶרְכָּז","N");
INSERT INTO hebrew_lemma VALUES ("n#06286659","n","מֶרְכָּז","N");
INSERT INTO hebrew_lemma VALUES ("n#06318511","n","מֶרְכָּז-הַמִּגְרָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03456767","n","מֶרְכָּזִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03963506","n","מֶרְכָּזִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10923619","n","מֶרְץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00617685","n","מֶרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00617685","n","מֶרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#00762791","n","מֶרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#10540432","n","מֶרֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#03338120","n","מֶשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#03943113","n","מֶשֶׁךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10859852","n","מֶשֶׁךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02666240","n","מֶשֶׁק","N");
INSERT INTO hebrew_lemma VALUES ("n#10728170","n","מֶתָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01609323","a","מֶתוֹדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06754119","n","מַאְדִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#00409719","n","מַאֲבָק","N");
INSERT INTO hebrew_lemma VALUES ("n#00505798","n","מַאֲבָק","N");
INSERT INTO hebrew_lemma VALUES ("n#00614914","n","מַאֲבָק","N");
INSERT INTO hebrew_lemma VALUES ("n#07991644","n","מַאֲבָק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003897","n","מַאֲזִין","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003898","n","מַאֲזִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00409314","n","מַאֲמָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00503611","n","מַאֲמָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02238961","n","מַאֲפִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#08927613","n","מַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#10924252","n","מַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#04850278","n","מַארְק","N");
INSERT INTO hebrew_lemma VALUES ("n#02355821","n","מַבְעֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004561","n","מַבְרִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004562","n","מַבְרִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03288471","n","מַבְרֵג","N");
INSERT INTO hebrew_lemma VALUES ("n#02983580","n","מַגְבִּיר-קוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#02185415","n","מַגְבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03351837","n","מַגְלֵשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01076845","a","מַגְנִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#02954440","n","מַגְנֵט","N");
INSERT INTO hebrew_lemma VALUES ("a#01566899","a","מַגְעִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#02528299","n","מַגְרֵסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03210008","n","מַגְרֵפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03522760","n","מַגֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03333468","n","מַגָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05432221","n","מַגָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#03534522","n","מַגָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01139868","a","מַדְאִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#02481403","n","מַדְחֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#03493877","n","מַדְחֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#03410915","n","מַדְרֵגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07551670","n","מַדְּעָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03560722","n","מַדִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#02668605","n","מַדֵּי-בֵּית","N");
INSERT INTO hebrew_lemma VALUES ("n#04982561","n","מַדַּד-הַמְּחִירִים-לַצַּרְכָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04982561","n","מַדָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#04359865","n","מַדָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#04596663","n","מַדָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#04596907","n","מַדָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#02601025","a","מַדָּעִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02005997","a","מַדָּעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06740141","n","מַדָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03314483","n","מַדָּף","N");
INSERT INTO hebrew_lemma VALUES ("r#00031106","r","מַה-זֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004559","n","מַהְפְּכָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004560","n","מַהְפְּכָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00618075","n","מַהְפֵּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05524865","n","מַהְפֵּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04948748","n","מַהֲדוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05968443","n","מַהֲדוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04944727","n","מַהֲדוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02750133","n","מַהֲלָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#06249735","n","מַהֲלָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#06730089","n","מַהֲמוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00082992","r","מַהֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#00012865","n","מַהוּת-פְּסִיכוֹלוֹגִית","N");
INSERT INTO hebrew_lemma VALUES ("a#02563837","a","מַהוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02079609","a","מַהוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02170691","n","מַזְגָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07529024","n","מַזְכִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#07556672","n","מַזְכִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#07556911","n","מַזְכִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#02884672","n","מַזְכֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04479404","n","מַזְכֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03459673","n","מַזְרֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#06395233","n","מַזַּל-גְּדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06395065","n","מַזַּל-קַשָּׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#07769986","n","מַזָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10381983","n","מַזָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#07770258","n","מַזָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02390632","n","מַחְבֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03200805","n","מַחְבֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03394310","n","מַחְבֵּט-סְקְווֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10981933","n","מַחְזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06115587","n","מַחְזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#10981933","n","מַחְזוֹר-חָדְשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#02477843","n","מַחְלֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#06058911","n","מַחְלֶקֶת-הַהֲגָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06060831","n","מַחְלֶקֶת-הַמְּדִינָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02809567","a","מַחְלַקְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#06302563","n","מַחְלָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06049069","n","מַחְלָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06039237","n","מַחְלָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06096872","n","מַחְלָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05369177","n","מַחְלקֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03244730","n","מַחְסוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#03986577","n","מַחְסוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#10367399","n","מַחְסוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03518223","n","מַחְצֵצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10508351","n","מַחְצָב","N");
INSERT INTO hebrew_lemma VALUES ("n#03132395","n","מַחְצָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02909970","n","מַחְרֵטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03034095","n","מַחְרֹזֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02368666","n","מַחְשְׁבוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07135102","n","מַחְשֵׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#02481557","n","מַחְשֵׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#02368666","n","מַחְשֵׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#04450733","n","מַחְשָׁבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04492484","n","מַחְשָׁבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04570143","n","מַחְשָׁבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03034426","n","מַחְשׂוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#06190366","n","מַחְתֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05265364","n","מַחֲזֶמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#07225854","n","מַחֲזַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#10168619","n","מַחֲלַת-הַנְסֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#10129713","n","מַחֲלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10207260","n","מַחֲלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10123988","n","מַחֲלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01198741","a","מַחֲנִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#02211356","n","מַחֲנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#00146677","n","מַחֲנָק","N");
INSERT INTO hebrew_lemma VALUES ("a#01394549","a","מַחֲרִישׁ-אָזְנַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#03259558","n","מַחַק","N");
INSERT INTO hebrew_lemma VALUES ("n#08538266","n","מַטְאֲטֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#08821583","n","מַטְאֲטֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#02343048","n","מַטְאֲטֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#09642587","n","מַטְבֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03001255","n","מַטְחֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09625689","n","מַטְמוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#01879301","n","מַטְעֵן","N");
INSERT INTO hebrew_lemma VALUES ("a#01173339","a","מַטְעֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00714136","a","מַטְרִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#07493768","n","מַטִּיף","N");
INSERT INTO hebrew_lemma VALUES ("n#02775434","n","מַטָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#09535771","n","מַטָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#03811208","n","מַטָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04586952","n","מַטָּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02912737","n","מַכְסֵחַת-דֶּשֶׁא","N");
INSERT INTO hebrew_lemma VALUES ("n#02912737","n","מַכְסֵחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00112599","n","מַכְשִׁיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06772258","n","מַכְתֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03014676","n","מַכְתֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06731752","n","מַכְתֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03201157","n","מַכָּ&quotם","N");
INSERT INTO hebrew_lemma VALUES ("n#07060310","n","מַכָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00798083","a","מַלְאֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#00176189","n","מַלְבִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#10002392","n","מַלְבֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004286","n","מַלְוֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07658922","n","מַלְוֶה-בְּרִבִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004287","n","מַלְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07173042","n","מַלְחִין","N");
INSERT INTO hebrew_lemma VALUES ("n#07543103","n","מַלָּח","N");
INSERT INTO hebrew_lemma VALUES ("a#00224659","a","מַמְאִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00224799","a","מַמְאִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#03391408","n","מַמְטֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004282","n","מַמְצִיא","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004283","n","מַמְצִיאָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00363408","r","מַמָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("r#00037263","r","מַמָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03738112","n","מַמָּשִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05270417","n","מַנְגִּינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05193039","n","מַנְדָּרִין","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004203","n","מַנְהִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004204","n","מַנְהִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09580808","n","מַס","N");
INSERT INTO hebrew_lemma VALUES ("n#06709272","n","מַסְלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06348591","n","מַסְלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03263282","n","מַסְלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03027985","n","מַסְמֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#02680280","n","מַסְנֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#02679962","n","מַסְנֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#00504369","n","מַסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04830849","n","מַסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00198579","n","מַסָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#02814163","n","מַסּוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#02877136","n","מַסּוֹרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02898427","n","מַעְבָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00717167","n","מַעְבֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02671945","n","מַעְבֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00191531","n","מַעְגָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02822908","n","מַעְדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06326607","n","מַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00093654","r","מַעְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004233","n","מַעֲבִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004234","n","מַעֲבִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00131763","n","מַעֲבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#02176857","n","מַעֲבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00180278","n","מַעֲבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#02176672","n","מַעֲבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06362245","n","מַעֲגָן","N");
INSERT INTO hebrew_lemma VALUES ("n#06362896","n","מַעֲגָן","N");
INSERT INTO hebrew_lemma VALUES ("n#06671614","n","מַעֲטֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#02635448","n","מַעֲלִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06724958","n","מַעֲלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#10356224","n","מַעֲלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09871313","n","מַעֲלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00379237","n","מַעֲלָלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10048803","n","מַעֲמָד","N");
INSERT INTO hebrew_lemma VALUES ("n#10049681","n","מַעֲמָד_חֶבְרָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","מַעֲמָסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05055491","n","מַעֲנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07722114","n","מַעֲנָק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004233","n","מַעֲסִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004234","n","מַעֲסִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00211896","n","מַעֲצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00523653","n","מַעֲצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00743956","n","מַעֲצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10085503","n","מַעֲצָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07631359","n","מַעֲרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004057","n","מַעֲרִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004058","n","מַעֲרִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06102786","n","מַעֲרֶכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06009454","n","מַעֲרֶכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06038109","n","מַעֲרֶכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09966059","n","מַעֲרָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00785018","a","מַעֲרָבִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00318838","r","מַעֲרָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10959680","n","מַעֲרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10371715","n","מַעֲרֻמִּים","N");
INSERT INTO hebrew_lemma VALUES ("a#01871755","a","מַעֲשִׂי","N");
INSERT INTO hebrew_lemma VALUES ("n#00474950","n","מַעֲשֵׂה-קֻנְדָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00017487","n","מַעֲשֶׂה","N");
INSERT INTO hebrew_lemma VALUES ("n#05083171","n","מַעַן","N");
INSERT INTO hebrew_lemma VALUES ("n#10371715","n","מַעַר","N");
INSERT INTO hebrew_lemma VALUES ("a#00067643","a","מַפְלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07381843","n","מַפְסִידָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07381938","n","מַפְסִידָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02433142","n","מַפְסֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004223","n","מַפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004224","n","מַפְקִידָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02248299","a","מַפְתִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06842790","n","מַפְּלֵי-אַנְחֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#03029664","n","מַפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#06794207","n","מַפַּל-מַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#03462134","n","מַפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02965788","n","מַפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06794207","n","מַפָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05558471","n","מַפָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05512009","n","מַפֹּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004017","n","מַצְבִּיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004018","n","מַצְבִּיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07678836","n","מַצְלִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#03087453","n","מַצְנֵחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03799909","n","מַצְפּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05580137","n","מַצְפּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06664059","n","מַצְפּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07373907","n","מַצִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#10835650","n","מַצִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#02984139","n","מַצֵּבַת-זִכָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02768644","n","מַצֵּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02900451","n","מַצֶּקֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10430604","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00016185","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03960878","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10031939","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10032130","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10034299","n","מַצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10000506","n","מַקְבִּילִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02603157","n","מַקְדֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02603535","n","מַקְדֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01433642","a","מַקְסִימָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02551422","n","מַקְפִּיא","N");
INSERT INTO hebrew_lemma VALUES ("n#02551422","n","מַקְפֵּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02584544","n","מַקְפֵּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03137218","n","מַקְצוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03136725","n","מַקְצוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00210644","a","מַקְרִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05126188","n","מַקָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#01736855","n","מַקָּק","N");
INSERT INTO hebrew_lemma VALUES ("n#07414666","n","מַר","N");
INSERT INTO hebrew_lemma VALUES ("n#05068012","n","מַרְאֵה-מָקוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#03004534","n","מַרְאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03260882","n","מַרְבָד","N");
INSERT INTO hebrew_lemma VALUES ("a#00092842","a","מַרְגִּיז","N");
INSERT INTO hebrew_lemma VALUES ("n#03014498","n","מַרְגֵּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05715937","n","מַרְגָּרִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07076009","n","מַרְדִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#02781109","n","מַרְזֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#03189222","n","מַרְיוֹנֶטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10923619","n","מַרְס","N");
INSERT INTO hebrew_lemma VALUES ("n#06754119","n","מַרְס","N");
INSERT INTO hebrew_lemma VALUES ("n#06903063","n","מַרְס","N");
INSERT INTO hebrew_lemma VALUES ("n#02730921","n","מַרְעוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#02228691","n","מַרְצֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07367816","n","מַרְצֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003662","n","מַרְצֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03504435","n","מַרְצֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003663","n","מַרְצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00795989","a","מַרְשִׁים","N");
INSERT INTO hebrew_lemma VALUES ("a#01229098","a","מַרְשִׁים","N");
INSERT INTO hebrew_lemma VALUES ("n#07197725","n","מַרְשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#02411112","n","מַרְתֵּף-יֵינוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","מַשָּׂא","N");
INSERT INTO hebrew_lemma VALUES ("n#05347846","n","מַשָּׂא-וּמַתָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02942446","n","מַשָּׂאִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03186409","n","מַשְׁאֵבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10040291","n","מַשְׁבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05520463","n","מַשְׁבֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07345139","n","מַשְׁגִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03531817","n","מַשְׁדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03408089","n","מַשְׁחֵז","N");
INSERT INTO hebrew_lemma VALUES ("n#03310368","n","מַשְׁחֵזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02558580","n","מַשְׁחֶתֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09613349","n","מַשְׁכַּנְתָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#09613349","n","מַשְׁכַּנְתָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004221","n","מַשְׁמִיצָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004222","n","מַשְׁמִיצָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04546018","n","מַשְׁמָעוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#02078228","a","מַשְׁמָעוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01436246","a","מַשְׁמָעוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02435885","n","מַשְׁנֵק","N");
INSERT INTO hebrew_lemma VALUES ("a#00717242","a","מַשְׁפִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004284","n","מַשְׁקִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004285","n","מַשְׁקִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01077729","a","מַשְׂבִּיעַ-רָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05609785","n","מַשְׂטֵמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09556237","n","מַשְׂכֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#00138021","a","מַתְאִים","N");
INSERT INTO hebrew_lemma VALUES ("a#01077975","a","מַתְאִים","N");
INSERT INTO hebrew_lemma VALUES ("a#01673086","a","מַתְמִיד","N");
INSERT INTO hebrew_lemma VALUES ("a#02248299","a","מַתְמִיהַּ","N");
INSERT INTO hebrew_lemma VALUES ("a#01699236","a","מַתִּירָנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01698376","a","מַתִּירָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03657928","n","מַתִּירָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10476248","n","מַתֶּכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03450747","n","מַתַּכְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","מַתַּכְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01464354","a","מַתַּכְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00205732","n","מַתָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07616904","n","מָאצ\'וֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#03316977","n","מָגֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#03316835","n","מָגֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#03622504","n","מָגֵן-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00033525","v","מָדַד","N");
INSERT INTO hebrew_lemma VALUES ("n#07386233","n","מָדָם","N");
INSERT INTO hebrew_lemma VALUES ("n#02478646","n","מָדוֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#00926833","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00928545","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01218234","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00033527","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00928674","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00928268","a","מָהִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01838565","a","מָהוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10877003","n","מָחָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10964560","n","מָחָר","N");
INSERT INTO hebrew_lemma VALUES ("r#00473486","r","מָחָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06374245","n","מָחוֹז","N");
INSERT INTO hebrew_lemma VALUES ("n#06304618","n","מָחוֹז","N");
INSERT INTO hebrew_lemma VALUES ("n#02504878","n","מָחוֹךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#04581754","n","מָטֶרְיָאלִיזְם","N");
INSERT INTO hebrew_lemma VALUES ("n#03938934","n","מָטָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07641053","n","מָטוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#02174460","n","מָטוֹס","N");
INSERT INTO hebrew_lemma VALUES ("v#00579423","v","מָכַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00579423","v","מָכַר-לוֹ-לוֹקְשִׁים","N");
INSERT INTO hebrew_lemma VALUES ("n#06217164","n","מָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00481645","a","מָלֵא","N");
INSERT INTO hebrew_lemma VALUES ("a#02189742","a","מָלֵא","N");
INSERT INTO hebrew_lemma VALUES ("a#01488913","a","מָלֵא","N");
INSERT INTO hebrew_lemma VALUES ("a#00481167","a","מָלֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#06547707","n","מָלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#10133011","n","מָלַרְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02835992","n","מָלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#02283993","a","מָלוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06502515","n","מָן","N");
INSERT INTO hebrew_lemma VALUES ("n#05043559","n","מָנִיפֶסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#04512950","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05033972","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05621640","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09562389","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09957148","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05631178","n","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00642112","v","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00641064","v","מָנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03017435","n","מָנוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02516101","n","מָנוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#07619717","n","מָנוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#07620008","n","מָנוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004563","n","מָנוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01135871","a","מָסִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01526132","v","מָסַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01526289","v","מָסַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00591857","v","מָסַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06757743","n","מָסָךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01630291","a","מָסָרְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00577362","a","מָסָרְתִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#03488343","n","מָסוֹף","N");
INSERT INTO hebrew_lemma VALUES ("a#00486658","a","מָסוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07136302","n","מָעֳמָד","N");
INSERT INTO hebrew_lemma VALUES ("n#07535673","n","מָעֳמָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06940455","n","מָעֳמָד","N");
INSERT INTO hebrew_lemma VALUES ("v#01567643","v","מָעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#03431121","n","מָעֹז","N");
INSERT INTO hebrew_lemma VALUES ("a#02885097","a","מָעוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00605193","n","מָצוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#05422811","n","מָצוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#00695744","n","מָצוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06700314","n","מָצוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00385376","n","מָקוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#06331805","n","מָקוֹם-דִּמְיוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03331403","n","מָקוֹם-קָדוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05417541","n","מָקוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06275359","n","מָקוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04767390","n","מָקוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04201458","n","מָרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00947241","a","מָרוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#06890396","n","מָשִׁיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06890135","n","מָשִׁיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06890275","n","מָשִׁיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01579864","v","מָשַׁךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03049541","n","מָשׁוֹט","N");
INSERT INTO hebrew_lemma VALUES ("n#02677714","n","מָשׁוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#04597590","n","מָתֶמָטִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00560756","v","מָתַח-בִּקֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#02286984","a","מָתוּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01467790","a","מָתוּן","N");
INSERT INTO hebrew_lemma VALUES ("a#01447261","a","מָתוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05605389","n","מֹרַת-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#00823051","a","מֻבְטָל","N");
INSERT INTO hebrew_lemma VALUES ("n#06305263","n","מֻבְלַעַת","N");
INSERT INTO hebrew_lemma VALUES ("a#00967283","a","מֻגְבָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10432352","n","מֻגְבָּלוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00838013","a","מֻגְזָם","N");
INSERT INTO hebrew_lemma VALUES ("a#00837815","a","מֻגְזָם","N");
INSERT INTO hebrew_lemma VALUES ("a#01470257","a","מֻגְזָם","N");
INSERT INTO hebrew_lemma VALUES ("n#04206730","n","מֻגְלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01550520","a","מֻזְנָח","N");
INSERT INTO hebrew_lemma VALUES ("a#00303284","a","מֻזְנָח","N");
INSERT INTO hebrew_lemma VALUES ("a#02879008","a","מֻחְזָק","N");
INSERT INTO hebrew_lemma VALUES ("a#01020775","a","מֻחְמָץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01963193","a","מֻטְעֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00596990","a","מֻטְעֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01183415","a","מֻטֶּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00278090","a","מֻכְסָף","N");
INSERT INTO hebrew_lemma VALUES ("a#00893638","a","מֻכְרָז","N");
INSERT INTO hebrew_lemma VALUES ("a#01768682","a","מֻכְשָׁר","N");
INSERT INTO hebrew_lemma VALUES ("a#00917550","a","מֻכָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01320533","a","מֻכָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04362799","n","מֻמְחִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003956","n","מֻמְחִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07597405","n","מֻמְחֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003955","n","מֻמְחֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07597774","n","מֻמְחֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00070075","a","מֻמְלָץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01867344","a","מֻמְצָא","N");
INSERT INTO hebrew_lemma VALUES ("a#02396428","a","מֻסְוֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#02357220","a","מֻסְכָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00511429","n","מֻעְמָדוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01072155","a","מֻפְקָע","N");
INSERT INTO hebrew_lemma VALUES ("a#00950585","a","מֻפְרֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01470633","a","מֻפְרָז","N");
INSERT INTO hebrew_lemma VALUES ("a#01929728","a","מֻפְרָז","N");
INSERT INTO hebrew_lemma VALUES ("a#00837815","a","מֻפְרָז","N");
INSERT INTO hebrew_lemma VALUES ("a#02246531","a","מֻפְתָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#02220016","a","מֻצְלָח","N");
INSERT INTO hebrew_lemma VALUES ("n#02997499","n","מֻצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00335980","n","מֻצָּג","N");
INSERT INTO hebrew_lemma VALUES ("n#05048417","n","מֻצָּג-מִשְׁפָּטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00070075","a","מֻצָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#00486467","a","מֻקְדָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01599514","a","מֻקָּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01551365","a","מֻרְגָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01549824","a","מֻרְגָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02091753","a","מֻרְכָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#03742947","n","מֻרְכָּבוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00179854","a","מֻרְשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#03435902","n","מֻשָּׂא-תֵּאוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04493671","n","מֻשָּׂג","N");
INSERT INTO hebrew_lemma VALUES ("a#00012800","a","מֻשָּׂגִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01444522","a","מֻתָּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01696697","a","מֻתָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","מֻתָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00554183","a","מוֹחֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#05350422","n","מוֹטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("a#01497126","a","מוֹטוֹרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01412402","n","מוֹךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07543846","n","מוֹכֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07563088","n","מוֹכֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#09880332","n","מוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#02485878","n","מוֹלִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10633272","n","מוֹלִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#06277165","n","מוֹלֶדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03926914","n","מוֹמֶנְטוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#03724711","n","מוֹנוֹטוֹנִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04046959","n","מוֹסְרוֹת-הַשִּׁלְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06217164","n","מוֹסָד","N");
INSERT INTO hebrew_lemma VALUES ("n#04382645","n","מוֹסָד","N");
INSERT INTO hebrew_lemma VALUES ("n#06002286","n","מוֹסָד","N");
INSERT INTO hebrew_lemma VALUES ("n#02458761","n","מוֹעֲדוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06200783","n","מוֹעֶצֶת-מְנַהֲלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#06167560","n","מוֹעָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06167708","n","מוֹעָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04549171","n","מוֹפֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#06275359","n","מוֹצָא","N");
INSERT INTO hebrew_lemma VALUES ("n#03001369","n","מוֹקֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04507240","n","מוֹרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003666","n","מוֹרֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003667","n","מוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07547514","n","מוֹשִׁיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03294261","n","מוֹשָׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#03989310","n","מוֹתָרוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06944593","n","מוּג-לֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#03024989","n","מוּזֵאוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01162081","a","מוּזָל","N");
INSERT INTO hebrew_lemma VALUES ("a#00919283","a","מוּזָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00013216","a","מוּחָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02151830","a","מוּחָשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#00013216","a","מוּחָשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#03738112","n","מוּחָשִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04056757","n","מוּמְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004216","n","מוּמֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004215","n","מוּמָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04955371","n","מוּסַר-הַשְׂכֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02738353","n","מוּסָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02738220","n","מוּסָךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#00047697","a","מוּסָף","N");
INSERT INTO hebrew_lemma VALUES ("a#01961794","a","מוּסָרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00279019","a","מוּעָם","N");
INSERT INTO hebrew_lemma VALUES ("n#05604181","n","מוּעָקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07162052","n","מוּקְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004211","n","מוּקְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07506812","n","נְבִיאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09710563","n","נְבִיטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01809563","a","נְבוּאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00538233","n","נְגִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05631794","n","נְגִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00192663","n","נְדִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00727594","n","נְדִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05451289","n","נְדִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03278928","n","נְדָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00192663","n","נְדוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#00192663","n","נְדוּדִים","N");
INSERT INTO hebrew_lemma VALUES ("n#09545730","n","נְדוּנְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05387878","n","נְהִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05497808","n","נְהִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05497808","n","נְהָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05033972","n","נְזִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05423476","n","נְזִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07437315","n","נְזִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05504155","n","נְחִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00536548","n","נְחִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09941551","n","נְטִיַּת-הַפֹּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#09941651","n","נְטִיַּת-הַשֵּׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#03867407","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04697988","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05574602","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09941320","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06390652","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03956710","n","נְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05996676","n","נְטִיּוֹת-הַפֹּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#05996441","n","נְטִיּוֹת-הַשֵּׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#00458729","n","נְטִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00681444","n","נְטִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05716225","n","נְטִיפֵי-שֻׁמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09664211","n","נְיַר-עֵרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#04955518","n","נְיוּאַנְס","N");
INSERT INTO hebrew_lemma VALUES ("r#00200650","r","נְכוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01646172","n","נְמִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#01723223","n","נְמָלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02274731","a","נְמוּךְ-קוֹמָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01053999","a","נְסִבָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07499227","n","נְסִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06309044","n","נְסִיכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00191846","n","נְסִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00198579","n","נְסִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00200342","n","נְסִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10780167","n","נְסֹרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00530172","n","נְעִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05493410","n","נְעִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10274960","n","נְפִיחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05560048","n","נְפִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03985255","n","נְפִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05483545","n","נְפִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09731934","n","נְפִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04776155","n","נְקֵבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04707108","n","נְקֻדַּת-מַבָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#06387458","n","נְקֻדַּת-תַּצְפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#05101450","n","נְקֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05126526","n","נְקֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10044643","n","נְקֻדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05101450","n","נְקֻדָּה_עֶשְׂרוֹנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00532749","n","נְשִׁימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00536039","n","נְשִׁיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00388267","n","נְשִׂיאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03772017","n","נִבְזִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00859401","a","נִבְזֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#03772017","n","נִבְזוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00806061","a","נִבְחָר","N");
INSERT INTO hebrew_lemma VALUES ("a#02047878","a","נִבְחָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04591530","n","נִבְעָרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02421451","n","נִבְרֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#04453620","n","נִבּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05057929","n","נִבּוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#01779664","v","נִגְמַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01791776","v","נִהְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00734610","n","נִהוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00792210","n","נִהוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03835766","n","נִהוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06201180","n","נִהוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01656373","v","נִהוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01257779","v","נִוֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00204151","n","נִוּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00521429","n","נִוּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00716331","n","נִוּוּט","N");
INSERT INTO hebrew_lemma VALUES ("a#00117872","a","נִזְעָם","N");
INSERT INTO hebrew_lemma VALUES ("n#05352409","n","נִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#04415246","n","נִיחוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#00589915","a","נִכְבָּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00881108","a","נִכְחָד","N");
INSERT INTO hebrew_lemma VALUES ("v#00242403","v","נִכְנַס","N");
INSERT INTO hebrew_lemma VALUES ("v#01133757","v","נִכְנַס","N");
INSERT INTO hebrew_lemma VALUES ("v#01376901","v","נִכְנַס","N");
INSERT INTO hebrew_lemma VALUES ("v#00845185","v","נִכְנַס","N");
INSERT INTO hebrew_lemma VALUES ("v#00217001","v","נִכֵּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01747701","a","נִלְהָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00842521","a","נִלְהָב","N");
INSERT INTO hebrew_lemma VALUES ("v#00010240","v","נִמְנֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#00551140","n","נִמְנוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07062359","n","נִמְעָן","N");
INSERT INTO hebrew_lemma VALUES ("r#00177762","r","נִמְרָצוֹת","N");
INSERT INTO hebrew_lemma VALUES ("v#01845642","v","נִמְשַׁךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#04955371","n","נִמְשָׁל","N");
INSERT INTO hebrew_lemma VALUES ("r#00056854","r","נִנּוֹחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04823493","n","נִסְפָּח","N");
INSERT INTO hebrew_lemma VALUES ("v#01726067","v","נִסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00494444","n","נִסָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05434281","n","נִסָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00503611","n","נִסָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04441868","n","נִסָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00508046","n","נִסּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04469208","n","נִסּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#07142806","n","נִפְגָּע","N");
INSERT INTO hebrew_lemma VALUES ("a#01617066","a","נִפְלָא","N");
INSERT INTO hebrew_lemma VALUES ("v#01830886","v","נִפְסַק","N");
INSERT INTO hebrew_lemma VALUES ("a#01497519","a","נִפְעָם","N");
INSERT INTO hebrew_lemma VALUES ("n#07055704","n","נִפְקָד","N");
INSERT INTO hebrew_lemma VALUES ("v#00569024","v","נִפֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00815465","n","נִפּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00242321","n","נִפּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01495807","a","נִצְחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01691167","a","נִצְחִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05516369","n","נִצְנוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02655039","n","נִצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#07597116","n","נִצָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05556959","n","נִצָּחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00160717","n","נִקָּיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00160717","n","נִקּוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02464962","a","נִרְדָּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02883579","a","נִרְדָּף","N");
INSERT INTO hebrew_lemma VALUES ("v#01582621","v","נִשֵּׁל","N");
INSERT INTO hebrew_lemma VALUES ("v#01581572","v","נִשֵּׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#07632088","n","נִשּׁוֹם","N");
INSERT INTO hebrew_lemma VALUES ("v#00078446","v","נִשְׁאַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01868387","v","נִשְׁאַר","N");
INSERT INTO hebrew_lemma VALUES ("n#05630599","n","נִשְׁנוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07059160","n","נִתְבָּע","N");
INSERT INTO hebrew_lemma VALUES ("v#00845185","v","נִתְקַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01562883","v","נִתְקַל","N");
INSERT INTO hebrew_lemma VALUES ("n#00436664","n","נִתּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00242321","n","נִתּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00076442","n","נִתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06127339","n","נִתּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02800635","n","נֵבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#02800343","n","נֵבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","נֵטֶל","N");
INSERT INTO hebrew_lemma VALUES ("a#01748650","a","נֵיטְרָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05436522","n","נֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#05436886","n","נֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#10545850","n","נֵפְט","N");
INSERT INTO hebrew_lemma VALUES ("n#10710816","n","נֵפְט","N");
INSERT INTO hebrew_lemma VALUES ("n#10528487","n","נֵפְט","N");
INSERT INTO hebrew_lemma VALUES ("n#10749997","n","נֵפְט","N");
INSERT INTO hebrew_lemma VALUES ("n#01127903","n","נֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07311054","n","נֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#10971654","n","נֵצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#02375096","n","נֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#03446739","n","נֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#09806947","n","נֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#00550293","a","נֶאֱמָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03820929","n","נֶאֱמָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09536193","n","נֶאֱמָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07059160","n","נֶאֱשַׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#07867623","n","נֶבֶג","N");
INSERT INTO hebrew_lemma VALUES ("a#01748247","a","נֶגְדִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01617066","a","נֶהְדָּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01791776","v","נֶהְפַּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01791776","v","נֶהֱפַךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00785538","n","נֶחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05570308","n","נֶחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07396119","n","נֶחָת","N");
INSERT INTO hebrew_lemma VALUES ("n#09540718","n","נֶטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#07298770","n","נֶכְדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07299656","n","נֶכֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#10274392","n","נֶמֶק","N");
INSERT INTO hebrew_lemma VALUES ("a#01391590","a","נֶעֱדָר","N");
INSERT INTO hebrew_lemma VALUES ("v#01475232","v","נֶעֱלַם","N");
INSERT INTO hebrew_lemma VALUES ("v#00297682","v","נֶעֱלַם","N");
INSERT INTO hebrew_lemma VALUES ("v#00297331","v","נֶעֱלַם","N");
INSERT INTO hebrew_lemma VALUES ("v#01475232","v","נֶעֱלַם-מֵהָעַיִן","N");
INSERT INTO hebrew_lemma VALUES ("v#01270990","v","נֶעֱמַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01270990","v","נֶעֱצַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00186555","v","נֶעֱרַךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10056202","n","נֶצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10971654","n","נֶצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#05943989","n","נֶקְטָר","N");
INSERT INTO hebrew_lemma VALUES ("n#03601056","n","נֶשֶׁק","N");
INSERT INTO hebrew_lemma VALUES ("n#05697837","n","נֶתַח","N");
INSERT INTO hebrew_lemma VALUES ("n#07309754","n","נַבְלַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07309754","n","נַבְלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07434519","n","נַגָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#03232583","n","נַגָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#07424573","n","נַגָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004053","n","נַגָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004054","n","נַגָּרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00400874","n","נַגָּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03772017","n","נַוְלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07428502","n","נַוָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#07542916","n","נַוָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#01051104","n","נַחְלִיאֵלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01051104","n","נַחֲלִיאֵלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05504155","n","נַחֲרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00536548","n","נַחֲרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05504155","n","נַחַר","N");
INSERT INTO hebrew_lemma VALUES ("n#00536548","n","נַחַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06738619","n","נַטּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00381641","n","נַיֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03746913","n","נַיָּדוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01337558","a","נַנָּסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07290496","n","נַעֲרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01401729","a","נַעֲרָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03186896","n","נַעַל-סִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07115121","n","נַפָּח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004237","n","נַצְלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004238","n","נַצְלָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04717211","n","נַצְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05613522","n","נַקְמָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#08723548","n","נַרְקִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#02825203","n","נַרְתִּיק","N");
INSERT INTO hebrew_lemma VALUES ("n#03311748","n","נַרְתִּיק","N");
INSERT INTO hebrew_lemma VALUES ("n#10501854","n","נַתְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03823333","n","נָאִיבִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00589915","a","נָאֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#00249716","v","נָבַט","N");
INSERT INTO hebrew_lemma VALUES ("n#07666308","n","נָבָל","N");
INSERT INTO hebrew_lemma VALUES ("n#00871107","n","נָגִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#00527203","v","נָגַד","N");
INSERT INTO hebrew_lemma VALUES ("v#00297682","v","נָגוֹז","N");
INSERT INTO hebrew_lemma VALUES ("n#06343300","n","נָדִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01628572","a","נָדוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01628974","a","נָדוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#01317106","v","נָהַג","N");
INSERT INTO hebrew_lemma VALUES ("v#01317321","v","נָהַג","N");
INSERT INTO hebrew_lemma VALUES ("n#06789983","n","נָהָר","N");
INSERT INTO hebrew_lemma VALUES ("n#07280020","n","נָזִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00559552","v","נָזַף","N");
INSERT INTO hebrew_lemma VALUES ("a#01831884","a","נָזוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00706689","v","נָחַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00708073","v","נָחַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00011570","v","נָחַר","N");
INSERT INTO hebrew_lemma VALUES ("n#03359620","n","נָחָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01247280","n","נָחָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07587675","n","נָחָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06738619","n","נָטִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01858964","v","נָטָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01859256","v","נָטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01188256","a","נָטוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01183415","a","נָטוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#01264917","a","נָכֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00597129","a","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01807436","a","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01807603","a","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00138021","a","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00595353","a","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("r#00180343","r","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("r#00200650","r","נָכוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10432352","n","נָכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06362245","n","נָמֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#01027508","a","נָמֵס","N");
INSERT INTO hebrew_lemma VALUES ("n#01638301","n","נָמֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07641846","n","נָמֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#02274731","a","נָמוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01420490","v","נָס","N");
INSERT INTO hebrew_lemma VALUES ("n#07498573","n","נָסִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01283094","v","נָסַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01848681","v","נָסַב","N");
INSERT INTO hebrew_lemma VALUES ("n#07743334","n","נָעֳמִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01529719","a","נָעִים","N");
INSERT INTO hebrew_lemma VALUES ("a#01728957","a","נָעִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00003142","v","נָפַח","N");
INSERT INTO hebrew_lemma VALUES ("n#07207615","n","נָצִיג","N");
INSERT INTO hebrew_lemma VALUES ("a#01597378","a","נָצוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01496693","v","נָקַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#00624610","a","נָקוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#01423727","a","נָשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#03678976","n","נָשִׁיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00867289","a","נָשִׁיר","N");
INSERT INTO hebrew_lemma VALUES ("v#00003142","v","נָשַׁף","N");
INSERT INTO hebrew_lemma VALUES ("v#00526908","v","נָשַׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#07496412","n","נָשִׂיא","N");
INSERT INTO hebrew_lemma VALUES ("n#04766191","n","נָשׂוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#02905534","n","נָתִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#02905606","n","נָתִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#06709272","n","נָתִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#06952517","n","נָתִין","N");
INSERT INTO hebrew_lemma VALUES ("v#00559552","v","נָתַן-לוֹ-עַל-הָרֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04480764","n","נָתוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06753533","n","נֹגַהּ","N");
INSERT INTO hebrew_lemma VALUES ("n#07064646","n","נוֹאֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#10785027","n","נוֹגְדָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07672456","n","נוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("a#01321996","a","נוֹדָע","N");
INSERT INTO hebrew_lemma VALUES ("a#01667781","a","נוֹכְחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01774407","a","נוֹכְחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02843913","a","נוֹכְחִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00628521","a","נוֹכְחִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00800467","n","נוֹכְחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07537276","n","נוֹכֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#00479979","v","נוֹעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#09417961","n","נוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#06995978","n","נוֹצְרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02721959","a","נוֹצְרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01137483","a","נוֹצִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00274811","a","נוֹצֵץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00252195","v","נוֹצַר","N");
INSERT INTO hebrew_lemma VALUES ("n#07569027","n","נוֹקֵד","N");
INSERT INTO hebrew_lemma VALUES ("a#00697629","a","נוֹרְמָטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00193648","a","נוֹרָא","N");
INSERT INTO hebrew_lemma VALUES ("a#01079225","a","נוֹרָא","N");
INSERT INTO hebrew_lemma VALUES ("r#00031106","r","נוֹרָא","N");
INSERT INTO hebrew_lemma VALUES ("n#07192423","n","נוֹשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01257095","a","נוֹשָׁב","N");
INSERT INTO hebrew_lemma VALUES ("n#04479710","n","נוֹשֵׂא","N");
INSERT INTO hebrew_lemma VALUES ("n#04950638","n","נוֹשֵׂא","N");
INSERT INTO hebrew_lemma VALUES ("a#00878999","a","נוֹתָר","N");
INSERT INTO hebrew_lemma VALUES ("n#02941379","n","נוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05121684","n","נוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06867794","n","נוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01726067","v","נסה","N");
INSERT INTO hebrew_lemma VALUES ("n#06315687","n","סְבִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06363890","n","סְבִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10040804","n","סְבִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09908553","n","סְבִיבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#03736278","n","סְבִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03454043","n","סְוֶדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#00502000","n","סְחִיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10413485","n","סְחִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00056554","r","סְחוֹר-סְחוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#04104335","n","סְחוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00478287","n","סְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00548323","n","סְטִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00548323","n","סְטִיָּה-מִינִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04788121","n","סְטֶנוֹגְרַפְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004264","n","סְטָזֶ\'ר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004265","n","סְטָזֶ\'רִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07597116","n","סְטָטִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#10032130","n","סְטָטוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#10048803","n","סְטָטוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#06738619","n","סְטָלַקְטִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#03433996","n","סְטוּדְיוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#07617015","n","סְטוּדֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#01877371","n","סְיָח","N");
INSERT INTO hebrew_lemma VALUES ("n#03312123","n","סְכָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03440994","n","סְכוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04511080","n","סְכוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00795926","n","סְלִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03222943","n","סְלִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#02205944","a","סְלִילִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02698959","n","סְנַפִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#01856503","n","סְנָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00087361","n","סְנוֹקֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09766572","n","סְעִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#04819775","n","סְעִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#07803078","n","סְעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10069810","n","סְעָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03374325","n","סְפִינַת-חָלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02671945","n","סְפִינַת-מַעְבֹּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09766572","n","סְפִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00426345","n","סְפִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003745","n","סְפָרַדִּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02727705","a","סְפָרַדִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003746","n","סְפָרַדִּיָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02205944","a","סְפִּירָלִי","N");
INSERT INTO hebrew_lemma VALUES ("r#00039677","r","סְפֶּצִיפִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05258594","n","סְצֶנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10152408","n","סְקְלֶרוֹזִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#05938531","n","סְקְרוּדְּרַיְבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#00421016","n","סְקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04859040","n","סְקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00566440","n","סְקִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04586506","n","סְקֶפְּטִיצִיזְם","N");
INSERT INTO hebrew_lemma VALUES ("n#05447394","n","סְקַנְדָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00584054","n","סְרִיגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00604336","n","סְרִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10945693","n","סְתָו","N");
INSERT INTO hebrew_lemma VALUES ("a#01557449","a","סְתָמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05051824","n","סִבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03856995","n","סִגְנוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03857935","n","סִגְנוֹן-חַיִּים","N");
INSERT INTO hebrew_lemma VALUES ("a#01947036","a","סִגְנוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04947023","n","סִדְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04966481","n","סִדְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06042229","n","סִדְרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00188537","v","סִדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00579817","v","סִדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00690810","v","סִדֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00650412","n","סִדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00441099","v","סִוֵּג","N");
INSERT INTO hebrew_lemma VALUES ("n#00198358","n","סִחְרוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00219627","n","סִחְרוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00866366","v","סִיֵּד","N");
INSERT INTO hebrew_lemma VALUES ("v#00337013","v","סִיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00056138","v","סִיֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01737017","v","סִיֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04761096","n","סִיֹּמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10042115","n","סִיּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#04449467","n","סִיּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00138106","n","סִיּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04822648","n","סִיּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00137299","n","סִיּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04015637","n","סִיּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00759289","n","סִיּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#00634183","n","סִיּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06224833","n","סִיאַנְס","N");
INSERT INTO hebrew_lemma VALUES ("n#02673126","n","סִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#10663683","n","סִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#05535507","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10959811","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00219234","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05535152","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00189453","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#02281683","n","סִיבוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05085885","n","סִיגְנָל","N");
INSERT INTO hebrew_lemma VALUES ("n#10482003","n","סִידָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03344475","n","סִיח\'","N");
INSERT INTO hebrew_lemma VALUES ("n#07348907","n","סִיטוֹנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00722994","n","סִיטוֹנָאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00722994","n","סִיטוֹנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00459727","n","סִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05090749","n","סִימָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02424438","n","סִימָן-טוֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#02313987","n","סִימָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06417803","n","סִין","N");
INSERT INTO hebrew_lemma VALUES ("n#04687137","n","סִינְטַקְס","N");
INSERT INTO hebrew_lemma VALUES ("a#02265462","a","סִינְכְרוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05192706","n","סִינִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04858569","n","סִינוֹפְּסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#05350422","n","סִיסְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10167405","n","סִיפִילִיס","N");
INSERT INTO hebrew_lemma VALUES ("v#00681575","v","סִכֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00642843","v","סִכֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#03973089","n","סִכּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04858219","n","סִכּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04857759","n","סִכּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00512734","n","סִכּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10428324","n","סִכּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#09893975","n","סִפְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09894531","n","סִפְרָה-עֶשְׂרוֹנִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01364640","a","סִפְרוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02625317","a","סִפְרוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00994136","a","סִפְרוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00804764","v","סִפֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#01590833","v","סִפֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#01822979","v","סִפֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#00804159","v","סִפֵּק","N");
INSERT INTO hebrew_lemma VALUES ("v#00645379","v","סִפֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02549316","n","סִפּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05392977","n","סִפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05063177","n","סִפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00465739","a","סִפּוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01242774","v","סִקְרֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#04415512","n","סִרָחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#08757070","n","סִתְוָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04423455","n","סֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10399952","n","סֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10063906","n","סֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05149395","n","סֵמֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#04446693","n","סֵמֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#05097156","n","סֵמֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#02636606","n","סֵמֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#04798536","n","סֵפֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04843097","n","סֵפֶר-שָׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00541774","v","סֵרֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01531148","v","סֵרֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#04415512","n","סֵרָחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04977056","n","סֵרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#05383758","n","סֵרוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00219234","n","סֶבֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#04876008","n","סֶבֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#00683485","n","סֶבֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#07265711","n","סֶגֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#05132573","n","סֶפְּטִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07578721","n","סֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#02679248","n","סֶרֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#04960631","n","סֶרֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#03470891","n","סֶרֶט-מִדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02679248","n","סֶרֶט-צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04960631","n","סֶרֶט-קוֹלְנוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02229576","n","סֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07138749","n","סֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#06868386","n","סֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#00480533","a","סַבְלָנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01672718","a","סַבְלָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03659752","n","סַבְלָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07299407","n","סַבְתָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07299261","n","סַבָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#03824298","n","סַגְפָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03124259","n","סַד","N");
INSERT INTO hebrew_lemma VALUES ("n#07658794","n","סַדְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07658612","n","סַדְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07658724","n","סַדְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07173379","n","סַדָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07584682","n","סַהֲרוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07610890","n","סַוָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00502000","n","סַחְטָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#08348831","n","סַחְלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004967","n","סַיֶּפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02527582","n","סַיֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07604764","n","סַיָּס","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004966","n","סַיָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03440994","n","סַךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10428324","n","סַכָּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00125430","n","סַל","N");
INSERT INTO hebrew_lemma VALUES ("n#02609065","n","סַם","N");
INSERT INTO hebrew_lemma VALUES ("n#03030428","n","סַם","N");
INSERT INTO hebrew_lemma VALUES ("n#03228145","n","סַם","N");
INSERT INTO hebrew_lemma VALUES ("n#02981307","n","סַם","N");
INSERT INTO hebrew_lemma VALUES ("n#10436354","n","סַמְיוּת-עֵינַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#07163769","n","סַנְדְּלָר","N");
INSERT INTO hebrew_lemma VALUES ("n#03273160","n","סַנְדָּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04339764","n","סַנְטֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#00371545","a","סַסְגּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00378698","a","סַסְגּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06176302","n","סַפְסָל","N");
INSERT INTO hebrew_lemma VALUES ("n#07504695","n","סַפְסָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04586506","n","סַפְקָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003664","n","סַפְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003665","n","סַפְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00391334","n","סַפְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03366331","n","סַפָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07543103","n","סַפָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#07508719","n","סַפָּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005134","n","סַפָּק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005135","n","סַפָּקִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07218543","n","סַרְבָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#03261562","n","סַרְגֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10229324","n","סַרְטָן","N");
INSERT INTO hebrew_lemma VALUES ("a#02746453","a","סַרְטָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07477156","n","סַרְסוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07398165","n","סַתָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07299261","n","סָב","N");
INSERT INTO hebrew_lemma VALUES ("r#00068963","r","סָבִיב","N");
INSERT INTO hebrew_lemma VALUES ("a#00043399","a","סָבִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#01874606","a","סָבִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01468678","a","סָבִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01284430","v","סָבַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01848681","v","סָבַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01436577","v","סָבַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01283094","v","סָבַב","N");
INSERT INTO hebrew_lemma VALUES ("v#00656764","v","סָבַב","N");
INSERT INTO hebrew_lemma VALUES ("v#00465761","v","סָבַר","N");
INSERT INTO hebrew_lemma VALUES ("n#07299261","n","סָבָא","N");
INSERT INTO hebrew_lemma VALUES ("n#07299407","n","סָבָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00923454","v","סָחַט","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","סָחוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#03440994","n","סָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05968150","n","סָךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00058325","v","סָךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01812809","v","סָכַךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#07618181","n","סָכָל","N");
INSERT INTO hebrew_lemma VALUES ("n#05839780","n","סָלַט-יְרָקוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05839780","n","סָלָט","N");
INSERT INTO hebrew_lemma VALUES ("n#05720190","n","סָלָמִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01676464","a","סָלוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00482444","v","סָמַךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#02241625","a","סָמוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#00416294","a","סָמוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003583","n","סָנֵגוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003594","n","סָנֵגוֹרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04402548","n","סָפֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#03736708","n","סָפֵק","N");
INSERT INTO hebrew_lemma VALUES ("v#00642112","v","סָפַר","N");
INSERT INTO hebrew_lemma VALUES ("v#00641935","v","סָפַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01473651","v","סָקַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02894468","n","סָרִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#07249124","n","סָרִיס","N");
INSERT INTO hebrew_lemma VALUES ("a#02456469","a","סָרוּג","N");
INSERT INTO hebrew_lemma VALUES ("a#01375387","a","סָרוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02310342","a","סָרוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05625286","n","סֹלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03256834","n","סֹמֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#10621550","n","סֻבִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#05624467","n","סֻבִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#10157458","n","סֻכֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05888112","n","סֻכָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10609937","n","סֻכָּרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02899686","n","סֻלָּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00036903","a","סוֹאֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#10040804","n","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01432332","v","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01848681","v","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01284430","v","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#01046121","v","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#00631462","v","סוֹבֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#10501854","n","סוֹדְיוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07673310","n","סוֹהֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07673430","n","סוֹהֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07646824","n","סוֹחֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#02228878","n","סוֹכֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#06207838","n","סוֹלְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00316920","n","סוֹלִיטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005132","n","סוֹלִיסְט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005133","n","סוֹלִיסְטִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005132","n","סוֹלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005133","n","סוֹלָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10966797","n","סוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#04761096","n","סוֹפִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07689380","n","סוֹפֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07092196","n","סוֹפֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02884672","n","סוּבֶנִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06043947","n","סוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#04496504","n","סוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#09172696","n","סוּמְסוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06189502","n","סוּס-טְרוֹיָאנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01878219","n","סוּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04761096","n","סוּפִיקְס","N");
INSERT INTO hebrew_lemma VALUES ("n#07803078","n","סוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07992572","n","עֱלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00490590","n","עֲבֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06958552","n","עֲבַרְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00383807","n","עֲבוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03631348","n","עֲבוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","עֲגָבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#02230875","n","עֲגָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02393752","n","עֲגָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02791167","n","עֲגָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02516101","n","עֲגוּרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02917907","n","עֲדֶשֶׁת-אֱלֶקְטְרוֹנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02917478","n","עֲדָשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#04127649","n","עֲדָשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#10135808","n","עֲוִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00029100","n","עֲזִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10274793","n","עֲטִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#01647814","n","עֲטַלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10096231","n","עֲיֵפוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06382213","n","עֲיָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02938794","n","עֲלִיַּת-גַּג","N");
INSERT INTO hebrew_lemma VALUES ("n#00182418","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02938794","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04191921","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06725562","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05487790","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05459005","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00234220","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05480347","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003416","n","עֲלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05596105","n","עֲלִיצוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05773284","n","עֲלֵי-תֶּרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#07367906","n","עֲלוּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09553349","n","עֲלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10801135","n","עֲמִילָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03034745","n","עֲנִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00751324","n","עֲנִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#03837137","n","עֲנָוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03829724","n","עֲנָוָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01333157","a","עֲנָק","N");
INSERT INTO hebrew_lemma VALUES ("a#01076845","a","עֲנָק","N");
INSERT INTO hebrew_lemma VALUES ("a#01332180","a","עֲנָקִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01333157","a","עֲנָקִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10425626","n","עֲצִירַת-גְּשָׁמִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02678745","n","עֲצִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10310911","n","עֲצִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04888919","n","עֲצוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00793584","n","עֲקִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07328822","n","עֲקֶרֶת-בַּיִת","N");
INSERT INTO hebrew_lemma VALUES ("n#10117000","n","עֲקָרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00652495","n","עֲרִיכַת-רְשִׁימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04844438","n","עֲרִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003670","n","עֲרִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005137","n","עֲרֵבָהּ","N");
INSERT INTO hebrew_lemma VALUES ("n#09614018","n","עֲרֵבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09612224","n","עֲרֵבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09920124","n","עֲרֵמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06489489","n","עֲרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#06351167","n","עֲרָבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04570435","n","עֲרָכִים","N");
INSERT INTO hebrew_lemma VALUES ("n#07799541","n","עֲרָפֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#10415292","n","עֲרָפֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00767259","n","עֲרָר","N");
INSERT INTO hebrew_lemma VALUES ("n#05012923","n","עֲרֻבָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00593220","n","עֲשִׂיָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02106077","a","עֲשִׂירִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05373078","n","עֲתִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06092042","n","עֲתוּדוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05241839","n","עִבְרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00600921","n","עִבּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09745007","n","עִבּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00259372","n","עִדְכּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10954662","n","עִדָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10955141","n","עִדָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05016741","n","עִדּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#00785108","n","עִדּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#10436354","n","עִוְּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10436354","n","עִוָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09544459","n","עִזָּבוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00168605","n","עִטּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00168201","n","עִטּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02550579","n","עִטּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10274793","n","עִטּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00440790","v","עִיֵּן-מֵחָדָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00383340","n","עִיּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06296380","n","עִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06383382","n","עִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06287351","n","עִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06283013","n","עִיר-בִּירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003044","n","עִיר-הָאָבוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00689955","n","עִכּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10970463","n","עִכּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#09712272","n","עִכּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#09689013","n","עִכּוּל","N");
INSERT INTO hebrew_lemma VALUES ("a#02353332","a","עִלִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05051824","n","עִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00290256","v","עִמְלֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#01479955","v","עִמְעֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#05400049","n","עִמּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04120767","n","עִנְבָּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01827745","v","עִנְיֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#01242774","v","עִנְיֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#04479710","n","עִנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04384343","n","עִנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00717352","n","עִסְקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05073174","n","עִסְקָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01135429","a","עִסָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00430910","n","עִסּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00075441","n","עִפְעוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#03103254","n","עִפָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04415512","n","עִפּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00593716","n","עִצּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00591217","n","עִצּוּב-נוֹף","N");
INSERT INTO hebrew_lemma VALUES ("n#05324819","n","עִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05325089","n","עִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01554470","v","עִקֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03991218","n","עִקָּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01450092","a","עִקָּרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00694273","a","עִקָּרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01225152","a","עִקָּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02281683","n","עִקּוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01138007","v","עִרְבֵּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00244665","n","עִרְבּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00767259","n","עִרְעוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05386838","n","עִרְעוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03702260","n","עִרְפּוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00815217","v","עִשֵּׁן","N");
INSERT INTO hebrew_lemma VALUES ("v#01891088","v","עִשֵּׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#00535462","n","עִשּׁוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06009637","n","עִתּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04738466","n","עִתּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03039218","n","עִתּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#02823372","a","עִתּוֹנָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03939250","n","עִתּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05986088","n","עֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05988699","n","עֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05988905","n","עֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#06082537","n","עֵדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#01913590","n","עֵז","N");
INSERT INTO hebrew_lemma VALUES ("n#00782440","n","עֵזֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10371715","n","עֵירֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#00427123","a","עֵירֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#06730976","n","עֵמֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#06008236","n","עֵסֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#05073174","n","עֵסֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#10832541","n","עֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#05002688","n","עֵצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03628801","n","עֵרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#04003047","n","עֵרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#00094960","a","עֵרָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07583414","n","עֶבֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#07583588","n","עֶבֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#02230875","n","עֶגְלַת-יְלָדִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02230875","n","עֶגְלַת-תִּינוֹקוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#01900832","n","עֶגְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07141865","n","עֶגְלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07704255","n","עֶגְלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00782440","n","עֶזְרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02229073","a","עֶלְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01155248","a","עֶלְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#02321439","a","עֶלְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10362361","n","עֶלְיוֹנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03966697","n","עֶמְדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10578837","n","עֶצֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#04089833","n","עֶצֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#00010572","n","עֶצֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#04292437","n","עֶצֶם-הַמֵּצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#00010123","n","עֶצֶם-טִבְעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05565891","n","עֶרְגָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04271545","n","עֶרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10371715","n","עֶרְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02890425","n","עֶרְכָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00219555","a","עַב-כָּרֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#05770815","n","עַגְבָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09203529","n","עַגְבָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10167405","n","עַגֶּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10971654","n","עַד","N");
INSERT INTO hebrew_lemma VALUES ("r#00057204","r","עַד-מְאֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#00479886","n","עַוְלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01755567","a","עַז","N");
INSERT INTO hebrew_lemma VALUES ("a#00246712","a","עַז-נֶפֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05121901","n","עַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#03415353","n","עַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#04122028","n","עַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#03020109","n","עַכְבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#01832174","n","עַכְבָּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00046870","r","עַכְשָׁו","N");
INSERT INTO hebrew_lemma VALUES ("r#00047793","r","עַכְשָׁו","N");
INSERT INTO hebrew_lemma VALUES ("r#00047077","r","עַכְשָׁו","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","עַכּוּז","N");
INSERT INTO hebrew_lemma VALUES ("r#00151980","r","עַל-פֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09440011","n","עַלְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09590667","n","עַמְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02571784","n","עַמְעָם","N");
INSERT INTO hebrew_lemma VALUES ("n#03337486","n","עַמָם-פְּלִיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10017100","n","עַמּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#03829724","n","עַנְוְתָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04123557","n","עַפְעַף","N");
INSERT INTO hebrew_lemma VALUES ("a#02290807","a","עַצְבָּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004009","n","עַצְלָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00290443","a","עַצְלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004010","n","עַצְלָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03050219","n","עַצְמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10080443","n","עַצְמָאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01289705","n","עַקְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#03843490","n","עַקְשָׁנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03810298","n","עַקְשָׁנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10888065","n","עַרְבַּיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#09614018","n","עַרְבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09612224","n","עַרְבוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00359214","a","עַרְמוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00149802","a","עַרְמוּמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04353829","n","עַרְמוּמִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02789573","n","עַרְסָל","N");
INSERT INTO hebrew_lemma VALUES ("n#07953787","n","עַרְעָר","N");
INSERT INTO hebrew_lemma VALUES ("n#06895137","n","עַרְפָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09734785","n","עַשֶּׁשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("r#00046870","r","עַתָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01016940","a","עָבֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00579817","v","עָבַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01048914","v","עָבַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01644138","v","עָבַד-עַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01750236","v","עָבַר-עַל","N");
INSERT INTO hebrew_lemma VALUES ("n#04777321","n","עָבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04871813","n","עָבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10849142","n","עָבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10866655","n","עָבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#04871813","n","עָבָר-פְּלִילִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02620228","n","עָגִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00869694","a","עָגֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#01524724","n","עָגוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00674840","a","עָדִין","N");
INSERT INTO hebrew_lemma VALUES ("a#00698942","a","עָדִיף","N");
INSERT INTO hebrew_lemma VALUES ("v#01191006","v","עָדַר","N");
INSERT INTO hebrew_lemma VALUES ("n#00479886","n","עָוֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#06876198","n","עָווֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00056138","v","עָזַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01737017","v","עָזַר","N");
INSERT INTO hebrew_lemma VALUES ("a#00303284","a","עָזוּב","N");
INSERT INTO hebrew_lemma VALUES ("a#00402914","a","עָכוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#02914669","n","עָלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04731596","n","עָלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#09440981","n","עָלֶה-שָׁסוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01340367","v","עָלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01356820","v","עָלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00106108","v","עָלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01340626","v","עָלָה","N");
INSERT INTO hebrew_lemma VALUES ("v#H0003417","v","עָלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02235465","a","עָלוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#07165420","n","עָמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07687635","n","עָמֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01252269","v","עָמַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01270990","v","עָמַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01270990","v","עָמַד-מִלֶּכֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#00526734","a","עָמוּס","N");
INSERT INTO hebrew_lemma VALUES ("v#00554194","v","עָנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02229453","a","עָנָו","N");
INSERT INTO hebrew_lemma VALUES ("n#05943522","n","עָסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#07213735","n","עָצִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00929969","a","עָצֵל","N");
INSERT INTO hebrew_lemma VALUES ("a#00290443","a","עָצֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#01270990","v","עָצַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01745445","v","עָצַר","N");
INSERT INTO hebrew_lemma VALUES ("a#00039066","a","עָצוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01486353","v","עָקַב","N");
INSERT INTO hebrew_lemma VALUES ("n#04280158","n","עָרְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04353829","n","עָרְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07654699","n","עָרִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003669","n","עָרִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0005136","n","עָרֵב","N");
INSERT INTO hebrew_lemma VALUES ("v#00137111","v","עָרַךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#01082003","v","עָרַף","N");
INSERT INTO hebrew_lemma VALUES ("v#01761339","v","עָרַק","N");
INSERT INTO hebrew_lemma VALUES ("a#00342933","a","עָרוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#00427123","a","עָרוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#00149802","a","עָרוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04734014","n","עָרוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06732888","n","עָרוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04734014","n","עָרוּץ-תִּקְשֹׁרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#01785910","n","עָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09739257","n","עָשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("v#00977560","v","עָשָׂה-אַהֲבָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","עָשָׂה-מִמֶּנּוּ-צְחוֹק","N");
INSERT INTO hebrew_lemma VALUES ("v#00050470","v","עָשָׂה-פִּיפִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04777460","n","עָתִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#10849807","n","עָתִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#00512473","v","עָתַר","N");
INSERT INTO hebrew_lemma VALUES ("n#03989688","n","עֹדֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","עֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","עֹמֶס","N");
INSERT INTO hebrew_lemma VALUES ("n#10397144","n","עֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01927002","n","עֹפֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04909767","n","עֹצֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04296848","n","עֹרֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#00985200","n","עֻבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07999972","n","עֻבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00985911","n","עֻבָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07240707","n","עוֹבֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#06957738","n","עוֹבֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","עוֹבֵד-אֲדָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07440234","n","עוֹבֵד-צִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01692272","a","עוֹבֵר","N");
INSERT INTO hebrew_lemma VALUES ("r#00032928","r","עוֹד-מְעַט","N");
INSERT INTO hebrew_lemma VALUES ("r#00039142","r","עוֹד-פַּעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#07151308","n","עוֹזֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003415","n","עוֹלֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#01512420","a","עוֹלָמִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01617066","a","עוֹלָמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10945309","n","עוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10947554","n","עוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10947841","n","עוֹנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01432242","a","עוֹנָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10580693","n","עוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#01101739","n","עוֹרֵב-שָׁחֹר","N");
INSERT INTO hebrew_lemma VALUES ("a#01310388","a","עוֹרֵג","N");
INSERT INTO hebrew_lemma VALUES ("n#07234892","n","עוֹרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#04933998","n","עוֹרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003476","n","עוֹרֵךְ-דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#07591764","n","עוֹרֵךְ_דִּין","N");
INSERT INTO hebrew_lemma VALUES ("v#01200852","v","עוֹרֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003477","n","עוֹרֶכֶת-דִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#06665737","n","עוֹשֵׂה-הַפְּעֻלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05681148","n","עוּגִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05681148","n","עוּגִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05678434","n","עוּגַת-סְפוֹג","N");
INSERT INTO hebrew_lemma VALUES ("n#03062454","n","עוּגָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05707494","n","עוּגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05675891","n","עוּגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00330518","n","פְלִרְטוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#06240750","n","פְלוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03225469","n","פְרִיגִ\'ידֶר","N");
INSERT INTO hebrew_lemma VALUES ("a#00483862","a","פְרַגְמֶנְטָרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02679962","n","פִילְטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05478207","n","פִינִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02639054","a","פִינַנְסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10966797","n","פִינָלֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#08705962","n","פִיקוּס-הַשִּׁקְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06892480","n","פֵיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10923216","n","פֶבְּרוּאָר","N");
INSERT INTO hebrew_lemma VALUES ("n#10881782","n","פֶסְטִיבָל","N");
INSERT INTO hebrew_lemma VALUES ("n#00333254","n","פֶסְטִיבָל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003979","n","פַלַּאח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003980","n","פַלַּאחִית","N");
INSERT INTO hebrew_lemma VALUES ("a#01617066","a","פַנְטַסְטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","פַסְפוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05139664","n","פָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10983365","n","פָזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04704651","n","פָנָטִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04009545","n","פְּאֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#00794619","n","פְּגִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10377620","n","פְּגָם","N");
INSERT INTO hebrew_lemma VALUES ("n#10438697","n","פְּזִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09596000","n","פְּחָת","N");
INSERT INTO hebrew_lemma VALUES ("n#03899791","n","פְּיָאנִיסִימוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#03899791","n","פְּיָאנוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#05582358","n","פְּלִיאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00628646","n","פְּלִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#05527236","n","פְּלִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#10618145","n","פְּלָדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05087726","n","פְּלָקָט","N");
INSERT INTO hebrew_lemma VALUES ("n#06333215","n","פְּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#06333091","n","פְּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#09630121","n","פְּנִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00689161","n","פְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00689508","n","פְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#10863160","n","פְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#10863399","n","פְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00698191","n","פְּסִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00053585","n","פְּסִיקַת-הוֹצָאוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00771975","n","פְּסִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07475337","n","פְּסַנְתְּרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#03115608","n","פְּסַנְתֵּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04765220","n","פְּסוּקִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05493300","n","פְּעִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10090167","n","פְּעִילוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00017487","n","פְּעֻלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00259090","n","פְּצִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02677714","n","פְּצִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02310834","n","פְּצָצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00683875","n","פְּקִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10635013","n","פְּקַק-שַׁעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#03146454","n","פְּקָק","N");
INSERT INTO hebrew_lemma VALUES ("n#10635013","n","פְּקָק","N");
INSERT INTO hebrew_lemma VALUES ("n#03640400","n","פְּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09423815","n","פְּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05440251","n","פְּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04033272","n","פְּרִיבִילֶגְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03864058","n","פְּרִיכוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00779258","a","פְּרִימִיטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00502400","n","פְּרִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00458521","n","פְּרִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03824298","n","פְּרִישׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05157784","n","פְּרֶמְיֶרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04760894","n","פְּרֶפִיקְס","N");
INSERT INTO hebrew_lemma VALUES ("a#01871755","a","פְּרַגְמָטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01871755","a","פְּרַקְטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01703258","a","פְּרָטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05020360","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#00791294","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#05020360","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#05358552","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#05441142","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#09560299","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#09547800","n","פְּרָס","N");
INSERT INTO hebrew_lemma VALUES ("n#00269667","n","פְּרָעוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05058536","n","פְּרוֹגְנוֹזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02504113","n","פְּרוֹזְדוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#10560829","n","פְּרוֹטֶאִין","N");
INSERT INTO hebrew_lemma VALUES ("n#00468909","n","פְּרוֹיֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#00508925","n","פְּרוֹיֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#04541674","n","פְּרוֹיֶקְט","N");
INSERT INTO hebrew_lemma VALUES ("n#04362940","n","פְּרוֹפֶסְיוֹנָלִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05004860","n","פְּרוֹפָּגַנְדָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00450284","a","פְּרוֹפּוֹרְצְיוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00450284","a","פְּרוֹפּוֹרְצְיוֹנָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07507944","n","פְּרוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05372171","n","פְּשִׁיטַת-יָד","N");
INSERT INTO hebrew_lemma VALUES ("n#00496453","n","פְּשִׁיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00628970","n","פְּשִׁיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00781090","n","פְּשָׁרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05366843","n","פְּשָׁרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04822335","n","פְּתִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05279046","n","פְּתִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04821883","n","פְּתִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03446739","n","פְּתִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00690838","n","פִּגּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04366760","n","פִּגּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00061001","n","פִּדְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00537182","n","פִּהוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00237068","n","פִּזּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05463669","n","פִּזּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04303171","n","פִּטְמָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00703394","v","פִּטְפֵּט","N");
INSERT INTO hebrew_lemma VALUES ("n#09288624","n","פִּטְרִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05119853","n","פִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05306820","n","פִּיּוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#00746374","n","פִּיּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#00746155","n","פִּיּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#10610760","n","פִּיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#01997527","n","פִּיל","N");
INSERT INTO hebrew_lemma VALUES ("n#07414869","n","פִּילֶגֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04279799","n","פִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#10655576","n","פִּיפִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05448780","n","פִּיצוּץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00124529","v","פִּנָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09716211","n","פִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00030456","n","פִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00774224","n","פִּנּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#06349777","n","פִּסְגָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10045044","n","פִּסְגָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02677354","n","פִּסְלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04824115","n","פִּסְקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02901628","n","פִּסֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00130529","v","פִּסֵּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00599509","n","פִּסּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03290519","n","פִּסּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00250162","n","פִּסּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#09566341","n","פִּצּוּיִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00242644","n","פִּצּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04353391","n","פִּקְחוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04096637","n","פִּקַּת-הַבֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#00735967","n","פִּקּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#10135808","n","פִּרְכּוּס","N");
INSERT INTO hebrew_lemma VALUES ("v#00646076","v","פִּרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#00655737","v","פִּרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#00660910","v","פִּרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#01192426","v","פִּרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#01193001","v","פִּרְסֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#05411061","n","פִּרְסֹמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00713952","n","פִּרְסוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05409803","n","פִּרְסוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04944010","n","פִּרְסוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00715056","n","פִּרְסוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10665795","n","פִּשְׁתָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05351147","n","פִּתְגָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#03353273","n","פִּתְקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04377480","n","פִּתְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05053336","n","פִּתְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09745553","n","פִּתּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02281683","n","פִּתּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00585874","n","פֵּרוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05465616","n","פֶּגַע","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003660","n","פֶּדָגוֹג","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003661","n","פֶּדָגוֹגִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04076503","n","פֶּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07460301","n","פֶּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10628288","n","פֶּחָם","N");
INSERT INTO hebrew_lemma VALUES ("n#10526690","n","פֶּחָם","N");
INSERT INTO hebrew_lemma VALUES ("n#08955660","n","פֶּטֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#05781662","n","פֶּטֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#10001449","n","פֶּנְטָגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09639546","n","פֶּנְסְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09644617","n","פֶּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09856513","n","פֶּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00599509","n","פֶּסֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#03290519","n","פֶּסֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#03405014","n","פֶּסֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00687814","n","פֶּסֶק-זְמַן","N");
INSERT INTO hebrew_lemma VALUES ("n#10911850","n","פֶּסַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10257907","n","פֶּצַע","N");
INSERT INTO hebrew_lemma VALUES ("n#04084248","n","פֶּרְמָנֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#01887701","n","פֶּרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#04335626","n","פֶּרֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#04821096","n","פֶּרֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#10654209","n","פֶּרֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#00490590","n","פֶּשַׁע","N");
INSERT INTO hebrew_lemma VALUES ("n#00491001","n","פֶּשַׁע","N");
INSERT INTO hebrew_lemma VALUES ("n#03353273","n","פֶּתֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#02641840","n","פֶּתַח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004015","n","פַּזְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004016","n","פַּזְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00479309","n","פַּזְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03833567","n","פַּזְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03313932","n","פַּח","N");
INSERT INTO hebrew_lemma VALUES ("n#06944593","n","פַּחְדָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02374411","n","פַּחִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05590260","n","פַּחַד","N");
INSERT INTO hebrew_lemma VALUES ("n#10526690","n","פַּחַם-עֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03821817","n","פַּטְרִיוֹטִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03821817","n","פַּטְרִיוֹטִיזְם","N");
INSERT INTO hebrew_lemma VALUES ("n#07483717","n","פַּיְטָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04186985","n","פַּנְקְרֵאָס","N");
INSERT INTO hebrew_lemma VALUES ("n#10905001","n","פַּסְחָא","N");
INSERT INTO hebrew_lemma VALUES ("n#00316920","n","פַּסְיַאנְס","N");
INSERT INTO hebrew_lemma VALUES ("n#10280858","n","פַּסְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03371714","n","פַּסְקוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#07554940","n","פַּסֶּלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07554744","n","פַּסָּל","N");
INSERT INTO hebrew_lemma VALUES ("r#00115984","r","פַּעַם","N");
INSERT INTO hebrew_lemma VALUES ("r#00116080","r","פַּעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#07461272","n","פַּצְיֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#06306119","n","פַּרְבָר","N");
INSERT INTO hebrew_lemma VALUES ("n#01414637","n","פַּרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10584548","n","פַּרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02728611","n","פַּרְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07161229","n","פַּרְוָן","N");
INSERT INTO hebrew_lemma VALUES ("n#06306119","n","פַּרְוָר","N");
INSERT INTO hebrew_lemma VALUES ("n#01690836","n","פַּרְעוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01777374","n","פַּרְפַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00374336","n","פַּרְפַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10038885","n","פַּרְשִׁיַּת-אֲהָבִים","N");
INSERT INTO hebrew_lemma VALUES ("n#07169294","n","פַּרְשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#07438399","n","פַּרְשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#05067461","n","פַּרְשָׁנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05672582","n","פַּשְׁטִידָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02090808","a","פַּשְׁטָנִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00069684","v","פָּגַע","N");
INSERT INTO hebrew_lemma VALUES ("n#02352536","n","פָּגוֹשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01689559","a","פָּגוּם","N");
INSERT INTO hebrew_lemma VALUES ("v#01544212","v","פָּדָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01218416","a","פָּזִיז","N");
INSERT INTO hebrew_lemma VALUES ("a#01218544","a","פָּזִיז","N");
INSERT INTO hebrew_lemma VALUES ("r#00258112","r","פָּחוֹת","N");
INSERT INTO hebrew_lemma VALUES ("r#00006065","r","פָּחוֹת-אוֹ-יוֹתֵר","N");
INSERT INTO hebrew_lemma VALUES ("a#00621931","a","פָּחוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#07524744","n","פָּלִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#07023466","n","פָּלֶשְׂתִּינִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02739809","a","פָּלֶשְׂתִּינִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07023466","n","פָּלֶשְׂתִּינָאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02739809","a","פָּלֶשְׂתִּינָאִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00071198","v","פָּלַט","N");
INSERT INTO hebrew_lemma VALUES ("n#06234851","n","פָּמַלְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02375281","n","פָּמוֹט","N");
INSERT INTO hebrew_lemma VALUES ("n#02695433","n","פָּנַס-כִּיס","N");
INSERT INTO hebrew_lemma VALUES ("n#02695433","n","פָּנָס","N");
INSERT INTO hebrew_lemma VALUES ("a#00043399","a","פָּסִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01829006","v","פָּסַק","N");
INSERT INTO hebrew_lemma VALUES ("v#01830886","v","פָּסַק","N");
INSERT INTO hebrew_lemma VALUES ("v#00484458","v","פָּסַק","N");
INSERT INTO hebrew_lemma VALUES ("n#07409291","n","פָּעִיל","N");
INSERT INTO hebrew_lemma VALUES ("v#01722366","v","פָּעַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01048914","v","פָּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","פָּעוֹט","N");
INSERT INTO hebrew_lemma VALUES ("a#01594742","a","פָּעוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01076845","a","פָּצָץ","N");
INSERT INTO hebrew_lemma VALUES ("a#00674517","a","פָּרִיךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00202730","v","פָּרַח","N");
INSERT INTO hebrew_lemma VALUES ("v#00762959","v","פָּרַס","N");
INSERT INTO hebrew_lemma VALUES ("v#00781082","v","פָּרַס","N");
INSERT INTO hebrew_lemma VALUES ("v#00855714","v","פָּרַס","N");
INSERT INTO hebrew_lemma VALUES ("v#00965965","v","פָּרַס","N");
INSERT INTO hebrew_lemma VALUES ("v#01074448","v","פָּרַס","N");
INSERT INTO hebrew_lemma VALUES ("n#08208225","n","פָּרָג","N");
INSERT INTO hebrew_lemma VALUES ("n#10829857","n","פָּרָפִין","N");
INSERT INTO hebrew_lemma VALUES ("n#10038885","n","פָּרָשַׁת-אֲהָבִים","N");
INSERT INTO hebrew_lemma VALUES ("a#02307103","a","פָּרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07460301","n","פָּשָׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01375703","a","פָּשׁוּט","N");
INSERT INTO hebrew_lemma VALUES ("a#01721444","a","פָּשׁוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#04821883","n","פָּתִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00877349","v","פָּתַח","N");
INSERT INTO hebrew_lemma VALUES ("v#00506975","v","פָּתַח-וְאָמַר","N");
INSERT INTO hebrew_lemma VALUES ("n#04769237","n","פֹּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#04767056","n","פֹּעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#00269667","n","פּוֹגְרוֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#01747447","a","פּוֹזִיטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10497589","n","פּוֹטַסְיוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07376166","n","פּוֹלִיגְלוֹט","N");
INSERT INTO hebrew_lemma VALUES ("n#09989692","n","פּוֹלִיגוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#01743546","a","פּוֹלִיטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02646683","a","פּוֹלִיטִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02646845","a","פּוֹלִיטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04897248","n","פּוֹלִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07343952","n","פּוֹלֵשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003743","n","פּוֹלָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003744","n","פּוֹלָנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05206804","n","פּוֹלָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05087726","n","פּוֹסְטֶר","N");
INSERT INTO hebrew_lemma VALUES ("a#00697629","a","פּוֹסְקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07062449","n","פּוֹסֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003443","n","פּוֹסֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#04602657","n","פּוֹסֵק","N");
INSERT INTO hebrew_lemma VALUES ("a#00697629","a","פּוֹסֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#07360164","n","פּוֹעֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#03159967","n","פּוֹרְטְפוֹלְיוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#07535008","n","פּוֹרֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07130429","n","פּוֹרֵץ","N");
INSERT INTO hebrew_lemma VALUES ("n#07193161","n","פּוֹשֵׁעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00687814","n","פּוּגָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00742390","n","פּוּטְשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#01412402","n","פּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#05369415","n","פּוּלְמוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05693545","n","פּוּלְקֶע","N");
INSERT INTO hebrew_lemma VALUES ("n#02768298","n","פּוּמְפִּיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#01634046","n","פּוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10318432","n","פוֹבְּיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03113185","n","פוֹטוֹגְרָף","N");
INSERT INTO hebrew_lemma VALUES ("n#05321825","n","פוֹנֶמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02435885","n","צ\'וֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#01919213","n","צְבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01919213","n","צְבִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06209363","n","צְבָא-קֶבַע","N");
INSERT INTO hebrew_lemma VALUES ("a#02586912","a","צְבָאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01455377","a","צְבָאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01454237","a","צְבָאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01786279","a","צְדָדִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02321974","a","צְדָדִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05330158","n","צְוִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05503486","n","צְוָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05330158","n","צְוָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00158173","n","צְלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00280586","n","צְלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10433722","n","צְלִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00087268","n","צְלִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03861110","n","צְמִיגוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05483545","n","צְנִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05731213","n","צְנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03837137","n","צְנִיעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05959071","n","צְעִירִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03898072","n","צְרִידוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05330158","n","צְרִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02842105","n","צְרִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#02839632","n","צְרִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#05330158","n","צְרָחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10655576","n","צְרָכִים-קְטַנִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#01733061","n","צְרָצַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02353159","n","צְרוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#08755705","n","צִבְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00375007","a","צִבְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00368578","a","צִבְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00378698","a","צִבְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06079949","n","צִבּוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00460814","a","צִבּוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01790261","a","צִבּוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09940115","n","צִוּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#00379645","n","צִחְצוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00021067","v","צִחְקֵק","N");
INSERT INTO hebrew_lemma VALUES ("n#05333008","n","צִחְקוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#05333102","n","צִחְקוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#04960176","n","צִטּוּט","N");
INSERT INTO hebrew_lemma VALUES ("v#00689564","v","צִיֵּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06273995","n","צִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06455500","n","צִיּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05399540","n","צִיּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05494365","n","צִיּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#03079051","n","צִיּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04960176","n","צִיטָטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02344950","a","צִינִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05607640","n","צִינִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04302960","n","צִיצִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07245827","n","צִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#07412508","n","צִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#10047472","n","צִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#02229576","n","צִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#02819675","n","צִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01187102","v","צִלֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00408287","n","צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#09674939","n","צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00580612","n","צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00582602","n","צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#03113185","n","צִלּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06240750","n","צִמְחִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07661856","n","צִמְחוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05621048","n","צִמְחוֹנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03868242","n","צִמָּאוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10113657","n","צִמָּאוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05468378","n","צִנְצֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#09914955","n","צִנְצֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02873027","n","צִנְצֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04324786","n","צִפֹּרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#01716135","n","צִרְעָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01633014","v","צֵרֵף","N");
INSERT INTO hebrew_lemma VALUES ("v#01633117","v","צֵרֵף","N");
INSERT INTO hebrew_lemma VALUES ("n#07212065","n","צֶאֱצָא","N");
INSERT INTO hebrew_lemma VALUES ("n#03078466","n","צֶבַע","N");
INSERT INTO hebrew_lemma VALUES ("n#06060223","n","צֶדֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#04097129","n","צֶלַע","N");
INSERT INTO hebrew_lemma VALUES ("n#06369892","n","צֶלַע","N");
INSERT INTO hebrew_lemma VALUES ("n#05982639","n","צֶמֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#01415150","n","צֶמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10837885","n","צֶמֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#00008864","n","צֶמַח","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003749","n","צֶנְזוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003750","n","צֶנְזוֹרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00525511","n","צֶנְזוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00254803","n","צֶנְזוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03824298","n","צֶנַע","N");
INSERT INTO hebrew_lemma VALUES ("n#05058536","n","צֶפִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01272450","n","צֶפַע","N");
INSERT INTO hebrew_lemma VALUES ("n#04896216","n","צַ\'רְטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04860883","n","צַ\'רְטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#01183829","n","צַב-יָם","N");
INSERT INTO hebrew_lemma VALUES ("n#07453414","n","צַבָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#07453830","n","צַבָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#04415512","n","צַחֲנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01554065","a","צַיְתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00755927","n","צַיְתָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03841543","n","צַיְתָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00287066","n","צַיִד","N");
INSERT INTO hebrew_lemma VALUES ("n#00410109","n","צַיִד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003754","n","צַיֶּדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003756","n","צַיֶּדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02841320","n","צַיָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003753","n","צַיָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003755","n","צַיָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#07474054","n","צַלָּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07588010","n","צַלָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#09417961","n","צַמֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07456719","n","צַנְחָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00645691","n","צַנֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03147209","n","צַנֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("a#01394793","a","צַעֲקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05497366","n","צַעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#09907411","n","צַעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#04492345","n","צַעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#05602279","n","צַעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#09030953","n","צַפְצָפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06943718","n","צַרְכָן","N");
INSERT INTO hebrew_lemma VALUES ("n#04973475","n","צָ\'אוּ","N");
INSERT INTO hebrew_lemma VALUES ("n#01191090","n","צָב","N");
INSERT INTO hebrew_lemma VALUES ("v#01576236","v","צָבַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06082744","n","צָבָא","N");
INSERT INTO hebrew_lemma VALUES ("n#06091847","n","צָבָא","N");
INSERT INTO hebrew_lemma VALUES ("n#06089493","n","צָבָא","N");
INSERT INTO hebrew_lemma VALUES ("v#01382752","v","צָבָא","N");
INSERT INTO hebrew_lemma VALUES ("n#01626344","n","צָבוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07332358","n","צָבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02097138","a","צָבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#01366980","v","צָד","N");
INSERT INTO hebrew_lemma VALUES ("v#00777314","v","צָד","N");
INSERT INTO hebrew_lemma VALUES ("n#05499511","n","צָהֳלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05596527","n","צָהֳלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10884479","n","צָהֳרַיִם","N");
INSERT INTO hebrew_lemma VALUES ("v#00718098","v","צָהַל","N");
INSERT INTO hebrew_lemma VALUES ("v#01488249","v","צָוַח","N");
INSERT INTO hebrew_lemma VALUES ("v#00071715","v","צָחַק","N");
INSERT INTO hebrew_lemma VALUES ("n#05636142","n","צָלִי","N");
INSERT INTO hebrew_lemma VALUES ("v#01361481","v","צָלַע","N");
INSERT INTO hebrew_lemma VALUES ("v#01308351","v","צָלַע","N");
INSERT INTO hebrew_lemma VALUES ("a#00583207","a","צָלוּי","N");
INSERT INTO hebrew_lemma VALUES ("v#00808763","v","צָם","N");
INSERT INTO hebrew_lemma VALUES ("v#00808622","v","צָם","N");
INSERT INTO hebrew_lemma VALUES ("n#10113657","n","צָמָא","N");
INSERT INTO hebrew_lemma VALUES ("n#03868242","n","צָמָא","N");
INSERT INTO hebrew_lemma VALUES ("v#01339823","v","צָנַח","N");
INSERT INTO hebrew_lemma VALUES ("n#03280442","n","צָעִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#06950430","n","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#00865638","n","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#07692038","n","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00778835","a","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01589874","a","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01587804","a","צָעִיר","N");
INSERT INTO hebrew_lemma VALUES ("v#01310684","v","צָעַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01313443","v","צָעַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01345133","v","צָעַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01316088","v","צָעַד","N");
INSERT INTO hebrew_lemma VALUES ("v#00617516","v","צָעַק","N");
INSERT INTO hebrew_lemma VALUES ("v#00618000","v","צָעַק","N");
INSERT INTO hebrew_lemma VALUES ("n#01913506","n","צָפִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#09963172","n","צָפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#09962919","n","צָפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00882114","a","צָפוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#02396532","a","צָפוּן","N");
INSERT INTO hebrew_lemma VALUES ("a#00526734","a","צָפוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01135312","a","צָפוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#06524612","n","צָרְפַת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003737","n","צָרְפָתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02727539","a","צָרְפָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003738","n","צָרְפָתִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07039204","n","צָרְפָתִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05223176","n","צָרְפָתִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10286788","n","צָרֶבֶת","N");
INSERT INTO hebrew_lemma VALUES ("v#01488249","v","צָרַח","N");
INSERT INTO hebrew_lemma VALUES ("v#00617840","v","צָרַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10168619","n","צָרַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#04395081","n","צָרָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00295224","a","צָרוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#04790774","n","צֹפֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#10666463","n","צֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#06846327","n","צֹרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#10654524","n","צוֹאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00692334","n","צוֹם","N");
INSERT INTO hebrew_lemma VALUES ("a#01201117","a","צוֹנֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003751","n","צוֹעֲנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003752","n","צוֹעֲנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003747","n","צוֹעֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004264","n","צוֹעֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003748","n","צוֹעֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004265","n","צוֹעֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07124158","n","צוֹפֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07291722","n","צוֹפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05660665","n","צוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10651048","n","צוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","צוּצִיק","N");
INSERT INTO hebrew_lemma VALUES ("n#06700314","n","צוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#03858557","n","צוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03856995","n","צוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03724071","n","קְבִיעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03944434","n","קְבִיעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10302574","n","קְבָס","N");
INSERT INTO hebrew_lemma VALUES ("n#05991008","n","קְבוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06093198","n","קְבוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04606861","n","קְבוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05962976","n","קְבוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00017954","n","קְבוּצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05962976","n","קְבוּצָה-חֶבְרָתִית","N");
INSERT INTO hebrew_lemma VALUES ("a#00460554","a","קְבוּצָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00602658","n","קְדִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00592646","n","קְדִיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04018338","n","קְדִימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04018338","n","קְדִימוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03804759","n","קְדֻשָּׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#00799654","n","קְהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05979928","n","קְהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06105250","n","קְהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05986276","n","קְהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01056978","a","קְהִלָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06997421","n","קְוֶקֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#04427092","n","קְטִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10873719","n","קְטִינוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03570223","n","קְטִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07197309","n","קְלִיֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#06212767","n","קְלִיֶנְטוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06002732","n","קְלִינִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02848205","n","קְלַסְתֵּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05331503","n","קְלָלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07383205","n","קְלוֹץ","N");
INSERT INTO hebrew_lemma VALUES ("n#00233090","n","קְמִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05455221","n","קְמִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00049855","n","קְנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#09394969","n","קְנוֹקֶנֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003674","n","קְצִינָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00032688","r","קְצָת","N");
INSERT INTO hebrew_lemma VALUES ("n#00220549","n","קְרִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00303222","n","קְרִיקֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#00619159","n","קְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00758807","n","קְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00610417","n","קְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00614914","n","קְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#06281317","n","קְרָבַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003901","n","קְרוֹב-מִשְׁפָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003902","n","קְרוֹבַת-מִשְׁפָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003902","n","קְרוֹבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#01217953","n","קְרוֹקוֹדִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#04277222","n","קְרוּם-הַבְּתוּלִים","N");
INSERT INTO hebrew_lemma VALUES ("n#00097058","n","קְשִׁירָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00610465","v","קִבֵּל-אֶת-פָּנָיו","N");
INSERT INTO hebrew_lemma VALUES ("n#06005150","n","קִבּוּץ","N");
INSERT INTO hebrew_lemma VALUES ("v#01741671","v","קִדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#01633376","v","קִדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00661487","v","קִדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00610465","v","קִדֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#00610465","v","קִדֵּם-אֶת-פָּנָיו","N");
INSERT INTO hebrew_lemma VALUES ("v#01531034","v","קִדֵּם-בִּבְרָכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00602658","n","קִדּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00592646","n","קִדּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00130078","n","קִדּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05412651","n","קִדּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00159609","n","קִדּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00672319","n","קִדּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07073892","n","קִטֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05387614","n","קִטּוּרִים","N");
INSERT INTO hebrew_lemma VALUES ("v#00449252","v","קִיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("v#01860915","v","קִיֵּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05367196","n","קִיּוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#02890425","n","קִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#08110076","n","קִיסוֹס","N");
INSERT INTO hebrew_lemma VALUES ("n#07253766","n","קִיצוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07682628","n","קִיצוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01692272","a","קִיקְיוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03132833","n","קִלְשׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("v#00135603","v","קִלֵּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01933977","a","קִמְעוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003735","n","קִמְעוֹנַאי","N");
INSERT INTO hebrew_lemma VALUES ("a#01933977","a","קִמְעוֹנָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003736","n","קִמְעוֹנָאִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00722842","n","קִמְעוֹנָאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00722842","n","קִמְעוֹנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09639546","n","קִצְבַּת-זִקְנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00702810","n","קִצּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00230622","n","קִצּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#03327102","n","קִצּוּר-דֶּרֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00714915","v","קִרְקֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#01131741","n","קִרְקָס","N");
INSERT INTO hebrew_lemma VALUES ("n#05331675","n","קִרְקוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00884615","v","קִשֵּׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#00168201","n","קִשּׁוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#02550579","n","קִשּׁוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#04194181","n","קֵבָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00318951","r","קֵדְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03518223","n","קֵיסַם-שִׁנַּיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#03518223","n","קֵיסָם","N");
INSERT INTO hebrew_lemma VALUES ("n#05776840","n","קֵיסָרוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01203685","a","קֵיצִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02768416","n","קֶבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#06209363","n","קֶבַע","N");
INSERT INTO hebrew_lemma VALUES ("n#03944434","n","קֶבַע","N");
INSERT INTO hebrew_lemma VALUES ("n#09964070","n","קֶדֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#03296757","n","קֶטַע","N");
INSERT INTO hebrew_lemma VALUES ("n#04514703","n","קֶטַע","N");
INSERT INTO hebrew_lemma VALUES ("n#06686223","n","קֶטַע","N");
INSERT INTO hebrew_lemma VALUES ("n#04819171","n","קֶטַע","N");
INSERT INTO hebrew_lemma VALUES ("n#06299088","n","קֶלַח","N");
INSERT INTO hebrew_lemma VALUES ("n#02403444","n","קֶלַע","N");
INSERT INTO hebrew_lemma VALUES ("n#05624582","n","קֶמַח","N");
INSERT INTO hebrew_lemma VALUES ("n#06733540","n","קֶנְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03692429","n","קֶסֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#10964831","n","קֶצֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#10978422","n","קֶצֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#03948875","n","קֶצֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#05523281","n","קֶצֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#03326923","n","קֶצֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#06333091","n","קֶרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#00869291","n","קֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#02722608","n","קֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07777807","n","קֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#09618851","n","קֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#00089520","n","קֶרֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07777807","n","קֶרֶן-אוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#02722608","n","קֶרֶן-יַעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02722608","n","קֶרֶן-צָרְפָתִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10528487","n","קֶרוֹסִין","N");
INSERT INTO hebrew_lemma VALUES ("n#00294570","n","קֶרלִינְג","N");
INSERT INTO hebrew_lemma VALUES ("n#06942405","n","קֶשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#10036039","n","קֶשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#02896406","n","קֶשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#00018916","n","קֶשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#00019464","n","קֶשֶׁר-חֶבְרָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07419708","n","קַבְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07107135","n","קַבְּצָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07107212","n","קַבְּצָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05372171","n","קַבְּצָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04974979","n","קַבָּלַת-פָּנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#05004203","n","קַבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03218660","n","קַבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00055481","n","קַבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04894307","n","קַבָּלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00089010","a","קַדַּחְתָּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10133011","n","קַדַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#10133011","n","קַדַּחַת-הַבִּצּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#06279444","n","קַו-גְּבוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03002764","n","קַטְנוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#00282562","a","קַטְנוּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03982878","n","קַטְנוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01142598","a","קַל","N");
INSERT INTO hebrew_lemma VALUES ("a#01136498","a","קַל","N");
INSERT INTO hebrew_lemma VALUES ("a#02045369","a","קַל-דַּעַת","N");
INSERT INTO hebrew_lemma VALUES ("a#01137865","a","קַל-מִשְׁקָל","N");
INSERT INTO hebrew_lemma VALUES ("a#00033527","a","קַל-תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003720","n","קַלָּע","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003721","n","קַלָּעִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07413689","n","קַמְצָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01065122","a","קַמְצָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03789279","n","קַמְצָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06940455","n","קַנְדִּידָט","N");
INSERT INTO hebrew_lemma VALUES ("n#09806947","n","קַנְדֶּלָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01824710","a","קַנְטְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07133843","n","קַנְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07256105","n","קַנַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#04704651","n","קַנָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05155466","n","קַפְּדָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003732","n","קַצְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003733","n","קַצְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04788121","n","קַצְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10174999","n","קַצֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#08152618","n","קַקְטוּס","N");
INSERT INTO hebrew_lemma VALUES ("a#01199751","a","קַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02386680","n","קַרְבּוּרָטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#02229021","n","קַרְדֹּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06747770","n","קַרְחוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10615963","n","קַרְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04126221","n","קַרְנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#01889509","n","קַרְנָף","N");
INSERT INTO hebrew_lemma VALUES ("n#04322434","n","קַרְסֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#00966030","n","קַרְפִּיּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05814400","n","קַרְפִּיּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04291359","n","קַרְקֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06395065","n","קַשָּׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#07082243","n","קַשָּׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#03843490","n","קַשְׁיוּת-עֹרֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#10515601","n","קָאוֹלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#07189764","n","קָאוּבּוֹי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003747","n","קָדֶט","N");
INSERT INTO hebrew_lemma VALUES ("v#01852936","v","קָדַם","N");
INSERT INTO hebrew_lemma VALUES ("v#01836899","v","קָדַם","N");
INSERT INTO hebrew_lemma VALUES ("n#05972960","n","קָהָל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003722","n","קָטֵגוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#05991008","n","קָטֵגוֹרְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003724","n","קָטֵגוֹרִית","N");
INSERT INTO hebrew_lemma VALUES ("v#00103366","v","קָטַן","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","קָטַנְצִ\'יק","N");
INSERT INTO hebrew_lemma VALUES ("v#00855839","v","קָטַע","N");
INSERT INTO hebrew_lemma VALUES ("n#07643338","n","קָטָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01396363","a","קָטָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01336443","a","קָטָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01413178","a","קָטָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01589390","a","קָטָן","N");
INSERT INTO hebrew_lemma VALUES ("v#01149581","v","קָלַע","N");
INSERT INTO hebrew_lemma VALUES ("n#02311368","n","קָלוֹרִימֶטֶר-פְּצָצָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01263425","a","קָלוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02072513","a","קָלוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#02185947","n","קָמֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01389477","a","קָמוּץ","N");
INSERT INTO hebrew_lemma VALUES ("a#01970144","a","קָמוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00502070","a","קָמוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#01200711","a","קָפוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07451223","n","קָצִין","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003673","n","קָצִין","N");
INSERT INTO hebrew_lemma VALUES ("n#06314081","n","קָצֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#00901473","v","קָצַר","N");
INSERT INTO hebrew_lemma VALUES ("a#00512552","a","קָצָר","N");
INSERT INTO hebrew_lemma VALUES ("a#01384633","a","קָצָר","N");
INSERT INTO hebrew_lemma VALUES ("a#00623957","a","קָצוּץ","N");
INSERT INTO hebrew_lemma VALUES ("v#01263165","v","קָרַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01404337","v","קָרַב","N");
INSERT INTO hebrew_lemma VALUES ("v#00537255","v","קָרָא","N");
INSERT INTO hebrew_lemma VALUES ("n#07717771","n","קָרָה","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","קָרָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00235191","v","קָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003901","n","קָרוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#01064552","a","קָרוֹב","N");
INSERT INTO hebrew_lemma VALUES ("a#00412848","a","קָרוֹב","N");
INSERT INTO hebrew_lemma VALUES ("r#00403897","r","קָרוֹב","N");
INSERT INTO hebrew_lemma VALUES ("r#00134549","r","קָרוֹב-לְוַדַּאי","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","קָרוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#00797776","a","קָשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#00710342","a","קָשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01248007","a","קָשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#01080240","a","קָשֶׁה","N");
INSERT INTO hebrew_lemma VALUES ("a#00251073","a","קָשׁוּר","N");
INSERT INTO hebrew_lemma VALUES ("r#00058575","r","קֹדֶם","N");
INSERT INTO hebrew_lemma VALUES ("r#00058575","r","קֹדֶם-לָכֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#03804759","n","קֹדֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03982878","n","קֹטֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#07635239","n","קֻפַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#01486444","n","קֻרְקְבָן","N");
INSERT INTO hebrew_lemma VALUES ("n#01268360","n","קוֹבְּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00013243","n","קוֹגְנִיצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04792090","n","קוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#05000141","n","קוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#04790774","n","קוֹד","N");
INSERT INTO hebrew_lemma VALUES ("n#07494167","n","קוֹדֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#00775727","a","קוֹדֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#01666340","a","קוֹדֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#00129370","a","קוֹדֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#05000141","n","קוֹדֵקְס","N");
INSERT INTO hebrew_lemma VALUES ("a#00271928","a","קוֹדֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#04735661","n","קוֹלְנוֹעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02038355","a","קוֹלֶקְטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02797103","n","קוֹלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#02481403","n","קוֹמְפְּרֶסוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#07173042","n","קוֹמְפּוֹזִיטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#09590667","n","קוֹמִיסְיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003999","n","קוֹמִיקַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004000","n","קוֹמִיקָאִית","N");
INSERT INTO hebrew_lemma VALUES ("v#01137221","v","קוֹמֵם","N");
INSERT INTO hebrew_lemma VALUES ("n#04728675","n","קוֹמוּנִיקַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02485388","n","קוֹנְדּוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#06401522","n","קוֹנְטִינֶנְט","N");
INSERT INTO hebrew_lemma VALUES ("a#01747562","a","קוֹנְסְטְרוּקְטִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00012800","a","קוֹנְסֶפְּטוּאָלִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04710672","n","קוֹנְסֶרְבָטִיבִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05324819","n","קוֹנְסוֹנַנְט","N");
INSERT INTO hebrew_lemma VALUES ("n#05325089","n","קוֹנְסוֹנַנְט","N");
INSERT INTO hebrew_lemma VALUES ("a#00013216","a","קוֹנְקְרֶטִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07133843","n","קוֹנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07572465","n","קוֹנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#04490800","n","קוֹץ-בַּתַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#02463642","n","קוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#02463642","n","קוֹקָאִין","N");
INSERT INTO hebrew_lemma VALUES ("a#00275515","a","קוֹרֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#09972198","n","קוֹרֶלַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04616407","n","קוֹרֶלַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02755412","n","קוֹרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04892722","n","קוּפּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04447957","n","רְאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03004534","n","רְאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04373924","n","רְאִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#02105183","a","רְבִיעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05088890","n","רְבָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00206677","n","רְדִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00269249","n","רְדִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01065754","a","רְחַב-לֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#02960286","n","רְחוֹב-רָאשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#10424399","n","רְטִיבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00193791","n","רְכִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00285479","n","רְכִיבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05338361","n","רְכִילוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07297035","n","רְכִילוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00046246","n","רְכִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#00051225","n","רְכִישָׁה","N");
INSERT INTO hebrew_lemma VALUES ("n#09528888","n","רְכוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03868829","n","רְכוּשָׁנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00485108","n","רְמִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03819481","n","רְמִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05064035","n","רְמִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02944079","n","רְפָפָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01120947","a","רְפוּאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02475324","a","רְפוּאִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02585051","a","רְפוּאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04627248","n","רְפוּאַת-עוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#00403778","n","רְפוּאָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00614072","a","רְצִינִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00589915","a","רְצִינִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02400805","a","רְצוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06285184","n","רְקִיעַ-הַשָּׁמַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#04866394","n","רְשִׁימָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03471806","n","רְשַׁמְקוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#05015182","n","רְשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00738404","n","רְשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02688619","n","רִאשׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00775042","a","רִאשׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","רִאשׁוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04753435","n","רִבּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#05602697","n","רִגְשֵׁי_אָשָׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#02729592","n","רִהוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#04018175","n","רִוְחִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#01355211","v","רִוֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03194375","n","רִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#05369518","n","רִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#06500621","n","רִידִינְג","N");
INSERT INTO hebrew_lemma VALUES ("n#06740258","n","רִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#05552482","n","רִיצַת-מְשׂוּכוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#00365145","n","רִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00190535","n","רִיצָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00242321","n","רִיצוּץ","N");
INSERT INTO hebrew_lemma VALUES ("v#00705705","v","רִכֵל","N");
INSERT INTO hebrew_lemma VALUES ("v#00489333","v","רִכֵּז","N");
INSERT INTO hebrew_lemma VALUES ("v#00579423","v","רִמָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#02771050","n","רִמּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#00242321","n","רִסּוּק","N");
INSERT INTO hebrew_lemma VALUES ("v#01598993","v","רִפֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#03562070","n","רִפּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09718860","n","רִפּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04993010","n","רִצְפָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01282944","v","רִצֵּד","N");
INSERT INTO hebrew_lemma VALUES ("v#00864543","v","רִצֵּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00914321","v","רִצֵּף","N");
INSERT INTO hebrew_lemma VALUES ("n#04089143","n","רִקְמַת-שֻׁמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02636894","n","רִקְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00253715","n","רִקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#04916758","n","רִשָּׁיוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#00991360","a","רִשְׁמִי","N");
INSERT INTO hebrew_lemma VALUES ("n#00779977","n","רִשְׁמִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03845084","n","רִשְׁמִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05503161","n","רִשְׁרוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#04127985","n","רִשְׁתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#02800148","n","רִתְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02799877","n","רִתְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00097334","n","רִתּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#09682678","n","רֵאַקְצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04187344","n","רֵאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06275359","n","רֵאשִׁית","N");
INSERT INTO hebrew_lemma VALUES ("a#01001840","a","רֵיחָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10038317","n","רֵעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09891778","n","רֶבַע","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004559","n","רֶבוֹלוּצְיוֹנֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004560","n","רֶבוֹלוּצְיוֹנֶרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05307231","n","רֶגֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#05560878","n","רֶגֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10952516","n","רֶגַע","N");
INSERT INTO hebrew_lemma VALUES ("n#10953688","n","רֶגַע","N");
INSERT INTO hebrew_lemma VALUES ("n#00514820","n","רֶגוּלַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04017901","n","רֶוַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10024194","n","רֶוַח","N");
INSERT INTO hebrew_lemma VALUES ("n#04275292","n","רֶחֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#03569523","n","רֶכֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#03373458","n","רֶכֶב-חָלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#09933378","n","רֶלֶוַנְטִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05094004","n","רֶמֶז","N");
INSERT INTO hebrew_lemma VALUES ("n#06688669","n","רֶמֶץ","N");
INSERT INTO hebrew_lemma VALUES ("n#02182142","n","רֶסֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#02534722","n","רֶסֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#04046959","n","רֶסֶן-הַשִּׁלְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#02513818","n","רֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003699","n","רֶפּוּבְּלִיקָאִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003700","n","רֶפּוּבְּלִיקָאִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003699","n","רֶפּוּבְּלִיקָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003700","n","רֶפּוּבְּלִיקָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#00510453","n","רֶפוֹרְמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004557","n","רֶפוֹרְמָטוֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#00143589","n","רֶצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#03038207","n","רֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#06239044","n","רֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#03038461","n","רֶשֶׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#02864326","n","רֶשֶׁת-הָאִינְטֶרְנֶט","N");
INSERT INTO hebrew_lemma VALUES ("n#03038461","n","רֶשֶׁת-שִׁדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00480312","n","רֶשַׁע","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003895","n","רַאַוְתָן","N");
INSERT INTO hebrew_lemma VALUES ("a#00546919","a","רַאַוְתָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003896","n","רַאַוְתָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07517306","n","רַב","N");
INSERT INTO hebrew_lemma VALUES ("a#01333157","a","רַב","N");
INSERT INTO hebrew_lemma VALUES ("a#01488913","a","רַב","N");
INSERT INTO hebrew_lemma VALUES ("a#01490743","a","רַב","N");
INSERT INTO hebrew_lemma VALUES ("a#00371545","a","רַב-גּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01758782","a","רַב-הַשְׁפָּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07376166","n","רַב-לְשׁוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01755567","a","רַב-עָצְמָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00371545","a","רַב-צִבְעִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00493236","a","רַבְגּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00371545","a","רַבְגּוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03828199","n","רַבְרְבָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07517306","n","רַבִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003718","n","רַבִּים","N");
INSERT INTO hebrew_lemma VALUES ("a#02704711","a","רַבָּנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06048529","n","רַבָּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01339584","a","רַבָּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003719","n","רַבּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("a#01088163","a","רַגְזָן","N");
INSERT INTO hebrew_lemma VALUES ("n#05503161","n","רַחְשׁוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05615476","n","רַחֲמִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02839735","n","רַחֶפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05503161","n","רַחַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05338361","n","רַכְלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07297035","n","רַכְלָן","N");
INSERT INTO hebrew_lemma VALUES ("a#01415885","a","רַכְרוּכִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02993501","n","רַכֶּבֶת-תַּחְתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#02993501","n","רַכֶּבֶת_תַּחְתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004220","n","רַכֶּזֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07163025","n","רַכָּב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004219","n","רַכָּז","N");
INSERT INTO hebrew_lemma VALUES ("n#00485959","n","רַמַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00492002","n","רַמַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07205881","n","רַמַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#00485108","n","רַמָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03819481","n","רַמָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05064035","n","רַמָּאוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01078381","a","רַע","N");
INSERT INTO hebrew_lemma VALUES ("a#02456935","a","רַעְיוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01415243","n","רַעֲמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04080650","n","רַעֲמָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01850366","a","רַעֲשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("n#10786704","n","רַעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#04024290","n","רַעַל","N");
INSERT INTO hebrew_lemma VALUES ("n#05506014","n","רַעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#05493195","n","רַעַם","N");
INSERT INTO hebrew_lemma VALUES ("n#10814033","n","רַעַף","N");
INSERT INTO hebrew_lemma VALUES ("n#05499597","n","רַעַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07657738","n","רַפָּד","N");
INSERT INTO hebrew_lemma VALUES ("r#00007655","r","רַק","N");
INSERT INTO hebrew_lemma VALUES ("n#10698844","n","רַקְבּוּבִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003671","n","רַקְדָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003672","n","רַקְדָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#08400581","n","רַקֶּפֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00476598","n","רַשְׁלָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03677496","n","רַשְׁלָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07677000","n","רַתָּךְ","N");
INSERT INTO hebrew_lemma VALUES ("a#01224413","a","רָאשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#01450092","a","רָאשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("a#01225152","a","רָאשִׁי","N");
INSERT INTO hebrew_lemma VALUES ("n#00388267","n","רָאשׁוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00921474","a","רָגִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00025790","a","רָגִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00456499","a","רָגִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#01650136","a","רָגִישׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10473160","n","רָדִיקָל","N");
INSERT INTO hebrew_lemma VALUES ("n#03201157","n","רָדָאר","N");
INSERT INTO hebrew_lemma VALUES ("n#02729950","n","רָהִיט","N");
INSERT INTO hebrew_lemma VALUES ("a#01091073","a","רָהוּט","N");
INSERT INTO hebrew_lemma VALUES ("v#00819436","v","רָוָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00936334","a","רָזֶה","N");
INSERT INTO hebrew_lemma VALUES ("v#00032369","v","רָזָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00377885","v","רָחַב","N");
INSERT INTO hebrew_lemma VALUES ("a#01330877","a","רָחָב","N");
INSERT INTO hebrew_lemma VALUES ("a#02436517","a","רָחָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00411239","a","רָחוֹק","N");
INSERT INTO hebrew_lemma VALUES ("a#00411449","a","רָחוֹק","N");
INSERT INTO hebrew_lemma VALUES ("v#01282944","v","רָטַט","N");
INSERT INTO hebrew_lemma VALUES ("v#01333288","v","רָכַב","N");
INSERT INTO hebrew_lemma VALUES ("v#01511279","v","רָכַשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#02201398","a","רָכוּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00009323","v","רָעַד","N");
INSERT INTO hebrew_lemma VALUES ("v#01289419","v","רָעַד","N");
INSERT INTO hebrew_lemma VALUES ("n#10367751","n","רָעָב","N");
INSERT INTO hebrew_lemma VALUES ("n#03868242","n","רָעָב","N");
INSERT INTO hebrew_lemma VALUES ("n#10112984","n","רָעָב","N");
INSERT INTO hebrew_lemma VALUES ("a#00643575","a","רָעוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#02292291","n","רָץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04589152","n","רָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04912311","n","רָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04371730","n","רָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#02419103","a","רָצוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00129930","a","רָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01608832","a","רָצוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","רָצוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#06285184","n","רָקִיעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#06000383","n","רָשֻׁיּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("a#00566939","a","רָתוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#07273905","n","רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#07311393","n","רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#09392482","n","רֹאשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#06349777","n","רֹאשׁ-הַר","N");
INSERT INTO hebrew_lemma VALUES ("n#09921720","n","רֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#03991218","n","רֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#09760262","n","רֹב","N");
INSERT INTO hebrew_lemma VALUES ("n#09760262","n","רֹב-מֻחְלָט","N");
INSERT INTO hebrew_lemma VALUES ("v#00383502","v","רֻפָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#07058678","n","רוֹאֵה_חֶשְׁבּוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03239566","n","רוֹבֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#02226816","n","רוֹבּוֹט","N");
INSERT INTO hebrew_lemma VALUES ("n#06243405","n","רוֹדָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07187296","n","רוֹזֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#04876008","n","רוֹטַצְיָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00724183","n","רוֹכְלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02667713","n","רוֹכְסָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07533426","n","רוֹכֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#07465360","n","רוֹכֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#10002071","n","רוֹמְבּוּס","N");
INSERT INTO hebrew_lemma VALUES ("n#05221640","n","רוֹמִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10038885","n","רוֹמָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07569027","n","רוֹעֵה-צֹאן","N");
INSERT INTO hebrew_lemma VALUES ("n#07317144","n","רוֹעֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07189764","n","רוֹעֶה-בָּקָר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003702","n","רוֹפְאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003704","n","רוֹפְאָה-מְנַתַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#07220883","n","רוֹפֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003701","n","רוֹפֵא","N");
INSERT INTO hebrew_lemma VALUES ("n#07438516","n","רוֹפֵא-מְיַלֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003703","n","רוֹפֵא-מְנַתֵּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07076009","n","רוֹפֵא-מַרְדִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#07597774","n","רוֹפֵא-מֻמְחֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#07423684","n","רוֹצֵחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07424038","n","רוֹצַחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#02403444","n","רוּגַטְקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03256834","n","רוּז\'","N");
INSERT INTO hebrew_lemma VALUES ("n#07791597","n","רוּחַ-מִזְרָחִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07780411","n","רוּחַ-קַלָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#01892897","a","רוּטִינִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03998008","n","רוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05605136","n","שִעֲמוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05564290","n","שְׁאִיפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05376578","n","שְׁאֵלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04862567","n","שְׁאֵלוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003901","n","שְׁאֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#09947509","n","שְׁאֵרִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003902","n","שְׁאֵרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03790984","n","שְׁאַפְתָּנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05502831","n","שְׁאָגָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02105701","a","שְׁבִיעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#09976262","n","שְׁבִיעִית","N");
INSERT INTO hebrew_lemma VALUES ("n#09892243","n","שְׁבִיעִית","N");
INSERT INTO hebrew_lemma VALUES ("n#06687696","n","שְׁבָב","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003909","n","שְׁבוּי-מִלְחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003910","n","שְׁבוּיַת-מִלְחָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003760","n","שְׁבוּיָה","N");
INSERT INTO hebrew_lemma VALUES ("a#02490254","a","שְׁבוּעִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10861977","n","שְׁבוּעַ-עֲבוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05011384","n","שְׁבוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00499726","n","שְׁדִידָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08938018","n","שְׁזִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#05787409","n","שְׁזִיף","N");
INSERT INTO hebrew_lemma VALUES ("n#09691024","n","שְׁחִיקָה","N");
INSERT INTO hebrew_lemma VALUES ("a#00365404","a","שְׁחַרְחַר","N");
INSERT INTO hebrew_lemma VALUES ("n#04959357","n","שְׁטֻיּוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#09947509","n","שְׁיָר","N");
INSERT INTO hebrew_lemma VALUES ("n#09954914","n","שְׁכִיחוּת-יַחֲסִית","N");
INSERT INTO hebrew_lemma VALUES ("n#09770742","n","שְׁכִיחוּת-מֻחְלֶטֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003818","n","שְׁכֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03670244","n","שְׁכֵנוּת-טוֹבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06106024","n","שְׁכוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04044520","n","שְׁלִיטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01747801","a","שְׁלִילִי","N");
INSERT INTO hebrew_lemma VALUES ("n#05384228","n","שְׁלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09983362","n","שְׁלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00541182","n","שְׁלוּק","N");
INSERT INTO hebrew_lemma VALUES ("a#02105827","a","שְׁמִינִי","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003883","n","שְׁמַרְטַף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003884","n","שְׁמַרְטַפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#09320769","n","שְׁמָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10839681","n","שְׁמָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04123557","n","שְׁמוּרַת-עַיִן","N");
INSERT INTO hebrew_lemma VALUES ("n#09898493","n","שְׁנֵים-עָשָׂר","N");
INSERT INTO hebrew_lemma VALUES ("n#10917283","n","שְׁנַת-הַלִּמּוּדִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10060454","n","שְׁנַת-נֶצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10060454","n","שְׁנַת-עוֹלָם","N");
INSERT INTO hebrew_lemma VALUES ("a#02489110","a","שְׁנָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04843097","n","שְׁנָתוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#07418757","n","שְׁנוֹרֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10316608","n","שְׁפִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06728413","n","שְׁפֵלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10656399","n","שְׁפָכִים","N");
INSERT INTO hebrew_lemma VALUES ("n#10018378","n","שְׁפִּיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#04459683","n","שְׁקִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03928177","n","שְׁרִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#04105406","n","שְׁרִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#04105203","n","שְׁרִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00683768","a","שְׁרִירוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07482774","n","שְׁרַבְרָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00645691","n","שְׁרַבְרָבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00401944","n","שְׁרַבְרָבוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03589950","n","שְׁתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07871286","n","שְׁתִיל","N");
INSERT INTO hebrew_lemma VALUES ("n#00681444","n","שְׁתִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00477462","n","שְׁתַמְּטָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#01892897","a","שִׁגְרָתִי","N");
INSERT INTO hebrew_lemma VALUES ("a#01615102","a","שִׁגְרָתִי","N");
INSERT INTO hebrew_lemma VALUES ("v#00522215","v","שִׁדֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02428247","n","שִׁדָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10215316","n","שִׁדָּפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05020101","n","שִׁדּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04964806","n","שִׁדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#04967331","n","שִׁדּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#00002841","v","שִׁהֵק","N");
INSERT INTO hebrew_lemma VALUES ("a#00680600","a","שִׁוְיוֹנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10260783","n","שִׁזָּפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10260783","n","שִׁזּוּף","N");
INSERT INTO hebrew_lemma VALUES ("n#10963303","n","שִׁחְזוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00060117","n","שִׁחְרוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#08067245","n","שִׁטָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00577669","v","שִׁטָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04427252","n","שִׁיּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03858557","n","שִׁיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04376254","n","שִׁיטָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01609323","a","שִׁיטָתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03744231","n","שִׁיטָתִיּוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04807372","n","שִׁיר","N");
INSERT INTO hebrew_lemma VALUES ("n#05306706","n","שִׁירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00354500","n","שִׁירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00988305","n","שִׁכְבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02913016","n","שִׁכְבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06335649","n","שִׁכְבָה","N");
INSERT INTO hebrew_lemma VALUES ("v#00522671","v","שִׁכְנֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05408552","n","שִׁכְנוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00658366","n","שִׁכְפּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#10097920","n","שִׁכְרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04845143","n","שִׁכְתּוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#10097920","n","שִׁכָּרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06000383","n","שִׁלְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10311109","n","שִׁלְשׁוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03088570","n","שִׁמְשִׁיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00459727","n","שִׁמּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00524093","n","שִׁמּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00605730","n","שִׁמּוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("v#00082064","v","שִׁנָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00083947","v","שִׁנָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#00111031","v","שִׁנָּה","N");
INSERT INTO hebrew_lemma VALUES ("v#01606101","v","שִׁעְבֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09613349","n","שִׁעְבּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#05605136","n","שִׁעְמוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04434211","n","שִׁעְרוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03772017","n","שִׁפְלוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03344475","n","שִׁפּוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09566341","n","שִׁפּוּי","N");
INSERT INTO hebrew_lemma VALUES ("n#03956088","n","שִׁפּוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00159157","n","שִׁפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#10347699","n","שִׁפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05480347","n","שִׁפּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#08705962","n","שִׁקְמָה","N");
INSERT INTO hebrew_lemma VALUES ("v#01487239","v","שִׁקְשֵׁק","N");
INSERT INTO hebrew_lemma VALUES ("n#05494969","n","שִׁקְשׁוּק","N");
INSERT INTO hebrew_lemma VALUES ("v#00330720","v","שִׁקֵּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#00484777","n","שִׁקּוּר","N");
INSERT INTO hebrew_lemma VALUES ("v#01598897","v","שִׁרְיֵן","N");
INSERT INTO hebrew_lemma VALUES ("a#02105576","a","שִׁשִּׁי","N");
INSERT INTO hebrew_lemma VALUES ("v#01645167","v","שִׁתֵּף-פְּעֻלָּה","N");
INSERT INTO hebrew_lemma VALUES ("a#00435502","a","שִׁתּוּפִי","N");
INSERT INTO hebrew_lemma VALUES ("a#02038355","a","שִׁתּוּפִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00294050","a","שִׁתּוּפִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10439292","n","שִׁתּוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#10358851","n","שֵׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#10359826","n","שֵׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#04705103","n","שֵׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#10358202","n","שֵׁמַע","N");
INSERT INTO hebrew_lemma VALUES ("r#00099672","r","שֵׁנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10094888","n","שֵׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10102311","n","שֵׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10103438","n","שֵׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10971856","n","שֵׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","שֵׁת","N");
INSERT INTO hebrew_lemma VALUES ("n#02719232","n","שֶׁבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#09887157","n","שֶׁבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#10261267","n","שֶׁבֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#09887356","n","שֶׁבֶר-פָּשׁוּט","N");
INSERT INTO hebrew_lemma VALUES ("n#05018478","n","שֶׁבַח","N");
INSERT INTO hebrew_lemma VALUES ("n#05018240","n","שֶׁבַח","N");
INSERT INTO hebrew_lemma VALUES ("n#04596256","n","שֶׁטַח","N");
INSERT INTO hebrew_lemma VALUES ("n#02207321","n","שֶׁטַח","N");
INSERT INTO hebrew_lemma VALUES ("a#01487615","a","שֶׁל-עֶקְרוֹנוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#07835489","n","שֶׁלֶג","N");
INSERT INTO hebrew_lemma VALUES ("n#03860008","n","שֶׁלֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#10749997","n","שֶׁמֶן-אֲדָמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07820384","n","שֶׁמֶשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#10578609","n","שֶׁנְהָב","N");
INSERT INTO hebrew_lemma VALUES ("n#08929535","n","שֶׁסֶק","N");
INSERT INTO hebrew_lemma VALUES ("n#05799396","n","שֶׁסֶק","N");
INSERT INTO hebrew_lemma VALUES ("a#01243248","a","שֶׁעָבַר","N");
INSERT INTO hebrew_lemma VALUES ("a#02839797","a","שֶׁעָבַר","N");
INSERT INTO hebrew_lemma VALUES ("a#01664341","a","שֶׁעָבַר","N");
INSERT INTO hebrew_lemma VALUES ("n#06792476","n","שֶׁפֶךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03986878","n","שֶׁפַע","N");
INSERT INTO hebrew_lemma VALUES ("n#03987430","n","שֶׁפַע","N");
INSERT INTO hebrew_lemma VALUES ("n#09863808","n","שֶׁקֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#10655576","n","שֶׁתֶן","N");
INSERT INTO hebrew_lemma VALUES ("a#00672182","a","שַׁבְרִירִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10883605","n","שַׁבָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10883469","n","שַׁבָּת","N");
INSERT INTO hebrew_lemma VALUES ("n#02636321","n","שַׁגְרִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00323207","n","שַׁח","N");
INSERT INTO hebrew_lemma VALUES ("n#00323207","n","שַׁח-מָט","N");
INSERT INTO hebrew_lemma VALUES ("n#00323207","n","שַׁחְמָט","N");
INSERT INTO hebrew_lemma VALUES ("n#01552970","n","שַׁחַף","N");
INSERT INTO hebrew_lemma VALUES ("n#05835955","n","שַׁחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#00203158","n","שַׁיִט","N");
INSERT INTO hebrew_lemma VALUES ("n#10725638","n","שַׁיִשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05597799","n","שַׁיָּכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#09933378","n","שַׁיָּכוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#01344464","n","שַׁלְדָּג","N");
INSERT INTO hebrew_lemma VALUES ("n#10064397","n","שַׁלְוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09561072","n","שַׁלְמוֹנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003763","n","שַׁלִּיט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003764","n","שַׁלִּיטָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03228452","n","שַׁלַּט-רַחַק","N");
INSERT INTO hebrew_lemma VALUES ("n#03228452","n","שַׁלָּט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003889","n","שַׁמְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003890","n","שַׁמְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04710672","n","שַׁמְרָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#07631359","n","שַׁמַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#07105394","n","שַׁמָּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#03530611","n","שַׁנַּאי","N");
INSERT INTO hebrew_lemma VALUES ("n#10828986","n","שַׁעֲוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05394812","n","שַׁעֲרוּרִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#05447394","n","שַׁעֲרוּרִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10173849","n","שַׁעֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00123083","n","שַׁעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02747160","n","שַׁעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#02759209","n","שַׁעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#09594438","n","שַׁעַר-הַחֲלִיפִין","N");
INSERT INTO hebrew_lemma VALUES ("n#02747511","n","שַׁעַר-לוֹגִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01771587","n","שַׁפִּירִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10159752","n","שַׁפַּעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#03344475","n","שַׁפּוּד","N");
INSERT INTO hebrew_lemma VALUES ("a#00718804","a","שַׁקְדָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003905","n","שַׁקְרָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003906","n","שַׁקְרָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#02265158","n","שַׁרְבִיט","N");
INSERT INTO hebrew_lemma VALUES ("n#03350642","n","שַׁרְווּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03350385","n","שַׁרְווּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05416617","n","שַׁרְווּל-רוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#03667509","n","שַׁתְקָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("v#00532796","v","שָׁאַל","N");
INSERT INTO hebrew_lemma VALUES ("v#00003763","v","שָׁאַף","N");
INSERT INTO hebrew_lemma VALUES ("v#00815554","v","שָׁאַף","N");
INSERT INTO hebrew_lemma VALUES ("n#06758353","n","שָׁבִיט","N");
INSERT INTO hebrew_lemma VALUES ("a#02214837","a","שָׁבִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00673994","a","שָׁבִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003759","n","שָׁבוּי","N");
INSERT INTO hebrew_lemma VALUES ("a#00824313","a","שָׁבוּי-בְּקִסְמוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#10888430","n","שָׁבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#10862128","n","שָׁבוּעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04302960","n","שָׁד","N");
INSERT INTO hebrew_lemma VALUES ("a#00700402","a","שָׁדוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#01354638","a","שָׁוֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00845976","a","שָׁוֶה","N");
INSERT INTO hebrew_lemma VALUES ("a#00240704","a","שָׁזוּף","N");
INSERT INTO hebrew_lemma VALUES ("a#02093605","a","שָׁזוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#02206804","a","שָׁזוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#06960662","n","שָׁחֹר","N");
INSERT INTO hebrew_lemma VALUES ("n#03260882","n","שָׁטִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00559552","v","שָׁטַף-אֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06669110","n","שָׁכֵן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003817","n","שָׁכֵן","N");
INSERT INTO hebrew_lemma VALUES ("a#00413957","a","שָׁכֵן","N");
INSERT INTO hebrew_lemma VALUES ("v#00977560","v","שָׁכַב-עִם","N");
INSERT INTO hebrew_lemma VALUES ("v#01809405","v","שָׁכַן","N");
INSERT INTO hebrew_lemma VALUES ("n#03311249","n","שָׁל","N");
INSERT INTO hebrew_lemma VALUES ("n#07245827","n","שָׁלִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07406477","n","שָׁלִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#07239996","n","שָׁלִיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#01877938","n","שָׁלֵם","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","שָׁלֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#00481645","a","שָׁלֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#01123172","a","שָׁלֵם","N");
INSERT INTO hebrew_lemma VALUES ("a#00481167","a","שָׁלֵם","N");
INSERT INTO hebrew_lemma VALUES ("v#01763262","v","שָׁלַט","N");
INSERT INTO hebrew_lemma VALUES ("n#10983365","n","שָׁלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#10044643","n","שָׁלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#02944345","n","שָׁלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#03349027","n","שָׁלָב","N");
INSERT INTO hebrew_lemma VALUES ("n#09543577","n","שָׁלָל","N");
INSERT INTO hebrew_lemma VALUES ("n#10065207","n","שָׁלוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#04973475","n","שָׁלוֹם","N");
INSERT INTO hebrew_lemma VALUES ("v#00459984","v","שָׁם","N");
INSERT INTO hebrew_lemma VALUES ("r#00106407","r","שָׁם","N");
INSERT INTO hebrew_lemma VALUES ("r#00251195","r","שָׁם","N");
INSERT INTO hebrew_lemma VALUES ("r#00106088","r","שָׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#06326607","n","שָׁמַיִם","N");
INSERT INTO hebrew_lemma VALUES ("n#06749007","n","שָׁמַיִם","N");
INSERT INTO hebrew_lemma VALUES ("r#00106088","r","שָׁמָּה","N");
INSERT INTO hebrew_lemma VALUES ("r#00106274","r","שָׁמָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03879856","n","שָׁנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#03880797","n","שָׁנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10915598","n","שָׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10917283","n","שָׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10917509","n","שָׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10917791","n","שָׁנָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01216154","a","שָׁנוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#02452507","n","שָׁעוֹן","N");
INSERT INTO hebrew_lemma VALUES ("a#02314990","a","שָׁפוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("v#00440790","v","שָׁקַל-מֵחָדָשׁ","N");
INSERT INTO hebrew_lemma VALUES ("a#01858003","a","שָׁקוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#01457503","v","שָׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#07865636","n","שָׁרָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#06483262","n","שֹׁבֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#00620675","n","שֹׁד","N");
INSERT INTO hebrew_lemma VALUES ("n#00499726","n","שֹׁד","N");
INSERT INTO hebrew_lemma VALUES ("n#09561072","n","שֹׁחַד","N");
INSERT INTO hebrew_lemma VALUES ("n#03905655","n","שֹׁמֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#02572848","n","שֻׁלְחָן","N");
INSERT INTO hebrew_lemma VALUES ("n#02572848","n","שֻׁלְחָן-אֹכֶל","N");
INSERT INTO hebrew_lemma VALUES ("n#09172696","n","שֻׁמְשֹׁם","N");
INSERT INTO hebrew_lemma VALUES ("n#10661323","n","שֻׁמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#04089143","n","שֻׁמָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003888","n","שֻׁתְּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003887","n","שֻׁתָּף","N");
INSERT INTO hebrew_lemma VALUES ("n#07121607","n","שׁוֹאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003899","n","שׁוֹאֵל","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003900","n","שׁוֹאֶלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04892722","n","שׁוֹבֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#06941930","n","שׁוֹבֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#02291913","n","שׁוֹבָךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003907","n","שׁוֹדֵד","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003908","n","שׁוֹדֶדֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#07132921","n","שׁוֹחֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003747","n","שׁוֹחֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003748","n","שׁוֹחֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#03611698","n","שׁוֹט","N");
INSERT INTO hebrew_lemma VALUES ("v#01284430","v","שׁוֹטֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003734","n","שׁוֹטֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07485712","n","שׁוֹטֶרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003897","n","שׁוֹמֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003883","n","שׁוֹמֵר-טַף","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003898","n","שׁוֹמַעַת","N");
INSERT INTO hebrew_lemma VALUES ("a#01992026","a","שׁוֹנֶה","N");
INSERT INTO hebrew_lemma VALUES ("n#10656399","n","שׁוֹפְכִין","N");
INSERT INTO hebrew_lemma VALUES ("n#02677714","n","שׁוֹפִין","N");
INSERT INTO hebrew_lemma VALUES ("n#07249386","n","שׁוֹפֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003891","n","שׁוֹפֵט","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003893","n","שׁוֹפֵט","N");
INSERT INTO hebrew_lemma VALUES ("a#00014012","a","שׁוֹפֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#02170020","a","שׁוֹפֵעַ-חַיִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003892","n","שׁוֹפֶטֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003894","n","שׁוֹפֶטֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05693545","n","שׁוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#07126446","n","שׁוֹשְׁבִינָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05976600","n","שׁוֹשֶׁלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#08727889","n","שׁוֹשָׁן","N");
INSERT INTO hebrew_lemma VALUES ("r#00039142","r","שׁוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#08736400","n","שׁוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#05851153","n","שׁוּם","N");
INSERT INTO hebrew_lemma VALUES ("a#01470425","a","שׁוּם","N");
INSERT INTO hebrew_lemma VALUES ("NULL","N","שׁוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04428566","n","שׁוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06740258","n","שׁוּנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07221232","n","שׁוּעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#10585384","n","שׁוּעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#01627543","n","שׁוּעָל","N");
INSERT INTO hebrew_lemma VALUES ("n#02967394","n","שׁוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#00711063","n","שׁוּק","N");
INSERT INTO hebrew_lemma VALUES ("n#10369117","n","שְׂבִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05598833","n","שְׂבִיעוּת-רָצוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10369117","n","שְׂבֵעוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00373866","n","שְׂחִיַּת-חֲתִירָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00374336","n","שְׂחִיַּת-פַּרְפַּר","N");
INSERT INTO hebrew_lemma VALUES ("n#09540718","n","שְׂכַר-נֶטוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#05692621","n","שְׂלָו","N");
INSERT INTO hebrew_lemma VALUES ("n#01324122","n","שְׂלָו","N");
INSERT INTO hebrew_lemma VALUES ("n#03196324","n","שְׂמִיכַת-פּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02623403","n","שְׂמִיכַת-פּוּךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#02296948","n","שְׂמִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06671614","n","שְׂמִיכָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01958764","a","שְׂמֹאלָנִי","N");
INSERT INTO hebrew_lemma VALUES ("n#01913506","n","שְׂעִיר-עִזִּים","N");
INSERT INTO hebrew_lemma VALUES ("n#05145873","n","שְׂפַת-סִימָנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#02931334","n","שְׂפָתוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#10685306","n","שְׂרָף","N");
INSERT INTO hebrew_lemma VALUES ("n#03323271","n","שְׂרוֹךְ-נַעַל","N");
INSERT INTO hebrew_lemma VALUES ("v#00214424","v","שִׂגְשֵׂג","N");
INSERT INTO hebrew_lemma VALUES ("v#01599732","v","שִׂגְשֵׂג","N");
INSERT INTO hebrew_lemma VALUES ("v#01190902","v","שִׂדֵּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09769589","n","שִׂיא","N");
INSERT INTO hebrew_lemma VALUES ("n#10045044","n","שִׂיא","N");
INSERT INTO hebrew_lemma VALUES ("n#00036443","n","שִׂיא","N");
INSERT INTO hebrew_lemma VALUES ("n#10019938","n","שִׂיא","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003761","n","שִׂיאָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003762","n","שִׂיאָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07703270","n","שִׂיחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#04742189","n","שִׂיחַת-טֶלֶפוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04698896","n","שִׂיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04742189","n","שִׂיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05337255","n","שִׂיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05347846","n","שִׂיחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05596218","n","שִׂמְחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02764599","n","שִׂמְלַת-עֶרֶב","N");
INSERT INTO hebrew_lemma VALUES ("n#02600401","n","שִׂמְלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05609785","n","שִׂנְאָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06739486","n","שִׂרְטוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04896216","n","שֶׂכֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003911","n","שַׂחְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003913","n","שַׂחְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003912","n","שַׂחְיָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003914","n","שַׂחְיָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#07061094","n","שַׂחְקָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07480903","n","שַׂחְקָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07271874","n","שַׂחְקָן-פוּטְבּוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#07061896","n","שַׂחְקָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10369117","n","שָׂבְעָה","N");
INSERT INTO hebrew_lemma VALUES ("a#01999835","a","שָׂבֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("a#01999564","a","שָׂבֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("v#00807803","v","שָׂבַע","N");
INSERT INTO hebrew_lemma VALUES ("v#00811762","v","שָׂבַע","N");
INSERT INTO hebrew_lemma VALUES ("v#01335172","v","שָׂחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06894661","n","שָׂטָן","N");
INSERT INTO hebrew_lemma VALUES ("v#01512144","v","שָׂכַר","N");
INSERT INTO hebrew_lemma VALUES ("v#01676541","v","שָׂכַר","N");
INSERT INTO hebrew_lemma VALUES ("n#09556237","n","שָׂכָר","N");
INSERT INTO hebrew_lemma VALUES ("v#01026409","v","שָׂם","N");
INSERT INTO hebrew_lemma VALUES ("a#01530492","a","שָׂנוּא","N");
INSERT INTO hebrew_lemma VALUES ("a#01400194","a","שָׂנוּא","N");
INSERT INTO hebrew_lemma VALUES ("n#01913506","n","שָׂעִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00211427","a","שָׂעִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#06314081","n","שָׂפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04085355","n","שָׂפָם","N");
INSERT INTO hebrew_lemma VALUES ("n#03634739","n","שָׂרִיד","N");
INSERT INTO hebrew_lemma VALUES ("v#01785787","v","שָׂרַד","N");
INSERT INTO hebrew_lemma VALUES ("v#00263602","v","שָׂרַף","N");
INSERT INTO hebrew_lemma VALUES ("n#06891976","n","שָׂרָף","N");
INSERT INTO hebrew_lemma VALUES ("n#10369117","n","שֹׂבַע","N");
INSERT INTO hebrew_lemma VALUES ("n#05788922","n","תְּאֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#08704163","n","תְּאֵנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06627435","n","תְּאוֹ","N");
INSERT INTO hebrew_lemma VALUES ("n#06844168","n","תְּאוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#00686953","n","תְּבִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00776884","n","תְּבִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06011094","n","תְּבִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004031","n","תְּבוּסְתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004032","n","תְּבוּסְתָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#05607104","n","תְּבוּסְתָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05558471","n","תְּבוּסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09682678","n","תְּגוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00551220","n","תְּגוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09682678","n","תְּגוּבָה-כִּימִית","N");
INSERT INTO hebrew_lemma VALUES ("n#10975635","n","תְּדִירוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#03690420","n","תְּהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#10358076","n","תְּהִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03734192","n","תְּהוֹם","N");
INSERT INTO hebrew_lemma VALUES ("n#00180278","n","תְּזוּזָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09707335","n","תְּזוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04760894","n","תְּחִלִּית","N");
INSERT INTO hebrew_lemma VALUES ("r#00099935","r","תְּחִלָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#04595218","n","תְּחוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#06307482","n","תְּחוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#10410497","n","תְּחוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04506274","n","תְּחוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04594727","n","תְּחוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#04734266","n","תְּחוּם-תְּדָרִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04503850","n","תְּכוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03714294","n","תְּכוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02797379","n","תְּלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00657170","n","תְּלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00753567","n","תְּלִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03956850","n","תְּלִילוּת","N");
INSERT INTO hebrew_lemma VALUES ("a#00623140","a","תְּלַת-מְמַדִּי","N");
INSERT INTO hebrew_lemma VALUES ("n#04892722","n","תְּלוּשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#05582358","n","תְּמִיהָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03823333","n","תְּמִימוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10451252","n","תְּמִסָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03113185","n","תְּמוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05258594","n","תְּמוּנָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03946608","n","תְּמוּתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10974561","n","תְּמוּתָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05062190","n","תְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#05072928","n","תְּנַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#09380644","n","תְּנוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03965003","n","תְּנוּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00511256","n","תְּנוּעַת-נֹעַר","N");
INSERT INTO hebrew_lemma VALUES ("n#00023967","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00213518","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00722332","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05146366","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05324546","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05449557","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07775426","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00511256","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06231214","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00180278","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05322484","n","תְּנוּעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03932233","n","תְּנוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#07798186","n","תְּסִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10070620","n","תְּסִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09690047","n","תְּסִיסָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04864239","n","תְּעוּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04860581","n","תְּעוּדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09745295","n","תְּקִיעָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10945693","n","תְּקוּפַת-תִּשְׁרֵי","N");
INSERT INTO hebrew_lemma VALUES ("n#10954662","n","תְּקוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10955141","n","תְּקוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09898493","n","תְּרֵיסָר","N");
INSERT INTO hebrew_lemma VALUES ("n#00504440","n","תְּרוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00706536","n","תְּרוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09549012","n","תְּרוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00445646","n","תְּרוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02981307","n","תְּרוּפָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05017234","n","תְּשׁוּאוֹת","N");
INSERT INTO hebrew_lemma VALUES ("n#05379686","n","תְּשׁוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05602852","n","תְּשׁוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05055491","n","תְּשׁוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05053336","n","תְּשׁוּבָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00158831","n","תִּבְלוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00158831","n","תִּבּוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00563942","v","תִּדְרֵךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#03061606","n","תִּזְמֹרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#06122853","n","תִּזְמֹרֶת","N");
INSERT INTO hebrew_lemma VALUES ("v#00564109","v","תִּחְקֵר","N");
INSERT INTO hebrew_lemma VALUES ("n#07154665","n","תִּינוֹק","N");
INSERT INTO hebrew_lemma VALUES ("n#04491717","n","תִּיק","N");
INSERT INTO hebrew_lemma VALUES ("n#01736855","n","תִּיקָן","N");
INSERT INTO hebrew_lemma VALUES ("n#05768962","n","תִּירָס","N");
INSERT INTO hebrew_lemma VALUES ("n#08450904","n","תִּירָס","N");
INSERT INTO hebrew_lemma VALUES ("v#01193948","v","תִּכְנֵת","N");
INSERT INTO hebrew_lemma VALUES ("n#08063621","n","תִּלְתָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#01217953","n","תִּמְסָח","N");
INSERT INTO hebrew_lemma VALUES ("n#05582358","n","תִּמָּהוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#03603464","n","תִּסְבֹּכֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05589778","n","תִּסְכּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05605777","n","תִּסְכּוּל","N");
INSERT INTO hebrew_lemma VALUES ("v#00348785","v","תִּעֵשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#05577810","n","תִּעוּב","N");
INSERT INTO hebrew_lemma VALUES ("n#00593063","n","תִּעוּשׂ","N");
INSERT INTO hebrew_lemma VALUES ("n#00357253","n","תִּפוּף","N");
INSERT INTO hebrew_lemma VALUES ("v#00490839","v","תִּקְצֵב","N");
INSERT INTO hebrew_lemma VALUES ("n#04992880","n","תִּקְרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#09931984","n","תִּקְשֹׁרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04728675","n","תִּקְשֹׁרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00019671","n","תִּקְשֹׁרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04786785","n","תִּקְשֹׁרֶת-בִּכְתָב","N");
INSERT INTO hebrew_lemma VALUES ("n#00167178","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00167762","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00811685","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#06326331","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#10431107","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00510453","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00171220","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("n#05041525","n","תִּקּוּן","N");
INSERT INTO hebrew_lemma VALUES ("v#00409147","v","תִּרְגֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#00574902","n","תִּרְגּוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#02480510","n","תִּרְכֹּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#04516798","n","תִּרְכֹּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#10630741","n","תִּרְכֹּבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05018240","n","תִּשְׁבָּחָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03491295","n","תֵּאַטְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05256340","n","תֵּאַטְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#06085732","n","תֵּאַטְרוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#05565069","n","תֵּאָבוֹן","N");
INSERT INTO hebrew_lemma VALUES ("n#04497139","n","תֵּאוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05380994","n","תֵּאוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#05042407","n","תֵּאוּר","N");
INSERT INTO hebrew_lemma VALUES ("a#00697470","a","תֵּאוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("a#00697814","a","תֵּאוּרִי","N");
INSERT INTO hebrew_lemma VALUES ("n#02427713","n","תֵּבָה","N");
INSERT INTO hebrew_lemma VALUES ("r#00047341","r","תֵּכֶף-וּמִיָּד","N");
INSERT INTO hebrew_lemma VALUES ("n#02355342","n","תֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#03018868","n","תֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05969773","n","תֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#06723626","n","תֵּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05052528","n","תֵּרוּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#10975635","n","תֶּדֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#02730783","n","תֶּלֶם","N");
INSERT INTO hebrew_lemma VALUES ("n#03926914","n","תֶּנַע","N");
INSERT INTO hebrew_lemma VALUES ("n#03493877","n","תֶּרְמוֹמֶטֶר","N");
INSERT INTO hebrew_lemma VALUES ("n#05773284","n","תֶּרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#08145982","n","תֶּרֶד","N");
INSERT INTO hebrew_lemma VALUES ("n#09572926","n","תֶּשֶׁר","N");
INSERT INTO hebrew_lemma VALUES ("n#00490220","n","תַּאֲוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05568116","n","תַּאֲוָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05387878","n","תַּאֲנִיָּה-וַאֲנִיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#03900622","n","תַּבְלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05842853","n","תַּבְלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#05845405","n","תַּבְלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#10799018","n","תַּבְלִין","N");
INSERT INTO hebrew_lemma VALUES ("n#03288844","n","תַּבְרִיג","N");
INSERT INTO hebrew_lemma VALUES ("n#06233236","n","תַּהֲלוּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04882660","n","תַּזְכִּיר","N");
INSERT INTO hebrew_lemma VALUES ("a#00149802","a","תַּחְבְּלָן","N");
INSERT INTO hebrew_lemma VALUES ("n#00273902","n","תַּחְבִּיב","N");
INSERT INTO hebrew_lemma VALUES ("n#06240108","n","תַּחְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#04687137","n","תַּחְבִּיר","N");
INSERT INTO hebrew_lemma VALUES ("n#00171721","n","תַּחְזוּקָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04353829","n","תַּחְמָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#10742206","n","תַּחְמֹצֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02665381","n","תַּחְפֹּשֶׂת","N");
INSERT INTO hebrew_lemma VALUES ("n#02576738","n","תַּחְפֹּשֶׂת","N");
INSERT INTO hebrew_lemma VALUES ("n#05392760","n","תַּחְקִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#02993501","n","תַּחְתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#05058536","n","תַּחֲזִית","N");
INSERT INTO hebrew_lemma VALUES ("n#03632472","n","תַּחֲנַת-עֲבוֹדָה","N");
INSERT INTO hebrew_lemma VALUES ("n#02898729","n","תַּחֲרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00757193","n","תַּחֲרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#00756855","n","תַּחֲרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05542799","n","תַּחֲרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#05554206","n","תַּחֲרוּת-צְלִילָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04306560","n","תַּחַת","N");
INSERT INTO hebrew_lemma VALUES ("n#01913506","n","תַּיִשׁ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003936","n","תַּיֶּרֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003935","n","תַּיָּר","N");
INSERT INTO hebrew_lemma VALUES ("n#00193473","n","תַּיָּרוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04587307","n","תַּכְלִית","N");
INSERT INTO hebrew_lemma VALUES ("a#02720715","a","תַּכְסִיסִי","N");
INSERT INTO hebrew_lemma VALUES ("n#07348247","n","תַּכְשִׁיט","N");
INSERT INTO hebrew_lemma VALUES ("n#02876152","n","תַּכְשִׁיט","N");
INSERT INTO hebrew_lemma VALUES ("n#07309438","n","תַּלְיָן","N");
INSERT INTO hebrew_lemma VALUES ("n#07617015","n","תַּלְמִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#07217388","n","תַּלְמִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#04856408","n","תַּלְמוּד","N");
INSERT INTO hebrew_lemma VALUES ("n#09996989","n","תַּלְתַּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04081954","n","תַּלְתַּל","N");
INSERT INTO hebrew_lemma VALUES ("n#05260613","n","תַּמְלִיל","N");
INSERT INTO hebrew_lemma VALUES ("a#00512104","a","תַּמְצִיתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#06660574","n","תַּמְרִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#09551149","n","תַּמְרִיץ","N");
INSERT INTO hebrew_lemma VALUES ("n#01624311","n","תַּן","N");
INSERT INTO hebrew_lemma VALUES ("n#01217953","n","תַּנִּין","N");
INSERT INTO hebrew_lemma VALUES ("n#03068591","n","תַּנּוּר","N");
INSERT INTO hebrew_lemma VALUES ("n#07554016","n","תַּסְרִיטַאי","N");
INSERT INTO hebrew_lemma VALUES ("n#06231214","n","תַּעֲבוּרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00474950","n","תַּעֲלוּל","N");
INSERT INTO hebrew_lemma VALUES ("n#04802962","n","תַּעֲלוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#04394091","n","תַּעֲלוּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#05004860","n","תַּעֲמוּלָה","N");
INSERT INTO hebrew_lemma VALUES ("n#00692334","n","תַּעֲנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04490585","n","תַּעֲנוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#05569060","n","תַּעֲנוּג","N");
INSERT INTO hebrew_lemma VALUES ("n#00244416","n","תַּעֲרֹבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05623572","n","תַּעֲרֹבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#05491211","n","תַּעֲרֹבֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#00336519","n","תַּעֲרוּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06217283","n","תַּעֲרוּכָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03811831","n","תַּעֲשִׂיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#06011363","n","תַּעֲשִׂיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#00592801","n","תַּעֲשִׂיָּה","N");
INSERT INTO hebrew_lemma VALUES ("n#07337550","n","תַּעֲשִׂיָּן","N");
INSERT INTO hebrew_lemma VALUES ("n#00461585","n","תַּפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#09586410","n","תַּפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#04011535","n","תַּפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#00462318","n","תַּפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#04552661","n","תַּפְקִיד","N");
INSERT INTO hebrew_lemma VALUES ("n#05783752","n","תַּפּוּז","N");
INSERT INTO hebrew_lemma VALUES ("n#08933828","n","תַּפּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05775435","n","תַּפּוּחַ","N");
INSERT INTO hebrew_lemma VALUES ("n#05783752","n","תַּפּוּחַ-זָהָב","N");
INSERT INTO hebrew_lemma VALUES ("n#05049744","n","תַּצְהִיר","N");
INSERT INTO hebrew_lemma VALUES ("n#03113185","n","תַּצְלוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00565102","n","תַּצְפִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#09668771","n","תַּקְצִיב","N");
INSERT INTO hebrew_lemma VALUES ("n#09668437","n","תַּקְצִיב","N");
INSERT INTO hebrew_lemma VALUES ("a#02778941","a","תַּקְצִיבִי","N");
INSERT INTO hebrew_lemma VALUES ("n#04858569","n","תַּקְצִיר","N");
INSERT INTO hebrew_lemma VALUES ("a#01879678","a","תַּרְבּוּתִי","N");
INSERT INTO hebrew_lemma VALUES ("n#10093894","n","תַּרְדֵּמַת-חֹרֶף","N");
INSERT INTO hebrew_lemma VALUES ("n#10060454","n","תַּרְדֵּמַת-נֶצַח","N");
INSERT INTO hebrew_lemma VALUES ("n#10094639","n","תַּרְדֵּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#10093894","n","תַּרְדֵּמָה","N");
INSERT INTO hebrew_lemma VALUES ("n#03564977","n","תַּרְכִּיב","N");
INSERT INTO hebrew_lemma VALUES ("n#01310529","n","תַּרְנְגֹלֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#01310064","n","תַּרְנְגוֹל","N");
INSERT INTO hebrew_lemma VALUES ("n#10800431","n","תַּרְסִיס","N");
INSERT INTO hebrew_lemma VALUES ("n#05588960","n","תַּרְעֹמֶת","N");
INSERT INTO hebrew_lemma VALUES ("n#02563119","n","תַּרְשִׁים","N");
INSERT INTO hebrew_lemma VALUES ("n#05082116","n","תַּשְׁבֵּץ","N");
INSERT INTO hebrew_lemma VALUES ("n#09555462","n","תַּשְׁלוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#00725730","n","תַּשְׁלוּם","N");
INSERT INTO hebrew_lemma VALUES ("n#02855978","n","תַּשְׁתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#02855587","n","תַּשְׁתִּית","N");
INSERT INTO hebrew_lemma VALUES ("n#00003095","n","תָּא","N");
INSERT INTO hebrew_lemma VALUES ("n#04233304","n","תָּא-זֶרַע","N");
INSERT INTO hebrew_lemma VALUES ("n#02410657","n","תָּא-כֶּלֶא","N");
INSERT INTO hebrew_lemma VALUES ("n#04964806","n","תָּכְנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004317","n","תָּכְנִיתָן","N");
INSERT INTO hebrew_lemma VALUES ("n#H0004318","n","תָּכְנִיתָנִית","N");
INSERT INTO hebrew_lemma VALUES ("n#04871504","n","תֹּכֶן","N");
INSERT INTO hebrew_lemma VALUES ("n#04871504","n","תֹּכֶן-הָעִנְיָנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#04871504","n","תֹּכֶן_הָעִנְיָנִים","N");
INSERT INTO hebrew_lemma VALUES ("n#03467835","n","תֹּף-מִרְיָם","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003722","n","תּוֹבֵעַ","N");
INSERT INTO hebrew_lemma VALUES ("n#H0003724","n","תּוֹבַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#06333091","n","תּוֹךְ","N");
INSERT INTO hebrew_lemma VALUES ("n#01811851","n","תּוֹלַעַת","N");
INSERT INTO hebrew_lemma VALUES ("n#03662132","n","תּוֹקְפָנוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#04648621","n","תּוֹרַת-הַיַּחֲסוּת","N");
INSERT INTO hebrew_lemma VALUES ("n#06107058","n","תּוֹשָׁבֵי-הָעֲיָרָה","N");
INSERT INTO hebrew_lemma VALUES ("n#06106897","n","תּוֹשָׁבֵי-הָעִיר","N");