from abc import ABCMeta, abstractmethod
from typing import Any, Optional, TypedDict

class PropagationContext:
    trace_id: str
    parent_id: str
    trace_fields: dict[str, Any]
    dataset: Optional[str]
    def __init__(
        self,
        trace_id: str,
        parent_id: str,
        trace_fields: dict[str, Any] = ...,
        dataset: Optional[str] = ...,
    ) -> None: ...

class Request(metaclass=ABCMeta):
    @abstractmethod
    def header(self, key: str) -> str: ...
    @abstractmethod
    def method(self) -> str: ...
    @abstractmethod
    def scheme(self) -> str: ...
    @abstractmethod
    def host(self) -> str: ...
    @abstractmethod
    def path(self) -> str: ...
    @abstractmethod
    def query(self) -> str: ...
    @abstractmethod
    def middleware_request(self) -> Any: ...

class DictRequestRepr(TypedDict):
    headers: dict[str, str]
    props: dict[str, str]

class DictRequest(Request):
    def __init__(
        self, headers: dict[str, str], props: dict[str, str] = ...
    ) -> None: ...
    def header(self, key: str) -> str: ...
    def method(self) -> str: ...
    def scheme(self) -> str: ...
    def host(self) -> str: ...
    def path(self) -> str: ...
    def query(self) -> str: ...
    def middleware_request(self) -> DictRequestRepr: ...
