# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-03-04 14:58
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip_address', models.CharField(max_length=45)),
                ('live', models.BooleanField()),
                ('event_code', models.CharField(blank=True, max_length=50)),
                ('psp_reference', models.CharField(blank=True, max_length=150)),
                ('original_reference', models.CharField(blank=True, max_length=150)),
                ('merchant_reference', models.CharField(blank=True, max_length=128)),
                ('merchant_account_code', models.CharField(blank=True, max_length=150)),
                ('event_date', models.DateTimeField(blank=True)),
                ('success', models.BooleanField()),
                ('payment_method', models.CharField(blank=True, max_length=50)),
                ('operations', models.CharField(blank=True, max_length=100)),
                ('reason', models.CharField(blank=True, max_length=250)),
                ('amount', models.CharField(blank=True, max_length=15)),
                ('valid', models.NullBooleanField()),
                ('creation_time', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ('-creation_time',),
            },
        ),
        migrations.CreateModel(
            name='RecurringContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recurring_detail_reference', models.CharField(blank=True, max_length=150)),
                ('shopper_reference', models.CharField(max_length=80)),
                ('contract_type', models.CharField(max_length=50)),
                ('payment_method_type', models.CharField(max_length=15)),
                ('variant', models.CharField(blank=True, max_length=50)),
                ('creation_date', models.DateTimeField(blank=True)),
                ('creation_time', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ('-creation_time',),
            },
        ),
        migrations.CreateModel(
            name='RecurringContractDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=100)),
                ('value', models.CharField(blank=True, max_length=250)),
                ('recurring_contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='details', to='adyengo.RecurringContract')),
            ],
        ),
        migrations.CreateModel(
            name='RecurringPaymentResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('psp_reference', models.PositiveIntegerField()),
                ('result_code', models.CharField(choices=[('Authorised', 'Authorised'), ('Refused', 'Refused'), ('Error', 'Error')], max_length=30)),
                ('auth_code', models.PositiveIntegerField(null=True)),
                ('refusal_reason', models.CharField(blank=True, max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_type', models.CharField(choices=[('hpp_regular', 'HPP Regular'), ('hpp_recurring', 'HPP Recurring'), ('api_recurring', 'API Recurring')], max_length=25)),
                ('merchant_reference', models.CharField(max_length=80, unique=True)),
                ('payment_amount', models.PositiveSmallIntegerField()),
                ('currency_code', models.CharField(choices=[('EUR', 'Euro')], default=None, max_length=3)),
                ('ship_before_date', models.DateTimeField(null=True)),
                ('skin_code', models.CharField(default='BCS1MHG2', max_length=10)),
                ('shopper_locale', models.CharField(blank=True, choices=[('en_GB', 'English (United Kingdom)'), ('nl_BE', 'Dutch (Belgium)'), ('nl_NL', 'Dutch (Holland)'), ('fr_BE', 'French (Belgium)'), ('de_DE', 'German (Germany)')], max_length=5)),
                ('order_data', models.TextField(blank=True)),
                ('session_validity', models.DateTimeField(null=True)),
                ('merchant_return_data', models.CharField(max_length=128)),
                ('country_code', models.CharField(blank=True, choices=[('BE', 'Belgium'), ('NL', 'Netherlands'), ('DE', 'Germany'), ('GB', 'United Kingdom')], max_length=2)),
                ('shopper_email', models.EmailField(blank=True, max_length=254)),
                ('shopper_reference', models.CharField(blank=True, max_length=80)),
                ('shopper_ip', models.CharField(blank=True, max_length=45)),
                ('shopper_statement', models.CharField(blank=True, max_length=135)),
                ('fraud_offset', models.PositiveIntegerField(null=True)),
                ('recurring_contract', models.CharField(blank=True, choices=[('RECURRING', 'Recurring'), ('RECURRING,ONECLICK', 'Recurring and One click (user chooses)'), ('ONECLICK', 'One click')], max_length=50)),
                ('recurring_detail_reference', models.CharField(blank=True, max_length=80)),
                ('page_type', models.CharField(choices=[('skip', 'Skip'), ('single', 'Single'), ('multiple', 'Multiple')], max_length=15)),
                ('creation_time', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ('-creation_time',),
            },
        ),
        migrations.CreateModel(
            name='SessionAllowedPaymentMethods',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(choices=[('bankTransfer', 'All banktransfers'), ('paypal', 'PayPal'), ('ideal', 'iDEAL'), ('bankTransfer_DE', 'German Banktransfer'), ('bankTransfer_NL', 'Dutch Banktransfer'), ('card', 'All debit and credit cards'), ('elv', 'ELV'), ('mc', 'Master Card'), ('visa', 'Visa'), ('directdebit_NL', 'Direct Debit (Netherlands)'), ('amex', 'Amex'), ('directEbanking', 'SofortUberweisung')], max_length=50)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='allowed_payment_methods', to='adyengo.Session')),
            ],
        ),
        migrations.CreateModel(
            name='SessionBlockedPaymentMethods',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(choices=[('bankTransfer', 'All banktransfers'), ('paypal', 'PayPal'), ('ideal', 'iDEAL'), ('bankTransfer_DE', 'German Banktransfer'), ('bankTransfer_NL', 'Dutch Banktransfer'), ('card', 'All debit and credit cards'), ('elv', 'ELV'), ('mc', 'Master Card'), ('visa', 'Visa'), ('directdebit_NL', 'Direct Debit (Netherlands)'), ('amex', 'Amex'), ('directEbanking', 'SofortUberweisung')], max_length=50)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='blocked_payment_methods', to='adyengo.Session')),
            ],
        ),
        migrations.AddField(
            model_name='recurringpaymentresult',
            name='session',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recurring_payment_results', to='adyengo.Session'),
        ),
        migrations.AlterUniqueTogether(
            name='recurringcontract',
            unique_together=set([('recurring_detail_reference', 'shopper_reference')]),
        ),
        migrations.AddField(
            model_name='notification',
            name='session',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='adyengo.Session'),
        ),
        migrations.AlterUniqueTogether(
            name='notification',
            unique_together=set([('live', 'merchant_account_code', 'psp_reference', 'event_code', 'success')]),
        ),
    ]
