/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.dependence.pdg;

import codeintelligence.codeanalysis.extractors.AbstractProgramGraph;
import codeintelligence.codeanalysis.extractors.dependence.DEPEdge;
import codeintelligence.codeanalysis.extractors.dependence.DEPNode;
import codeintelligence.codeanalysis.extractors.dependence.cfg.CFEdge;
import codeintelligence.codeanalysis.extractors.dependence.cfg.ControlFlowGraph;
import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.StringUtils;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProgramDependenceGraph
extends AbstractProgramGraph<DEPNode, DEPEdge> {
    private String name;
    private DEPNode entry;
    private List<DEPNode> params;

    public ProgramDependenceGraph(String name) {
        this.name = name;
        this.entry = null;
        this.params = new ArrayList<DEPNode>();
        this.properties.put("label", "PDG");
        this.properties.put("type", "Program Dependence Graph (PDG)");
    }

    public String getName() {
        return this.name;
    }

    public void setEntry(DEPNode entry) {
        this.entry = entry;
    }

    public DEPNode getEntry() {
        return this.entry;
    }

    public void addParams(List<DEPNode> params) {
        this.params = params;
        for (DEPNode param : params) {
            this.addVertex(param);
        }
    }

    public List<DEPNode> getParams() {
        return this.params;
    }

    public void attachCFG(ControlFlowGraph cfg) {
        this.entry = cfg.getEntry();
        for (DEPNode param : this.params) {
            this.addVertex(param);
        }
        Iterator ctrlNodes = cfg.allVerticesIterator();
        while (ctrlNodes.hasNext()) {
            DEPNode ctrlNode = (DEPNode)ctrlNodes.next();
            this.addVertex(ctrlNode);
        }
        Iterator ctrlEdges = cfg.allEdgesIterator();
        while (ctrlEdges.hasNext()) {
            Edge ctrlEdge = ctrlEdges.next();
            this.addEdge(new Edge<DEPNode, DEPEdge>((DEPNode)ctrlEdge.source, new DEPEdge(DEPEdge.Type.CTRL, ((CFEdge)ctrlEdge.label).getLabel()), (DEPNode)ctrlEdge.target));
        }
    }

    public List<Edge<DEPNode, DEPEdge>> ctrlEdges() {
        ArrayList<Edge<DEPNode, DEPEdge>> ctrlEdges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        for (Edge edge : this.allEdges) {
            if (((DEPEdge)edge.label).getType() != DEPEdge.Type.CTRL) continue;
            ctrlEdges.add(edge);
        }
        return ctrlEdges;
    }

    public List<Edge<DEPNode, DEPEdge>> dataEdges() {
        ArrayList<Edge<DEPNode, DEPEdge>> dataEdges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        for (Edge edge : this.allEdges) {
            if (((DEPEdge)edge.label).getType() != DEPEdge.Type.DATA) continue;
            dataEdges.add(edge);
        }
        return dataEdges;
    }

    public List<Edge<DEPNode, DEPEdge>> outCtrlEdges(DEPNode node) {
        ArrayList<Edge<DEPNode, DEPEdge>> edges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        Iterator outEdges = this.outgoingEdgesIterator(node);
        while (outEdges.hasNext()) {
            Edge out = outEdges.next();
            if (((DEPEdge)out.label).getType() != DEPEdge.Type.CTRL) continue;
            edges.add(out);
        }
        return edges;
    }

    public List<Edge<DEPNode, DEPEdge>> outDataEdges(DEPNode node) {
        ArrayList<Edge<DEPNode, DEPEdge>> edges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        Iterator outEdges = this.outgoingEdgesIterator(node);
        while (outEdges.hasNext()) {
            Edge out = outEdges.next();
            if (((DEPEdge)out.label).getType() != DEPEdge.Type.DATA) continue;
            edges.add(out);
        }
        return edges;
    }

    public void printAllNodesUseDefs(Logger.Level level) {
        for (DEPNode node : this.allVertices) {
            Logger.log(node, level);
            Logger.log("  + USEs: " + Arrays.toString(node.getAllUSEs()), level);
            Logger.log("  + DEFs: " + Arrays.toString(node.getAllDEFs()) + "\n", level);
        }
    }

    @Override
    public void exportDOT(String filepath) throws IOException {
        this.exportDOT(filepath, true);
    }

    public void exportDOT(String filepath, boolean ctrlEdgeLabels) throws FileNotFoundException {
        try (PrintWriter dot = new PrintWriter(filepath, "UTF-8");){
            String trg;
            String src;
            dot.println("digraph PDG {");
            dot.println("  // graph-vertices");
            LinkedHashMap<DEPNode, CallSite> nodeNames = new LinkedHashMap<DEPNode, CallSite>();
            int nodeCounter = 1;
            for (DEPNode node : this.params) {
                String string = "v" + nodeCounter++;
                nodeNames.put(node, (CallSite)((Object)string));
                StringBuilder label = new StringBuilder("  [label=\"");
                if (node.getLineOfCode() > 0) {
                    label.append(node.getLineOfCode()).append(":  ");
                }
                String code = node.getCode();
                label.append(StringUtils.escape(code)).append("\", shape=box, style=filled, fillcolor=orange];");
                dot.println("  " + string + label.toString());
            }
            HashSet<DEPNode> paramNodes = new HashSet<DEPNode>(this.params);
            for (DEPNode dEPNode : this.allVertices) {
                if (paramNodes.contains(dEPNode)) continue;
                String name = "v" + nodeCounter++;
                nodeNames.put(dEPNode, (CallSite)((Object)name));
                StringBuilder label = new StringBuilder("  [label=\"");
                if (dEPNode.getLineOfCode() > 0) {
                    label.append(dEPNode.getLineOfCode()).append(":  ");
                }
                String code = dEPNode.getCode();
                label.append(StringUtils.escape(code)).append("\"];");
                dot.println("  " + name + label.toString());
            }
            dot.println("  // graph-edges");
            for (Edge edge : this.ctrlEdges()) {
                src = (String)nodeNames.get(edge.source);
                trg = (String)nodeNames.get(edge.target);
                if (ctrlEdgeLabels) {
                    dot.println("  " + src + " -> " + trg + "  [arrowhead=empty, color=gray, style=dashed, label=\"" + ((DEPEdge)edge.label).getLabel() + "\"];");
                    continue;
                }
                dot.println("  " + src + " -> " + trg + "  [arrowhead=empty, color=gray, style=dashed];");
            }
            for (Edge edge : this.dataEdges()) {
                src = (String)nodeNames.get(edge.source);
                trg = (String)nodeNames.get(edge.target);
                dot.println("   " + src + " -> " + trg + "   [style=bold, label=\" " + ((DEPEdge)edge.label).getLabel() + "\"];");
            }
            dot.println("  // end-of-graph\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("PDG exported to: " + filepath);
    }

    @Override
    public void exportJSON(String filepath) throws FileNotFoundException {
        try (PrintWriter json = new PrintWriter(filepath, "UTF-8");){
            json.println("{\n  \"directed\": true,");
            json.println("  \"multigraph\": true,");
            block13: for (Map.Entry property : this.properties.entrySet()) {
                switch ((String)property.getKey()) {
                    case "directed": {
                        continue block13;
                    }
                }
                json.println("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",");
            }
            LinkedHashMap<DEPNode, Integer> nodeNames = new LinkedHashMap<DEPNode, Integer>();
            json.println("  \"nodes\": [");
            int nodeCounter = 0;
            for (DEPNode node : this.allVertices) {
                json.println("    {");
                json.println("      \"id\": " + nodeCounter + ",");
                json.println("      \"line\": " + node.getLineOfCode() + ",");
                String code = node.getCode();
                json.println("      \"label\": \"" + StringUtils.escape(code) + "\",");
                json.println("      \"defs\": " + StringUtils.toJsonArray(node.getAllDEFs()) + ",");
                json.println("      \"uses\": " + StringUtils.toJsonArray(node.getAllUSEs()));
                nodeNames.put(node, nodeCounter);
                if (++nodeCounter == this.vertexCount()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ],\n\n  \"edges\": [");
            int edgeCounter = 0;
            for (Edge<DEPNode, DEPEdge> edge : this.ctrlEdges()) {
                json.println("    {");
                json.println("      \"id\": " + edgeCounter + ",");
                json.println("      \"source\": " + nodeNames.get(edge.source) + ",");
                json.println("      \"target\": " + nodeNames.get(edge.target) + ",");
                json.println("      \"type\": \"Control\",");
                json.println("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"");
                if (++edgeCounter == this.edgeCount()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            for (Edge<DEPNode, DEPEdge> edge : this.dataEdges()) {
                json.println("    {");
                json.println("      \"id\": " + edgeCounter + ",");
                json.println("      \"source\": " + nodeNames.get(edge.source) + ",");
                json.println("      \"target\": " + nodeNames.get(edge.target) + ",");
                json.println("      \"type\": \"Data\",");
                json.println("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"");
                if (++edgeCounter == this.edgeCount()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ]\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("PDG exported to: " + filepath);
    }

    public String exportCodeToJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n  \"directed\": true,");
        stringBuilder.append("  \"multigraph\": true,");
        block6: for (Map.Entry property : this.properties.entrySet()) {
            switch ((String)property.getKey()) {
                case "directed": {
                    continue block6;
                }
            }
            stringBuilder.append("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",");
        }
        LinkedHashMap<DEPNode, Integer> nodeNames = new LinkedHashMap<DEPNode, Integer>();
        stringBuilder.append("  \"nodes\": [");
        int nodeCounter = 0;
        for (DEPNode node : this.allVertices) {
            stringBuilder.append("    {");
            stringBuilder.append("      \"id\": " + nodeCounter + ",");
            stringBuilder.append("      \"line\": " + node.getLineOfCode() + ",");
            String code = node.getCode();
            stringBuilder.append("      \"label\": \"" + StringUtils.escape(code) + "\",");
            stringBuilder.append("      \"defs\": " + StringUtils.toJsonArray(node.getAllDEFs()) + ",");
            stringBuilder.append("      \"uses\": " + StringUtils.toJsonArray(node.getAllUSEs()));
            nodeNames.put(node, nodeCounter);
            if (++nodeCounter == this.vertexCount()) {
                stringBuilder.append("    }");
                continue;
            }
            stringBuilder.append("    },");
        }
        stringBuilder.append("  ],\n\n  \"edges\": [");
        int edgeCounter = 0;
        for (Edge<DEPNode, DEPEdge> edge : this.ctrlEdges()) {
            stringBuilder.append("    {");
            stringBuilder.append("      \"id\": " + edgeCounter + ",");
            stringBuilder.append("      \"source\": " + nodeNames.get(edge.source) + ",");
            stringBuilder.append("      \"target\": " + nodeNames.get(edge.target) + ",");
            stringBuilder.append("      \"type\": \"Control\",");
            stringBuilder.append("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"");
            if (++edgeCounter == this.edgeCount()) {
                stringBuilder.append("    }");
                continue;
            }
            stringBuilder.append("    },");
        }
        for (Edge<DEPNode, DEPEdge> edge : this.dataEdges()) {
            stringBuilder.append("    {");
            stringBuilder.append("      \"id\": " + edgeCounter + ",");
            stringBuilder.append("      \"source\": " + nodeNames.get(edge.source) + ",");
            stringBuilder.append("      \"target\": " + nodeNames.get(edge.target) + ",");
            stringBuilder.append("      \"type\": \"Data\",");
            stringBuilder.append("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"");
            if (++edgeCounter == this.edgeCount()) {
                stringBuilder.append("    }");
                continue;
            }
            stringBuilder.append("    },");
        }
        stringBuilder.append("  ]\n}");
        Logger.info("PDG exported finished\uff01\uff01\uff01");
        return stringBuilder.toString();
    }
}

