/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.ast;

import codeintelligence.codeanalysis.extractors.AbstractProgramGraph;
import codeintelligence.codeanalysis.extractors.ast.ASEdge;
import codeintelligence.codeanalysis.extractors.ast.ASNode;
import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.StringUtils;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbstractSyntaxTree
extends AbstractProgramGraph<ASNode, ASEdge> {
    public final ASNode root;

    public AbstractSyntaxTree() {
        this.root = new ASNode(ASNode.Type.ROOT);
        this.properties.put("label", "AST");
        this.properties.put("type", "Abstract Syntax Tree (AST)");
        this.addVertex(this.root);
    }

    public AbstractSyntaxTree(AbstractSyntaxTree ast) {
        super(ast);
        this.root = ast.root;
    }

    @Override
    public void exportDOT(String filepath) throws FileNotFoundException {
        try (PrintWriter dot = new PrintWriter(filepath, "UTF-8");){
            dot.println("digraph AST {");
            dot.println("  // graph-vertices");
            LinkedHashMap<ASNode, CallSite> nodeNames = new LinkedHashMap<ASNode, CallSite>();
            int nodeCounter = 1;
            for (ASNode node : this.allVertices) {
                String name = "n" + nodeCounter++;
                nodeNames.put(node, (CallSite)((Object)name));
                StringBuilder label = new StringBuilder("  [label=\"");
                label.append(StringUtils.escape(node.toString())).append("\"];");
                dot.println("  " + name + label.toString());
            }
            dot.println("  // graph-edges");
            for (Edge edge : this.allEdges) {
                String src = (String)nodeNames.get(edge.source);
                String trg = (String)nodeNames.get(edge.target);
                dot.println("  " + src + " -> " + trg + ";");
            }
            dot.println("  // end-of-graph\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("AST exported to: " + filepath);
    }

    @Override
    public void exportJSON(String filepath) throws FileNotFoundException {
        try (PrintWriter json = new PrintWriter(filepath, "UTF-8");){
            json.println("{\n  \"directed\": true,");
            block13: for (Map.Entry property : this.properties.entrySet()) {
                switch ((String)property.getKey()) {
                    case "directed": {
                        continue block13;
                    }
                }
                json.println("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",");
            }
            json.println("  \"nodes\": [");
            LinkedHashMap<ASNode, Integer> nodeIDs = new LinkedHashMap<ASNode, Integer>();
            int nodeCounter = 0;
            for (ASNode node : this.allVertices) {
                json.println("    {");
                json.println("      \"id\": " + nodeCounter + ",");
                json.println("      \"line\": " + node.getLineOfCode() + ",");
                json.println("      \"type\": \"" + node.getType() + "\",");
                String code = node.getCode();
                code = StringUtils.isEmpty(code) ? node.getType().label : StringUtils.escape(code);
                json.println("      \"label\": \"" + code + "\",");
                String normalized = node.getNormalizedCode();
                normalized = StringUtils.isEmpty(normalized) ? code : StringUtils.escape(normalized);
                json.println("      \"normalized\": \"" + normalized + "\"");
                nodeIDs.put(node, nodeCounter);
                if (++nodeCounter == this.allVertices.size()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ],\n\n  \"edges\": [");
            int edgeCounter = 0;
            for (Edge edge : this.allEdges) {
                json.println("    {");
                json.println("      \"id\": " + edgeCounter + ",");
                json.println("      \"source\": " + nodeIDs.get(edge.source) + ",");
                json.println("      \"target\": " + nodeIDs.get(edge.target) + ",");
                json.println("      \"label\": \"\"");
                if (++edgeCounter == this.allEdges.size()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ]\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("AST exported to: " + filepath);
    }
}

