# AUTOGENERATED! DO NOT EDIT! File to edit: ../04_seaborn.ipynb.

# %% auto 0
__all__ = ['sns', 'if_is_else', 'renamer', 'Seaborn']

# %% ../04_seaborn.ipynb 2
import inspect
from functools import wraps
import seaborn
from .case import *
from fastcore.all import *

# %% ../04_seaborn.ipynb 4
def if_is_else(fun, x, t):
    if isinstance(x, t): return fun(x)
    else: return x

# %% ../04_seaborn.ipynb 5
def renamer(fun):
    @wraps(fun)
    def _inner(*args, **kwargs):
        new_args = [if_is_else(rename2words_cols_and_index, x, pd.DataFrame) for x in args]
        new_args = [if_is_else(snake2words_if_str, x, str) for x in new_args]
        args = tuple(new_args)
        for k in kwargs:
            kwargs[k] = if_is_else(rename2words_cols_and_index, kwargs[k], pd.DataFrame)
        
        keys = ['x', 'y', 'hue', 'col', 'row', 'size', 'style']
        for k in keys:
            if k in kwargs:
                if is_listy(kwargs[k]):
                    kwargs[k] = [snake2words_if_str(x) for x in kwargs[k]]
                else:
                    kwargs[k] = snake2words_if_str(kwargs[k])
        return fun(*args, **kwargs)
    return _inner

# %% ../04_seaborn.ipynb 6
class Seaborn:
    '''Like `express` but renames all columns from snake_case to Words.'''
    
    rename_attr = ['scatterplot', 'lineplot', 'displot', 'histplot', 'kdeplot', 'ecdfplot', 'rugplot', 'distplot',
                   'catplot', 'stripplot', 'swarmplot', 'boxplot', 'violinplot', 'boxenplot', 'pointplot', 'barplot',
                   'countplot', 'lmplot', 'regplot', 'residplot', 'heatmap', 'clustermap', 'FacetGrid', 'pairplot',
                   'PairGrid', 'jointplot', 'JointGrid']
    def __getattr__(self, attr):
        fun = getattr(seaborn, attr)
        if attr in self.rename_attr:
            return renamer(fun)
        else:
            return fun
    __dir__ = seaborn.__dir__
sns = Seaborn()
