# trackplot

[![PyPI version](https://badge.fury.io/py/trackplot.svg)](https://pypi.org/project/trackplot/)
[![PyPI download](https://img.shields.io/pypi/dm/trackplot.svg)](https://pypi.org/project/trackplot/)
[![install with bioconda](https://img.shields.io/badge/install%20with-bioconda-brightgreen.svg?style=flat)](http://bioconda.github.io/recipes/trackplot/README.html)
[![Documentation Status](https://readthedocs.org/projects/trackplot/badge/?version=latest)](https://trackplot.readthedocs.io/en/latest/)
[![License: BSD 3-Clause](https://img.shields.io/badge/License-BSD%20v3-clause.svg)](https://www.gnu.org/licenses/agpl-3.0)
[![DOI](https://img.shields.io/badge/DOI-10.1101%2F2022.11.02.514803%20-blue)](https://www.biorxiv.org/content/10.1101/2022.11.02.514803v1)

---

![](example/diagram.png)

[Tutorials](https://trackplot.readthedocs.io/en/latest/)

## what is trackplot

trackplot is a tool for visualizing various next-generation sequencing (NGS) data, including DNA-seq, RNA-seq, single-cell RNA-seq and full-length sequencing datasets. 

### Features of trackplot

1. Support various file formats as input
2. Support strand-aware coverage plot
3. Visualize coverage by heatmap, including HiC diagram 
4. Visualize protein domain based the given gene id
5. Demultiplex the single-cell RNA/ATAC-seq which used cell barcode into cell population 
6. Support visualizing individual full-length reads in read-by-read style
7. Support visualize circRNA sequencing data

## Input

trackplot supports almost NGS data format, including

- BAM
- Bed
- Depth file generated by `samtools depth`
- bigBed [[pyBigWig](https://github.com/deeptools/pyBigWig) required]
- bigWig [[pyBigWig](https://github.com/deeptools/pyBigWig) required]
- naive Hi-C format [[hicmatrix](https://github.com/deeptools/HiCMatrix) required]


## Output

The output will be a pdf and other image file formats which satisfy the requirement of the major journals, 
and each track on output corresponds these datasets from config file.

## Usage

The trackplot is written in Python, and user could install it in a variety of ways as follows

__Note:__ if `segment fault` with multiple processing, please try to use docker image, or just run with `-p 1`.


1. install from bioconda

   ```bash
   conda install -c bioconda -c conda-forge trackplot
   
   # or install trackplot into an isolated environments
   conda create -n sashimi -c bioconda -c conda-forge trackplot
   
   # or install latest trackplot  
   git clone https://github.com/ygidtu/trackplot.git sashimi
   cd sashimi
   conda create -n sashimi -f environment.yaml
   ```

2. install from PyPi

   ```bash
   pip install trackplot
   # __Note:__ We noticed some pypi mirrors are not syncing some packages we depend on, 
   # therefore please try another pypi mirror once you encounter 
   # `No local packages or working download links found for xxx`
   
   # optional, enable bigWig, bigBed and hicMatrix support
   pip install pybigwig hicmatrix
   ```

3. using docker image

    ```bash
    docker pull ygidtu/sashimi
    docker run --rm ygidtu/sashimi --help

    # or build docker image from source
    git clone https://github.com/ygidtu/trackplot sashimi
    cd sashimi
    docker build -t ygidtu/docker .
    docker run --rm ygidtu/sashimi --help
    ```

4. install from source code

    ```bash
    git clone https://github.com/ygidtu/trackplot sashimi
    cd sashimi
    pip install -r requirements.txt
    python setup.py install
   
    # optional, enable bigWig, bigBed and hicMatrix support
    pip install pybigwig hicmatrix
    
    sashimipy --help
    # or
    python main.py --help
    ```

5. for `pipenv` or `poetry` users

   ```bash
   git clone https://github.com/ygidtu/trackplot
   cd trackplot
   
   # pipenv
   # create virtualenv and install required packages
   pipenv install
   # optional, with `--pypi-mirror https://pypi.tuna.tsinghua.edu.cn/simple` to specify your faverate PyPi mirror
   # optional, with `--skip-lock` once encounter locking issues
   
   # switch to virtualenv
   pipenv shell && python main.py --help
   
   # or just run with pipenv
   pipenv run python main.py --help
  
   
   # poetry
   # once facing installation issues, please try to change PyPi mirror in tool.poetry.source section of pyproject.toml 
   # create virtualenv and install required packages
   poetry install
   
   # switch to virtualenv
   poetry shell  && python main.py --help
   
   # or just run with poetry
   poetry run python main.py --help
   ```

6. running from a local webserver
   
   Install trackplot before set up the web server

   ```bash
   git clone https://github.com/ygidtu/trackplot sashimi
   cd sashimi/web
   
   # build the frontend static files
   npm install -g vue-cli vite && npm install
   vite build
   
   # prepare the backend server
   pip install fastapi pydantic jinja2 uvicorn
   
   python server.py --help
   ```
   

## Example

The `example` folder is downloaded from [here.](https://github.com/ygidtu/trackplot/archive/refs/heads/main.zip) 
And a more detailed tutorial could be found at [here.](https://sashimi.readthedocs.io/en/latest/)  

```bash

python main.py \
  -e chr1:1270656-1284730:+ \
  -r example/example.sorted.gtf.gz \
  --interval example/interval_list.tsv \
  --density example/density_list.tsv \
  --show-site \
  --show-junction-num \
  --igv example/igv.tsv \
  --heatmap example/heatmap_list.tsv \
  --focus 1272656-1272656:1275656-1277656 \
  --stroke 1275656-1277656:1277856-1278656@blue \
  --sites 1271656,1271656,1272656 \
  --line example/line_list.tsv \
  -o example.png \
  --dpi 300 \
  --width 10 \
  --height 1 \
  --barcode example/barcode_list.tsv \
  --domain --remove-duplicate-umi \
  --normalize-format cpm \
  -p 4
```

here is the [output file](https://raw.githubusercontent.com/ygidtu/trackplot/main/example/example.png).


## Questions

Visit [issues](https://github.com/ygidtu/trackplot/issues) or 
contact [Yiming Zhang](https://github.com/ygidtu) and 
[Ran Zhou](https://github.com/zhou-ran)

## Citation

If you use Sashimi.py in your publication, please cite Sashimi.py by

[Zhang et al. Sashimi.py: a flexible toolkit for combinatorial analysis of genomic data. bioRxiv 2022.11.02.514803.](https://www.biorxiv.org/content/10.1101/2022.11.02.514803v1)

