/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.PgxSession;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.graphviz.driver.PgxVisualQuery;
import oracle.pgx.graphviz.driver.PgxVisualizationUtils;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.driver.expandGraph.ExpandTemplate;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.PgxPreparedStatementExpandQueryBuilder;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.PgxPreparedStatementUtils;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.ArrayParameter;
import oracle.pgx.graphviz.library.QueryEnhancer;

public class PgxVisualization {
    protected final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    protected final TypeReference<HashMap<String, String>> dynamicFormParamsTypeRef = new TypeReference<HashMap<String, String>>(){};
    protected final PgxSession session;
    protected final PgxVisualQuery visualQuery;
    protected final String defaultFeatureFlags = "{}";
    protected final String edgesLimit = "100";
    protected static final int DEFAULT_MAX_NUMBER_OF_HOPS = 6;

    public PgxVisualization(PgxSession session, Properties properties, QueryEnhancer<?> enhancer) {
        this.session = session;
        this.visualQuery = new PgxVisualQuery(properties, session, enhancer);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public PgxSession getSession() {
        return this.session;
    }

    public boolean isGraphLoaded(String graphName) throws VisualizationException {
        try {
            return PgxVisualizationUtils.getGraphFromPgqlGraphRef(this.session, graphName) != null;
        }
        catch (VisualizationException e) {
            return false;
        }
    }

    public String expandGraph(String graphName, String[] selectedVertices, int hops, Map<String, String> dynamicFormsParams) throws VisualizationException {
        String[] edgeIds;
        IdType edgeIDType;
        if (selectedVertices.length < 1) {
            throw new VisualizationException("No vertex ids provided.");
        }
        if (hops < 1 || hops >= 6) {
            throw new VisualizationException("Number of hops must be strictly positive and less than 6");
        }
        PgxGraph graph = PgxVisualizationUtils.getGraphFromPgqlGraphRef(this.session, graphName);
        graph = this.expandOffloadedSubGraph(graph, selectedVertices, hops, dynamicFormsParams);
        IdType vertexIdType = graph.getVertexIdType();
        IdType idType = edgeIDType = graph.getEdgeIdStrategy().equals((Object)IdStrategy.PARTITIONED_IDS) ? IdType.STRING : graph.getMetaData().getEdgeIdType();
        if (hops == 1) {
            String finalQuery = String.format("SELECT e FROM MATCH (s)-[e]-() WHERE id(s) IN ? LIMIT %s", "100");
            ArrayList parameters = new ArrayList();
            parameters.add(new ArrayParameter(1, PgxPreparedStatementUtils.getListIds(selectedVertices, vertexIdType)));
            return PgxVisualizationUtils.queryPgql(this.visualQuery, graph, finalQuery, parameters);
        }
        try {
            PgxPreparedStatementExpandQueryBuilder builder = new PgxPreparedStatementExpandQueryBuilder(graph);
            builder.addVertices(selectedVertices);
            PgxPreparedStatement statement = builder.buildForExpand(hops);
            edgeIds = PgxVisualizationUtils.getEdgesIds(statement.executeQuery());
        }
        catch (PgqlException e) {
            throw new VisualizationException("Failed to execute the expand query", (Throwable)e);
        }
        if (edgeIds == null || edgeIds.length == 0) {
            return "";
        }
        ArrayList parameters = new ArrayList();
        parameters.add(new ArrayParameter(1, PgxPreparedStatementUtils.getListIds(edgeIds, edgeIDType)));
        String finalQuery = String.format("SELECT e FROM MATCH ()-[e]-() WHERE id(e) IN ? ", new Object[0]);
        return PgxVisualizationUtils.queryPgql(this.visualQuery, graph, finalQuery, parameters);
    }

    public PgxGraph expandOffloadedSubGraph(PgxGraph graph, String[] selectedVertices, int hops, Map<String, String> dynamicFormsParams) throws VisualizationException {
        if (PgxVisualizationUtils.isOffloadedSubgraph(graph)) {
            try {
                IdType vertexIdType = graph.getVertexIdType();
                String query = PgxVisualizationUtils.getReachabilityQueries(selectedVertices, vertexIdType, hops);
                return graph.expandGraph().withPgql().queryPgql(query).expandNewSnapshot();
            }
            catch (ExecutionException e) {
                throw new VisualizationException(String.format("Failed to expand a new snapshot of the graph '%s'", graph.getName()), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new VisualizationException(String.format("Failed to expand a new snapshot of the graph '%s'", graph.getName()), (Throwable)e);
            }
        }
        return graph;
    }

    public String smartExpandGraph(String graphName, String[] selectedVertices, ExpandTemplate expandTemplate, Map<String, String> dynamicFormsParams) throws VisualizationException {
        String[] edgeIds;
        if (selectedVertices.length < 1) {
            throw new VisualizationException("At least one vertex id must be provided");
        }
        if (expandTemplate.numberOfHops != null && expandTemplate.numberOfHops < 1) {
            throw new VisualizationException("Number of hops must be strictly positive");
        }
        PgxGraph graph = PgxVisualizationUtils.getGraphFromPgqlGraphRef(this.session, graphName);
        Integer numberOfHops = expandTemplate.numberOfHops != null ? expandTemplate.numberOfHops : 6;
        graph = this.expandOffloadedSubGraph(graph, selectedVertices, numberOfHops, dynamicFormsParams);
        IdType edgeIDType = graph.getEdgeIdStrategy().equals((Object)IdStrategy.PARTITIONED_IDS) ? IdType.STRING : graph.getMetaData().getEdgeIdType();
        try {
            PgxPreparedStatementExpandQueryBuilder builder = new PgxPreparedStatementExpandQueryBuilder(graph);
            builder.setExpandTemplate(selectedVertices, expandTemplate);
            PgxPreparedStatement statement = builder.buildForSmartExpand();
            edgeIds = PgxVisualizationUtils.getEdgesIds(statement.executeQuery());
        }
        catch (PgqlException e) {
            throw new VisualizationException("Failed to execute the smart expand query", (Throwable)e);
        }
        if (edgeIds == null || edgeIds.length == 0) {
            return "";
        }
        if (edgeIds == null || edgeIds.length == 0) {
            return "";
        }
        ArrayList parameters = new ArrayList();
        parameters.add(new ArrayParameter(1, PgxPreparedStatementUtils.getListIds(edgeIds, edgeIDType)));
        String finalQuery = String.format("SELECT e FROM MATCH ()-[e]-() WHERE id(e) IN ? ", new Object[0]);
        return PgxVisualizationUtils.queryPgql(this.visualQuery, graph, finalQuery, parameters);
    }

    public String getFeatureFlags() throws VisualizationException {
        return "{}";
    }
}

