/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.PgxSession;
import oracle.pgx.graphviz.driver.PgxDriver;
import oracle.pgx.graphviz.driver.exception.VisualQueryException;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.Parameter;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.library.QueryEnhancer;
import oracle.pgx.graphviz.library.QueryEnhancerUtils;
import oracle.pgx.graphviz.library.TableOnlyResultSet;
import oracle.pgx.graphviz.library.VisualResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import oracle.pgx.graphviz.library.misc.MalformedQueryException;

public class PgxVisualQuery {
    private final Properties properties;
    private final PgxSession session;
    private final QueryEnhancer<?> queryEnhancer;

    public PgxVisualQuery(Properties properties, PgxSession session, QueryEnhancer<?> enhancer) {
        this.session = session;
        this.queryEnhancer = enhancer;
        this.properties = properties;
    }

    @Deprecated
    public String queryPgql(String query) throws PgqlException, IOException, SQLException {
        return this.pgqlResultToString(this.queryEnhancer.execute(query, null, null, this.getProperties()));
    }

    public String queryPgql(PgxGraph graph, String query, List<Parameter<?>> parameters) throws VisualQueryException {
        Optional<Result> result = Optional.of(this.preparedStatementQuery(graph, query, parameters, this.getProperties()));
        return this.pgqlResultToString(result);
    }

    protected Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : this.properties.stringPropertyNames()) {
            props.put(key, this.properties.get(key));
        }
        props.put("graphviz.driver.session", this.session.getId());
        return props;
    }

    protected String pgqlResultToString(Optional<?> result) {
        if (result.isPresent()) {
            if (result.get() instanceof Result) {
                Result resultFromExecution = (Result)result.get();
                String typeStr = resultFromExecution.getType().toString().toLowerCase();
                String formatted = resultFromExecution.getJson().toString();
                return '%' + typeStr + ' ' + formatted;
            }
            return result.toString();
        }
        return "%text <small><i>Successful execution: No result returned.</i></small>";
    }

    protected Result preparedStatementQuery(PgxGraph graph, String queryString, List<Parameter<?>> parameters, Map<String, Object> properties) throws VisualQueryException {
        GraphQuery query;
        Enhancer enhancer;
        String graphName = graph.getName();
        String schema = null;
        try {
            enhancer = this.queryEnhancer.createEnhancer(queryString, null, graphName, properties);
        }
        catch (PgqlException e) {
            throw new VisualQueryException(String.format("Failed to parse the query: %s", queryString), (Throwable)e);
        }
        catch (SQLException e) {
            throw new VisualQueryException((Throwable)e);
        }
        List header = enhancer.getOriginalHeader();
        Pair canViz = enhancer.checkIfVisualizable();
        PgxDriver driver = (PgxDriver)this.queryEnhancer.getDriver();
        DataStudioFormatter formatter = (DataStudioFormatter)this.queryEnhancer.getFormatter();
        if (((Boolean)canViz.getFirst()).booleanValue()) {
            Enhancement enhancement = enhancer.enhance();
            String enhancedQuery = "/*ALLOW_REFERENCING_ANY_PROPERTY*/ " + enhancement.getQuery().toString();
            try {
                PgqlResultSet queryResultSet = this.executePreparedStatementQuery(graph, enhancedQuery, parameters, properties);
                return formatter.format((EnhancedResultSet)new VisualResultSet((ResultSet)queryResultSet, enhancement, schema, header, driver.isDirectedSupported(), driver.supportsMultipleIterations()), properties);
            }
            catch (PgqlException e) {
                throw new VisualQueryException(String.format("Failed to excute the query: %s", queryString), (Throwable)e);
            }
            catch (IOException e) {
                throw new VisualQueryException("Error occurs while formating the query result", (Throwable)e);
            }
        }
        try {
            query = QueryEnhancerUtils.parseQuery((String)queryString, null, (String)graphName);
        }
        catch (PgqlException | MalformedQueryException e) {
            throw new VisualQueryException(String.format("Failed to excute the query: %s", queryString), e);
        }
        String parsedQueryString = query.toString();
        try {
            PgqlResultSet queryResultSet = this.executePreparedStatementQuery(graph, parsedQueryString, parameters, properties);
            return formatter.format((EnhancedResultSet)new TableOnlyResultSet((ResultSet)queryResultSet, graphName, null, header, driver.supportsMultipleIterations()), properties);
        }
        catch (PgqlException e) {
            throw new VisualQueryException(String.format("Failed to parse the query: %s", queryString), (Throwable)e);
        }
        catch (IOException e) {
            throw new VisualQueryException("Error occurs while formating the query result", (Throwable)e);
        }
    }

    public PgqlResultSet executePreparedStatementQuery(PgxGraph graph, String query, List<Parameter<?>> parameters, Map<String, Object> properties) throws PgqlException {
        PgxPreparedStatement pgxPreparedStatement = graph.preparePgql(query);
        for (Parameter<?> parameter : parameters) {
            parameter.bindValue(pgxPreparedStatement);
        }
        return pgxPreparedStatement.executeQuery();
    }
}

