/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableReference;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class ElementUpdate
extends TableExpression {
    String tableName;
    String variable;
    String alias;
    List<String> selectVariables;
    List<String> setVariables;

    public ElementUpdate(SchemaQualifiedName table, String variable, String alias) {
        this.tableName = new TableReference(table, null).prettyPrint();
        this.variable = variable;
        this.alias = alias;
        this.selectVariables = new ArrayList<String>();
        this.setVariables = new ArrayList<String>();
    }

    public void setKeyVariable(String variable) {
        this.selectVariables.add(variable + " AS key");
    }

    public void addSetVariable(String column, String value) {
        this.setVariables.add(column + " = m." + value);
        this.selectVariables.add(column);
    }

    @Override
    public String prettyPrint() {
        return "BEGIN\n  MERGE /*+ */ INTO (\n    SELECT " + String.join((CharSequence)", ", this.selectVariables) + "\n    FROM " + this.tableName + " " + this.variable + "\n  ) " + this.variable + "\n  USING " + this.gttTableName + " m\n  ON ( " + this.variable + ".key = m." + this.alias + ")\n  WHEN MATCHED THEN UPDATE SET " + String.join((CharSequence)", ", this.setVariables) + ";\n  ? := SQL%ROWCOUNT;\nEND;";
    }
}

