/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

public class Column {
    public String name;
    public String type;
    int length;

    public Column(String name, String type, int length) {
        this.name = name;
        this.type = type;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getType(boolean appendLength) {
        String type = this.getType();
        if (!Column.isClobType(type) && appendLength && Column.isStringType(type)) {
            type = type + "(" + this.getLength() + ")";
        }
        return type;
    }

    static boolean isClobType(String type) {
        switch (type) {
            case "CLOB": 
            case "NCLOB": {
                return true;
            }
        }
        return false;
    }

    static boolean isStringType(String type) {
        switch (type) {
            case "CHAR": 
            case "VARCHAR": 
            case "VARCHAR2": 
            case "NCHAR": 
            case "NVARCHAR": 
            case "NVARCHAR2": 
            case "CLOB": 
            case "NCLOB": {
                return true;
            }
        }
        return false;
    }
}

