/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.ModifyContext;
import oracle.pg.rdbms.pgql.MutableBoolean;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlUtils {
    private static final Logger ms_log = LoggerFactory.getLogger(PgqlUtils.class);
    public static final String PG_SCHEMA_NOT_SUPPORTED = "PG_SCHEMA graphs are no longer supported";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GraphType getGraphType(Connection conn, String graphOwner, String graphName, boolean throwErrorIfPgSchema, boolean isDropStatement, boolean isCreateStatement) throws PgqlToSqlException {
        boolean isPgSqlGraph;
        if (!isCreateStatement && PgqlTranslator.containsGraphMetadata(conn, graphOwner, graphName)) {
            return GraphType.PG_VIEWS;
        }
        String query = "DECLARE\n  cnt  NUMBER := 0;\n  idx  NUMBER := -1;\n  graph_name  VARCHAR2(4000) := ?;\n  owner       VARCHAR2(4000) := ?;\nBEGIN\n  BEGIN\n    execute immediate 'SELECT count(*) FROM SYS.ALL_PROPERTY_GRAPHS\n    WHERE graph_name = :graph_name AND owner = :owner'\n    into cnt\n    using graph_name, owner;\n   EXCEPTION when others then\n    if SQLCODE != -942 then\n      raise;\n    end if;\n  END;\n  ? := cnt;\n  BEGIN\n    select decode(table_name, ?, " + GraphType.PG_VIEWS.ordinal() + ")\n    into idx\n    from sys.all_tables\n    where owner = ?\n      and table_name IN(?);\n   EXCEPTION when NO_DATA_FOUND then null;\n  END;\n  ? := idx;\nEND;";
        try (CallableStatement ps = conn.prepareCall(query);){
            String pgViewTable = graphName + "_ELEM_TABLE$";
            ps.setString(1, graphName);
            ps.setString(2, graphOwner);
            ps.registerOutParameter(3, 4);
            ps.setString(4, pgViewTable);
            ps.setString(5, graphOwner);
            ps.setString(6, pgViewTable);
            ps.registerOutParameter(7, 4);
            ps.execute();
            isPgSqlGraph = ps.getInt(3) > 0;
            int idx = ps.getInt(7);
            if (idx >= 0) {
                if (isPgSqlGraph && !isDropStatement) {
                    throw new PgqlToSqlException("There exist a SQL property graph and a property graph view with the same name");
                }
                GraphType graphType = GraphType.values()[idx];
                return graphType;
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (isPgSqlGraph) {
            return GraphType.PG_SQL;
        }
        if (throwErrorIfPgSchema && PgqlUtils.countPgSchemaTables(conn, graphOwner, graphName) > 0) {
            throw new PgqlToSqlException(PG_SCHEMA_NOT_SUPPORTED);
        }
        if (graphOwner.length() > 128) {
            throw new PgqlToSqlException("Schema name: " + graphOwner + " exceeds maximum length of 128 characters");
        }
        if (graphName.length() <= 112) return null;
        throw new PgqlToSqlException("Graph name: " + graphName + " exceeds maximum length of 112 characters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int countPgSchemaTables(Connection conn, String graphOwner, String graphName) {
        int n;
        PreparedStatement ps;
        ResultSet rs;
        block11: {
            String query = "SELECT COUNT(*) FROM SYS.ALL_TABLES WHERE owner = ? AND table_name IN(?, ?, ?, ?)";
            rs = null;
            ps = conn.prepareStatement(query);
            String clnGraphName = graphName.toUpperCase();
            ps.setString(1, graphOwner);
            ps.setString(2, clnGraphName + "VT$");
            ps.setString(3, clnGraphName + "GE$");
            ps.setString(4, clnGraphName + "VD$");
            ps.setString(5, clnGraphName + "GT$");
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
            if (ps == null) break block11;
            ps.close();
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
        return n;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        int n2 = 0;
                        return n2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
                }
            }
        }
    }

    public static void setQueryOptions(QueryContext ctx, String options) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting query options ...");
        }
        ctx.useIso = false;
        if (ctx.graphType == GraphType.PG_VIEWS) {
            ctx.checkTypes = true;
            ctx.reversePath = true;
            ctx.pushSrcHops = true;
            ctx.pushDstHops = false;
            ctx.expPathClob = true;
            ctx.escapeIDs = true;
            ctx.spCreateView = false;
            ctx.spCreateTable = true;
            ctx.spStartVC = true;
            ctx.spEndVC = true;
            ctx.spPathVC = true;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Checking system parameters ...");
        }
        ctx.useIso = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useIso", ctx.useIso);
        if (ctx.graphType == GraphType.PG_VIEWS) {
            ctx.checkTypes = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.checkTypes", ctx.checkTypes);
            ctx.reversePath = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.reversePath", ctx.reversePath);
            ctx.pushSrcHops = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.pushSrcHops", ctx.pushSrcHops);
            ctx.pushDstHops = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.pushDstHops", ctx.pushDstHops);
            ctx.expPathClob = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.expPathClob", ctx.expPathClob);
            ctx.escapeIDs = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.escapeIDs", ctx.escapeIDs);
            ctx.spCreateView = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.spCreateView", ctx.spCreateView);
            ctx.spCreateTable = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.spCreateTable", ctx.spCreateTable);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking system parameters");
            ms_log.debug("Checking options string ...");
            ms_log.debug("options=[" + options + "]");
        }
        if (options != null) {
            ctx.useIso = PgqlUtils.extractBooleanOptionValue(options, "USE_ISO", ctx.useIso);
            if (ctx.graphType == GraphType.PG_VIEWS) {
                ctx.checkTypes = PgqlUtils.extractBooleanOptionValue(options, "CHECK_TYPES", ctx.checkTypes);
                ctx.reversePath = PgqlUtils.extractBooleanOptionValue(options, "REVERSE_PATH", ctx.reversePath);
                ctx.pushSrcHops = PgqlUtils.extractBooleanOptionValue(options, "PUSH_SRC_HOPS", ctx.pushSrcHops);
                ctx.pushDstHops = PgqlUtils.extractBooleanOptionValue(options, "PUSH_DST_HOPS", ctx.pushDstHops);
                ctx.expPathClob = PgqlUtils.extractBooleanOptionValue(options, "EXP_PATH_CLOB", ctx.expPathClob);
                ctx.escapeIDs = PgqlUtils.extractBooleanOptionValue(options, "ESCAPE_IDS", ctx.escapeIDs);
                ctx.spCreateView = PgqlUtils.extractBooleanOptionValue(options, "SP_CREATE_VIEW", ctx.spCreateView);
                ctx.spCreateTable = PgqlUtils.extractBooleanOptionValue(options, "SP_CREATE_TABLE", ctx.spCreateTable);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking options string");
            ms_log.debug("... Done setting options ... QueryContext:\n" + ctx.toString());
        }
    }

    public static void setModifyOptions(ModifyContext modifyCtx, String options) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting modify options ...");
        }
        modifyCtx.resetOptions();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Checking system parameters ...");
        }
        modifyCtx.setOptionsFromSystemProperties();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking system parameters");
            ms_log.debug("Checking options string ...");
            ms_log.debug("options=[" + options + "]");
        }
        if (options != null) {
            String uOptions = options.toUpperCase();
            modifyCtx.setOptionsFromString(uOptions);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking options string");
            ms_log.debug("... Done setting options ... ModifyContext:\n" + modifyCtx.toString());
        }
    }

    public static boolean extractBooleanProperty(String propName, boolean defaultValue) {
        String val;
        boolean boolVal;
        block3: {
            boolVal = defaultValue;
            val = null;
            try {
                val = System.getProperty(propName);
            }
            catch (Exception ex) {
                if (!ms_log.isDebugEnabled()) break block3;
                ms_log.debug("Error extracting system property [" + propName + "] " + ex.getMessage());
            }
        }
        if (val != null) {
            boolVal = Boolean.parseBoolean(val);
        }
        return boolVal;
    }

    public static boolean extractBooleanOptionValue(String options, String optionName, boolean defaultValue) {
        boolean boolVal = defaultValue;
        if (options.contains(optionName + "=T")) {
            boolVal = true;
        }
        if (options.contains(optionName + "=F")) {
            boolVal = false;
        }
        return boolVal;
    }

    public static String escapeAndEnquoteIdentifier(String columnName) {
        return PgqlUtils.escapeAndEnquoteIdentifier(columnName, true);
    }

    public static String escapeAndEnquoteIdentifier(String columnName, boolean alwaysQuote) {
        String identifier = oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)columnName, (boolean)alwaysQuote);
        if (identifier.startsWith("\"")) {
            identifier = "\"" + identifier.replaceAll("\"", "") + "\"";
        }
        return identifier;
    }

    public static boolean containsSubquery(QueryExpression exp) {
        final MutableBoolean result = new MutableBoolean(false);
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Function.Exists exists) {
                result.setTrue();
            }

            public void visit(QueryExpression.ScalarSubquery subquery) {
                result.setTrue();
            }
        });
        return result.isTrue();
    }

    public static <T> List<T> buildList(T element) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    static enum DbFeature {
        INSERT_UPDATE_DELETE(18),
        SUBQUERY_PATH_EDGE_JOIN(23),
        SHORTEST_PATH_CURSOR(19);

        private final int requiredVersion;

        private DbFeature(int requiredVersion) {
            this.requiredVersion = requiredVersion;
        }

        public boolean isSupported(int dbVersion) {
            return dbVersion >= this.requiredVersion;
        }
    }
}

